/*
 * Decompiled with CFR 0.152.
 */
package org.boon;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.boon.Exceptions;
import org.boon.Universal;
import org.boon.core.Conversions;
import org.boon.core.Typ;
import org.boon.core.reflection.BeanUtils;
import org.boon.core.reflection.MapObjectConversion;

public class Maps {
    public static <V> List<V> lazyCreate(List<V> lazy) {
        if (lazy == null) {
            lazy = new ArrayList<V>();
        }
        return lazy;
    }

    public static <K, V> Map<K, V> lazyCreate(Map<K, V> lazy) {
        if (lazy == null) {
            lazy = new LinkedHashMap();
        }
        return lazy;
    }

    public static <K, V> Map<K, V> lazyCreate(HashMap<K, V> lazy) {
        if (lazy == null) {
            lazy = new HashMap();
        }
        return lazy;
    }

    public static <K, V> Map<K, V> lazyCreate(LinkedHashMap<K, V> lazy) {
        if (lazy == null) {
            lazy = new LinkedHashMap();
        }
        return lazy;
    }

    public static <K, V> Map<K, V> lazyCreateLinked(Map<K, V> lazy) {
        if (lazy == null) {
            lazy = new LinkedHashMap();
        }
        return lazy;
    }

    public static <K, V> Map<K, V> lazyCreate(ConcurrentHashMap<K, V> lazy) {
        if (lazy == null) {
            lazy = new ConcurrentHashMap();
        }
        return lazy;
    }

    public static <K, V> Map<K, V> lazyCreateSafe(Map<K, V> lazy) {
        if (lazy == null) {
            lazy = new ConcurrentHashMap();
        }
        return lazy;
    }

    @Universal
    public static int lengthOf(Map<?, ?> map) {
        return Maps.len(map);
    }

    @Universal
    public static <K, V> V atIndex(Map<K, V> map, K k) {
        return Maps.idx(map, k);
    }

    @Universal
    public static <K, V> SortedMap<K, V> sliceOf(NavigableMap<K, V> map, K startIndex, K endIndex) {
        return Maps.slc(map, startIndex, endIndex);
    }

    @Universal
    public static <K, V> SortedMap<K, V> endSliceOf(NavigableMap<K, V> map, K fromKey) {
        return Maps.slcEnd(map, fromKey);
    }

    @Universal
    public static int len(Map<?, ?> map) {
        return map.size();
    }

    @Universal
    public static <K, V> boolean in(K key, Map<K, V> map) {
        return map.containsKey(key);
    }

    @Universal
    public static <K, V> void add(Map<K, V> map, Entry<K, V> entry) {
        map.put(entry.key(), entry.value());
    }

    @Universal
    public static <K, V> V idx(Map<K, V> map, K k) {
        return map.get(k);
    }

    @Universal
    public static <K, V> void idx(Map<K, V> map, K k, V v) {
        map.put(k, v);
    }

    public static <K, V> String idxStr(Map<K, V> map, K k) {
        return (String)map.get(k);
    }

    public static <K, V> Integer idxInt(Map<K, V> map, K k) {
        return (Integer)map.get(k);
    }

    public static <K, V> Long idxLong(Map<K, V> map, K k) {
        return (Long)map.get(k);
    }

    public static <K, V> Map idxMap(Map<K, V> map, K k) {
        return (Map)map.get(k);
    }

    public static <K, V> List idxList(Map<K, V> map, K k) {
        return (List)map.get(k);
    }

    public static <K, V> long toLong(Map<K, V> map, K key) {
        V value = map.get(key);
        long l = Conversions.toLong(value, Long.MIN_VALUE);
        if (l == Long.MIN_VALUE) {
            Exceptions.die("Cannot convert", key, "into long value", value);
        }
        return l;
    }

    public static <K, V> int toInt(Map<K, V> map, K key) {
        V value = map.get(key);
        int v = Conversions.toInt(value, Integer.MIN_VALUE);
        if (v == Integer.MIN_VALUE) {
            Exceptions.die("Cannot convert", key, "into int value", value);
        }
        return v;
    }

    @Universal
    public static <K, V> SortedMap<K, V> copy(SortedMap<K, V> map) {
        if (map instanceof TreeMap) {
            return new TreeMap<K, V>(map);
        }
        if (map instanceof ConcurrentSkipListMap) {
            return new ConcurrentSkipListMap<K, V>(map);
        }
        return new TreeMap<K, V>(map);
    }

    @Universal
    public static <K, V> Map<K, V> copy(Map<K, V> map) {
        if (map instanceof LinkedHashMap) {
            return new LinkedHashMap<K, V>(map);
        }
        if (map instanceof ConcurrentHashMap) {
            return new ConcurrentHashMap<K, V>(map);
        }
        return new LinkedHashMap<K, V>(map);
    }

    @Universal
    public static <K, V> V after(NavigableMap<K, V> map, K index) {
        return map.get(map.higherKey(index));
    }

    @Universal
    public static <K, V> V before(NavigableMap<K, V> map, K index) {
        return map.get(map.lowerKey(index));
    }

    @Universal
    public static <K, V> SortedMap<K, V> slc(NavigableMap<K, V> map, K startIndex, K endIndex) {
        return map.subMap(startIndex, endIndex);
    }

    @Universal
    public static <K, V> SortedMap<K, V> slcEnd(NavigableMap<K, V> map, K fromKey) {
        return map.tailMap(fromKey);
    }

    @Universal
    public static <K, V> SortedMap<K, V> slc(NavigableMap<K, V> map, K toKey) {
        return map.headMap(toKey);
    }

    public static <K, V> boolean valueIn(V value, Map<K, V> map) {
        return map.containsValue(value);
    }

    public static <K, V> Entry<K, V> entry(K k, V v) {
        return new EntryImpl<K, V>(k, v);
    }

    public static <K, V> Entry<K, V> entry(Entry<K, V> entry) {
        return new EntryImpl<K, V>(entry);
    }

    public static Map<?, ?> mapFromArray(Object ... args) {
        Map<Class<Object>, Class<Object>> map = Maps.map(Object.class, Object.class);
        if (args.length % 2 != 0) {
            return Exceptions.die(Map.class, "mapFromArray arguments must be equal");
        }
        Object lastKey = null;
        for (int index = 0; index < args.length; ++index) {
            if (index % 2 == 0) {
                lastKey = args[index];
                continue;
            }
            map.put((Class<Object>)lastKey, (Class<Object>)args[index]);
        }
        return map;
    }

    public static <K, V> Map<K, V> map(Class<K> keyClass, Class<V> valueClass) {
        return new LinkedHashMap(10);
    }

    public static <K, V> Map<K, V> safeMap(Class<K> keyClass, Class<V> valueClass) {
        return new ConcurrentHashMap(10);
    }

    public static <K, V> Map<K, V> map(K k0, V v0) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(10);
        map.put(k0, v0);
        return map;
    }

    public static <K, V> Map<K, V> map(K k0, V v0, K k1, V v1) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(10);
        map.put(k0, v0);
        map.put(k1, v1);
        return map;
    }

    public static <K, V> Map<K, V> map(K k0, V v0, K k1, V v1, K k2, V v2) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(10);
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        return map;
    }

    public static <K, V> Map<K, V> map(K k0, V v0, K k1, V v1, K k2, V v2, K k3, V v3) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(10);
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return map;
    }

    public static <K, V> Map<K, V> map(K k0, V v0, K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(10);
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        return map;
    }

    public static <K, V> Map<K, V> map(K k0, V v0, K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(10);
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        return map;
    }

    public static <K, V> Map<K, V> map(K k0, V v0, K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(10);
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        return map;
    }

    public static <K, V> Map<K, V> map(K k0, V v0, K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(10);
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        return map;
    }

    public static <K, V> Map<K, V> map(K k0, V v0, K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(10);
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        return map;
    }

    public static <K, V> Map<K, V> map(K k0, V v0, K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(10);
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        return map;
    }

    public static <K, V> Map<K, V> map(K k0, V v0, K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(10);
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        return map;
    }

    public static <K, V> Map<K, V> map(Collection<K> keys, Collection<V> values) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(10 + keys.size());
        Iterator<V> iterator = values.iterator();
        for (K k : keys) {
            if (iterator.hasNext()) {
                V v = iterator.next();
                map.put(k, v);
                continue;
            }
            map.put(k, null);
        }
        return map;
    }

    public static <K, V> Map<K, V> map(Iterable<K> keys, Iterable<V> values) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        Iterator<V> iterator = values.iterator();
        for (K k : keys) {
            if (iterator.hasNext()) {
                V v = iterator.next();
                map.put(k, v);
                continue;
            }
            map.put(k, null);
        }
        return map;
    }

    public static <K, V> Map<K, V> map(K[] keys, V[] values) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(10 + keys.length);
        int index = 0;
        for (K k : keys) {
            if (index < keys.length) {
                V v = values[index];
                map.put(k, v);
            } else {
                map.put(k, null);
            }
            ++index;
        }
        return map;
    }

    @SafeVarargs
    public static <K, V> Map<K, V> map(Entry<K, V> ... entries) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(entries.length);
        for (Entry<K, V> entry : entries) {
            map.put(entry.key(), entry.value());
        }
        return map;
    }

    public static <K, V> NavigableMap<K, V> sortedMap(K k0, V v0) {
        TreeMap<K, V> map = new TreeMap<K, V>();
        map.put(k0, v0);
        return map;
    }

    public static <K, V> NavigableMap<K, V> sortedMap(K k0, V v0, K k1, V v1) {
        TreeMap<K, V> map = new TreeMap<K, V>();
        map.put(k0, v0);
        map.put(k1, v1);
        return map;
    }

    public static <K, V> NavigableMap<K, V> sortedMap(K k0, V v0, K k1, V v1, K k2, V v2) {
        TreeMap<K, V> map = new TreeMap<K, V>();
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        return map;
    }

    public static <K, V> NavigableMap<K, V> sortedMap(K k0, V v0, K k1, V v1, K k2, V v2, K k3, V v3) {
        TreeMap<K, V> map = new TreeMap<K, V>();
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return map;
    }

    public static <K, V> NavigableMap<K, V> sortedMap(K k0, V v0, K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        TreeMap<K, V> map = new TreeMap<K, V>();
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        return map;
    }

    public static <K, V> NavigableMap<K, V> sortedMap(K k0, V v0, K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        TreeMap<K, V> map = new TreeMap<K, V>();
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        return map;
    }

    public static <K, V> NavigableMap<K, V> sortedMap(K k0, V v0, K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6) {
        TreeMap<K, V> map = new TreeMap<K, V>();
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        return map;
    }

    public static <K, V> NavigableMap<K, V> sortedMap(K k0, V v0, K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7) {
        TreeMap<K, V> map = new TreeMap<K, V>();
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        return map;
    }

    public static <K, V> NavigableMap<K, V> sortedMap(K k0, V v0, K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8) {
        TreeMap<K, V> map = new TreeMap<K, V>();
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        return map;
    }

    public static <K, V> NavigableMap<K, V> sortedMap(K k0, V v0, K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9) {
        TreeMap<K, V> map = new TreeMap<K, V>();
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        return map;
    }

    public static <K, V> NavigableMap<K, V> sortedMap(Collection<K> keys, Collection<V> values) {
        TreeMap<K, V> map = new TreeMap<K, V>();
        Iterator<V> iterator = values.iterator();
        for (K k : keys) {
            if (iterator.hasNext()) {
                V v = iterator.next();
                map.put(k, v);
                continue;
            }
            map.put(k, null);
        }
        return map;
    }

    public static <K, V> NavigableMap<K, V> sortedMap(Iterable<K> keys, Iterable<V> values) {
        TreeMap<K, V> map = new TreeMap<K, V>();
        Iterator<V> iterator = values.iterator();
        for (K k : keys) {
            if (iterator.hasNext()) {
                V v = iterator.next();
                map.put(k, v);
                continue;
            }
            map.put(k, null);
        }
        return map;
    }

    public static <K, V> NavigableMap<K, V> sortedMap(K[] keys, V[] values) {
        TreeMap<K, V> map = new TreeMap<K, V>();
        int index = 0;
        for (K k : keys) {
            if (index < keys.length) {
                V v = values[index];
                map.put(k, v);
            } else {
                map.put(k, null);
            }
            ++index;
        }
        return map;
    }

    public static <K, V> NavigableMap<K, V> sortedMap(List<Entry<K, V>> entries) {
        TreeMap<K, V> map = new TreeMap<K, V>();
        for (Entry<K, V> entry : entries) {
            map.put(entry.key(), entry.value());
        }
        return map;
    }

    public static <K, V> NavigableMap<K, V> sortedMap(Comparator<K> comparator, K k0, V v0) {
        TreeMap<K, V> map = new TreeMap<K, V>(comparator);
        map.put(k0, v0);
        return map;
    }

    public static <K, V> NavigableMap<K, V> sortedMap(Comparator<K> comparator, K k0, V v0, K k1, V v1) {
        TreeMap<K, V> map = new TreeMap<K, V>(comparator);
        map.put(k0, v0);
        map.put(k1, v1);
        return map;
    }

    public static <K, V> NavigableMap<K, V> sortedMap(Comparator<K> comparator, K k0, V v0, K k1, V v1, K k2, V v2) {
        TreeMap<K, V> map = new TreeMap<K, V>(comparator);
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        return map;
    }

    public static <K, V> NavigableMap<K, V> sortedMap(Comparator<K> comparator, K k0, V v0, K k1, V v1, K k2, V v2, K k3, V v3) {
        TreeMap<K, V> map = new TreeMap<K, V>(comparator);
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return map;
    }

    public static <K, V> NavigableMap<K, V> sortedMap(Comparator<K> comparator, K k0, V v0, K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        TreeMap<K, V> map = new TreeMap<K, V>(comparator);
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        return map;
    }

    public static <K, V> NavigableMap<K, V> sortedMap(Comparator<K> comparator, K k0, V v0, K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        TreeMap<K, V> map = new TreeMap<K, V>(comparator);
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        return map;
    }

    public static <K, V> NavigableMap<K, V> sortedMap(Comparator<K> comparator, K k0, V v0, K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6) {
        TreeMap<K, V> map = new TreeMap<K, V>(comparator);
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        return map;
    }

    public static <K, V> NavigableMap<K, V> sortedMap(Comparator<K> comparator, K k0, V v0, K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7) {
        TreeMap<K, V> map = new TreeMap<K, V>(comparator);
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        return map;
    }

    public static <K, V> NavigableMap<K, V> sortedMap(Comparator<K> comparator, K k0, V v0, K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8) {
        TreeMap<K, V> map = new TreeMap<K, V>(comparator);
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        return map;
    }

    public static <K, V> NavigableMap<K, V> sortedMap(Comparator<K> comparator, K k0, V v0, K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9) {
        TreeMap<K, V> map = new TreeMap<K, V>(comparator);
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        return map;
    }

    public static <K, V> NavigableMap<K, V> sortedMap(Comparator<K> comparator, Collection<K> keys, Collection<V> values) {
        TreeMap<K, V> map = new TreeMap<K, V>(comparator);
        Iterator<V> iterator = values.iterator();
        for (K k : keys) {
            if (iterator.hasNext()) {
                V v = iterator.next();
                map.put(k, v);
                continue;
            }
            map.put(k, null);
        }
        return map;
    }

    public static <K, V> NavigableMap<K, V> sortedMap(Comparator<K> comparator, K[] keys, V[] values) {
        TreeMap<K, V> map = new TreeMap<K, V>(comparator);
        int index = 0;
        for (K k : keys) {
            if (index < keys.length) {
                V v = values[index];
                map.put(k, v);
            } else {
                map.put(k, null);
            }
            ++index;
        }
        return map;
    }

    public static <K, V> NavigableMap<K, V> sortedMap(Comparator<K> comparator, List<Entry<K, V>> entries) {
        TreeMap<K, V> map = new TreeMap<K, V>(comparator);
        for (Entry<K, V> entry : entries) {
            map.put(entry.key(), entry.value());
        }
        return map;
    }

    public static <K, V> Map<K, V> safeMap(K k0, V v0) {
        ConcurrentHashMap<K, V> map = new ConcurrentHashMap<K, V>(10);
        map.put(k0, v0);
        return map;
    }

    public static <K, V> Map<K, V> safeMap(K k0, V v0, K k1, V v1) {
        ConcurrentHashMap<K, V> map = new ConcurrentHashMap<K, V>(10);
        map.put(k0, v0);
        map.put(k1, v1);
        return map;
    }

    public static <K, V> Map<K, V> safeMap(K k0, V v0, K k1, V v1, K k2, V v2) {
        ConcurrentHashMap<K, V> map = new ConcurrentHashMap<K, V>(10);
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        return map;
    }

    public static <K, V> Map<K, V> safeMap(K k0, V v0, K k1, V v1, K k2, V v2, K k3, V v3) {
        ConcurrentHashMap<K, V> map = new ConcurrentHashMap<K, V>(10);
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return map;
    }

    public static <K, V> Map<K, V> safeMap(K k0, V v0, K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        ConcurrentHashMap<K, V> map = new ConcurrentHashMap<K, V>(10);
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        return map;
    }

    public static <K, V> Map<K, V> safeMap(K k0, V v0, K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        ConcurrentHashMap<K, V> map = new ConcurrentHashMap<K, V>(10);
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        return map;
    }

    public static <K, V> Map<K, V> safeMap(K k0, V v0, K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6) {
        ConcurrentHashMap<K, V> map = new ConcurrentHashMap<K, V>(10);
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        return map;
    }

    public static <K, V> Map<K, V> safeMap(K k0, V v0, K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7) {
        ConcurrentHashMap<K, V> map = new ConcurrentHashMap<K, V>(10);
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        return map;
    }

    public static <K, V> Map<K, V> safeMap(K k0, V v0, K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8) {
        ConcurrentHashMap<K, V> map = new ConcurrentHashMap<K, V>(10);
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        return map;
    }

    public static <K, V> Map<K, V> safeMap(K k0, V v0, K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9) {
        ConcurrentHashMap<K, V> map = new ConcurrentHashMap<K, V>(10);
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        return map;
    }

    public static <K, V> Map<K, V> safeMap(Collection<K> keys, Collection<V> values) {
        ConcurrentHashMap<K, V> map = new ConcurrentHashMap<K, V>(10 + keys.size());
        Iterator<V> iterator = values.iterator();
        for (K k : keys) {
            if (iterator.hasNext()) {
                V v = iterator.next();
                map.put(k, v);
                continue;
            }
            map.put(k, null);
        }
        return map;
    }

    public static <K, V> Map<K, V> safeMap(Iterable<K> keys, Iterable<V> values) {
        ConcurrentHashMap<K, V> map = new ConcurrentHashMap<K, V>();
        Iterator<V> iterator = values.iterator();
        for (K k : keys) {
            if (iterator.hasNext()) {
                V v = iterator.next();
                map.put(k, v);
                continue;
            }
            map.put(k, null);
        }
        return map;
    }

    public static <K, V> Map<K, V> safeMap(K[] keys, V[] values) {
        ConcurrentHashMap<K, V> map = new ConcurrentHashMap<K, V>(10 + keys.length);
        int index = 0;
        for (K k : keys) {
            if (index < keys.length) {
                V v = values[index];
                map.put(k, v);
            } else {
                map.put(k, null);
            }
            ++index;
        }
        return map;
    }

    @SafeVarargs
    public static <K, V> Map<K, V> safeMap(Entry<K, V> ... entries) {
        ConcurrentHashMap<K, V> map = new ConcurrentHashMap<K, V>(entries.length);
        for (Entry<K, V> entry : entries) {
            map.put(entry.key(), entry.value());
        }
        return map;
    }

    public static <K, V> NavigableMap<K, V> safeSortedMap(K k0, V v0) {
        ConcurrentSkipListMap<K, V> map = new ConcurrentSkipListMap<K, V>();
        map.put(k0, v0);
        return map;
    }

    public static <K, V> NavigableMap<K, V> safeSortedMap(K k0, V v0, K k1, V v1) {
        ConcurrentSkipListMap<K, V> map = new ConcurrentSkipListMap<K, V>();
        map.put(k0, v0);
        map.put(k1, v1);
        return map;
    }

    public static <K, V> NavigableMap<K, V> safeSortedMap(K k0, V v0, K k1, V v1, K k2, V v2) {
        ConcurrentSkipListMap<K, V> map = new ConcurrentSkipListMap<K, V>();
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        return map;
    }

    public static <K, V> NavigableMap<K, V> safeSortedMap(K k0, V v0, K k1, V v1, K k2, V v2, K k3, V v3) {
        ConcurrentSkipListMap<K, V> map = new ConcurrentSkipListMap<K, V>();
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return map;
    }

    public static <K, V> NavigableMap<K, V> safeSortedMap(K k0, V v0, K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        ConcurrentSkipListMap<K, V> map = new ConcurrentSkipListMap<K, V>();
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        return map;
    }

    public static <K, V> NavigableMap<K, V> safeSortedMap(K k0, V v0, K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        ConcurrentSkipListMap<K, V> map = new ConcurrentSkipListMap<K, V>();
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        return map;
    }

    public static <K, V> NavigableMap<K, V> safeSortedMap(K k0, V v0, K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6) {
        ConcurrentSkipListMap<K, V> map = new ConcurrentSkipListMap<K, V>();
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        return map;
    }

    public static <K, V> NavigableMap<K, V> safeSortedMap(K k0, V v0, K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7) {
        ConcurrentSkipListMap<K, V> map = new ConcurrentSkipListMap<K, V>();
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        return map;
    }

    public static <K, V> NavigableMap<K, V> safeSortedMap(K k0, V v0, K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8) {
        ConcurrentSkipListMap<K, V> map = new ConcurrentSkipListMap<K, V>();
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        return map;
    }

    public static <K, V> NavigableMap<K, V> safeSortedMap(K k0, V v0, K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9) {
        ConcurrentSkipListMap<K, V> map = new ConcurrentSkipListMap<K, V>();
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        return map;
    }

    public static <K, V> NavigableMap<K, V> safeSortedMap(Collection<K> keys, Collection<V> values) {
        ConcurrentSkipListMap<K, V> map = new ConcurrentSkipListMap<K, V>();
        Iterator<V> iterator = values.iterator();
        for (K k : keys) {
            if (iterator.hasNext()) {
                V v = iterator.next();
                map.put(k, v);
                continue;
            }
            map.put(k, null);
        }
        return map;
    }

    public static <K, V> NavigableMap<K, V> safeSortedMap(Iterable<K> keys, Iterable<V> values) {
        ConcurrentSkipListMap<K, V> map = new ConcurrentSkipListMap<K, V>();
        Iterator<V> iterator = values.iterator();
        for (K k : keys) {
            if (iterator.hasNext()) {
                V v = iterator.next();
                map.put(k, v);
                continue;
            }
            map.put(k, null);
        }
        return map;
    }

    public static <K, V> NavigableMap<K, V> safeSortedMap(K[] keys, V[] values) {
        ConcurrentSkipListMap<K, V> map = new ConcurrentSkipListMap<K, V>();
        int index = 0;
        for (K k : keys) {
            if (index < keys.length) {
                V v = values[index];
                map.put(k, v);
            } else {
                map.put(k, null);
            }
            ++index;
        }
        return map;
    }

    @SafeVarargs
    public static <K, V> NavigableMap<K, V> safeSortedMap(Entry<K, V> ... entries) {
        ConcurrentSkipListMap<K, V> map = new ConcurrentSkipListMap<K, V>();
        for (Entry<K, V> entry : entries) {
            map.put(entry.key(), entry.value());
        }
        return map;
    }

    public static <K, V> NavigableMap<K, V> safeSortedMap(Comparator<K> comparator, K k0, V v0) {
        ConcurrentSkipListMap<K, V> map = new ConcurrentSkipListMap<K, V>(comparator);
        map.put(k0, v0);
        return map;
    }

    public static <K, V> NavigableMap<K, V> safeSortedMap(Comparator<K> comparator, K k0, V v0, K k1, V v1) {
        ConcurrentSkipListMap<K, V> map = new ConcurrentSkipListMap<K, V>(comparator);
        map.put(k0, v0);
        map.put(k1, v1);
        return map;
    }

    public static <K, V> NavigableMap<K, V> safeSortedMap(Comparator<K> comparator, K k0, V v0, K k1, V v1, K k2, V v2) {
        ConcurrentSkipListMap<K, V> map = new ConcurrentSkipListMap<K, V>(comparator);
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        return map;
    }

    public static <K, V> NavigableMap<K, V> safeSortedMap(Comparator<K> comparator, K k0, V v0, K k1, V v1, K k2, V v2, K k3, V v3) {
        ConcurrentSkipListMap<K, V> map = new ConcurrentSkipListMap<K, V>(comparator);
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return map;
    }

    public static <K, V> NavigableMap<K, V> safeSortedMap(Comparator<K> comparator, K k0, V v0, K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        ConcurrentSkipListMap<K, V> map = new ConcurrentSkipListMap<K, V>(comparator);
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        return map;
    }

    public static <K, V> NavigableMap<K, V> safeSortedMap(Comparator<K> comparator, K k0, V v0, K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        ConcurrentSkipListMap<K, V> map = new ConcurrentSkipListMap<K, V>(comparator);
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        return map;
    }

    public static <K, V> NavigableMap<K, V> safeSortedMap(Comparator<K> comparator, K k0, V v0, K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6) {
        ConcurrentSkipListMap<K, V> map = new ConcurrentSkipListMap<K, V>(comparator);
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        return map;
    }

    public static <K, V> NavigableMap<K, V> safeSortedMap(Comparator<K> comparator, K k0, V v0, K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7) {
        ConcurrentSkipListMap<K, V> map = new ConcurrentSkipListMap<K, V>(comparator);
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        return map;
    }

    public static <K, V> NavigableMap<K, V> safeSortedMap(Comparator<K> comparator, K k0, V v0, K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8) {
        ConcurrentSkipListMap<K, V> map = new ConcurrentSkipListMap<K, V>(comparator);
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        return map;
    }

    public static <K, V> NavigableMap<K, V> safeSortedMap(Comparator<K> comparator, K k0, V v0, K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9) {
        ConcurrentSkipListMap<K, V> map = new ConcurrentSkipListMap<K, V>(comparator);
        map.put(k0, v0);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        return map;
    }

    public static <K, V> NavigableMap<K, V> safeSortedMap(Comparator<K> comparator, Collection<K> keys, Collection<V> values) {
        ConcurrentSkipListMap<K, V> map = new ConcurrentSkipListMap<K, V>(comparator);
        Iterator<V> iterator = values.iterator();
        for (K k : keys) {
            if (iterator.hasNext()) {
                V v = iterator.next();
                map.put(k, v);
                continue;
            }
            map.put(k, null);
        }
        return map;
    }

    public static <K, V> NavigableMap<K, V> safeSortedMap(Comparator<K> comparator, K[] keys, V[] values) {
        ConcurrentSkipListMap<K, V> map = new ConcurrentSkipListMap<K, V>(comparator);
        int index = 0;
        for (K k : keys) {
            if (index < keys.length) {
                V v = values[index];
                map.put(k, v);
            } else {
                map.put(k, null);
            }
            ++index;
        }
        return map;
    }

    public static <K, V> NavigableMap<K, V> safeSortedMap(Comparator<K> comparator, List<Entry<K, V>> entries) {
        ConcurrentSkipListMap<K, V> map = new ConcurrentSkipListMap<K, V>(comparator);
        for (Entry<K, V> entry : entries) {
            map.put(entry.key(), entry.value());
        }
        return map;
    }

    public static <T> T idx(Class<T> clz, Map map, Object key) {
        Object value = map.get(key.toString());
        if (value == null) {
            return (T)value;
        }
        if (value.getClass() != clz) {
            T t = Conversions.coerce(clz, value);
            return t;
        }
        return (T)value;
    }

    public static <T> T fromMap(Map<String, Object> map, Class<T> clazz) {
        return MapObjectConversion.fromMap(map, clazz);
    }

    public static Object fromMap(Map<String, Object> map) {
        return MapObjectConversion.fromMap(map);
    }

    public static Map<String, Object> toMap(Object object) {
        return MapObjectConversion.toMap(object);
    }

    public static <T> Map<String, List<T>> toMultiValueMap(String propertyPath, Collection<T> collection) {
        LinkedHashMap<String, List<T>> map = new LinkedHashMap<String, List<T>>(collection.size());
        for (T item : collection) {
            Object oKey = BeanUtils.idx(item, propertyPath);
            if (oKey == null) continue;
            String key = Conversions.coerce(Typ.string, oKey);
            List<T> list = map.get(key);
            if (list == null) {
                list = new ArrayList<T>();
                map.put(key, list);
            }
            list.add(item);
        }
        return map;
    }

    public static <T> Map<String, T> toMap(String propertyPath, Collection<T> collection) {
        return Maps.toMap(Typ.string, propertyPath, collection);
    }

    public static <T> NavigableMap<String, T> toSortedMap(String propertyPath, Collection<T> collection) {
        return Maps.toSortedMap(Typ.string, propertyPath, collection);
    }

    public static <T> NavigableMap<String, T> toSafeSortedMap(String propertyPath, Collection<T> collection) {
        return Maps.toSafeSortedMap(Typ.string, propertyPath, collection);
    }

    public static <T> Map<String, T> toSafeMap(String propertyPath, Collection<T> collection) {
        return Maps.toSafeMap(Typ.string, propertyPath, collection);
    }

    public static <K, T> Map<K, T> toMap(Class<K> keyType, String propertyPath, Collection<T> collection) {
        LinkedHashMap map = new LinkedHashMap(collection.size());
        Maps.doPopulateMapWithCollectionAndPropPath(keyType, propertyPath, collection, map);
        return map;
    }

    public static <K, T> NavigableMap<K, T> toSortedMap(Class<K> keyType, String propertyPath, Collection<T> collection) {
        TreeMap map = new TreeMap();
        Maps.doPopulateMapWithCollectionAndPropPath(keyType, propertyPath, collection, map);
        return map;
    }

    public static <K, T> NavigableMap<K, T> toSafeSortedMap(Class<K> keyType, String propertyPath, Collection<T> collection) {
        ConcurrentSkipListMap map = new ConcurrentSkipListMap();
        Maps.doPopulateMapWithCollectionAndPropPath(keyType, propertyPath, collection, map);
        return map;
    }

    public static <K, T> Map<K, T> toSafeMap(Class<K> keyType, String propertyPath, Collection<T> collection) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        Maps.doPopulateMapWithCollectionAndPropPath(keyType, propertyPath, collection, map);
        return map;
    }

    private static <K, T> void doPopulateMapWithCollectionAndPropPath(Class<K> keyType, String propertyPath, Collection<T> collection, Map<K, T> map) {
        for (T item : collection) {
            Object oKey = BeanUtils.idx(item, propertyPath);
            if (oKey == null) continue;
            K key = Conversions.coerce(keyType, oKey);
            map.put(key, item);
        }
    }

    public static class EntryImpl<K, V>
    implements Entry<K, V> {
        private K k;
        private V v;

        public EntryImpl() {
        }

        public EntryImpl(EntryImpl<K, V> impl) {
            Exceptions.requireNonNull(impl);
            Exceptions.requireNonNull(impl.k);
            this.k = impl.k;
            this.v = impl.v;
        }

        public EntryImpl(Entry<K, V> entry) {
            Exceptions.requireNonNull(entry);
            Exceptions.requireNonNull(entry.key());
            this.k = entry.key();
            this.v = entry.value();
        }

        public EntryImpl(K k, V v) {
            Exceptions.requireNonNull(k);
            this.k = k;
            this.v = v;
        }

        @Override
        public K key() {
            return this.k;
        }

        @Override
        public V value() {
            return this.v;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EntryImpl entry = (EntryImpl)o;
            return this.equals(entry);
        }

        @Override
        public boolean equals(Entry entry) {
            if (this.k != null ? !this.k.equals(entry.key()) : entry.key() != null) {
                return false;
            }
            return !(this.v == null ? entry.value() != null : !this.v.equals(entry.value()));
        }

        public int hashCode() {
            int result = this.k != null ? this.k.hashCode() : 0;
            result = 31 * result + (this.v != null ? this.v.hashCode() : 0);
            return result;
        }

        @Override
        public int compareTo(Entry entry) {
            Exceptions.requireNonNull(entry);
            return this.key().toString().compareTo(entry.key().toString());
        }

        public String toString() {
            return "{\"k\":" + this.k + ", \"v\":" + this.v + '}';
        }
    }

    public static interface Entry<K, V>
    extends Comparable<Entry>,
    Serializable,
    Cloneable {
        public K key();

        public V value();

        public boolean equals(Entry var1);
    }
}

