/*
 * Decompiled with CFR 0.152.
 */
package org.boon.sort;

import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.boon.Exceptions;
import org.boon.Str;
import org.boon.core.Conversions;
import org.boon.core.Typ;
import org.boon.core.reflection.BeanUtils;
import org.boon.core.reflection.Fields;
import org.boon.core.reflection.fields.FieldAccess;

public class Ordering {
    private static final Logger log = Logger.getLogger(Ordering.class.getName());

    public static Comparable comparable(Object comparable) {
        return (Comparable)comparable;
    }

    public static void sortAsc(List list) {
        Ordering.sortAsc(list, "this");
    }

    public static void sortDesc(List list) {
        Ordering.sortDesc(list, "this");
    }

    public static void sortAsc(List list, String sortBy) {
        if (list == null || list.size() == 0) {
            return;
        }
        Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(list.iterator().next());
        Ordering.sortAsc(list, sortBy, fields);
    }

    public static void sortDesc(List list, String sortBy) {
        if (list == null || list.size() == 0) {
            return;
        }
        Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(list.iterator().next());
        Ordering.sortDesc(list, sortBy, fields);
    }

    public static void sortAsc(List list, String sortBy, Map<String, FieldAccess> fields) {
        Ordering.sort(list, sortBy, fields, true);
    }

    public static void sortDesc(List list, String sortBy, Map<String, FieldAccess> fields) {
        Ordering.sort(list, sortBy, fields, false);
    }

    public static void sort(List list, String sortBy, Map<String, FieldAccess> fields, boolean ascending) {
        if (list == null || list.size() == 0) {
            return;
        }
        Object o = list.get(0);
        if (sortBy.equals("this") && o instanceof Comparable) {
            Collections.sort(list);
            if (!ascending) {
                Collections.reverse(list);
            }
            return;
        }
        FieldAccess field = fields.get(sortBy);
        if (field != null) {
            Collections.sort(list, Ordering.universalComparator(field, ascending));
        }
    }

    public static Comparator universalComparator(final FieldAccess field, final boolean ascending) {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                Object value1 = null;
                Object value2 = null;
                if (ascending) {
                    value1 = field.getValue(o1);
                    value2 = field.getValue(o2);
                } else {
                    value1 = field.getValue(o2);
                    value2 = field.getValue(o1);
                }
                return Ordering.compare(value1, value2);
            }
        };
    }

    public static Comparator universalComparator(final String sortBy, final Map<String, FieldAccess> fields, final boolean ascending, final List<Comparator> comparators) {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                int compare;
                block8: {
                    Comparator comparator;
                    Object value1 = null;
                    Object value2 = null;
                    if (sortBy.equals("this") && o1 instanceof Comparable) {
                        if (ascending) {
                            value1 = o1;
                            value2 = o2;
                        } else {
                            value1 = o2;
                            value2 = o1;
                        }
                    } else {
                        FieldAccess field = (FieldAccess)fields.get(sortBy);
                        if (field == null) {
                            Exceptions.die(Str.lines("The fields was null for sortBy " + sortBy, String.format("fields = %s", fields), String.format("Outer object type = %s", o1.getClass().getName()), String.format("Outer object is %s", o1)));
                        }
                        if (ascending) {
                            value1 = field.getValue(o1);
                            value2 = field.getValue(o2);
                        } else {
                            value1 = field.getValue(o2);
                            value2 = field.getValue(o1);
                        }
                    }
                    compare = Ordering.compare(value1, value2);
                    if (compare != 0) break block8;
                    Iterator i$ = comparators.iterator();
                    while (i$.hasNext() && (compare = (comparator = (Comparator)i$.next()).compare(o1, o2)) == 0) {
                    }
                }
                return compare;
            }
        };
    }

    public static int compare(Object value1, Object value2) {
        if (value1 == null && value2 == null) {
            return 0;
        }
        if (value1 == null && value2 != null) {
            return -1;
        }
        if (value1 != null && value2 == null) {
            return 1;
        }
        if (value1 instanceof CharSequence) {
            String str1 = Conversions.toString(value1);
            String str2 = Conversions.toString(value2);
            Collator collator = Collator.getInstance();
            return collator.compare(str1, str2);
        }
        if (Typ.isComparable(value1)) {
            Comparable c1 = Ordering.comparable(value1);
            Comparable c2 = Ordering.comparable(value2);
            return c1.compareTo(c2);
        }
        String name = Fields.getSortableField(value1);
        String sv1 = (String)BeanUtils.getPropByPath(value1, name);
        String sv2 = (String)BeanUtils.getPropByPath(value2, name);
        return Ordering.compare(sv1, sv2);
    }
}

