/*
 * Decompiled with CFR 0.152.
 */
package org.boon.primitive;

import org.boon.Exceptions;
import org.boon.Universal;
import org.boon.core.reflection.Invoker;

public class Shrt {
    public static short[] shorts(short ... array) {
        return array;
    }

    public static short[] grow(short[] array, int size) {
        Exceptions.requireNonNull(array);
        short[] newArray = new short[array.length + size];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static short[] grow(short[] array) {
        Exceptions.requireNonNull(array);
        short[] newArray = new short[array.length * 2];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static short[] shrink(short[] array, int size) {
        Exceptions.requireNonNull(array);
        short[] newArray = new short[array.length - size];
        System.arraycopy(array, 0, newArray, 0, array.length - size);
        return newArray;
    }

    public static short[] compact(short[] array) {
        Exceptions.requireNonNull(array);
        int nullCount = 0;
        for (short ch : array) {
            if (ch != 0) continue;
            ++nullCount;
        }
        short[] newArray = new short[array.length - nullCount];
        int j = 0;
        for (short ch : array) {
            if (ch == 0) continue;
            newArray[j] = ch;
            ++j;
        }
        return newArray;
    }

    public static short[] arrayOfShort(int size) {
        return new short[size];
    }

    @Universal
    public static short[] array(short ... array) {
        Exceptions.requireNonNull(array);
        return array;
    }

    @Universal
    public static int len(short[] array) {
        return array.length;
    }

    @Universal
    public static int lengthOf(short[] array) {
        return array.length;
    }

    @Universal
    public static short idx(short[] array, int index) {
        int i = Shrt.calculateIndex(array, index);
        return array[i];
    }

    @Universal
    public static void idx(short[] array, int index, short value) {
        int i = Shrt.calculateIndex(array, index);
        array[i] = value;
    }

    @Universal
    public static short[] slc(short[] array, int startIndex, int endIndex) {
        int start = Shrt.calculateIndex(array, startIndex);
        int end = Shrt.calculateIndex(array, endIndex);
        int newLength = end - start;
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, end index %d, length %d", startIndex, endIndex, array.length));
        }
        short[] newArray = new short[newLength];
        System.arraycopy(array, start, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static short[] sliceOf(short[] array, int startIndex, int endIndex) {
        int start = Shrt.calculateIndex(array, startIndex);
        int end = Shrt.calculateIndex(array, endIndex);
        int newLength = end - start;
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, end index %d, length %d", startIndex, endIndex, array.length));
        }
        short[] newArray = new short[newLength];
        System.arraycopy(array, start, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static short[] slc(short[] array, int startIndex) {
        int start = Shrt.calculateIndex(array, startIndex);
        int newLength = array.length - start;
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, length %d", startIndex, array.length));
        }
        short[] newArray = new short[newLength];
        System.arraycopy(array, start, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static short[] sliceOf(short[] array, int startIndex) {
        int start = Shrt.calculateIndex(array, startIndex);
        int newLength = array.length - start;
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, length %d", startIndex, array.length));
        }
        short[] newArray = new short[newLength];
        System.arraycopy(array, start, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static short[] endSliceOf(short[] array, int endIndex) {
        int end;
        Exceptions.requireNonNull(array);
        int newLength = end = Shrt.calculateIndex(array, endIndex);
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, length %d", endIndex, array.length));
        }
        short[] newArray = new short[newLength];
        System.arraycopy(array, 0, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static short[] slcEnd(short[] array, int endIndex) {
        int end;
        Exceptions.requireNonNull(array);
        int newLength = end = Shrt.calculateIndex(array, endIndex);
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, length %d", endIndex, array.length));
        }
        short[] newArray = new short[newLength];
        System.arraycopy(array, 0, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static boolean in(short value, short[] array) {
        for (short currentValue : array) {
            if (currentValue != value) continue;
            return true;
        }
        return false;
    }

    @Universal
    public static short[] copy(short[] array) {
        Exceptions.requireNonNull(array);
        short[] newArray = new short[array.length];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    @Universal
    public static short[] add(short[] array, short v) {
        Exceptions.requireNonNull(array);
        short[] newArray = new short[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = v;
        return newArray;
    }

    @Universal
    public static short[] add(short[] array, short[] array2) {
        Exceptions.requireNonNull(array);
        short[] newArray = new short[array.length + array2.length];
        System.arraycopy(array, 0, newArray, 0, array.length);
        System.arraycopy(array2, 0, newArray, array.length, array2.length);
        return newArray;
    }

    @Universal
    public static short[] insert(short[] array, int idx, short v) {
        Exceptions.requireNonNull(array);
        if (idx >= array.length) {
            return Shrt.add(array, v);
        }
        int index = Shrt.calculateIndex(array, idx);
        short[] newArray = new short[array.length + 1];
        if (index != 0) {
            System.arraycopy(array, 0, newArray, 0, index);
        }
        boolean lastIndex = index == array.length - 1;
        int remainingIndex = array.length - index;
        if (lastIndex) {
            System.arraycopy(array, index, newArray, index + 1, remainingIndex);
        } else {
            System.arraycopy(array, index, newArray, index + 1, remainingIndex);
        }
        newArray[index] = v;
        return newArray;
    }

    @Universal
    public static short[] insert(short[] array, int fromIndex, short[] values) {
        Exceptions.requireNonNull(array);
        if (fromIndex >= array.length) {
            return Shrt.add(array, values);
        }
        int index = Shrt.calculateIndex(array, fromIndex);
        short[] newArray = new short[array.length + values.length];
        if (index != 0) {
            System.arraycopy(array, 0, newArray, 0, index);
        }
        boolean lastIndex = index == array.length - 1;
        int toIndex = index + values.length;
        int remainingIndex = newArray.length - toIndex;
        if (lastIndex) {
            System.arraycopy(array, index, newArray, index + values.length, remainingIndex);
        } else {
            System.arraycopy(array, index, newArray, index + values.length, remainingIndex);
        }
        int i = index;
        int j = 0;
        while (i < toIndex) {
            newArray[i] = values[j];
            ++i;
            ++j;
        }
        return newArray;
    }

    private static int calculateIndex(short[] array, int originalIndex) {
        int length = array.length;
        Exceptions.requireNonNull(array, "array cannot be null");
        int index = originalIndex;
        if (index < 0) {
            index = length + index;
        }
        if (index < 0) {
            index = 0;
        }
        if (index >= length) {
            index = length - 1;
        }
        return index;
    }

    public static int reduceBy(short[] array, Object object) {
        int sum = 0;
        for (short v : array) {
            sum = ((Short)Invoker.invokeReducer(object, sum, v)).shortValue();
        }
        return sum;
    }
}

