/*
 * Decompiled with CFR 0.152.
 */
package org.boon.di.impl;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.boon.Boon;
import org.boon.Exceptions;
import org.boon.collections.ConcurrentLinkedHashSet;
import org.boon.core.Supplier;
import org.boon.core.reflection.BeanUtils;
import org.boon.core.reflection.Fields;
import org.boon.core.reflection.Invoker;
import org.boon.core.reflection.MapObjectConversion;
import org.boon.core.reflection.Reflection;
import org.boon.core.reflection.fields.FieldAccess;
import org.boon.di.Context;
import org.boon.di.Module;
import org.boon.di.ProviderInfo;
import org.boon.json.JsonFactory;

public class ContextImpl
implements Context,
Module {
    protected ConcurrentLinkedHashSet<Module> modules = new ConcurrentLinkedHashSet();
    private String name;
    private AtomicReference<Context> parent = new AtomicReference();

    @Override
    public void setParent(Context context) {
        this.parent.set(context);
    }

    @Override
    public Iterable<Object> values() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Module m : this.modules) {
            for (Object o : m.values()) {
                list.add(o);
            }
        }
        return list;
    }

    @Override
    public Iterable<String> names() {
        ArrayList<String> list = new ArrayList<String>();
        for (Module m : this.modules) {
            for (String n : m.names()) {
                list.add(n);
            }
        }
        return list;
    }

    @Override
    public Iterable<Class<?>> types() {
        ArrayList list = new ArrayList();
        for (Module m : this.modules) {
            for (Class<?> c : m.types()) {
                list.add(c);
            }
        }
        return list;
    }

    @Override
    public Iterable<Module> children() {
        return this.modules;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ContextImpl(Module ... modules) {
        for (Module module : modules) {
            module.setParent(this);
            this.modules.add(module);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T get(Class<T> type) {
        T object = null;
        for (Module module : this.modules) {
            if (!module.has(type)) continue;
            object = module.get(type);
            break;
        }
        this.resolveProperties(object, this.getProviderInfo(type));
        T t = object;
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T get(Class<T> type, String name) {
        T object = null;
        for (Module module : this.modules) {
            if (!module.has(name)) continue;
            object = module.get(type, name);
            break;
        }
        this.resolveProperties(object, this.getProviderInfo(type, name));
        T t = object;
        return t;
    }

    @Override
    public ProviderInfo getProviderInfo(Class<?> type) {
        ProviderInfo pi = null;
        for (Module module : this.modules) {
            if (!module.has(type)) continue;
            pi = module.getProviderInfo(type);
            break;
        }
        return pi;
    }

    @Override
    public ProviderInfo getProviderInfo(String name) {
        ProviderInfo pi = null;
        for (Module module : this.modules) {
            if (!module.has(name)) continue;
            pi = module.getProviderInfo(name);
            break;
        }
        return pi;
    }

    @Override
    public ProviderInfo getProviderInfo(Class<?> type, String name) {
        ProviderInfo pi = null;
        for (Module module : this.modules) {
            if (!module.has(name)) continue;
            pi = module.getProviderInfo(type, name);
            break;
        }
        return pi;
    }

    @Override
    public boolean has(Class type) {
        for (Module module : this.modules) {
            if (!module.has(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean has(String name) {
        for (Module module : this.modules) {
            if (!module.has(name)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Supplier<T> getSupplier(final Class<T> type, final String name) {
        Supplier<T> supplier = null;
        for (Module module : this.modules) {
            if (!module.has(name)) continue;
            supplier = module.getSupplier(type, name);
            break;
        }
        final Supplier<T> s = supplier;
        final ContextImpl resolver = this;
        Supplier supplier2 = new Supplier<T>(){
            String supplierName;
            Class<T> supplierType;
            {
                this.supplierName = name;
                this.supplierType = type;
            }

            @Override
            public T get() {
                Object o = s.get();
                resolver.resolveProperties(o);
                return o;
            }
        };
        return supplier2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Supplier<T> getSupplier(Class<T> type) {
        Supplier<T> supplier = null;
        for (Module module : this.modules) {
            if (!module.has(type)) continue;
            supplier = module.getSupplier(type);
            break;
        }
        final Supplier<T> s = supplier;
        ContextImpl resolver = this;
        Supplier supplier2 = new Supplier<T>(){

            @Override
            public T get() {
                Object o = s.get();
                ContextImpl.this.resolveProperties(o);
                return o;
            }
        };
        return supplier2;
    }

    private void resolveProperties(Object object, ProviderInfo info) {
        if (object != null) {
            if (Fields.hasField(object, "__init__") && BeanUtils.idxBoolean(object, "__init__")) {
                return;
            }
            if (info != null && info.isPostConstructCalled() && info.value() != null && !info.prototype()) {
                return;
            }
            Map<String, FieldAccess> fields = Reflection.getAllAccessorFields(object.getClass(), true);
            for (FieldAccess field : fields.values()) {
                if (!field.injectable()) continue;
                this.handleInjectionOfField(object, field);
            }
            Invoker.invokeMethodWithAnnotationNoReturn(object, "postConstruct");
            if (info != null && info.value() != null && !info.prototype()) {
                info.setPostConstructCalled(true);
            }
        }
    }

    @Override
    public void resolveProperties(Object object) {
        this.resolveProperties(object, null);
    }

    private void handleInjectionOfField(Object object, FieldAccess field) {
        Object value = null;
        boolean fieldNamed = field.isNamed();
        value = fieldNamed && field.type() != Supplier.class ? (Object)this.get(field.type(), field.named()) : (fieldNamed && field.type() == Supplier.class ? this.getSupplier(field.getComponentClass(), field.named()) : (Object)this.get(field.type()));
        if (value == null && field.isNamed() && (value = this.get(field.named())) != null) {
            field.type().isAssignableFrom(value.getClass());
        }
        if (field.requiresInjection() && value == null) {
            this.debug();
            Exceptions.die(Boon.sputs("Unable to inject into", field.getName(), " of ", field.parent(), "with alias\n", field.named(), "was named", field.isNamed(), "field info", field, "\n"));
        }
        field.setValue(object, value);
    }

    @Override
    public void debug() {
        Boon.puts(this, "----debug----");
        if (this.parent.get() != null) {
            Boon.puts(this, "delegating to parent----");
            this.parent.get().debug();
        } else {
            this.displayModuleInfo();
        }
    }

    private void displayModuleInfo() {
        int index = 0;
        for (Module module : this.modules) {
            if (module instanceof ContextImpl) {
                ContextImpl context = (ContextImpl)module;
                context.displayModuleInfo();
            } else {
                Boon.puts(index, module);
                Boon.puts("Names:---------------------------");
                for (String string : module.names()) {
                    Boon.puts("              ", string);
                }
                Boon.puts("Type--:---------------------------");
                for (Class clazz : module.types()) {
                    Boon.puts("              ", this.name);
                }
                Boon.puts("Object--:---------------------------");
                for (Object object : module.values()) {
                    Boon.puts("              ", this.name);
                }
            }
            ++index;
        }
    }

    @Override
    public Object get(String name) {
        Map map;
        Object object = null;
        for (Module module : this.modules) {
            if (!module.has(name)) continue;
            object = module.get(name);
            break;
        }
        if (object instanceof Map && (map = (Map)object).containsKey("class")) {
            object = MapObjectConversion.fromMap(map);
        }
        this.resolveProperties(object, this.getProviderInfo(name));
        return object;
    }

    @Override
    public Object invoke(String objectName, String methodName, Object args) {
        Object object = this.get(objectName);
        return Invoker.invokeFromObject(object, methodName, args);
    }

    @Override
    public Object invokeOverload(String objectName, String methodName, Object args) {
        Object object = this.get(objectName);
        return Invoker.invokeOverloadedFromObject(object, methodName, args);
    }

    @Override
    public Object invokeFromJson(String objectName, String methodName, String args) {
        return this.invoke(objectName, methodName, JsonFactory.fromJson(args));
    }

    @Override
    public Object invokeOverloadFromJson(String objectName, String methodName, String args) {
        return this.invokeOverload(objectName, methodName, JsonFactory.fromJson(args));
    }

    @Override
    public Context add(Module module) {
        module.setParent(this);
        this.modules.add(module);
        return this;
    }

    @Override
    public Context remove(Module module) {
        module.setParent(null);
        this.modules.remove(module);
        return this;
    }

    @Override
    public Context addFirst(Module module) {
        module.setParent(this);
        this.modules.addFirst(module);
        return this;
    }

    public String toString() {
        return "ContextImpl{, name='" + this.name + '\'' + '}';
    }
}

