/*
 * Decompiled with CFR 0.152.
 */
package org.boon.datarepo;

import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.boon.Exceptions;
import org.boon.core.Function;
import org.boon.core.Typ;
import org.boon.core.reflection.BeanUtils;
import org.boon.core.reflection.Fields;
import org.boon.core.reflection.fields.FieldAccess;
import org.boon.criteria.internal.Criteria;
import org.boon.datarepo.CollectionDecorator;
import org.boon.datarepo.DataRepoException;
import org.boon.datarepo.Filter;
import org.boon.datarepo.LookupIndex;
import org.boon.datarepo.SearchableCollection;
import org.boon.datarepo.impl.decorators.FilterWithSimpleCache;
import org.boon.datarepo.spi.SPIFactory;
import org.boon.datarepo.spi.SearchIndex;
import org.boon.datarepo.spi.SearchableCollectionComposer;

public class Collections {
    public static <T> List<T> $q(List<T> list, Class<?> ... classes) {
        return Collections.listQuery(list, true, true, classes);
    }

    public static <T> List<T> $c(List<T> list) {
        return Collections.plainList(list);
    }

    private static <T> List<T> plainList(List<T> list) {
        if (list instanceof QList) {
            return ((QList)list).list;
        }
        return list;
    }

    public static <T> List<T> listQuery(List<T> list) {
        return Collections.listQuery(list, true, true, new Class[0]);
    }

    public static <T> List<T> listQuery(List<T> list, boolean useField, boolean useUnSafe, Class<?> ... classes) {
        if (list == null || list.size() == 0) {
            return list;
        }
        SearchableCollectionComposer query = null;
        if (classes == null || classes.length == 0) {
            Class<?> clazz = list.get(0).getClass();
            query = Collections.getSearchableCollectionComposer(list, useField, useUnSafe, clazz);
        } else {
            query = Collections.getSearchableCollectionComposer(list, useField, useUnSafe, classes);
        }
        return new QList<T>(list, (SearchableCollection)((Object)query));
    }

    public static <T> Set<T> $q(Set<T> set) {
        return Collections.setQuery(set, true, true);
    }

    public static <T> Set<T> $c(Set<T> set) {
        return Collections.plainSet(set);
    }

    private static <T> Set<T> plainSet(Set<T> set) {
        if (set instanceof QSet) {
            return ((QSet)set).set;
        }
        return set;
    }

    public static <T> Set<T> setQuery(Set<T> set) {
        return Collections.setQuery(set, true, true);
    }

    public static <T> Set<T> setQuery(Set<T> set, boolean useField, boolean useUnSafe) {
        if (set == null || set.size() == 0) {
            return set;
        }
        Class<?> clazz = set.iterator().next().getClass();
        SearchableCollectionComposer query = Collections.getSearchableCollectionComposer(set, useField, useUnSafe, clazz);
        return new QSet<T>(set, (SearchableCollection)((Object)query));
    }

    private static <T> SearchableCollectionComposer getSearchableCollectionComposer(Collection set, boolean useField, boolean useUnSafe, Class<?> ... classes) {
        SearchableCollectionComposer query = SPIFactory.getSearchableCollectionFactory().get();
        LinkedHashMap<String, FieldAccess> fields = new LinkedHashMap<String, FieldAccess>();
        for (Class<?> cls : classes) {
            Map<String, FieldAccess> fieldsSubType = BeanUtils.getFieldsFromObject(cls);
            for (String sKey : fieldsSubType.keySet()) {
                if (fields.containsKey(sKey)) continue;
                fields.put(sKey, fieldsSubType.get(sKey));
            }
        }
        String primaryKey = Collections.findPrimaryKey(fields);
        FieldAccess field = (FieldAccess)fields.get(primaryKey);
        Function keyGetter = Collections.createKeyGetter(field);
        query.setFields(fields);
        query.setPrimaryKeyGetter(keyGetter);
        query.setPrimaryKeyName(primaryKey);
        Filter filter = SPIFactory.getFilterFactory().get();
        query.setFilter(filter);
        LookupIndex index = SPIFactory.getUniqueLookupIndexFactory().apply(((FieldAccess)fields.get(primaryKey)).type());
        index.setKeyGetter(keyGetter);
        ((SearchableCollection)((Object)query)).addLookupIndex(primaryKey, index);
        for (FieldAccess f : fields.values()) {
            if (f.getName().equals(primaryKey) || !Typ.isBasicType(f.type())) continue;
            Collections.configIndexes((SearchableCollection)((Object)query), f.getName(), fields);
        }
        query.init();
        query.setFilter(new FilterWithSimpleCache(filter));
        ((SearchableCollection)((Object)query)).addAll(set);
        return query;
    }

    public static <T> List<T> query(List<T> list, Criteria ... expressions) {
        if (list instanceof QList) {
            QList qlist = (QList)list;
            return qlist.searchCollection().query(expressions);
        }
        throw new DataRepoException("Not a criteria-able listStream.");
    }

    public static <T> List<T> sortedQuery(List<T> list, String sortBy, Criteria ... expressions) {
        if (list instanceof QList) {
            QList qlist = (QList)list;
            return qlist.searchCollection().sortedQuery(sortBy, expressions);
        }
        throw new DataRepoException("Not a criteria-able listStream.");
    }

    public static <T> List<T> query(Set<T> set, Criteria ... expressions) {
        if (set instanceof QSet) {
            QSet qset = (QSet)set;
            return qset.searchCollection().query(expressions);
        }
        return null;
    }

    public static <T> List<T> sortedQuery(Set<T> set, String sortBy, Criteria ... expressions) {
        if (set instanceof QSet) {
            QSet qset = (QSet)set;
            return qset.searchCollection().sortedQuery(sortBy, expressions);
        }
        return null;
    }

    private static String findPrimaryKey(Map<String, FieldAccess> fields) {
        return "id";
    }

    private static Function createKeyGetter(final FieldAccess field) {
        Exceptions.requireNonNull(field, "field cannot be null");
        return new Function(){

            public Object apply(Object o) {
                if (Fields.hasField(o.getClass(), field.getName())) {
                    return field.getValue(o);
                }
                return null;
            }
        };
    }

    private static void configIndexes(SearchableCollection query, String prop, Map<String, FieldAccess> fields) {
        SearchIndex searchIndex = SPIFactory.getSearchIndexFactory().apply(fields.get(prop).type());
        searchIndex.init();
        Function kg = Collections.createKeyGetter(fields.get(prop));
        searchIndex.setKeyGetter(kg);
        query.addSearchIndex(prop, searchIndex);
        LookupIndex index = SPIFactory.getLookupIndexFactory().apply(fields.get(prop).type());
        index.setKeyGetter(kg);
        query.addLookupIndex(prop, index);
    }

    static class QList<T>
    extends AbstractList<T>
    implements CollectionDecorator {
        List<T> list;
        SearchableCollection query;

        QList(List<T> list, SearchableCollection query) {
            this.list = list;
            this.query = query;
        }

        @Override
        public boolean add(T item) {
            this.query.add(item);
            return this.list.add(item);
        }

        @Override
        public boolean remove(Object item) {
            this.query.delete(item);
            return this.list.remove(item);
        }

        @Override
        public T get(int index) {
            return this.list.get(index);
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public SearchableCollection searchCollection() {
            return this.query;
        }

        @Override
        public Collection collection() {
            return this.list;
        }
    }

    static class QSet<T>
    extends AbstractSet<T>
    implements CollectionDecorator {
        final Set<T> set;
        final SearchableCollection searchCollection;

        QSet(Set<T> set, SearchableCollection searchCollection) {
            this.set = set;
            this.searchCollection = searchCollection;
        }

        @Override
        public boolean add(T item) {
            this.searchCollection.add(item);
            return this.set.add(item);
        }

        @Override
        public boolean remove(Object item) {
            this.searchCollection.delete(item);
            return this.set.remove(item);
        }

        @Override
        public Iterator<T> iterator() {
            return this.set.iterator();
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public SearchableCollection searchCollection() {
            return this.searchCollection;
        }

        @Override
        public Collection collection() {
            return this.set;
        }
    }
}

