/*
 * Decompiled with CFR 0.152.
 */
package org.boon.criteria;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.boon.Boon;
import org.boon.core.Conversions;
import org.boon.core.Typ;
import org.boon.core.reflection.BeanUtils;
import org.boon.core.reflection.fields.FieldAccess;
import org.boon.criteria.Criterion;
import org.boon.criteria.internal.Criteria;
import org.boon.criteria.internal.Group;
import org.boon.criteria.internal.Not;
import org.boon.criteria.internal.Operator;

public class ObjectFilter {
    public static boolean matches(Object obj, Criteria ... exp) {
        return ObjectFilter.and(exp).test(obj);
    }

    public static boolean matches(Object obj, List<Criteria> expressions) {
        return ObjectFilter.and(expressions.toArray(new Criteria[expressions.size()])).test(obj);
    }

    public static <T> List<T> filter(Collection<T> items, List<Criteria> expressions) {
        if (items.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<T> results = new ArrayList<T>();
        for (T item : items) {
            if (!ObjectFilter.and(expressions.toArray(new Criteria[expressions.size()])).test((Object)item)) continue;
            results.add(item);
        }
        return results;
    }

    public static <T> List<T> filter(Collection<T> items, Criteria ... exp) {
        if (items.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<T> results = new ArrayList<T>();
        for (T item : items) {
            if (!ObjectFilter.and(exp).test((Object)item)) continue;
            results.add(item);
        }
        return results;
    }

    public static Not not(Criteria expression) {
        return new Not(expression);
    }

    public static Group and(Criteria ... expressions) {
        return new Group.And(expressions);
    }

    public static Group or(Criteria ... expressions) {
        return new Group.Or(expressions);
    }

    public static Criterion eqNestedAdvanced(Object value, final Object ... path) {
        return new Criterion<Object>(Boon.joinBy('.', path), Operator.EQUAL, new Object[]{value}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                Object v = BeanUtils.getPropByPath(path, new String[0]);
                if (v instanceof List) {
                    List list = (List)v;
                    for (Object i : list) {
                        if (!i.equals(this.value)) continue;
                        return false;
                    }
                    return true;
                }
                return this.value.equals(v);
            }
        };
    }

    public static Criterion eqNested(Object value, final String ... path) {
        return new Criterion<Object>(Boon.joinBy('.', path), Operator.EQUAL, new Object[]{value}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                Object v = BeanUtils.getPropertyValue(owner, path);
                if (v instanceof List) {
                    List list = (List)v;
                    for (Object i : list) {
                        if (!i.equals(this.value)) continue;
                        return false;
                    }
                    return true;
                }
                return this.value.equals(v);
            }
        };
    }

    public static Criterion eq(final Object name, Object value) {
        return new Criterion<Object>(name.toString(), Operator.EQUAL, new Object[]{value}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                return this.value.equals(field.getValue(owner));
            }
        };
    }

    public static Criterion typeOf(final String className) {
        return new Criterion<Object>("_type", Operator.EQUAL, new Object[]{className}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                for (Class<?> cls = owner.getClass(); cls != Typ.object; cls = cls.getSuperclass()) {
                    Class<?>[] interfaces;
                    String simpleName = cls.getSimpleName();
                    String name = cls.getName();
                    if (simpleName.equals(className) || name.equals(className)) {
                        return true;
                    }
                    for (Class<?> i : interfaces = cls.getInterfaces()) {
                        simpleName = i.getSimpleName();
                        name = i.getName();
                        if (!simpleName.equals(className) && !name.equals(className)) continue;
                        return true;
                    }
                }
                return false;
            }
        };
    }

    public static Criterion instanceOf(final Class<?> cls) {
        return new Criterion<Object>("_type", Operator.EQUAL, new Object[]{cls.getName()}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                return Typ.isSuperClass(owner.getClass(), cls);
            }
        };
    }

    public static Criterion implementsInterface(final Class<?> cls) {
        return new Criterion<Object>("_type", Operator.EQUAL, new Object[]{cls.getName()}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                return Typ.implementsInterface(owner.getClass(), cls);
            }
        };
    }

    public static Criterion notEq(final Object name, Object value) {
        return new Criterion<Object>(name.toString(), Operator.NOT_EQUAL, new Object[]{value}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                return !this.value.equals(field.getValue(owner));
            }
        };
    }

    public static Criterion notIn(final Object name, Object ... values) {
        return new Criterion<Object>(name.toString(), Operator.NOT_IN, values){
            HashSet set;
            {
                super(x0, x1, x2);
                this.set = new HashSet();
                for (Object value : this.values) {
                    this.set.add(value);
                }
            }

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                Object value = field.getValue(owner);
                if (value == null) {
                    return false;
                }
                return !this.set.contains(value);
            }
        };
    }

    public static Criterion in(final Object name, Object ... values) {
        return new Criterion<Object>(name.toString(), Operator.IN, values){
            HashSet set;
            {
                super(x0, x1, x2);
                this.set = new HashSet();
                for (Object value : this.values) {
                    this.set.add(value);
                }
            }

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                return this.set.contains(field.getValue(owner));
            }
        };
    }

    public static Criterion lt(final Object name, Object value) {
        return new Criterion<Object>(name.toString(), Operator.LESS_THAN, new Object[]{value}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                return ((Comparable)this.value).compareTo(field.getValue(owner)) > 0;
            }
        };
    }

    public static Criterion lte(final Object name, Object value) {
        return new Criterion<Object>(name.toString(), Operator.LESS_THAN_EQUAL, new Object[]{value}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                return ((Comparable)this.value).compareTo(field.getValue(owner)) >= 0;
            }
        };
    }

    public static Criterion gt(final Object name, Object value) {
        return new Criterion<Object>(name.toString(), Operator.GREATER_THAN, new Object[]{value}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                return ((Comparable)this.value).compareTo(field.getValue(owner)) < 0;
            }
        };
    }

    public static Criterion gte(final Object name, Object value) {
        return new Criterion<Object>(name.toString(), Operator.GREATER_THAN_EQUAL, new Object[]{value}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                return ((Comparable)this.value).compareTo(field.getValue(owner)) <= 0;
            }
        };
    }

    public static Criterion between(final Object name, Object value, final Object value2) {
        return new Criterion<Object>(name.toString(), Operator.BETWEEN, new Object[]{value, value2}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                return ((Comparable)this.value).compareTo(field.getValue(owner)) <= 0 && ((Comparable)value2).compareTo(field.getValue(owner)) >= 0;
            }
        };
    }

    public static Criterion between(Class clazz, Object name, String svalue, String svalue2) {
        FieldAccess field = null;
        Criterion c = null;
        if (clazz != null) {
            field = BeanUtils.getField(clazz, name.toString());
        }
        if (field == null) {
            c = ObjectFilter.between(name, svalue, svalue2);
        } else {
            Object o = Conversions.coerce(field.type(), svalue);
            Object o2 = Conversions.coerce(field.type(), svalue2);
            c = ObjectFilter.between(name, o, o2);
        }
        c.initByClass(clazz);
        return c;
    }

    public static Criterion between(final Object name, String svalue, String svalue2) {
        return new Criterion<Object>(name.toString(), Operator.BETWEEN, new Object[]{svalue, svalue2}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                return ((Comparable)this.value).compareTo(field.getValue(owner)) <= 0 && ((Comparable)this.values[1]).compareTo(field.getValue(owner)) >= 0;
            }
        };
    }

    public static Criterion gt(final Object name, String svalue) {
        return new Criterion<Object>(name.toString(), Operator.GREATER_THAN, new Object[]{svalue}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                Object fieldValue = field.getValue(owner);
                return ((Comparable)this.value).compareTo(fieldValue) < 0;
            }
        };
    }

    public static Criterion startsWith(final Object name, Object value) {
        return new Criterion<Object>(name.toString(), Operator.STARTS_WITH, new Object[]{value}){
            String sValue;
            {
                super(x0, x1, x2);
                this.sValue = this.value instanceof String ? (String)this.value : this.value.toString();
            }

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                Object itemValue = field.getValue(owner);
                String sItemvalue = itemValue instanceof String ? (String)itemValue : itemValue.toString();
                return sItemvalue.startsWith(this.sValue);
            }
        };
    }

    public static Criterion endsWith(final Object name, Object value) {
        return new Criterion<Object>(name.toString(), Operator.ENDS_WITH, new Object[]{value}){
            String sValue;
            {
                super(x0, x1, x2);
                this.sValue = this.value instanceof String ? (String)this.value : this.value.toString();
            }

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                Object itemValue = field.getValue(owner);
                String sItemvalue = itemValue instanceof String ? (String)itemValue : itemValue.toString();
                return sItemvalue.endsWith(this.sValue);
            }
        };
    }

    public static Criterion notContains(Object name, Object value) {
        return ObjectFilter.doContains(name, value, true);
    }

    public static Criterion contains(Object name, Object value) {
        return ObjectFilter.doContains(name, value, false);
    }

    private static Criterion doContains(final Object name, Object value, final boolean not) {
        return new Criterion<Object>(name.toString(), not ? Operator.NOT_CONTAINS : Operator.CONTAINS, new Object[]{value}){
            String sValue;
            {
                super(x0, x1, x2);
                this.sValue = this.value instanceof String ? (String)this.value : this.value.toString();
            }

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                boolean returnVal;
                FieldAccess field = fields.get(name);
                if (Typ.implementsInterface(field.type(), Typ.collection)) {
                    Collection collection = (Collection)field.getValue(owner);
                    returnVal = collection.contains(this.value);
                } else if (field.type().isArray()) {
                    returnVal = false;
                    Object array = field.getValue(owner);
                    Iterator iter = Boon.iterator(array);
                    while (iter.hasNext()) {
                        Object i = iter.next();
                        if (!i.equals(this.value)) continue;
                        returnVal = true;
                    }
                } else {
                    Object itemValue = field.getValue(owner);
                    String sItemvalue = itemValue instanceof String ? (String)itemValue : itemValue.toString();
                    returnVal = sItemvalue.contains(this.sValue);
                }
                return not ? !returnVal : returnVal;
            }
        };
    }

    public static Criterion notEmpty(Object name) {
        return ObjectFilter.doEmpty(name, true);
    }

    public static Criterion empty(Object name) {
        return ObjectFilter.doEmpty(name, false);
    }

    private static Criterion doEmpty(final Object name, final boolean not) {
        return new Criterion<Object>(name.toString(), not ? Operator.NOT_EMPTY : Operator.IS_EMPTY, new Object[]{""}){
            String sValue;
            {
                super(x0, x1, x2);
                this.sValue = this.value instanceof String ? (String)this.value : this.value.toString();
            }

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                boolean returnVal;
                FieldAccess field = fields.get(name);
                if (Typ.implementsInterface(field.type(), Typ.collection)) {
                    Collection collection = (Collection)field.getValue(owner);
                    returnVal = collection == null || collection.isEmpty();
                } else if (field.type().isArray()) {
                    Object array = field.getValue(owner);
                    returnVal = array == null || Boon.len(array) == 0;
                } else {
                    Object obj = field.getValue(owner);
                    boolean bl = returnVal = obj == null || Boon.len(obj) == 0;
                }
                return not ? !returnVal : returnVal;
            }
        };
    }

    public static Criterion notNull(Object name) {
        return ObjectFilter.doIsNull(name, true);
    }

    public static Criterion isNull(Object name) {
        return ObjectFilter.doIsNull(name, false);
    }

    private static Criterion doIsNull(final Object name, final boolean not) {
        return new Criterion<Object>(name.toString(), not ? Operator.NOT_NULL : Operator.IS_NULL, new Object[]{""}){
            String sValue;
            {
                super(x0, x1, x2);
                this.sValue = this.value instanceof String ? (String)this.value : this.value.toString();
            }

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                boolean isNull;
                FieldAccess field = fields.get(name);
                boolean bl = isNull = field.getValue(owner) == null;
                return not ? !isNull : isNull;
            }
        };
    }

    public static Criterion eqInt(final Object name, final int compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValue}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                int value = field.getInt(owner);
                return value == compareValue;
            }
        };
    }

    public static Criterion notEqInt(final Object name, final int compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValue}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                int value = field.getInt(owner);
                return value != compareValue;
            }
        };
    }

    public static Criterion notInInts(final Object name, final int ... compareValues) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValues}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                int value = field.getInt(owner);
                for (int compareValue : compareValues) {
                    if (value != compareValue) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static Criterion inInts(final Object name, final int ... compareValues) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValues}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                int value = field.getInt(owner);
                for (int compareValue : compareValues) {
                    if (value != compareValue) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Criterion ltInt(final Object name, final int compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValue}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                int value = field.getInt(owner);
                return value < compareValue;
            }
        };
    }

    public static Criterion lteInt(final Object name, final int compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValue}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                int value = field.getInt(owner);
                return value <= compareValue;
            }
        };
    }

    public static Criterion gtInt(final Object name, final int compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValue}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                int value = field.getInt(owner);
                return value > compareValue;
            }
        };
    }

    public static Criterion gteInt(final Object name, final int compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValue}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                int value = field.getInt(owner);
                return value >= compareValue;
            }
        };
    }

    public static Criterion betweenInt(final Object name, final int start, final int stop) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.BETWEEN, new Object[]{start, stop}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                int value = field.getInt(owner);
                return value >= start && value <= stop;
            }
        };
    }

    public static Criterion eqFloat(final Object name, final float compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{Float.valueOf(compareValue)}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                float value = field.getFloat(owner);
                return value == compareValue;
            }
        };
    }

    public static Criterion notEqFloat(final Object name, final float compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{Float.valueOf(compareValue)}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                float value = field.getFloat(owner);
                return value != compareValue;
            }
        };
    }

    public static Criterion notInFloats(final Object name, final float ... compareValues) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValues}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                float value = field.getFloat(owner);
                for (float compareValue : compareValues) {
                    if (value != compareValue) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static Criterion inFloats(final Object name, final float ... compareValues) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValues}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                float value = field.getFloat(owner);
                for (float compareValue : compareValues) {
                    if (value != compareValue) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Criterion ltFloat(final Object name, final float compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{Float.valueOf(compareValue)}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                float value = field.getFloat(owner);
                return value < compareValue;
            }
        };
    }

    public static Criterion lteFloat(final Object name, final float compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{Float.valueOf(compareValue)}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                float value = field.getFloat(owner);
                return value <= compareValue;
            }
        };
    }

    public static Criterion gtFloat(final Object name, final float compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{Float.valueOf(compareValue)}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                float value = field.getFloat(owner);
                return value > compareValue;
            }
        };
    }

    public static Criterion gteFloat(final Object name, final float compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{Float.valueOf(compareValue)}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                float value = field.getFloat(owner);
                return value >= compareValue;
            }
        };
    }

    public static Criterion betweenFloat(final Object name, final float start, final float stop) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.BETWEEN, new Object[]{Float.valueOf(start), Float.valueOf(stop)}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                float value = field.getFloat(owner);
                return value >= start && value <= stop;
            }
        };
    }

    public static Criterion isTrue(Object name) {
        return ObjectFilter.eqBoolean(name, true);
    }

    public static Criterion isFalse(Object name) {
        return ObjectFilter.eqBoolean(name, false);
    }

    public static Criterion eqBoolean(final Object name, final boolean compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValue}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                boolean value = field.getBoolean(owner);
                return value == compareValue;
            }
        };
    }

    public static Criterion notEqBoolean(final Object name, final boolean compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValue}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                boolean value = field.getBoolean(owner);
                return value != compareValue;
            }
        };
    }

    public static Criterion eqDouble(final Object name, final double compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValue}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                double value = field.getDouble(owner);
                return value == compareValue;
            }
        };
    }

    public static Criterion notEqDouble(final Object name, final double compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValue}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                double value = field.getDouble(owner);
                return value != compareValue;
            }
        };
    }

    public static Criterion notInDoubles(final Object name, final double ... compareValues) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValues}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                double value = field.getDouble(owner);
                for (double compareValue : compareValues) {
                    if (value != compareValue) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static Criterion inDoubles(final Object name, final double ... compareValues) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValues}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                double value = field.getDouble(owner);
                for (double compareValue : compareValues) {
                    if (value != compareValue) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Criterion ltDouble(final Object name, final double compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValue}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                double value = field.getDouble(owner);
                return value < compareValue;
            }
        };
    }

    public static Criterion lteDouble(final Object name, final double compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValue}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                double value = field.getDouble(owner);
                return value <= compareValue;
            }
        };
    }

    public static Criterion gtDouble(final Object name, final double compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValue}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                double value = field.getDouble(owner);
                return value > compareValue;
            }
        };
    }

    public static Criterion gteDouble(final Object name, final double compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValue}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                double value = field.getDouble(owner);
                return value >= compareValue;
            }
        };
    }

    public static Criterion betweenDouble(final Object name, final double start, final double stop) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.BETWEEN, new Object[]{start, stop}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                double value = field.getDouble(owner);
                return value >= start && value <= stop;
            }
        };
    }

    public static Criterion eqShort(final Object name, final short compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValue}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                short value = field.getShort(owner);
                return value == compareValue;
            }
        };
    }

    public static Criterion notEqShort(final Object name, final short compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValue}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                short value = field.getShort(owner);
                return value != compareValue;
            }
        };
    }

    public static Criterion notInShorts(final Object name, final short ... compareValues) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValues}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                short value = field.getShort(owner);
                for (short compareValue : compareValues) {
                    if (value != compareValue) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static Criterion inShorts(final Object name, final short ... compareValues) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValues}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                short value = field.getShort(owner);
                for (short compareValue : compareValues) {
                    if (value != compareValue) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Criterion ltShort(final Object name, final short compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValue}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                short value = field.getShort(owner);
                return value < compareValue;
            }
        };
    }

    public static Criterion lteShort(final Object name, final short compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValue}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                short value = field.getShort(owner);
                return value <= compareValue;
            }
        };
    }

    public static Criterion gtShort(final Object name, final short compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValue}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                short value = field.getShort(owner);
                return value > compareValue;
            }
        };
    }

    public static Criterion gteShort(final Object name, final short compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValue}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                short value = field.getShort(owner);
                return value >= compareValue;
            }
        };
    }

    public static Criterion betweenShort(final Object name, final short start, final short stop) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.BETWEEN, new Object[]{start, stop}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                short value = field.getShort(owner);
                return value >= start && value <= stop;
            }
        };
    }

    public static Criterion eqByte(final Object name, final byte compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValue}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                byte value = field.getByte(owner);
                return value == compareValue;
            }
        };
    }

    public static Criterion notEqByte(final Object name, final byte compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValue}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                byte value = field.getByte(owner);
                return value != compareValue;
            }
        };
    }

    public static Criterion notInBytes(final Object name, final byte ... compareValues) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValues}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                byte value = field.getByte(owner);
                for (byte compareValue : compareValues) {
                    if (value != compareValue) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static Criterion inBytes(final Object name, final byte ... compareValues) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValues}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                byte value = field.getByte(owner);
                for (byte compareValue : compareValues) {
                    if (value != compareValue) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Criterion ltByte(final Object name, final byte compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValue}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                byte value = field.getByte(owner);
                return value < compareValue;
            }
        };
    }

    public static Criterion lteByte(final Object name, final byte compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValue}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                byte value = field.getByte(owner);
                return value <= compareValue;
            }
        };
    }

    public static Criterion gtByte(final Object name, final byte compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValue}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                byte value = field.getByte(owner);
                return value > compareValue;
            }
        };
    }

    public static Criterion gteByte(final Object name, final byte compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValue}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                byte value = field.getByte(owner);
                return value >= compareValue;
            }
        };
    }

    public static Criterion betweenByte(final Object name, final byte start, final byte stop) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.BETWEEN, new Object[]{start, stop}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                byte value = field.getByte(owner);
                return value >= start && value <= stop;
            }
        };
    }

    public static Criterion eqLong(final Object name, final long compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValue}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                long value = field.getLong(owner);
                return value == compareValue;
            }
        };
    }

    public static Criterion notEqLong(final Object name, final long compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValue}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                long value = field.getLong(owner);
                return value != compareValue;
            }
        };
    }

    public static Criterion notInLongs(final Object name, final long ... compareValues) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValues}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                long value = field.getLong(owner);
                for (long compareValue : compareValues) {
                    if (value != compareValue) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static Criterion inLongs(final Object name, final long ... compareValues) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValues}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                long value = field.getLong(owner);
                for (long compareValue : compareValues) {
                    if (value != compareValue) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Criterion ltLong(final Object name, final long compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValue}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                long value = field.getLong(owner);
                return value < compareValue;
            }
        };
    }

    public static Criterion lteLong(final Object name, final long compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValue}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                long value = field.getLong(owner);
                return value <= compareValue;
            }
        };
    }

    public static Criterion gtLong(final Object name, final long compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValue}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                long value = field.getLong(owner);
                return value > compareValue;
            }
        };
    }

    public static Criterion gteLong(final Object name, final long compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValue}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                long value = field.getLong(owner);
                return value >= compareValue;
            }
        };
    }

    public static Criterion betweenLong(final Object name, final long start, final long stop) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.BETWEEN, new Object[]{start, stop}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                long value = field.getLong(owner);
                return value >= start && value <= stop;
            }
        };
    }

    public static Criterion eqChar(final Object name, final char compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{Character.valueOf(compareValue)}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                char value = field.getChar(owner);
                return value == compareValue;
            }
        };
    }

    public static Criterion notEqChar(final Object name, final char compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{Character.valueOf(compareValue)}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                char value = field.getChar(owner);
                return value != compareValue;
            }
        };
    }

    public static Criterion notInChars(final Object name, final char ... compareValues) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValues}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                char value = field.getChar(owner);
                for (char compareValue : compareValues) {
                    if (value != compareValue) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static Criterion inChars(final Object name, final char ... compareValues) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{compareValues}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                char value = field.getChar(owner);
                for (char compareValue : compareValues) {
                    if (value != compareValue) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Criterion ltChar(final Object name, final char compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{Character.valueOf(compareValue)}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                char value = field.getChar(owner);
                return value < compareValue;
            }
        };
    }

    public static Criterion lteChar(final Object name, final char compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{Character.valueOf(compareValue)}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                char value = field.getChar(owner);
                return value <= compareValue;
            }
        };
    }

    public static Criterion gtChar(final Object name, final char compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{Character.valueOf(compareValue)}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                char value = field.getChar(owner);
                return value > compareValue;
            }
        };
    }

    public static Criterion gteChar(final Object name, final char compareValue) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.GREATER_THAN, new Object[]{Character.valueOf(compareValue)}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                char value = field.getChar(owner);
                return value >= compareValue;
            }
        };
    }

    public static Criterion betweenChar(final Object name, final char start, final char stop) {
        return new Criterion.PrimitiveCriterion(name.toString(), Operator.BETWEEN, new Object[]{Character.valueOf(start), Character.valueOf(stop)}){

            @Override
            public boolean resolve(Map<String, FieldAccess> fields, Object owner) {
                FieldAccess field = fields.get(name);
                char value = field.getChar(owner);
                return value >= start && value <= stop;
            }
        };
    }
}

