/*
 * Decompiled with CFR 0.152.
 */
package org.boon.criteria;

import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import org.boon.Boon;
import org.boon.Exceptions;
import org.boon.core.Conversions;
import org.boon.core.Typ;
import org.boon.core.reflection.fields.FieldAccess;
import org.boon.criteria.ObjectFilter;
import org.boon.criteria.internal.Criteria;
import org.boon.criteria.internal.Operator;
import org.boon.primitive.CharBuf;

public abstract class Criterion<VALUE>
extends Criteria {
    private String name;
    private Operator operator;
    protected VALUE value;
    protected VALUE[] values;
    private final int hashCode;
    private final String toString;
    private boolean initialized;
    private Criterion nativeDelegate;
    private boolean useDelegate;
    private FieldAccess field;
    private Object objectUnderTest;
    private Map<String, FieldAccess> fields;

    public Criterion(String name, Operator operator, VALUE ... values) {
        Exceptions.requireNonNull(name, "name cannot be null");
        Exceptions.requireNonNull((Object)operator, "operator cannot be null");
        Exceptions.requireNonNull(values, "values cannot be null");
        this.name = name;
        this.operator = operator;
        this.setValues(values);
        this.hashCode = this.doHashCode();
        this.toString = this.doToString();
    }

    public String getName() {
        return this.name;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public VALUE getValue() {
        return this.value;
    }

    public VALUE[] getValues() {
        return this.values;
    }

    public void setValues(VALUE[] values) {
        if (values.length > 0) {
            this.value = values[0];
        }
        this.values = values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Criterion)) {
            return false;
        }
        Criterion criterion = (Criterion)o;
        if (this.name != null ? !this.name.equals(criterion.name) : criterion.name != null) {
            return false;
        }
        if (this.operator != criterion.operator) {
            return false;
        }
        if (this.value != null ? !this.value.equals(criterion.value) : criterion.value != null) {
            return false;
        }
        return Arrays.equals(this.values, criterion.values);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public int doHashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.operator != null ? this.operator.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.values != null ? Arrays.hashCode(this.values) : 0);
        return result;
    }

    public String toString() {
        return this.toString;
    }

    public String doToString() {
        CharBuf builder = CharBuf.create(80);
        builder.add("c{");
        builder.add("\"name\":'");
        builder.add(String.valueOf(this.name));
        builder.add(", \"operator\":");
        builder.add(String.valueOf((Object)this.operator));
        builder.add(", \"set\":");
        builder.add(String.valueOf(this.value));
        builder.add(", \"update\":");
        builder.add(Arrays.toString(this.values));
        builder.add("}");
        return builder.toString();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void initByClass(Class clazz) {
        this.fields = this.getFieldsInternal(clazz);
        this.initIfNeeded();
    }

    public void initByFields(Map<String, FieldAccess> fields) {
        this.fields = fields;
        this.initIfNeeded();
    }

    @Override
    public void prepareForGroupTest(Map<String, FieldAccess> fields, Object owner) {
        this.fields = fields;
        this.objectUnderTest = owner;
    }

    @Override
    public void cleanAfterGroupTest() {
        this.clean();
    }

    public void clean() {
        this.field = null;
        this.fields = null;
        this.objectUnderTest = null;
    }

    @Override
    public boolean test(Object o) {
        try {
            Exceptions.requireNonNull(o, "object under test can't be null");
            this.objectUnderTest = o;
            this.initIfNeeded();
            if (this.useDelegate) {
                return this.nativeDelegate.resolve(this.fields, o);
            }
            FieldAccess field = this.fields.get(this.name);
            if (field == null && o instanceof Map) {
                return false;
            }
            boolean result = this.resolve(this.fields, o);
            return result;
        }
        catch (Exception ex) {
            return Exceptions.handle(Typ.bool, Boon.sputl("In class " + this.getClass().getName(), "the test method is unable to test the following criteria operator", String.valueOf((Object)this.getOperator()), Boon.sputs("The field name is          :          ", this.getName()), Boon.sputs("The value is               :          ", this.getValue()), Boon.sputs("The value type is          :          ", this.getValue().getClass().getName()), Boon.sputs("The object under test      :          ", this.objectUnderTest), Boon.sputs("The object under test type :          ", this.objectUnderTest == null ? "null" : this.objectUnderTest.getClass().getName()), Boon.sputs("Field                      :          ", this.field), Boon.sputs("Fields                     :          ", this.fields), Boon.sputs(new Object[0])), ex);
        }
    }

    private FieldAccess field() {
        if (this.field == null) {
            this.field = this.fields().get(this.name);
        }
        return this.field;
    }

    private Map<String, FieldAccess> fields() {
        if (this.fields == null) {
            this.fields = this.getFieldsInternal(this.objectUnderTest);
        }
        return this.fields;
    }

    private void initForShortValue(short v) {
        this.value = v;
        switch (this.operator) {
            case EQUAL: {
                this.nativeDelegate = ObjectFilter.eqShort(this.name, v);
                break;
            }
            case NOT_EQUAL: {
                this.nativeDelegate = ObjectFilter.notEqShort(this.name, v);
                break;
            }
            case LESS_THAN: {
                this.nativeDelegate = ObjectFilter.ltShort(this.name, v);
                break;
            }
            case LESS_THAN_EQUAL: {
                this.nativeDelegate = ObjectFilter.lteShort(this.name, v);
                break;
            }
            case GREATER_THAN: {
                this.nativeDelegate = ObjectFilter.gtShort(this.name, v);
                break;
            }
            case GREATER_THAN_EQUAL: {
                this.nativeDelegate = ObjectFilter.gteShort(this.name, v);
                break;
            }
            case IN: {
                this.nativeDelegate = ObjectFilter.inShorts(this.name, Conversions.sarray(this.values));
                break;
            }
            case BETWEEN: {
                this.nativeDelegate = ObjectFilter.betweenShort(this.name, v, Conversions.toShort(this.values[1]));
                break;
            }
            case NOT_IN: {
                this.nativeDelegate = ObjectFilter.notInShorts(this.name, Conversions.sarray(this.values));
                break;
            }
            default: {
                this.useDelegate = false;
            }
        }
    }

    private void initIfNeeded() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        FieldAccess field = this.field();
        if (field == null) {
            return;
        }
        Class<?> type = field.type();
        if (!type.isPrimitive() && type != Typ.date) {
            return;
        }
        if (type == Typ.date) {
            if (!(this.value instanceof Date)) {
                this.initForDate();
            }
            return;
        }
        this.useDelegate = true;
        if (type == Typ.intgr) {
            int v = Conversions.toInt(this.value);
            this.initForInt(v);
        } else if (type == Typ.bt) {
            byte v = Conversions.toByte(this.value);
            this.initForByte(v);
        } else if (type == Typ.shrt) {
            short v = Conversions.toShort(this.value);
            this.initForShortValue(v);
        } else if (type == Typ.lng) {
            long v = Conversions.toLong(this.value);
            this.initForLong(v);
        } else if (type == Typ.flt) {
            float v = Conversions.toFloat(this.value);
            this.initForFloat(v);
        } else if (type == Typ.dbl) {
            double v = Conversions.toDouble(this.value);
            this.initForDouble(v);
        } else if (type == Typ.bln) {
            switch (this.operator) {
                case EQUAL: {
                    this.nativeDelegate = ObjectFilter.eqBoolean(this.name, Conversions.toBoolean(this.value));
                    break;
                }
                case NOT_EQUAL: {
                    this.nativeDelegate = ObjectFilter.notEqBoolean(this.name, Conversions.toBoolean(this.value));
                    break;
                }
                default: {
                    this.useDelegate = false;
                    break;
                }
            }
        } else if (type == Typ.chr) {
            char v = Conversions.toChar(this.value);
            this.initForChar(v);
        }
    }

    private void initForChar(char value) {
        this.value = Character.valueOf(value);
        switch (this.operator) {
            case EQUAL: {
                this.nativeDelegate = ObjectFilter.eqChar(this.name, value);
                break;
            }
            case NOT_EQUAL: {
                this.nativeDelegate = ObjectFilter.notEqChar(this.name, value);
                break;
            }
            case LESS_THAN: {
                this.nativeDelegate = ObjectFilter.ltChar(this.name, value);
                break;
            }
            case LESS_THAN_EQUAL: {
                this.nativeDelegate = ObjectFilter.lteChar(this.name, value);
                break;
            }
            case GREATER_THAN: {
                this.nativeDelegate = ObjectFilter.gtChar(this.name, value);
                break;
            }
            case GREATER_THAN_EQUAL: {
                this.nativeDelegate = ObjectFilter.gteChar(this.name, value);
                break;
            }
            case BETWEEN: {
                this.nativeDelegate = ObjectFilter.betweenChar(this.name, value, Conversions.toChar(this.values[1]));
                break;
            }
            case IN: {
                this.nativeDelegate = ObjectFilter.inChars(this.name, Conversions.carray(this.values));
                break;
            }
            case NOT_IN: {
                this.nativeDelegate = ObjectFilter.notInChars(this.name, Conversions.carray(this.values));
                break;
            }
            default: {
                this.useDelegate = false;
            }
        }
    }

    private void initForDouble(double value) {
        this.value = value;
        switch (this.operator) {
            case EQUAL: {
                this.nativeDelegate = ObjectFilter.eqDouble(this.name, value);
                break;
            }
            case NOT_EQUAL: {
                this.nativeDelegate = ObjectFilter.notEqDouble(this.name, value);
                break;
            }
            case LESS_THAN: {
                this.nativeDelegate = ObjectFilter.ltDouble(this.name, value);
                break;
            }
            case LESS_THAN_EQUAL: {
                this.nativeDelegate = ObjectFilter.lteDouble(this.name, value);
                break;
            }
            case GREATER_THAN: {
                this.nativeDelegate = ObjectFilter.gtDouble(this.name, value);
                break;
            }
            case GREATER_THAN_EQUAL: {
                this.nativeDelegate = ObjectFilter.gteDouble(this.name, value);
                break;
            }
            case BETWEEN: {
                this.nativeDelegate = ObjectFilter.betweenDouble(this.name, value, Conversions.toDouble(this.values[1]));
                break;
            }
            case IN: {
                this.nativeDelegate = ObjectFilter.inDoubles(this.name, Conversions.darray(this.values));
                break;
            }
            case NOT_IN: {
                this.nativeDelegate = ObjectFilter.notInDoubles(this.name, Conversions.darray(this.values));
                break;
            }
            default: {
                this.useDelegate = false;
            }
        }
    }

    private void initForFloat(float value) {
        this.value = Float.valueOf(value);
        switch (this.operator) {
            case EQUAL: {
                this.nativeDelegate = ObjectFilter.eqFloat(this.name, value);
                break;
            }
            case NOT_EQUAL: {
                this.nativeDelegate = ObjectFilter.notEqFloat(this.name, value);
                break;
            }
            case LESS_THAN: {
                this.nativeDelegate = ObjectFilter.ltFloat(this.name, value);
                break;
            }
            case LESS_THAN_EQUAL: {
                this.nativeDelegate = ObjectFilter.lteFloat(this.name, value);
                break;
            }
            case GREATER_THAN: {
                this.nativeDelegate = ObjectFilter.gtFloat(this.name, value);
                break;
            }
            case GREATER_THAN_EQUAL: {
                this.nativeDelegate = ObjectFilter.gteFloat(this.name, value);
                break;
            }
            case BETWEEN: {
                this.nativeDelegate = ObjectFilter.betweenFloat(this.name, value, Conversions.toFloat(this.values[1]));
                break;
            }
            case IN: {
                this.nativeDelegate = ObjectFilter.inFloats(this.name, Conversions.farray(this.values));
                break;
            }
            case NOT_IN: {
                this.nativeDelegate = ObjectFilter.notInFloats(this.name, Conversions.farray(this.values));
                break;
            }
            default: {
                this.useDelegate = false;
            }
        }
    }

    private void initForLong(long value) {
        this.value = value;
        switch (this.operator) {
            case EQUAL: {
                this.nativeDelegate = ObjectFilter.eqLong(this.name, value);
                break;
            }
            case NOT_EQUAL: {
                this.nativeDelegate = ObjectFilter.notEqLong(this.name, value);
                break;
            }
            case LESS_THAN: {
                this.nativeDelegate = ObjectFilter.ltLong(this.name, value);
                break;
            }
            case LESS_THAN_EQUAL: {
                this.nativeDelegate = ObjectFilter.lteLong(this.name, value);
                break;
            }
            case GREATER_THAN: {
                this.nativeDelegate = ObjectFilter.gtLong(this.name, value);
                break;
            }
            case GREATER_THAN_EQUAL: {
                this.nativeDelegate = ObjectFilter.gteLong(this.name, value);
                break;
            }
            case IN: {
                this.nativeDelegate = ObjectFilter.inLongs(this.name, Conversions.larray(this.values));
                break;
            }
            case BETWEEN: {
                this.nativeDelegate = ObjectFilter.betweenLong(this.name, value, Conversions.toLong(this.values[1]));
                break;
            }
            case NOT_IN: {
                this.nativeDelegate = ObjectFilter.notInLongs(this.name, Conversions.larray(this.values));
                break;
            }
            default: {
                this.useDelegate = false;
            }
        }
    }

    private void initForByte(byte value) {
        this.value = value;
        switch (this.operator) {
            case EQUAL: {
                this.nativeDelegate = ObjectFilter.eqByte(this.name, value);
                break;
            }
            case NOT_EQUAL: {
                this.nativeDelegate = ObjectFilter.notEqByte(this.name, value);
                break;
            }
            case LESS_THAN: {
                this.nativeDelegate = ObjectFilter.ltByte(this.name, value);
                break;
            }
            case LESS_THAN_EQUAL: {
                this.nativeDelegate = ObjectFilter.lteByte(this.name, value);
                break;
            }
            case GREATER_THAN: {
                this.nativeDelegate = ObjectFilter.gtByte(this.name, value);
                break;
            }
            case GREATER_THAN_EQUAL: {
                this.nativeDelegate = ObjectFilter.gteByte(this.name, value);
                break;
            }
            case IN: {
                this.nativeDelegate = ObjectFilter.inBytes(this.name, Conversions.barray(this.values));
                break;
            }
            case NOT_IN: {
                this.nativeDelegate = ObjectFilter.notInBytes(this.name, Conversions.barray(this.values));
                break;
            }
            case BETWEEN: {
                this.nativeDelegate = ObjectFilter.betweenByte(this.name, value, Conversions.toByte(this.values[1]));
                break;
            }
            default: {
                this.useDelegate = false;
            }
        }
    }

    private void initForDate() {
        this.value = Conversions.toDate(this.value);
        if (this.operator == Operator.BETWEEN) {
            this.values[0] = Conversions.toDate(this.values[0]);
            this.values[1] = Conversions.toDate(this.values[1]);
        }
    }

    private void initForInt(int v) {
        this.value = v;
        switch (this.operator) {
            case EQUAL: {
                this.nativeDelegate = ObjectFilter.eqInt(this.name, v);
                break;
            }
            case NOT_EQUAL: {
                this.nativeDelegate = ObjectFilter.notEqInt(this.name, v);
                break;
            }
            case LESS_THAN: {
                this.nativeDelegate = ObjectFilter.ltInt(this.name, v);
                break;
            }
            case LESS_THAN_EQUAL: {
                this.nativeDelegate = ObjectFilter.lteInt(this.name, v);
                break;
            }
            case GREATER_THAN: {
                this.nativeDelegate = ObjectFilter.gtInt(this.name, v);
                break;
            }
            case GREATER_THAN_EQUAL: {
                this.nativeDelegate = ObjectFilter.gteInt(this.name, v);
                break;
            }
            case BETWEEN: {
                this.nativeDelegate = ObjectFilter.betweenInt(this.name, v, Conversions.toInt(this.values[1]));
                break;
            }
            case IN: {
                this.nativeDelegate = ObjectFilter.inInts(this.name, Conversions.iarray(this.values));
                break;
            }
            case NOT_IN: {
                this.nativeDelegate = ObjectFilter.notInInts(this.name, Conversions.iarray(this.values));
                break;
            }
            default: {
                this.useDelegate = false;
            }
        }
    }

    public static abstract class PrimitiveCriterion
    extends Criterion {
        public PrimitiveCriterion(String name, Operator operator, Object ... objects) {
            super(name, operator, objects);
        }

        @Override
        public boolean test(Object o) {
            Map<String, FieldAccess> fields = this.getFieldsInternal(o);
            return this.resolve(fields, o);
        }
    }
}

