/*
 * Decompiled with CFR 0.152.
 */
package org.boon.core.reflection.fields;

import java.lang.reflect.Field;
import org.boon.core.reflection.fields.BaseField;

public class ReflectField
extends BaseField {
    private final Field field;

    public ReflectField(Field field) {
        super(field);
        this.field = field;
    }

    @Override
    public Object getObject(Object obj) {
        try {
            return this.field.get(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.analyzeError(e, obj);
            return null;
        }
    }

    @Override
    public boolean getBoolean(Object obj) {
        try {
            return this.field.getBoolean(obj);
        }
        catch (Exception e) {
            this.analyzeError(e, obj);
            return false;
        }
    }

    @Override
    public int getInt(Object obj) {
        try {
            return this.field.getInt(obj);
        }
        catch (Exception e) {
            this.analyzeError(e, obj);
            return 0;
        }
    }

    @Override
    public short getShort(Object obj) {
        try {
            return this.field.getShort(obj);
        }
        catch (Exception e) {
            this.analyzeError(e, obj);
            return 0;
        }
    }

    @Override
    public char getChar(Object obj) {
        try {
            return this.field.getChar(obj);
        }
        catch (Exception e) {
            this.analyzeError(e, obj);
            return '\u0000';
        }
    }

    @Override
    public long getLong(Object obj) {
        try {
            return this.field.getLong(obj);
        }
        catch (Exception e) {
            this.analyzeError(e, obj);
            return 0L;
        }
    }

    @Override
    public double getDouble(Object obj) {
        try {
            return this.field.getDouble(obj);
        }
        catch (Exception e) {
            this.analyzeError(e, obj);
            return 0.0;
        }
    }

    @Override
    public float getFloat(Object obj) {
        try {
            return this.field.getFloat(obj);
        }
        catch (Exception e) {
            this.analyzeError(e, obj);
            return 0.0f;
        }
    }

    @Override
    public byte getByte(Object obj) {
        try {
            return this.field.getByte(obj);
        }
        catch (Exception e) {
            this.analyzeError(e, obj);
            return 0;
        }
    }

    public boolean getStaticBoolean() {
        return this.getBoolean(null);
    }

    public int getStaticInt() {
        return this.getInt(null);
    }

    public short getStaticShort() {
        return this.getShort(null);
    }

    public long getStaticLong() {
        return this.getLong(null);
    }

    public double getStaticDouble() {
        return this.getDouble(null);
    }

    public float getStaticFloat() {
        return this.getFloat(null);
    }

    public byte getStaticByte() {
        return this.getByte(null);
    }

    public Object getObject() {
        return this.getObject(null);
    }

    @Override
    public final Field getField() {
        return this.field;
    }

    @Override
    public void setBoolean(Object obj, boolean value) {
        try {
            this.field.setBoolean(obj, value);
        }
        catch (IllegalAccessException e) {
            this.analyzeError(e, obj);
        }
    }

    @Override
    public void setInt(Object obj, int value) {
        try {
            this.field.setInt(obj, value);
        }
        catch (IllegalAccessException e) {
            this.analyzeError(e, obj);
        }
    }

    @Override
    public void setShort(Object obj, short value) {
        try {
            this.field.setShort(obj, value);
        }
        catch (IllegalAccessException e) {
            this.analyzeError(e, obj);
        }
    }

    @Override
    public void setChar(Object obj, char value) {
        try {
            this.field.setChar(obj, value);
        }
        catch (IllegalAccessException e) {
            this.analyzeError(e, obj);
        }
    }

    @Override
    public void setLong(Object obj, long value) {
        try {
            this.field.setLong(obj, value);
        }
        catch (IllegalAccessException e) {
            this.analyzeError(e, obj);
        }
    }

    @Override
    public void setDouble(Object obj, double value) {
        try {
            this.field.setDouble(obj, value);
        }
        catch (IllegalAccessException e) {
            this.analyzeError(e, obj);
        }
    }

    @Override
    public void setFloat(Object obj, float value) {
        try {
            this.field.setFloat(obj, value);
        }
        catch (IllegalAccessException e) {
            this.analyzeError(e, obj);
        }
    }

    @Override
    public void setByte(Object obj, byte value) {
        try {
            this.field.setByte(obj, value);
        }
        catch (IllegalAccessException e) {
            this.analyzeError(e, obj);
        }
    }

    @Override
    public void setObject(Object obj, Object value) {
        try {
            this.field.set(obj, value);
        }
        catch (IllegalAccessException e) {
            this.analyzeError(e, obj);
        }
    }
}

