/*
 * Decompiled with CFR 0.152.
 */
package org.boon.core.reflection;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.boon.Boon;
import org.boon.Exceptions;
import org.boon.Lists;
import org.boon.Str;
import org.boon.core.Function;
import org.boon.core.Pair;
import org.boon.core.Sys;
import org.boon.core.Typ;
import org.boon.core.reflection.ClassMeta;
import org.boon.core.reflection.ConstructorAccess;
import org.boon.core.reflection.fields.FieldAccess;
import org.boon.core.reflection.fields.PropertyField;
import org.boon.core.reflection.fields.ReflectField;
import org.boon.core.reflection.fields.UnsafeField;
import sun.misc.Unsafe;

public class Reflection {
    private static final Logger log = Logger.getLogger(Reflection.class.getName());
    private static boolean _useUnsafe;
    private static final boolean useUnsafe;
    private static final Context _context;
    private static WeakReference<Context> weakContext;

    public static Unsafe getUnsafe() {
        if (Reflection.context().control == null) {
            try {
                Field f = Unsafe.class.getDeclaredField("theUnsafe");
                f.setAccessible(true);
                Reflection.context().control = (Unsafe)f.get(null);
                return Reflection.context().control;
            }
            catch (Exception e) {
                return null;
            }
        }
        return Reflection.context().control;
    }

    public static Object contextToHold() {
        return Reflection.context();
    }

    static Context context() {
        if (_context != null) {
            return _context;
        }
        Context context = (Context)weakContext.get();
        if (context == null) {
            context = new Context();
            weakContext = new WeakReference<Context>(context);
        }
        return context;
    }

    private static void setAccessorFieldInCache(Class<? extends Object> theClass, boolean useUnsafe, Map<String, FieldAccess> map) {
        if (useUnsafe) {
            Reflection.context()._allAccessorUnsafeFieldsCache.put(theClass, map);
        } else {
            Reflection.context()._allAccessorReflectionFieldsCache.put(theClass, map);
        }
    }

    private static void setPropertyAccessorFieldsInCache(Class<? extends Object> theClass, Map<String, FieldAccess> map) {
        Reflection.context()._allAccessorPropertyFieldsCache.put(theClass, map);
    }

    private static Map<String, FieldAccess> getPropertyAccessorFieldsFromCache(Class<? extends Object> theClass) {
        return Reflection.context()._allAccessorPropertyFieldsCache.get(theClass);
    }

    private static Map<String, FieldAccess> getAccesorFieldFromCache(Class<? extends Object> theClass, boolean useUnsafe) {
        if (useUnsafe) {
            return Reflection.context()._allAccessorUnsafeFieldsCache.get(theClass);
        }
        return Reflection.context()._allAccessorReflectionFieldsCache.get(theClass);
    }

    public static Map<String, FieldAccess> getPropertyFieldAccessMapFieldFirst(Class<?> clazz) {
        Map<String, FieldAccess> fieldsFallbacks = null;
        Map<String, FieldAccess> fieldsPrimary = null;
        fieldsPrimary = Reflection.getAllAccessorFields(clazz, true);
        fieldsFallbacks = Reflection.getPropertyFieldAccessors(clazz);
        Reflection.combineFieldMaps(fieldsFallbacks, fieldsPrimary);
        return fieldsPrimary;
    }

    private static void combineFieldMaps(Map<String, FieldAccess> fieldsFallbacks, Map<String, FieldAccess> fieldsPrimary) {
        for (Map.Entry<String, FieldAccess> field : fieldsFallbacks.entrySet()) {
            if (fieldsPrimary.containsKey(field.getKey())) continue;
            fieldsPrimary.put(field.getKey(), field.getValue());
        }
    }

    public static Map<String, FieldAccess> getPropertyFieldAccessMapPropertyFirst(Class<?> clazz) {
        Map<String, FieldAccess> fieldsFallbacks = null;
        Map<String, FieldAccess> fieldsPrimary = null;
        fieldsFallbacks = Reflection.getAllAccessorFields(clazz, true);
        fieldsPrimary = Reflection.getPropertyFieldAccessors(clazz);
        Reflection.combineFieldMaps(fieldsFallbacks, fieldsPrimary);
        return fieldsPrimary;
    }

    private static void handle(Exception ex) {
        throw new ReflectionException(ex);
    }

    public static Class<?> loadClass(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return clazz;
        }
        catch (Exception ex) {
            log.info(String.format("Unable to create load class %s", className));
            return null;
        }
    }

    public static Object newInstance(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return Reflection.newInstance(clazz);
        }
        catch (Exception ex) {
            log.info(String.format("Unable to create this class %s", className));
            return null;
        }
    }

    public static <T> T newInstance(Class<T> clazz) {
        Object newInstance = null;
        ClassMeta cls = ClassMeta.classMeta(clazz);
        try {
            ConstructorAccess declaredConstructor = cls.noArgConstructor();
            if (declaredConstructor != null) {
                newInstance = declaredConstructor.create(new Object[0]);
            } else if (_useUnsafe) {
                newInstance = Reflection.getUnsafe().allocateInstance(clazz);
            } else {
                Exceptions.die(Boon.sputs(clazz.getName(), "does not have a no arg constructor and unsafe is not turned on"));
            }
        }
        catch (Exception ex) {
            try {
                if (_useUnsafe) {
                    newInstance = Reflection.getUnsafe().allocateInstance(clazz);
                    return (T)newInstance;
                }
            }
            catch (Exception ex2) {
                Reflection.handle(ex2);
            }
            Reflection.handle(ex);
        }
        return (T)newInstance;
    }

    public static <T> T newInstance(Class<T> clazz, Object arg) {
        T newInstance = null;
        ClassMeta cls = ClassMeta.classMeta(clazz);
        try {
            ConstructorAccess declaredConstructor = cls.declaredConstructor(arg.getClass());
            if (declaredConstructor != null) {
                newInstance = declaredConstructor.create(arg);
            }
        }
        catch (Exception ex) {
            Reflection.handle(ex);
        }
        return newInstance;
    }

    public static Class<?> getComponentType(Collection<?> collection, FieldAccess fieldAccess) {
        Class<?> clz = fieldAccess.getComponentClass();
        if (clz == null) {
            clz = Reflection.getComponentType(collection);
        }
        return clz;
    }

    public static Class<?> getComponentType(Collection<?> value) {
        if (value.size() > 0) {
            Object next = value.iterator().next();
            return next.getClass();
        }
        return Typ.object;
    }

    public static Map<String, FieldAccess> getAllAccessorFields(Class<? extends Object> theClass) {
        return Reflection.getAllAccessorFields(theClass, true);
    }

    public static Map<String, FieldAccess> getAllAccessorFields(Class<? extends Object> theClass, boolean useUnsafe) {
        Map<String, FieldAccess> map = Reflection.getAccesorFieldFromCache(theClass, useUnsafe);
        if (map == null) {
            List<FieldAccess> list = Lists.mapBy(Reflection.getAllFields(theClass), new FieldConverter(useUnsafe));
            map = new LinkedHashMap<String, FieldAccess>(list.size());
            for (FieldAccess fieldAccess : list) {
                map.put(fieldAccess.getName(), fieldAccess);
            }
            Reflection.setAccessorFieldInCache(theClass, useUnsafe, map);
        }
        return map;
    }

    public static List<Field> getAllFields(Class<? extends Object> theClass) {
        List<Field> list = Reflection.getFields(theClass);
        while (theClass != Typ.object) {
            theClass = theClass.getSuperclass();
            Reflection.getFields(theClass, list);
        }
        return list;
    }

    public static Map<String, FieldAccess> getPropertyFieldAccessors(Class<? extends Object> theClass) {
        Map<String, FieldAccess> fields = Reflection.getPropertyAccessorFieldsFromCache(theClass);
        if (fields == null) {
            Map<String, Pair<Method>> methods = Reflection.getPropertySetterGetterMethods(theClass);
            fields = new LinkedHashMap<String, FieldAccess>();
            for (Map.Entry<String, Pair<Method>> entry : methods.entrySet()) {
                Pair<Method> methodPair = entry.getValue();
                String key = entry.getKey();
                PropertyField pf = new PropertyField(key, methodPair.getFirst(), methodPair.getSecond());
                fields.put(pf.getAlias(), pf);
            }
            Reflection.setPropertyAccessorFieldsInCache(theClass, fields);
        }
        return fields;
    }

    public static Map<String, Pair<Method>> getPropertySetterGetterMethods(Class<? extends Object> theClass) {
        String name;
        Method[] methods = theClass.getMethods();
        LinkedHashMap<String, Pair<Method>> methodMap = new LinkedHashMap<String, Pair<Method>>(methods.length);
        ArrayList<Method> getterMethodList = new ArrayList<Method>(methods.length);
        for (int index = 0; index < methods.length; ++index) {
            Method method = methods[index];
            name = method.getName();
            if (method.getParameterTypes().length == 1 && method.getReturnType() == Void.TYPE && name.startsWith("set")) {
                Pair<Method> pair = new Pair<Method>();
                pair.setFirst(method);
                String propertyName = Str.slc(name, 3);
                propertyName = Str.lower(Str.slc(propertyName, 0, 1)) + Str.slc(propertyName, 1);
                methodMap.put(propertyName, pair);
            }
            if (method.getParameterTypes().length > 0 || method.getReturnType() == Void.TYPE || !name.startsWith("get") && !name.startsWith("is") || name.equals("getClass")) continue;
            getterMethodList.add(method);
        }
        for (Method method : getterMethodList) {
            name = method.getName();
            String propertyName = null;
            if (name.startsWith("is")) {
                propertyName = name.substring(2);
            } else if (name.startsWith("get")) {
                propertyName = name.substring(3);
            }
            propertyName = Str.lower(propertyName.substring(0, 1)) + propertyName.substring(1);
            Pair<Method> pair = (Pair<Method>)methodMap.get(propertyName);
            if (pair == null) {
                pair = new Pair<Method>();
                methodMap.put(propertyName, pair);
            }
            pair.setSecond(method);
        }
        return methodMap;
    }

    public static void getFields(Class<? extends Object> theClass, List<Field> list) {
        List<Field> more = Reflection.getFields(theClass);
        list.addAll(more);
    }

    public static List<Field> getFields(Class<? extends Object> theClass) {
        List<Field> list = Lists.list(theClass.getDeclaredFields());
        for (Field field : list) {
            field.setAccessible(true);
        }
        return list;
    }

    public static boolean respondsTo(Class<?> type, String methodName) {
        return ClassMeta.classMeta(type).respondsTo(methodName);
    }

    public static boolean respondsTo(Class<?> type, String methodName, Class<?> ... params) {
        return ClassMeta.classMeta(type).respondsTo(methodName, params);
    }

    public static boolean respondsTo(Class<?> type, String methodName, Object ... params) {
        return ClassMeta.classMeta(type).respondsTo(methodName, params);
    }

    public static boolean respondsTo(Class<?> type, String methodName, List<?> params) {
        return ClassMeta.classMeta(type).respondsTo(methodName, params);
    }

    public static boolean respondsTo(Object object, String methodName) {
        return ClassMeta.classMeta(object.getClass()).respondsTo(methodName);
    }

    public static boolean respondsTo(Object object, String methodName, Class<?> ... params) {
        return ClassMeta.classMeta(object.getClass()).respondsTo(methodName, params);
    }

    public static boolean respondsTo(Object object, String methodName, Object ... params) {
        return ClassMeta.classMeta(object.getClass()).respondsTo(methodName, params);
    }

    public static boolean respondsTo(Object object, String methodName, List<?> params) {
        return ClassMeta.classMeta(object.getClass()).respondsTo(methodName, params);
    }

    public static boolean handles(Object object, Class<?> interfaceCls) {
        return ClassMeta.classMeta(object.getClass()).handles(interfaceCls);
    }

    public static boolean handles(Class cls, Class<?> interfaceCls) {
        return ClassMeta.classMeta(cls).handles(interfaceCls);
    }

    public static Object invoke(Object object, String name, Object ... args) {
        return ClassMeta.classMeta(object.getClass()).invoke(object, name, args);
    }

    public static Object invoke(Object object, String name, List<?> args) {
        return ClassMeta.classMeta(object.getClass()).invoke(object, name, args);
    }

    static {
        try {
            Class.forName("sun.misc.Unsafe");
            _useUnsafe = true;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            _useUnsafe = false;
        }
        useUnsafe = _useUnsafe = _useUnsafe && !Boolean.getBoolean("org.boon.noUnsafe");
        weakContext = new WeakReference<Object>(null);
        boolean noStatics = Boolean.getBoolean("org.boon.noStatics");
        if (noStatics || Sys.inContainer()) {
            _context = null;
            weakContext = new WeakReference<Context>(new Context());
        } else {
            _context = new Context();
        }
        try {
            if (_useUnsafe) {
                Field field = String.class.getDeclaredField("value");
            }
        }
        catch (Exception ex) {
            Exceptions.handle(ex);
        }
    }

    private static class FieldConverter
    implements Function<Field, FieldAccess> {
        boolean thisUseUnsafe;

        FieldConverter(boolean useUnsafe) {
            this.thisUseUnsafe = useUnsafe;
        }

        @Override
        public FieldAccess apply(Field from) {
            if (useUnsafe && this.thisUseUnsafe) {
                return UnsafeField.createUnsafeField(from);
            }
            return new ReflectField(from);
        }
    }

    public static class ReflectionException
    extends RuntimeException {
        public ReflectionException() {
        }

        public ReflectionException(String message, Throwable cause) {
            super(message, cause);
        }

        public ReflectionException(String message) {
            super(message);
        }

        public ReflectionException(Throwable cause) {
            super(cause);
        }
    }

    static class Context {
        Unsafe control;
        Map<String, String> _sortableFields = new ConcurrentHashMap<String, String>();
        Map<Class<?>, ClassMeta<?>> _classMetaMap = new ConcurrentHashMap(200);
        Map<Class<?>, Map<String, FieldAccess>> _allAccessorReflectionFieldsCache = new ConcurrentHashMap(200);
        Map<Class<?>, Map<String, FieldAccess>> _allAccessorPropertyFieldsCache = new ConcurrentHashMap(200);
        Map<Class<?>, Map<String, FieldAccess>> _allAccessorUnsafeFieldsCache = new ConcurrentHashMap(200);

        Context() {
        }
    }
}

