/*
 * Decompiled with CFR 0.152.
 */
package org.boon.core.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.boon.Exceptions;
import org.boon.Lists;
import org.boon.Sets;
import org.boon.collections.MultiMap;
import org.boon.core.Typ;
import org.boon.core.reflection.Annotated;
import org.boon.core.reflection.AnnotationData;
import org.boon.core.reflection.Annotations;
import org.boon.core.reflection.ConstructorAccess;
import org.boon.core.reflection.MethodAccess;
import org.boon.core.reflection.Reflection;
import org.boon.core.reflection.fields.FieldAccess;
import org.boon.core.reflection.impl.ConstructorAccessImpl;
import org.boon.core.reflection.impl.MethodAccessImpl;

public class ClassMeta<T>
implements Annotated {
    final Class<T> cls;
    final Map<String, MethodAccess> methodMap;
    final Set<ConstructorAccess<T>> constructorAccessSet;
    final MultiMap<String, MethodAccess> methodsMulti;
    final List<MethodAccess> methods;
    final Map<String, FieldAccess> fieldMap;
    final Map<String, FieldAccess> propertyMap;
    final List<FieldAccess> fields;
    final List<FieldAccess> properties;
    final ConstructorAccess<T> noArgConstructor;
    static final MethodAccess MANY_METHODS = new MethodAccessImpl(){

        @Override
        public Object invoke(Object object, Object ... args) {
            return Exceptions.die(Object.class, "Unable to invoke method as there are more than one with that same name", object, args);
        }

        @Override
        public boolean respondsTo(Class<?>[] parametersToMatch) {
            return false;
        }

        @Override
        public Iterable<AnnotationData> annotationData() {
            return Exceptions.die(Iterable.class, "Unable to use method as there are more than one with that same name");
        }

        @Override
        public boolean hasAnnotation(String annotationName) {
            return Exceptions.die(Boolean.class, "Unable to invoke method as there are more than one with that same name");
        }

        @Override
        public AnnotationData annotation(String annotationName) {
            return Exceptions.die(AnnotationData.class, "Unable to invoke method as there are more than one with that same name");
        }

        @Override
        public Class<?>[] parameterTypes() {
            return Exceptions.die(Class[].class, "Unable to invoke method as there are more than one with that same name");
        }

        @Override
        public Type[] getGenericParameterTypes() {
            return Exceptions.die(Type[].class, "Unable to invoke method as there are more than one with that same name");
        }
    };
    private final Map<String, AnnotationData> annotationMap;
    private final List<AnnotationData> annotations;

    public ClassMeta(Class<T> cls) {
        this.cls = cls;
        if (!cls.isInterface()) {
            this.fieldMap = Reflection.getAllAccessorFields(this.cls);
            this.fields = Lists.list(this.fieldMap.values());
        } else {
            this.fieldMap = Collections.EMPTY_MAP;
            this.fields = Collections.EMPTY_LIST;
        }
        this.propertyMap = Reflection.getPropertyFieldAccessors(this.cls);
        this.properties = Lists.list(this.propertyMap.values());
        Constructor<?>[] constructors = cls.getDeclaredConstructors();
        ConstructorAccessImpl noArg = null;
        HashSet set = new HashSet();
        for (Constructor<?> constructor : constructors) {
            if (constructor.getParameterTypes().length == 0) {
                noArg = new ConstructorAccessImpl(constructor);
            }
            set.add(new ConstructorAccessImpl(constructor));
        }
        this.noArgConstructor = noArg;
        this.constructorAccessSet = Sets.safeSet(set);
        List<Class<?>> classes = this.getBaseClassesSuperFirst();
        this.methodMap = new ConcurrentHashMap<String, MethodAccess>();
        this.methodsMulti = new MultiMap();
        for (Class<?> clasz : classes) {
            Method[] methods_;
            for (Method m : methods_ = clasz.getDeclaredMethods()) {
                if (this.methodMap.containsKey(m.getName())) {
                    MethodAccessImpl invoker = (MethodAccessImpl)this.methodMap.get(m.getName());
                    if (invoker != MANY_METHODS) {
                        if (invoker.method.getParameterTypes().length != m.getParameterTypes().length) {
                            this.methodMap.put(m.getName(), MANY_METHODS);
                        } else {
                            boolean match = true;
                            for (int index = 0; index < m.getParameterTypes().length; ++index) {
                                if (m.getParameterTypes()[index] == invoker.method.getParameterTypes()[index]) continue;
                                match = false;
                            }
                            if (match) {
                                this.methodMap.put(m.getName(), new MethodAccessImpl(m));
                            } else {
                                this.methodMap.put(m.getName(), MANY_METHODS);
                            }
                        }
                    }
                } else {
                    this.methodMap.put(m.getName(), new MethodAccessImpl(m));
                }
                this.methodsMulti.put(m.getName(), new MethodAccessImpl(m));
            }
        }
        this.methods = Lists.list(this.methodsMulti.values());
        this.annotationMap = Annotations.getAnnotationDataForClassAsMap(cls);
        this.annotations = Annotations.getAnnotationDataForClass(cls);
    }

    public static ClassMeta classMeta(Class<?> aClass) {
        ClassMeta<?> meta = Reflection.context()._classMetaMap.get(aClass);
        if (meta == null) {
            meta = new ClassMeta(aClass);
            Reflection.context()._classMetaMap.put(aClass, meta);
        }
        return meta;
    }

    public MethodAccess method(String name) {
        return this.methodMap.get(name);
    }

    public Iterable<MethodAccess> methods(String name) {
        return this.methodsMulti.getAll(name);
    }

    private List<Class<?>> getBaseClassesSuperFirst() {
        if (!this.cls.isInterface()) {
            ArrayList classes = new ArrayList(10);
            for (Class<T> currentClass = this.cls; currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
                classes.add(currentClass);
            }
            Collections.reverse(classes);
            return classes;
        }
        return Lists.list(this.cls.getInterfaces());
    }

    public Map<String, FieldAccess> fieldMap() {
        return this.fieldMap;
    }

    public Map<String, FieldAccess> propertyMap() {
        return this.propertyMap;
    }

    public Iterator<FieldAccess> fields() {
        return this.fields.iterator();
    }

    public Iterable<MethodAccess> methods() {
        return new Iterable<MethodAccess>(){

            @Override
            public Iterator<MethodAccess> iterator() {
                return ClassMeta.this.methods.iterator();
            }
        };
    }

    public Iterator<FieldAccess> properties() {
        return this.properties.iterator();
    }

    public Iterable<ConstructorAccess<T>> constructors() {
        return new Iterable<ConstructorAccess<T>>(){

            @Override
            public Iterator<ConstructorAccess<T>> iterator() {
                return ClassMeta.this.constructorAccessSet.iterator();
            }
        };
    }

    public ConstructorAccess<T> noArgConstructor() {
        return this.noArgConstructor;
    }

    public <T> ConstructorAccess<T> declaredConstructor(Class<? extends Object> singleArg) {
        for (ConstructorAccess<T> constructorAccess : this.constructorAccessSet) {
            if (constructorAccess.parameterTypes().length != 1 || !constructorAccess.parameterTypes()[0].isAssignableFrom(singleArg)) continue;
            return constructorAccess;
        }
        return null;
    }

    @Override
    public Iterable<AnnotationData> annotationData() {
        return new Iterable<AnnotationData>(){

            @Override
            public Iterator<AnnotationData> iterator() {
                return ClassMeta.this.annotations.iterator();
            }
        };
    }

    @Override
    public boolean hasAnnotation(String annotationName) {
        return this.annotationMap.containsKey(annotationName);
    }

    @Override
    public AnnotationData annotation(String annotationName) {
        return this.annotationMap.get(annotationName);
    }

    public boolean respondsTo(String methodName) {
        return this.methodMap.containsKey(methodName);
    }

    public boolean respondsTo(String methodName, Class<?> ... types) {
        Iterable<MethodAccess> methods = this.methodsMulti.getAll(methodName);
        for (MethodAccess methodAccess : methods) {
            if (methodAccess.isStatic() || !methodAccess.respondsTo(types)) continue;
            return true;
        }
        return false;
    }

    public boolean respondsTo(String methodName, Object ... args) {
        Iterable<MethodAccess> methods = this.methodsMulti.getAll(methodName);
        for (MethodAccess methodAccess : methods) {
            if (methodAccess.isStatic() || !methodAccess.respondsTo(args)) continue;
            return true;
        }
        return false;
    }

    public boolean respondsTo(String methodName, List list) {
        Object[] args = list.toArray(new Object[list.size()]);
        return this.respondsTo(methodName, args);
    }

    public boolean handles(Class<?> interfaceMethods) {
        Method[] declaredMethods;
        for (Method method : declaredMethods = interfaceMethods.getDeclaredMethods()) {
            if (this.respondsTo(method.getName(), method.getParameterTypes())) continue;
            return false;
        }
        return true;
    }

    public Object invoke(T instance, String methodName, Object ... args) {
        return this.methodMap.get(methodName).invoke(instance, args);
    }

    public Object invokeStatic(String methodName, Object ... args) {
        return this.methodMap.get(methodName).invokeStatic(args);
    }

    public Object invoke(T instance, String methodName, List<?> args) {
        Object[] array = args.toArray(new Object[args.size()]);
        return this.methodMap.get(methodName).invoke(instance, array);
    }

    public boolean invokeSingleBoolean(Object instance, Object arg) {
        MethodAccess methodAccess = null;
        methodAccess = this.methods.size() == 1 ? this.methods.get(0) : this.methodMap.get("test");
        return (Boolean)methodAccess.invoke(instance, arg);
    }

    public Object invokeReducer(Object instance, Object sum, Object value) {
        MethodAccess methodAccess = this.methods.size() == 1 ? this.methods.get(0) : this.methodMap.get("test");
        Class<?> arg1 = methodAccess.parameterTypes()[0];
        if (Typ.isPrimitiveNumber(arg1) && sum == null) {
            return methodAccess.invoke(instance, 0, value);
        }
        return methodAccess.invoke(instance, sum, value);
    }

    public Object invokeFunction(Object instance, Object arg) {
        if (this.methods.size() == 1) {
            return this.methods.get(0).invoke(instance, arg);
        }
        return this.methodMap.get("apply").invoke(instance, arg);
    }
}

