/*
 * Decompiled with CFR 0.152.
 */
package org.boon.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.boon.IO;
import org.boon.config.MetaConfigEvents;
import org.boon.config.NamespaceEventHandler;
import org.boon.di.Context;
import org.boon.di.ContextFactory;
import org.boon.json.JsonParserAndMapper;
import org.boon.json.JsonParserFactory;

public enum ContextConfig {
    JSON{

        @Override
        public Context createContext(String configNamespace, boolean startsWith, MetaConfigEvents events, List<String> resources) {
            return this.createContext(configNamespace, startsWith, events, resources.toArray(new String[resources.size()]));
        }

        @Override
        public Context createContext(String ... resources) {
            return this.createContext((String)null, false, (MetaConfigEvents)null, resources);
        }

        @Override
        public Context createContext(List<String> resources) {
            return this.createContext((String)null, false, (MetaConfigEvents)null, resources.toArray(new String[resources.size()]));
        }

        @Override
        public Context createContext(String namespace, boolean startsWith, String ... resources) {
            return this.createContext(namespace, startsWith, (MetaConfigEvents)null, resources);
        }

        @Override
        public Context createContext(MetaConfigEvents events, String ... resources) {
            return this.createContext(null, false, events, resources);
        }

        @Override
        public Context createContext(String namespace, boolean startsWith, MetaConfigEvents events, String ... resources) {
            return ContextFactory.fromMap(this.createConfigMap(namespace, startsWith, events, resources));
        }

        private Map<String, Object> createConfigMap(String namespace, boolean startsWith, MetaConfigEvents events, String ... resources) {
            return this.createConfigMap(namespace, startsWith, events, Arrays.asList(resources));
        }

        private Map<String, Object> createConfigMap(String namespace, boolean startsWith, MetaConfigEvents events, List<String> resources) {
            HashMap<String, Object> all = new HashMap<String, Object>();
            for (String resource : resources) {
                Map<String, Object> child;
                if (startsWith && !resource.startsWith(namespace + ".")) continue;
                if (resource.endsWith("/")) {
                    child = this.createMapFromDir(namespace, startsWith, events, resource);
                    all.putAll(child);
                    continue;
                }
                if (!resource.endsWith(".json")) continue;
                child = this.createMapFromFile(namespace, startsWith, events, resource);
                all.putAll(child);
            }
            return all;
        }

        private Map<String, Object> createMapFromFile(String namespace, boolean startsWith, MetaConfigEvents events, String resource) {
            Map<String, Object> all;
            NamespaceEventHandler jsonCreatorEventHandler = new NamespaceEventHandler(namespace, events);
            JsonParserAndMapper laxParser = new JsonParserFactory().createParserWithEvents(jsonCreatorEventHandler);
            Map<String, Object> fileConfig = laxParser.parseMap(IO.read(resource));
            if (fileConfig.containsKey("META")) {
                fileConfig.remove("META");
            }
            if (jsonCreatorEventHandler.include().size() > 0) {
                all = this.createConfigMap(namespace, startsWith, events, jsonCreatorEventHandler.include());
                all.putAll(fileConfig);
            } else {
                all = fileConfig;
            }
            return all;
        }

        private Map<String, Object> createMapFromDir(String namespace, boolean startWith, MetaConfigEvents events, String resource) {
            HashMap<String, Object> all = new HashMap<String, Object>();
            List<String> jsonFiles = IO.listByExt(resource, ".json");
            for (String jsonFile : jsonFiles) {
                Map<String, Object> child = this.createMapFromFile(namespace, startWith, events, jsonFile);
                all.putAll(child);
            }
            return all;
        }
    };


    public abstract Context createContext(String ... var1);

    public abstract Context createContext(List<String> var1);

    public abstract Context createContext(String var1, boolean var2, String ... var3);

    public abstract Context createContext(MetaConfigEvents var1, String ... var2);

    public abstract Context createContext(String var1, boolean var2, MetaConfigEvents var3, String ... var4);

    public abstract Context createContext(String var1, boolean var2, MetaConfigEvents var3, List<String> var4);
}

