/*
 * Decompiled with CFR 0.152.
 */
package org.boon.cache;

import java.util.concurrent.atomic.AtomicInteger;
import org.boon.Exceptions;
import org.boon.cache.CacheType;

class CacheEntry<KEY, VALUE>
implements Comparable<CacheEntry> {
    final AtomicInteger readCount = new AtomicInteger();
    final int order;
    VALUE value;
    final KEY key;
    final CacheType type;
    final long time;

    CacheEntry(KEY key, VALUE value, int order, CacheType type, long time) {
        this.order = order;
        this.value = value;
        this.key = key;
        this.time = time;
        this.type = type;
    }

    @Override
    public final int compareTo(CacheEntry other) {
        switch (this.type) {
            case LFU: {
                return this.compareToLFU(other);
            }
            case LRU: {
                return this.compareToLRU(other);
            }
            case FIFO: {
                return this.compareToFIFO(other);
            }
        }
        Exceptions.die();
        return 0;
    }

    private final int compareReadCount(CacheEntry other) {
        if (this.readCount.get() > other.readCount.get()) {
            return 1;
        }
        if (this.readCount.get() < other.readCount.get()) {
            return -1;
        }
        if (this.readCount.get() == other.readCount.get()) {
            return 0;
        }
        Exceptions.die();
        return 0;
    }

    private final int compareTime(CacheEntry other) {
        if (this.time > other.time) {
            return 1;
        }
        if (this.time < other.time) {
            return -1;
        }
        if (this.time == other.time) {
            return 0;
        }
        Exceptions.die();
        return 0;
    }

    private final int compareOrder(CacheEntry other) {
        if (this.order > other.order) {
            return 1;
        }
        if (this.order < other.order) {
            return -1;
        }
        if (this.order == other.order) {
            return 0;
        }
        Exceptions.die();
        return 0;
    }

    private final int compareToLFU(CacheEntry other) {
        int cmp = this.compareReadCount(other);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.compareTime(other);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.compareOrder(other);
        return cmp;
    }

    private final int compareToLRU(CacheEntry other) {
        int cmp = this.compareTime(other);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.compareOrder(other);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.compareReadCount(other);
        return cmp;
    }

    private final int compareToFIFO(CacheEntry other) {
        int cmp = this.compareOrder(other);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.compareTime(other);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.compareReadCount(other);
        return cmp;
    }

    public String toString() {
        return "CE{c=" + this.readCount + ", ord=" + this.order + ", val=" + this.value + ", ky=" + this.key + ", typ=" + (Object)((Object)this.type) + ", t=" + this.time + '}';
    }
}

