/*
 * Decompiled with CFR 0.152.
 */
package org.boon;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.boon.Classpaths;
import org.boon.Exceptions;
import org.boon.Lists;
import org.boon.Str;
import org.boon.StringScanner;
import org.boon.core.Function;
import org.boon.core.Sys;
import org.boon.core.Typ;
import org.boon.primitive.ByteBuf;
import org.boon.primitive.CharBuf;

public class IO {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    public static final String FILE_SCHEMA = "file";
    public static final String JAR_SCHEMA = "jar";
    public static final String CLASSPATH_SCHEMA = "classpath";
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final int EOF = -1;
    public static ConvertToPathFunction convertToPathFunction = new ConvertToPathFunction();

    public static List<String> list(Path path) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
                for (Path entry : directoryStream) {
                    result.add(entry.toAbsolutePath().toString());
                }
            }
            return result;
        }
        catch (IOException ex) {
            return Exceptions.handle(List.class, ex);
        }
    }

    public static List<String> listByGlob(String path, String glob) {
        Path pathFromFileSystem = IO.path(path);
        return IO.listByGlob(pathFromFileSystem, glob);
    }

    public static List<String> listByGlob(Path pathFromFileSystem, String glob) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(pathFromFileSystem, glob);){
                for (Path entry : stream) {
                    result.add(entry.toAbsolutePath().toString());
                }
            }
            return result;
        }
        catch (IOException ex) {
            return Exceptions.handle(List.class, ex);
        }
    }

    public static List<String> listByFileExtension(String path, String ext) {
        Path pathFromFileSystem = IO.path(path);
        return IO.listByFileExtension(pathFromFileSystem, ext);
    }

    public static List<String> listByFileExtension(Path pathFromFileSystem, String ext) {
        String extToLookForGlob = "*." + ext;
        ArrayList<String> result = new ArrayList<String>();
        try {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(pathFromFileSystem, extToLookForGlob);){
                for (Path entry : stream) {
                    result.add(entry.toAbsolutePath().toString());
                }
            }
            return result;
        }
        catch (IOException ex) {
            return Exceptions.handle(List.class, ex);
        }
    }

    public static List<String> listByFileExtensionRecursive(String path, String ext) {
        Path pathFromFileSystem = IO.path(path);
        return IO.listByFileExtensionRecursive(pathFromFileSystem, ext);
    }

    public static List<String> listByFileExtensionRecursive(Path pathFromFileSystem, String ext) {
        String extToLookForGlob = "*." + ext;
        ArrayList<String> result = new ArrayList<String>();
        return IO.doListByFileExtensionRecursive(result, pathFromFileSystem, extToLookForGlob);
    }

    private static List<String> doListByFileExtensionRecursive(List<String> result, Path pathFromFileSystem, String glob) {
        try {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(pathFromFileSystem, glob);){
                for (Path entry : stream) {
                    result.add(entry.toAbsolutePath().toString());
                }
            }
            stream = Files.newDirectoryStream(pathFromFileSystem);
            var4_5 = null;
            try {
                for (Path entry : stream) {
                    if (!Files.isDirectory(entry, new LinkOption[0])) continue;
                    IO.doListByFileExtensionRecursive(result, entry, glob);
                }
            }
            catch (Throwable throwable) {
                var4_5 = throwable;
                throw throwable;
            }
            finally {
                if (stream != null) {
                    if (var4_5 != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable x2) {
                            var4_5.addSuppressed(x2);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
            return result;
        }
        catch (IOException ex) {
            return Exceptions.handle(List.class, ex);
        }
    }

    public static String readChild(Path parentDir, String childFileName) {
        try {
            Path newFilePath = IO.path(parentDir.toString(), childFileName);
            return IO.read(newFilePath);
        }
        catch (Exception ex) {
            return Exceptions.handle(String.class, ex);
        }
    }

    public static String read(Path path) {
        try {
            return IO.read(Files.newBufferedReader(path, DEFAULT_CHARSET));
        }
        catch (IOException ex) {
            return Exceptions.handle(String.class, ex);
        }
    }

    public static char[] readCharBuffer(Path path) {
        try {
            long bufSize = Files.size(path);
            return IO.readCharBuffer(Files.newBufferedReader(path, DEFAULT_CHARSET), (int)bufSize);
        }
        catch (IOException ex) {
            return Exceptions.handle(char[].class, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String read(InputStream inputStream, Charset charset) {
        try (InputStreamReader reader = new InputStreamReader(inputStream, charset);){
            String string = IO.read(reader);
            return string;
        }
        catch (Exception ex) {
            return Exceptions.handle(String.class, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String read(InputStream inputStream, String charset) {
        try (InputStreamReader reader = new InputStreamReader(inputStream, charset);){
            String string = IO.read(reader);
            return string;
        }
        catch (Exception ex) {
            return Exceptions.handle(String.class, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readCharBuffer(InputStream inputStream, Charset charset) {
        try (InputStreamReader reader = new InputStreamReader(inputStream, charset);){
            String string = IO.read(reader);
            return string;
        }
        catch (Exception ex) {
            return Exceptions.handle(String.class, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String read(InputStream inputStream) {
        try (InputStreamReader reader = new InputStreamReader(inputStream, DEFAULT_CHARSET);){
            String string = IO.read(reader);
            return string;
        }
        catch (Exception ex) {
            return Exceptions.handle(String.class, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static char[] readCharBuffer(InputStream inputStream) {
        try (InputStreamReader reader = new InputStreamReader(inputStream);){
            char[] cArray = IO.readCharBuffer(reader);
            return cArray;
        }
        catch (Exception ex) {
            return Exceptions.handle(char[].class, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CharBuf read(InputStream inputStream, CharBuf charBuf) {
        try (InputStreamReader reader = new InputStreamReader(inputStream);){
            CharBuf charBuf2 = IO.read(reader, charBuf);
            return charBuf2;
        }
        catch (Exception ex) {
            return Exceptions.handle(CharBuf.class, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CharBuf read(InputStream inputStream, CharBuf charBuf, Charset charset) {
        try (InputStreamReader reader = new InputStreamReader(inputStream, charset);){
            CharBuf charBuf2 = IO.read(reader, charBuf);
            return charBuf2;
        }
        catch (Exception ex) {
            return Exceptions.handle(CharBuf.class, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CharBuf read(InputStream inputStream, CharBuf charBuf, Charset charset, int bufSize) {
        try (InputStreamReader reader = new InputStreamReader(inputStream, charset);){
            CharBuf charBuf2 = IO.read(reader, charBuf, bufSize);
            return charBuf2;
        }
        catch (Exception ex) {
            return Exceptions.handle(CharBuf.class, ex);
        }
    }

    public static byte[] input(String fileName) {
        try {
            return IO.input(Files.newInputStream(IO.path(fileName), new OpenOption[0]));
        }
        catch (IOException e) {
            return Exceptions.handle(byte[].class, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] input(InputStream inputStream) {
        try (InputStream is = inputStream;){
            ByteBuf buf = ByteBuf.create(4096);
            byte[] bytes = new byte[4096];
            int read = -2;
            while (read != -1) {
                read = inputStream.read(bytes);
                if (read == 4096) {
                    buf.add(bytes);
                    continue;
                }
                if (read <= 0) continue;
                buf.add(bytes, read);
            }
            byte[] byArray = buf.toBytes();
            return byArray;
        }
        catch (Exception ex) {
            return Exceptions.handle(byte[].class, ex);
        }
    }

    public static long copyLarge(Reader reader, Writer writer) {
        return IO.copyLarge(reader, writer, new char[4096]);
    }

    public static long copyLarge(Reader reader, Writer writer, char[] buffer) {
        long count = 0L;
        try {
            int n;
            while (-1 != (n = reader.read(buffer))) {
                writer.write(buffer, 0, n);
                count += (long)n;
            }
        }
        catch (IOException e) {
            Exceptions.handle(e);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(Reader input) {
        try {
            CharBuf sw = CharBuf.create(4096);
            IO.copy(input, sw);
            String string = sw.toString();
            return string;
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                Exceptions.handle(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CharBuf read(Reader input, CharBuf charBuf, int bufSize) {
        if (charBuf == null) {
            charBuf = CharBuf.create(bufSize);
        } else {
            charBuf.readForRecycle();
        }
        try {
            char[] buffer = charBuf.toCharArray();
            int size = input.read(buffer);
            if (size != -1) {
                charBuf._len(size);
            }
            if (size < buffer.length) {
                CharBuf charBuf2 = charBuf;
                return charBuf2;
            }
            IO.copy(input, charBuf);
        }
        catch (IOException e) {
            Exceptions.handle(e);
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                Exceptions.handle(e);
            }
        }
        return charBuf;
    }

    public static CharBuf read(Reader input, CharBuf charBuf) {
        return IO.read(input, charBuf, 2048);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] readCharBuffer(Reader input) {
        try {
            CharBuf sw = CharBuf.create(4096);
            IO.copy(input, sw);
            char[] cArray = sw.toCharArray();
            return cArray;
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                Exceptions.handle(e);
            }
        }
    }

    public static int copy(Reader input, Writer output) {
        long count = IO.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static char[] readCharBuffer(Reader reader, int size) {
        char[] buffer = new char[size];
        try (Reader r = reader;){
            reader.read(buffer);
        }
        catch (Exception ex) {
            return Exceptions.handle(char[].class, ex);
        }
        return buffer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String read(File file) {
        try (FileReader reader = new FileReader(file);){
            String string = IO.read(reader);
            return string;
        }
        catch (Exception ex) {
            return Exceptions.handle(String.class, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> readLines(Reader reader) {
        try (BufferedReader bufferedReader = new BufferedReader(reader);){
            List<String> list = IO.readLines(bufferedReader);
            return list;
        }
        catch (Exception ex) {
            return Exceptions.handle(List.class, ex);
        }
    }

    public static void eachLine(Reader reader, EachLine eachLine) {
        try (BufferedReader bufferedReader = new BufferedReader(reader);){
            IO.eachLine(bufferedReader, eachLine);
        }
        catch (Exception ex) {
            Exceptions.handle(List.class, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> readLines(InputStream is) {
        try (InputStreamReader reader = new InputStreamReader(is, DEFAULT_CHARSET);){
            List<String> list = IO.readLines(reader);
            return list;
        }
        catch (Exception ex) {
            return Exceptions.handle(List.class, ex);
        }
    }

    public static void eachLine(InputStream is, EachLine eachLine) {
        try (InputStreamReader reader = new InputStreamReader(is, DEFAULT_CHARSET);){
            IO.eachLine(reader, eachLine);
        }
        catch (Exception ex) {
            Exceptions.handle(ex);
        }
    }

    public static List<String> readLines(BufferedReader reader) {
        ArrayList<String> lines = new ArrayList<String>(80);
        try (BufferedReader bufferedReader = reader;){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (Exception ex) {
            return Exceptions.handle(List.class, ex);
        }
        return lines;
    }

    public static void eachLine(BufferedReader reader, EachLine eachLine) {
        try (BufferedReader bufferedReader = reader;){
            String line;
            int lineNumber = 0;
            while ((line = bufferedReader.readLine()) != null && eachLine.line(line, lineNumber++)) {
            }
        }
        catch (Exception ex) {
            Exceptions.handle(ex);
        }
    }

    public static void eachLine(File file, EachLine eachLine) {
        try (FileReader reader = new FileReader(file);){
            IO.eachLine(reader, eachLine);
        }
        catch (Exception ex) {
            Exceptions.handle(List.class, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> readLines(File file) {
        try (FileReader reader = new FileReader(file);){
            List<String> list = IO.readLines(reader);
            return list;
        }
        catch (Exception ex) {
            return Exceptions.handle(List.class, ex);
        }
    }

    public static List<String> readLines(final String location) {
        final String path = IO.getWindowsPathIfNeeded(location);
        final URI uri = IO.createURI(path);
        return Exceptions.tryIt(Typ.list, new Exceptions.TrialWithReturn<List>(){

            @Override
            public List<String> tryIt() throws Exception {
                if (uri.getScheme() == null) {
                    Path thePath = FileSystems.getDefault().getPath(path, new String[0]);
                    return Files.readAllLines(thePath, DEFAULT_CHARSET);
                }
                if (uri.getScheme().equals(IO.FILE_SCHEMA)) {
                    Path thePath = FileSystems.getDefault().getPath(uri.getPath(), new String[0]);
                    return Files.readAllLines(thePath, DEFAULT_CHARSET);
                }
                return IO.readLines(location, uri);
            }
        });
    }

    public static URI createURI(String path) {
        if (!Sys.isWindows()) {
            return URI.create(path);
        }
        if (path.contains("\\") || path.startsWith("C:") || path.startsWith("D:")) {
            String newPath = new File(path).toURI().toString();
            if (newPath.startsWith("file:/C:")) {
                newPath = Str.slc(newPath, 8);
                return URI.create(newPath);
            }
            return URI.create(newPath);
        }
        return URI.create(path);
    }

    public static void eachLine(final String location, final EachLine eachLine) {
        final URI uri = IO.createURI(location);
        Exceptions.tryIt(new Exceptions.Trial(){

            @Override
            public void tryIt() throws Exception {
                if (uri.getScheme() == null) {
                    Path thePath = FileSystems.getDefault().getPath(location, new String[0]);
                    BufferedReader buf = Files.newBufferedReader(thePath, DEFAULT_CHARSET);
                    IO.eachLine(buf, eachLine);
                } else if (uri.getScheme().equals(IO.FILE_SCHEMA)) {
                    Path thePath = null;
                    if (Sys.isWindows()) {
                        String path = uri.toString();
                        if (Str.slc(path = path.replace('/', Sys.windowsPathSeparator()), 0, 6).equals("file:\\")) {
                            path = Str.slc(path, 6);
                        }
                        thePath = FileSystems.getDefault().getPath(path, new String[0]);
                    } else {
                        thePath = FileSystems.getDefault().getPath(uri.getPath(), new String[0]);
                    }
                    BufferedReader buf = Files.newBufferedReader(thePath, DEFAULT_CHARSET);
                    IO.eachLine(buf, eachLine);
                } else {
                    IO.eachLine(location, uri, eachLine);
                }
            }
        });
    }

    private static String getWindowsPathIfNeeded(String path) {
        if (Sys.isWindows()) {
            if (!path.startsWith("http") && !path.startsWith(CLASSPATH_SCHEMA) && !path.startsWith(JAR_SCHEMA) && Str.slc(path = path.replace('/', Sys.windowsPathSeparator()), 0, 6).equals("file:\\")) {
                path = Str.slc(path, 6);
            }
            if (path.startsWith(".\\")) {
                path = Str.slc(path, 2);
            }
        }
        return path;
    }

    public static String read(final String location) {
        final URI uri = IO.createURI(location);
        return Exceptions.tryIt(String.class, new Exceptions.TrialWithReturn<String>(){

            @Override
            public String tryIt() throws Exception {
                String path = location;
                path = IO.getWindowsPathIfNeeded(path);
                if (uri.getScheme() == null) {
                    Path thePath = FileSystems.getDefault().getPath(path, new String[0]);
                    return IO.read(Files.newBufferedReader(thePath, DEFAULT_CHARSET));
                }
                if (uri.getScheme().equals(IO.FILE_SCHEMA)) {
                    return IO.readFromFileSchema(uri);
                }
                if (uri.getScheme().equals(IO.CLASSPATH_SCHEMA) || uri.getScheme().equals(IO.JAR_SCHEMA)) {
                    return IO.readFromClasspath(uri.toString());
                }
                return IO.read(location, uri);
            }
        });
    }

    private static String readFromFileSchema(URI uri) {
        Path thePath = IO.uriToPath(uri);
        try {
            return IO.read(Files.newBufferedReader(thePath, DEFAULT_CHARSET));
        }
        catch (IOException e) {
            return Exceptions.handle(Typ.string, e);
        }
    }

    public static Path uriToPath(URI uri) {
        Path thePath = null;
        if (Sys.isWindows()) {
            String newPath = uri.getPath();
            if (newPath.startsWith("/C:")) {
                newPath = Str.slc(newPath, 3);
            }
            thePath = FileSystems.getDefault().getPath(newPath, new String[0]);
        } else {
            thePath = FileSystems.getDefault().getPath(uri.getPath(), new String[0]);
        }
        return thePath;
    }

    private static List<String> readLines(String location, URI uri) throws Exception {
        try {
            String path = location;
            path = IO.getWindowsPathIfNeeded(path);
            FileSystem fileSystem = FileSystems.getFileSystem(uri);
            Path fsPath = fileSystem.getPath(path, new String[0]);
            return Files.readAllLines(fsPath, DEFAULT_CHARSET);
        }
        catch (ProviderNotFoundException ex) {
            return IO.readLines(uri.toURL().openStream());
        }
    }

    private static void eachLine(String location, URI uri, EachLine eachLine) throws Exception {
        try {
            FileSystem fileSystem = FileSystems.getFileSystem(uri);
            Path fsPath = fileSystem.getPath(location, new String[0]);
            BufferedReader buf = Files.newBufferedReader(fsPath, DEFAULT_CHARSET);
            IO.eachLine(buf, eachLine);
        }
        catch (ProviderNotFoundException ex) {
            IO.eachLine(uri.toURL().openStream(), eachLine);
        }
    }

    private static String read(String location, URI uri) throws Exception {
        try {
            FileSystem fileSystem = FileSystems.getFileSystem(uri);
            Path fsPath = fileSystem.getPath(location, new String[0]);
            return IO.read(Files.newBufferedReader(fsPath, DEFAULT_CHARSET));
        }
        catch (ProviderNotFoundException ex) {
            return IO.read(uri.toURL().openStream());
        }
    }

    public static void write(OutputStream out, String content, Charset charset) {
        try (OutputStream o = out;){
            o.write(content.getBytes(charset));
        }
        catch (Exception ex) {
            Exceptions.handle(ex);
        }
    }

    public static void writeChild(Path parentDir, String childFileName, String childContents) {
        try {
            Path newFilePath = IO.path(parentDir.toString(), childFileName);
            IO.write(newFilePath, childContents);
        }
        catch (Exception ex) {
            Exceptions.handle(ex);
        }
    }

    public static Path createChildDirectory(Path parentDir, String childDir) {
        try {
            Path newDir = IO.path(parentDir.toString(), childDir);
            if (!Files.exists(newDir, new LinkOption[0])) {
                Files.createDirectory(newDir, new FileAttribute[0]);
            }
            return newDir;
        }
        catch (Exception ex) {
            return Exceptions.handle(Path.class, ex);
        }
    }

    public static Path createDirectory(Path dir) {
        try {
            if (!Files.exists(dir, new LinkOption[0])) {
                return Files.createDirectory(dir, new FileAttribute[0]);
            }
            return null;
        }
        catch (Exception ex) {
            return Exceptions.handle(Path.class, ex);
        }
    }

    public static Path createDirectory(String dir) {
        try {
            Path newDir = IO.path(dir);
            IO.createDirectory(newDir);
            return newDir;
        }
        catch (Exception ex) {
            return Exceptions.handle(Path.class, ex);
        }
    }

    public static FileSystem fileSystem() {
        return FileSystems.getDefault();
    }

    public static Path path(String path, String ... more) {
        return Paths.get(path, more);
    }

    public static Path path(Path path, String ... more) {
        return Paths.get(path.toString(), more);
    }

    public static void write(Path file, String contents) {
        IO.write(file, contents.getBytes(DEFAULT_CHARSET));
    }

    public static void output(Path file, byte[] bytes) {
        IO.write(file, bytes);
    }

    public static void write(Path file, byte[] contents) {
        try {
            Files.write(file, contents, new OpenOption[0]);
        }
        catch (Exception ex) {
            Exceptions.handle(ex);
        }
    }

    public static void write(OutputStream out, String content) {
        try (OutputStream o = out;){
            o.write(content.getBytes(DEFAULT_CHARSET));
        }
        catch (Exception ex) {
            Exceptions.handle(ex);
        }
    }

    public static void writeNoClose(OutputStream out, String content) {
        try {
            out.write(content.getBytes(DEFAULT_CHARSET));
        }
        catch (Exception ex) {
            Exceptions.handle(ex);
        }
    }

    public static String readFromClasspath(Class<?> clazz, String location) {
        List<Path> resources = Classpaths.resources(clazz, location);
        if (Lists.len(resources) > 0) {
            try {
                return IO.read(Files.newBufferedReader(resources.get(0), DEFAULT_CHARSET));
            }
            catch (IOException e) {
                return Exceptions.handle(String.class, "unable to read classpath resource " + location, e);
            }
        }
        return null;
    }

    private static List<String> listFromDefaultClassLoader(String s) {
        ArrayList<String> result = new ArrayList<String>();
        String newPath = s;
        List<Path> resources = Classpaths.resources(IO.class, newPath);
        for (Path resourcePath : resources) {
            if (Files.isDirectory(resourcePath, new LinkOption[0])) {
                result.addAll(IO.list(resourcePath));
                continue;
            }
            result.add(resourcePath.toString());
        }
        return result;
    }

    public static Path path(String location) {
        if (!location.startsWith("classpath:")) {
            return Paths.get(location, new String[0]);
        }
        String path = StringScanner.split(location, ':')[1];
        List<Path> resources = Classpaths.resources(IO.class, path);
        Path result = Lists.idx(resources, 0);
        if (result == null) {
            return IO.path(path);
        }
        return result;
    }

    public static String readFromClasspath(String location) {
        Path path;
        Exceptions.requireNonNull(location, "location can't be null");
        if (!location.startsWith("classpath:")) {
            Exceptions.die("Location must starts with classpath");
        }
        if ((path = IO.path(location)) == null) {
            return null;
        }
        try {
            return IO.read(Files.newBufferedReader(path, DEFAULT_CHARSET));
        }
        catch (IOException e) {
            return Exceptions.handle(String.class, "unable to read classpath resource " + location, e);
        }
    }

    public static InputStream inputStream(String resource) {
        Path path = IO.path(resource);
        try {
            return Files.newInputStream(path, new OpenOption[0]);
        }
        catch (IOException e) {
            return Exceptions.handle(InputStream.class, "unable to open " + resource, e);
        }
    }

    public static List<String> list(String path) {
        URI uri = URI.create(path);
        if (uri.getScheme() == null) {
            Path pathFromFileSystem = IO.path(path);
            return IO.list(pathFromFileSystem);
        }
        if (uri.getScheme().equals(CLASSPATH_SCHEMA)) {
            return IO.listFromDefaultClassLoader(StringScanner.split(path, ':')[1]);
        }
        Path pathFromFileSystem = IO.path(path);
        return IO.list(pathFromFileSystem);
    }

    public static List<String> listByExt(String path, String ext) {
        List<String> list = IO.list(path);
        ArrayList<String> newList = new ArrayList<String>();
        for (String file : list) {
            if (!file.endsWith(ext)) continue;
            newList.add(file);
        }
        return newList;
    }

    public static interface EachLine {
        public boolean line(String var1, int var2);
    }

    public static class ConvertToPathFunction
    implements Function<String, Path> {
        @Override
        public Path apply(String s) {
            return IO.path(s);
        }
    }
}

