/*
 * Decompiled with CFR 0.152.
 */
package org.boon;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.boon.Exceptions;
import org.boon.Lists;
import org.boon.core.Sys;
import org.boon.core.reflection.BeanUtils;
import org.boon.primitive.CharBuf;

public class Boon {
    public static boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static void println(String message) {
        Sys.println(message);
    }

    public static void println() {
        Sys.println("");
    }

    public static void println(Object message) {
        Boon.print(message);
        Boon.println();
    }

    public static void print(String message) {
        Sys.print(message);
    }

    public static void print(Object message) {
        if (message == null) {
            Boon.print("<NULL>");
        } else if (message.getClass().isArray()) {
            Boon.print(Lists.toListOrSingletonList(message).toString());
        } else {
            Boon.print(message.toString());
        }
    }

    public static void puts(Object ... messages) {
        for (Object message : messages) {
            Boon.print(message);
            Boon.print(Character.valueOf(' '));
        }
        Boon.println();
    }

    public static void putl(Object ... messages) {
        for (Object message : messages) {
            Boon.print(message);
            Boon.println();
        }
        Boon.println();
    }

    public static String sputl(Object ... messages) {
        CharBuf buf = CharBuf.create(100);
        return Boon.sputl(buf, messages);
    }

    public static String sputs(Object ... messages) {
        StringBuilder buf = new StringBuilder();
        return Boon.sputs(buf, messages);
    }

    public static String sputl(CharBuf buf, Object ... messages) {
        for (Object message : messages) {
            if (message == null) {
                buf.add("<NULL>");
            } else if (message.getClass().isArray()) {
                buf.add(Lists.toListOrSingletonList(message).toString());
            } else {
                buf.add(message.toString());
            }
            buf.add('\n');
        }
        buf.add('\n');
        return buf.toString();
    }

    public static String sputs(CharBuf buf, Object ... messages) {
        int index = 0;
        for (Object message : messages) {
            if (index != 0) {
                buf.add(' ');
            }
            ++index;
            if (message == null) {
                buf.add("<NULL>");
                continue;
            }
            if (message.getClass().isArray()) {
                buf.add(Lists.toListOrSingletonList(message).toString());
                continue;
            }
            buf.add(message.toString());
        }
        buf.add('\n');
        return buf.toString();
    }

    public static String sputs(StringBuilder buf, Object ... messages) {
        int index = 0;
        for (Object message : messages) {
            if (index != 0) {
                buf.append(' ');
            }
            ++index;
            if (message == null) {
                buf.append("<NULL>");
                continue;
            }
            if (message.getClass().isArray()) {
                buf.append(Lists.toListOrSingletonList(message).toString());
                continue;
            }
            buf.append(message.toString());
        }
        buf.append('\n');
        return buf.toString();
    }

    public static boolean isArray(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj.getClass().isArray();
    }

    public static int len(Object obj) {
        if (Boon.isArray(obj)) {
            return Boon.arrayLength(obj);
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).size();
        }
        if (obj instanceof Map) {
            return ((Map)obj).size();
        }
        if (obj == null) {
            return 0;
        }
        Exceptions.die(Boon.sputs("Not an array like object", obj, obj.getClass()));
        return 0;
    }

    public static int arrayLength(Object obj) {
        return Array.getLength(obj);
    }

    public static Iterator iterator(final Object o) {
        if (o instanceof Collection) {
            return ((Collection)o).iterator();
        }
        if (Boon.isArray(o)) {
            return new Iterator(){
                int index = 0;
                int length = Boon.len(o);

                @Override
                public boolean hasNext() {
                    return this.index < this.length;
                }

                public Object next() {
                    Object value = BeanUtils.idx(o, this.index);
                    ++this.index;
                    return value;
                }

                @Override
                public void remove() {
                }
            };
        }
        return null;
    }

    public static String joinBy(char delim, Object ... args) {
        CharBuf builder = CharBuf.create(256);
        int index = 0;
        for (Object arg : args) {
            builder.add(arg.toString());
            if (index != args.length - 1) {
                builder.add(delim);
            }
            ++index;
        }
        return builder.toString();
    }
}

