/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.matrix;

import io.fair_acc.math.matrix.MatrixD;

public class MatrixFactory {
    public static MatrixD constructWithCopy(double[][] A) {
        int m = A.length;
        int n = A[0].length;
        MatrixD X = new MatrixD(m, n);
        double[][] C = X.getArray();
        for (int i = 0; i < m; ++i) {
            if (A[i].length != n) {
                throw new IllegalArgumentException("All rows must have the same length.");
            }
            System.arraycopy(A[i], 0, C[i], 0, n);
        }
        return X;
    }

    public static MatrixD identity(int m, int n) {
        MatrixD A = new MatrixD(m, n);
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                A.set(i, j, i == j ? 1.0 : 0.0);
            }
        }
        return A;
    }

    public static MatrixD random(int m, int n) {
        MatrixD A = new MatrixD(m, n);
        double[][] X = A.getArray();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                X[i][j] = Math.random();
            }
        }
        return A;
    }
}

