/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.functions;

import io.fair_acc.math.Math;
import io.fair_acc.math.functions.AbstractFunction1D;
import io.fair_acc.math.functions.Function1D;

public class GaussianFunction
extends AbstractFunction1D
implements Function1D {
    public GaussianFunction(String name) {
        this(name, null);
    }

    public GaussianFunction(String name, double[] parameter) {
        super(name, new double[3]);
        this.setParameterName(0, "mean");
        this.setParameterValue(0, 0.0);
        this.setParameterName(1, "sigma");
        this.setParameterValue(1, 1.0);
        this.setParameterName(2, "scaling");
        this.setParameterValue(2, 1.0);
        if (parameter == null) {
            return;
        }
        for (int i = 0; i < Math.min(parameter.length, 3); ++i) {
            this.setParameterValue(i, parameter[i]);
        }
    }

    @Override
    public double getValue(double x) {
        return this.fparameter[2] * Math.gauss(x, this.fparameter[0], this.fparameter[1], true);
    }
}

