/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math;

import io.fair_acc.dataset.utils.AssertUtils;
import io.fair_acc.math.Math;
import java.util.Arrays;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;

public final class ArrayUtils {
    private static final String ARRAY = "array";

    private ArrayUtils() {
    }

    public static double[] convertToDouble(boolean[] array) {
        double[] a = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            a[i] = array[i] ? 1.0 : 0.0;
        }
        return a;
    }

    public static double[] convertToDouble(boolean[] array, double scale) {
        double[] a = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            a[i] = scale * (array[i] ? 1.0 : 0.0);
        }
        return a;
    }

    public static double[] convertToDouble(byte[] array) {
        double[] a = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            a[i] = array[i];
        }
        return a;
    }

    public static double[] convertToDouble(byte[] array, double scale) {
        double[] a = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            a[i] = scale * (double)array[i];
        }
        return a;
    }

    public static double[] convertToDouble(float[] array) {
        double[] a = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            a[i] = array[i];
        }
        return a;
    }

    public static double[] convertToDouble(float[] array, double scale) {
        double[] a = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            a[i] = (double)array[i] * scale;
        }
        return a;
    }

    public static double[] convertToDouble(int[] array) {
        double[] a = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            a[i] = array[i];
        }
        return a;
    }

    public static double[] convertToDouble(int[] array, double scale) {
        double[] a = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            a[i] = (double)array[i] * scale;
        }
        return a;
    }

    public static double[] convertToDouble(long[] array) {
        double[] a = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            a[i] = array[i];
        }
        return a;
    }

    public static double[] convertToDouble(long[] array, double scale) {
        double[] a = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            a[i] = (double)array[i] * scale;
        }
        return a;
    }

    public static double[] convertToDouble(short[] array) {
        double[] a = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            a[i] = array[i];
        }
        return a;
    }

    public static double[] convertToDouble(short[] array, double scale) {
        double[] a = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            a[i] = (double)array[i] * scale;
        }
        return a;
    }

    public static double[] createArray(double offset, double scale, int size) {
        double[] a = new double[size];
        for (int i = 0; i < size; ++i) {
            a[i] = (double)i * scale + offset;
        }
        return a;
    }

    public static void fillArray(boolean[] array, boolean value) {
        AssertUtils.notNull((String)ARRAY, (Object)array);
        int len = array.length;
        if (len > 0) {
            array[0] = value;
        }
        for (int i = 1; i < len; i += i) {
            System.arraycopy(array, 0, array, i, len - i < i ? len - i : i);
        }
    }

    public static void fillArray(byte[] array, byte value) {
        AssertUtils.notNull((String)ARRAY, (Object)array);
        int len = array.length;
        if (len > 0) {
            array[0] = value;
        }
        for (int i = 1; i < len; i += i) {
            System.arraycopy(array, 0, array, i, len - i < i ? len - i : i);
        }
    }

    public static void fillArray(double[] array, double value) {
        AssertUtils.notNull((String)ARRAY, (Object)array);
        int len = array.length;
        ArrayUtils.fillArray(array, 0, len, value);
    }

    public static void fillArray(double[] array, int indexStart, int indexStop, double value) {
        AssertUtils.notNull((String)ARRAY, (Object)array);
        int len = indexStop - indexStart;
        if (len > 0) {
            array[indexStart] = value;
        }
        for (int i = 1; i < len; i <<= 1) {
            System.arraycopy(array, indexStart, array, indexStart + i, len - i < i ? len - i : i);
        }
    }

    public static void fillArray(float[] array, float value) {
        AssertUtils.notNull((String)ARRAY, (Object)array);
        int len = array.length;
        ArrayUtils.fillArray(array, 0, len, value);
    }

    public static void fillArray(float[] array, int indexStart, int indexStop, float value) {
        AssertUtils.notNull((String)ARRAY, (Object)array);
        int len = indexStop - indexStart;
        if (len > 0) {
            array[indexStart] = value;
        }
        for (int i = 1; i < len; i += i) {
            System.arraycopy(array, indexStart, array, i, len - i < i ? len - i : i);
        }
    }

    public static void fillArray(int[] array, int value) {
        AssertUtils.notNull((String)ARRAY, (Object)array);
        int len = array.length;
        if (len > 0) {
            array[0] = value;
        }
        for (int i = 1; i < len; i += i) {
            System.arraycopy(array, 0, array, i, len - i < i ? len - i : i);
        }
    }

    public static void fillArray(long[] array, long value) {
        AssertUtils.notNull((String)ARRAY, (Object)array);
        int len = array.length;
        if (len > 0) {
            array[0] = value;
        }
        for (int i = 1; i < len; i += i) {
            System.arraycopy(array, 0, array, i, len - i < i ? len - i : i);
        }
    }

    public static void fillArray(short[] array, short value) {
        AssertUtils.notNull((String)ARRAY, (Object)array);
        int len = array.length;
        if (len > 0) {
            array[0] = value;
        }
        for (int i = 1; i < len; i += i) {
            System.arraycopy(array, 0, array, i, len - i < i ? len - i : i);
        }
    }

    public static <T> void fillArray(T[] array, int indexStart, int indexStop, T value) {
        AssertUtils.notNull((String)ARRAY, array);
        int len = indexStop - indexStart;
        if (len > 0) {
            array[indexStart] = value;
        }
        for (int i = 1; i < len; i += i) {
            System.arraycopy(array, indexStart, array, i, len - i < i ? len - i : i);
        }
    }

    public static <T> void fillArray(T[] array, T value) {
        AssertUtils.notNull((String)ARRAY, array);
        int len = array.length;
        ArrayUtils.fillArray(array, 0, len, value);
    }

    public static boolean[] resizeMin(boolean[] array, int minSize) {
        if (array != null && array.length >= minSize) {
            return array;
        }
        return new boolean[ArrayUtils.growSize(minSize, array, arr -> ((boolean[])arr).length)];
    }

    public static double[] resizeMin(double[] array, int minSize) {
        if (array != null && array.length >= minSize) {
            return array;
        }
        return new double[ArrayUtils.growSize(minSize, array, arr -> ((double[])arr).length)];
    }

    public static double[] resizeMin(double[] array, int minSize, boolean copyValues) {
        if (array != null && array.length >= minSize) {
            return array;
        }
        int newSize = ArrayUtils.growSize(minSize, array, arr -> ((double[])arr).length);
        if (!copyValues || array == null) {
            return new double[newSize];
        }
        return Arrays.copyOfRange(array, 0, newSize);
    }

    public static int[] resizeMin(int[] array, int minSize) {
        if (array != null && array.length >= minSize) {
            return array;
        }
        return new int[ArrayUtils.growSize(minSize, array, arr -> ((int[])arr).length)];
    }

    public static <T> T[] resizeMinNulled(T[] array, int minSize, IntFunction<T[]> constructor) {
        return ArrayUtils.resizeMin(array, minSize, constructor, true);
    }

    public static <T> T[] resizeMin(T[] array, int minSize, IntFunction<T[]> constructor, boolean setNull) {
        if (array != null && array.length >= minSize) {
            if (setNull) {
                Arrays.fill(array, 0, minSize, null);
            }
            return array;
        }
        return constructor.apply(ArrayUtils.growSize(minSize, array, arr -> ((Object[])arr).length));
    }

    private static <T> int growSize(int minSize, T object, ToIntFunction<T> getSize) {
        int currentSize = object == null ? 0 : getSize.applyAsInt(object);
        int minGrowSize = Math.max(currentSize + 200, (int)((double)currentSize * 1.2));
        return Math.max(minSize, minGrowSize);
    }

    public static boolean[] clearIfLarger(boolean[] array, int maxSize) {
        return (boolean[])(array != null && array.length > maxSize ? null : array);
    }

    public static double[] clearIfLarger(double[] array, int maxSize) {
        return (double[])(array != null && array.length > maxSize ? null : array);
    }

    public static <T> T[] clearIfLarger(T[] array, int maxSize) {
        return array != null && array.length > maxSize ? null : array;
    }
}

