/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.zookeeper.curator;

import io.fabric8.zookeeper.ACLManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuratorACLManager
implements ACLManager,
ACLProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(CuratorACLManager.class);
    private final ConcurrentMap<String, String> acls = new ConcurrentHashMap<String, String>();

    @Inject
    public CuratorACLManager() {
        this(new HashMap());
    }

    public CuratorACLManager(Map<String, ?> configuration) {
        this.acls.put("/", "world:anyone:acdrw");
        this.acls.put("/fabric", "auth::acdrw,world:anyone:");
        for (Map.Entry<String, ?> entry : configuration.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith("acls.")) continue;
            String value = String.valueOf(entry.getValue());
            this.acls.put(key.substring("acls.".length()), value);
        }
    }

    public List<ACL> getDefaultAcl() {
        return this.getAclForPath("/");
    }

    public List<ACL> getAclForPath(String path) {
        String acl = this.findNodeAcls(this.adjustPath(path));
        if (acl == null) {
            throw new IllegalStateException("Could not find matching ACLs for " + path);
        }
        return this.parseACLs(acl);
    }

    @Override
    public void registerAcl(String path, String acl) {
        this.acls.put(path, acl);
    }

    @Override
    public void unregisterAcl(String path) {
        this.acls.remove(path);
    }

    @Override
    public void fixAcl(CuratorFramework curator, String path, boolean recursive) throws Exception {
        this.fixAclInternal(curator, path, recursive);
    }

    private void fixAclInternal(CuratorFramework curator, String path, boolean recursive) throws Exception {
        List<ACL> aclList = this.getAclForPath(path);
        ((BackgroundPathable)curator.setACL().withACL(aclList)).forPath(path);
        if (recursive) {
            for (String child : (List)curator.getChildren().forPath(path)) {
                this.fixAclInternal(curator, path.equals("/") ? "/" + child : path + "/" + child, recursive);
            }
        }
    }

    private String findNodeAcls(String path) {
        String longestPath = "";
        for (String acl : this.acls.keySet()) {
            if (acl.length() <= longestPath.length() || !path.startsWith(acl)) continue;
            longestPath = acl;
        }
        return (String)this.acls.get(longestPath);
    }

    private String adjustPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }

    private List<ACL> parseACLs(String aclString) {
        String[] acls = aclString.split(",");
        ArrayList<ACL> acl = new ArrayList<ACL>();
        for (String a : acls) {
            int firstColon = a.indexOf(58);
            int lastColon = a.lastIndexOf(58);
            if (firstColon == -1 || lastColon == -1 || firstColon == lastColon) {
                LOGGER.warn(a + " does not have the form scheme:id:perm");
                continue;
            }
            ACL newAcl = new ACL();
            newAcl.setId(new Id(a.substring(0, firstColon), a.substring(firstColon + 1, lastColon)));
            newAcl.setPerms(this.getPermFromString(a.substring(lastColon + 1)));
            acl.add(newAcl);
        }
        return acl;
    }

    private int getPermFromString(String permString) {
        int perm = 0;
        block7: for (int i = 0; i < permString.length(); ++i) {
            switch (permString.charAt(i)) {
                case 'r': {
                    perm |= 1;
                    continue block7;
                }
                case 'w': {
                    perm |= 2;
                    continue block7;
                }
                case 'c': {
                    perm |= 4;
                    continue block7;
                }
                case 'd': {
                    perm |= 8;
                    continue block7;
                }
                case 'a': {
                    perm |= 0x10;
                    continue block7;
                }
                default: {
                    LOGGER.warn("Unknown perm type: " + permString.charAt(i));
                }
            }
        }
        return perm;
    }
}

