/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.zookeeper.curator;

import com.google.common.base.Strings;
import com.google.common.io.Closeables;
import io.fabric8.utils.PasswordEncoder;
import io.fabric8.zookeeper.curator.CuratorConfig;
import io.fabric8.zookeeper.curator.CuratorFrameworkLocator;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PreDestroy;
import org.apache.curator.RetryPolicy;
import org.apache.curator.ensemble.EnsembleProvider;
import org.apache.curator.ensemble.fixed.FixedEnsembleProvider;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.retry.RetryNTimes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ManagedCuratorFramework {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagedCuratorFramework.class);
    private final CuratorConfig config;
    private final ACLProvider aclProvider;
    private final List<ConnectionStateListener> connectionStateListeners = new CopyOnWriteArrayList<ConnectionStateListener>();
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private AtomicReference<State> state = new AtomicReference();

    public ManagedCuratorFramework(CuratorConfig config, ACLProvider aclProvider) {
        State next;
        this.config = config;
        this.aclProvider = aclProvider;
        if (!Strings.isNullOrEmpty((String)config.getZookeeperUrl()) && this.state.compareAndSet(null, next = new State(config))) {
            this.executor.submit(next);
        }
    }

    @PreDestroy
    void destroy() throws IOException {
        State prev = this.state.getAndSet(null);
        if (prev != null) {
            CuratorFrameworkLocator.unbindCurator(prev.curator);
            prev.close();
        }
        this.executor.shutdownNow();
    }

    private synchronized CuratorFramework buildCuratorFramework(CuratorConfig curatorConfig) {
        ACLProvider aclProviderInstance = this.aclProvider;
        List<ConnectionStateListener> connectionListenerList = this.connectionStateListeners;
        return ManagedCuratorFramework.createCuratorFramework(curatorConfig, aclProviderInstance, connectionListenerList);
    }

    public static CuratorFramework createCuratorFramework(CuratorConfig curatorConfig, ACLProvider aclProviderInstance, List<ConnectionStateListener> connectionListenerList) {
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().canBeReadOnly(true).ensembleProvider((EnsembleProvider)new FixedEnsembleProvider(curatorConfig.getZookeeperUrl())).connectionTimeoutMs(curatorConfig.getZookeeperConnectionTimeOut()).sessionTimeoutMs(curatorConfig.getZookeeperSessionTimeout()).retryPolicy((RetryPolicy)new RetryNTimes(curatorConfig.getZookeeperRetryMax(), curatorConfig.getZookeeperRetryInterval()));
        if (!Strings.isNullOrEmpty((String)curatorConfig.getZookeeperPassword())) {
            String scheme = "digest";
            byte[] auth = ("fabric:" + PasswordEncoder.decode((String)curatorConfig.getZookeeperPassword())).getBytes();
            builder = builder.authorization(scheme, auth).aclProvider(aclProviderInstance);
        }
        CuratorFramework framework = builder.build();
        for (ConnectionStateListener listener : connectionListenerList) {
            framework.getConnectionStateListenable().addListener((Object)listener);
        }
        return framework;
    }

    void bindConnectionStateListener(ConnectionStateListener connectionStateListener) {
        CuratorFramework curator;
        this.connectionStateListeners.add(connectionStateListener);
        State curr = this.state.get();
        CuratorFramework curatorFramework = curator = curr != null ? curr.curator : null;
        if (curator != null && curator.getZookeeperClient().isConnected()) {
            connectionStateListener.stateChanged(curator, ConnectionState.CONNECTED);
        }
    }

    void unbindConnectionStateListener(ConnectionStateListener connectionStateListener) {
        this.connectionStateListeners.remove(connectionStateListener);
    }

    class State
    implements ConnectionStateListener,
    Runnable {
        final CuratorConfig configuration;
        final AtomicBoolean closed = new AtomicBoolean();
        CuratorFramework curator;

        State(CuratorConfig configuration) {
            this.configuration = configuration;
        }

        @Override
        public void run() {
            try {
                if (this.curator != null) {
                    this.curator.getZookeeperClient().stop();
                }
                try {
                    Closeables.close((Closeable)this.curator, (boolean)true);
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.curator = null;
                if (!this.closed.get()) {
                    this.curator = ManagedCuratorFramework.this.buildCuratorFramework(this.configuration);
                    this.curator.getConnectionStateListenable().addListener((Object)this, (Executor)ManagedCuratorFramework.this.executor);
                    this.curator.start();
                    CuratorFrameworkLocator.bindCurator(this.curator);
                }
            }
            catch (Throwable th) {
                LOGGER.error("Cannot start curator framework", th);
            }
        }

        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            for (ConnectionStateListener listener : ManagedCuratorFramework.this.connectionStateListeners) {
                listener.stateChanged(client, newState);
            }
            if (newState == ConnectionState.LOST) {
                this.run();
            }
        }

        public void close() {
            this.closed.set(true);
            CuratorFramework curator = this.curator;
            if (curator != null) {
                for (ConnectionStateListener listener : ManagedCuratorFramework.this.connectionStateListeners) {
                    listener.stateChanged(curator, ConnectionState.LOST);
                }
                curator.getZookeeperClient().stop();
            }
            try {
                ManagedCuratorFramework.this.executor.submit(this).get();
            }
            catch (Exception e) {
                LOGGER.warn("Error while closing curator", (Throwable)e);
            }
        }
    }
}

