/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jaxb.dynamic.watcher;

import io.fabric8.jaxb.dynamic.CompileResults;
import io.fabric8.jaxb.dynamic.CompileResultsHandler;
import io.fabric8.jaxb.dynamic.DefaultDynamicCompiler;
import io.fabric8.jaxb.dynamic.DynamicCompiler;
import io.fabric8.watcher.PathHelper;
import io.fabric8.watcher.Processor;
import io.fabric8.watcher.file.FileWatcher;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWatcherDynamicCompiler
extends FileWatcher
implements DynamicCompiler {
    private static final transient Logger LOG = LoggerFactory.getLogger(FileWatcherDynamicCompiler.class);
    private CompileResults compileResults;
    private CompileResultsHandler handler;
    private ConcurrentHashMap<String, Path> urlMap = new ConcurrentHashMap();
    private AtomicBoolean compileScheduled = new AtomicBoolean(false);
    private long compileDelayMillis = 1000L;
    private ClassLoader classLoader;

    public FileWatcherDynamicCompiler() {
        this.setFileMatchPattern("glob:**.xsd");
        this.setProcessor(new Processor(){

            public void process(Path path) {
                FileWatcherDynamicCompiler.this.addCompilePath(path);
            }

            public void onRemove(Path path) {
                FileWatcherDynamicCompiler.this.removeCompilePath(path);
            }
        });
    }

    public void setHandler(CompileResultsHandler handler) throws Exception {
        this.handler = handler;
        if (handler != null && this.compileResults != null) {
            handler.onCompileResults(this.compileResults);
        }
    }

    public void init() throws IOException {
        super.init();
        LOG.info("Watching directory " + this.getRoot() + " for XML Schema files to dynamically compile");
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public CompileResults getCompileResults() {
        return this.compileResults;
    }

    public long getCompileDelayMillis() {
        return this.compileDelayMillis;
    }

    public void setCompileDelayMillis(long compileDelayMillis) {
        this.compileDelayMillis = compileDelayMillis;
    }

    protected void addCompilePath(Path path) {
        try {
            String url = PathHelper.toUrlString((Path)path);
            Path old = this.urlMap.put(url, path);
            if (old == null) {
                this.scheduleRecompile();
            }
        }
        catch (MalformedURLException e) {
            LOG.warn("Ignored path " + path + " due to: " + e, (Throwable)e);
        }
    }

    protected void removeCompilePath(Path path) {
        try {
            String url = PathHelper.toUrlString((Path)path);
            Path old = this.urlMap.remove(url);
            if (old != null) {
                this.scheduleRecompile();
            }
        }
        catch (MalformedURLException e) {
            LOG.warn("Ignored path " + path + " due to: " + e, (Throwable)e);
        }
    }

    protected void scheduleRecompile() {
        if (this.compileScheduled.compareAndSet(false, true)) {
            ExecutorService executor = this.getExecutor();
            Runnable command = new Runnable(){

                @Override
                public void run() {
                    FileWatcherDynamicCompiler.this.compileScheduled.set(false);
                    FileWatcherDynamicCompiler.this.doCompile();
                }
            };
            if (executor instanceof ScheduledExecutorService) {
                ScheduledExecutorService scheduledExecutorService = (ScheduledExecutorService)executor;
                scheduledExecutorService.schedule(command, this.compileDelayMillis, TimeUnit.MILLISECONDS);
            } else {
                executor.execute(command);
            }
        }
    }

    protected void doCompile() {
        Set urls = this.urlMap.keySet();
        LOG.info("Compilng XSD urls: " + urls);
        this.compileResults = DefaultDynamicCompiler.doCompile((ClassLoader)this.classLoader, (Collection)urls);
        if (this.handler != null) {
            this.handler.onCompileResults(this.compileResults);
        }
    }
}

