/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.dozer.file;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.converter.dozer.DozerTypeConverter;
import org.apache.camel.converter.dozer.DozerTypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.util.ObjectHelper;
import org.dozer.DozerBeanMapper;

public class WatcherDozerTypeConverterLoader
extends DozerTypeConverterLoader {
    private final CamelContext camelContext;
    private String mappingFile;
    private final Set<ConverterFromTo> converters = new LinkedHashSet<ConverterFromTo>();

    public WatcherDozerTypeConverterLoader(CamelContext camelContext, String mappingFile, DozerBeanMapper mapper) {
        this.camelContext = camelContext;
        this.mappingFile = mappingFile;
        this.setMapper(mapper);
    }

    protected Map<String, DozerBeanMapper> lookupDozerBeanMappers() {
        ArrayList<String> mappingFiles = new ArrayList<String>(1);
        mappingFiles.add(this.mappingFile);
        this.getMapper().setMappingFiles(mappingFiles);
        HashMap<String, DozerBeanMapper> answer = new HashMap<String, DozerBeanMapper>(1);
        answer.put("dozer", this.getMapper());
        return answer;
    }

    protected void doStart() throws Exception {
        try {
            this.camelContext.addService((Object)this);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        for (ConverterFromTo fromTo : this.converters) {
            this.getCamelContext().getTypeConverterRegistry().removeTypeConverter(fromTo.getTo(), fromTo.getFrom());
        }
        this.converters.clear();
        super.doStop();
    }

    protected void addDozerTypeConverter(TypeConverterRegistry registry, DozerTypeConverter converter, String dozerId, Class<?> to, Class<?> from) {
        super.addDozerTypeConverter(registry, converter, dozerId, to, from);
        ConverterFromTo fromTo = new ConverterFromTo(from, to);
        this.converters.add(fromTo);
    }

    private static final class ConverterFromTo {
        private final Class<?> from;
        private final Class<?> to;

        private ConverterFromTo(Class<?> from, Class<?> to) {
            this.from = from;
            this.to = to;
        }

        public Class<?> getFrom() {
            return this.from;
        }

        public Class<?> getTo() {
            return this.to;
        }
    }
}

