/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.watcher.matchers;

import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class Maven {
    public static final String PREFIX = "mvn:";
    public static final String PREFIX_GROUPID = "groupId:";

    public static PathMatcher parse(String expression) {
        if (expression.startsWith(PREFIX)) {
            String log = expression.substring(PREFIX.length());
            return Maven.doParse(log);
        }
        throw new IllegalArgumentException("Expression does not start with the required prefix 'mvn:'");
    }

    private static PathMatcher doParse(String expression) {
        if (expression.startsWith(PREFIX_GROUPID)) {
            String[] groupIds = expression.substring(PREFIX_GROUPID.length()).split(",");
            return new GroupIdPathMatcher(Arrays.asList(groupIds));
        }
        throw new IllegalArgumentException("Unrecognized expression: " + expression);
    }

    public static class GroupIdPathMatcher
    implements PathMatcher {
        Node root = new Node();

        public GroupIdPathMatcher(Collection<String> groupIds) {
            if (groupIds.isEmpty()) {
                this.root.valid = true;
            } else {
                for (String groupId : groupIds) {
                    this.addGroupId(groupId);
                }
            }
        }

        private void addGroupId(String groupId) {
            Node node = this.root;
            for (String path : groupId.split("\\.")) {
                Node child = node.children.get(path);
                if (child == null) {
                    child = new Node();
                    node.children.put(path, child);
                }
                node = child;
            }
            node.valid = true;
        }

        @Override
        public boolean matches(Path path) {
            if (this.root.valid) {
                return true;
            }
            Node node = this.root;
            for (Path p : path) {
                node = node.children.get(p.toString());
                if (node == null) {
                    return false;
                }
                if (!node.valid) continue;
                return true;
            }
            return true;
        }

        static class Node {
            boolean valid;
            Map<String, Node> children = new HashMap<String, Node>();

            Node() {
            }
        }
    }
}

