/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.watcher;

import io.fabric8.common.util.XmlHelper;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class Paths {
    private static final transient Logger LOG = LoggerFactory.getLogger(Paths.class);

    public static boolean hasNamespace(Path file, String ... namespaceURis) {
        try {
            return XmlHelper.hasNamespace(Paths.getNamespaces(file), namespaceURis);
        }
        catch (Exception e) {
            LOG.warn("Failed to parse XML " + file + ". " + e, (Throwable)e);
            return false;
        }
    }

    public static Set<String> getNamespaces(Path path) throws IOException, ParserConfigurationException, SAXException {
        return XmlHelper.getNamespaces(path.toUri().toURL().openStream());
    }
}

