/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.watcher.blueprint.web;

import io.fabric8.watcher.PathHelper;
import io.fabric8.watcher.Paths;
import io.fabric8.watcher.Processor;
import io.fabric8.watcher.file.FileWatcher;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.aries.blueprint.container.BlueprintContainerImpl;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatcherBlueprintContainer
extends FileWatcher {
    private static final transient Logger LOG = LoggerFactory.getLogger(WatcherBlueprintContainer.class);
    public static final String BLUEPRINT_NAMESPACE_URI = "http://www.osgi.org/xmlns/blueprint/v1.0.0";
    private ConcurrentHashMap<URL, BlueprintContainer> containerMap = new ConcurrentHashMap();
    private ClassLoader classLoader;
    private Map<String, String> properties = new HashMap<String, String>();
    private AtomicBoolean closing = new AtomicBoolean(false);
    private BlueprintContainer parentContainer;

    public WatcherBlueprintContainer() {
        this.classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        this.setFileMatchPattern("glob:**.xml");
        this.setProcessor(new Processor(){

            public void process(Path path) {
                if (!WatcherBlueprintContainer.this.closing.get()) {
                    WatcherBlueprintContainer.this.addPath(path);
                }
            }

            public void onRemove(Path path) {
                if (!WatcherBlueprintContainer.this.closing.get()) {
                    WatcherBlueprintContainer.this.removePath(path);
                }
            }
        });
    }

    public void init() throws IOException {
        super.init();
        LOG.info("Watching directory " + this.getRoot() + " for Blueprint XML files to load");
    }

    public void destroy() {
        if (this.closing.compareAndSet(false, true)) {
            Set<Map.Entry<URL, BlueprintContainer>> entries = this.containerMap.entrySet();
            for (Map.Entry<URL, BlueprintContainer> entry : entries) {
                URL url = entry.getKey();
                BlueprintContainer container = entry.getValue();
                this.closeContainer(url, container);
            }
        }
        super.destroy();
    }

    public Set<URL> getContainerURLs() {
        return new HashSet<URL>(this.containerMap.keySet());
    }

    public BlueprintContainer getContainer(URL url) {
        return this.containerMap.get(url);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public BlueprintContainer getParentContainer() {
        return this.parentContainer;
    }

    public void setParentContainer(BlueprintContainer parentContainer) {
        this.parentContainer = parentContainer;
        if (parentContainer instanceof BlueprintContainerImpl) {
            BlueprintContainerImpl blueprintContainerImpl = (BlueprintContainerImpl)parentContainer;
        }
    }

    protected void addPath(Path path) {
        URL url = this.toUrl(path);
        if (url != null) {
            BlueprintContainer container = this.containerMap.get(url);
            if (container != null) {
                this.closeContainer(url, container);
            }
            try {
                container = this.createContainer(path, url);
                if (container != null) {
                    this.containerMap.put(url, container);
                }
            }
            catch (Exception e) {
                LOG.info("Failed to create container at " + url + ". " + e, (Throwable)e);
            }
        }
    }

    protected void removePath(Path path) {
        URL url = this.toUrl(path);
        if (url != null) {
            BlueprintContainer container = this.containerMap.remove(url);
            this.closeContainer(url, container);
        }
    }

    protected BlueprintContainer createContainer(Path path, URL url) throws Exception {
        if (!Paths.hasNamespace((Path)path, (String[])new String[]{BLUEPRINT_NAMESPACE_URI})) {
            LOG.info("Ignoring XML file " + path + " which is not a blueprint XML");
            return null;
        }
        LOG.info("Creating container at " + url);
        List<URL> locations = Arrays.asList(url);
        return new BlueprintContainerImpl(this.classLoader, locations, this.properties, true);
    }

    protected void closeContainer(URL url, BlueprintContainer container) {
        if (container instanceof BlueprintContainerImpl) {
            BlueprintContainerImpl impl = (BlueprintContainerImpl)container;
            try {
                LOG.info("Closing container at path " + url + " container " + container);
                impl.destroy();
            }
            catch (Exception e) {
                LOG.info("Failed to close at " + url + " container " + container + ". " + e, (Throwable)e);
            }
        }
    }

    protected URL toUrl(Path path) {
        URL url = null;
        try {
            url = PathHelper.toURL((Path)path);
        }
        catch (MalformedURLException e) {
            LOG.warn("Ignored path " + path + " due to: " + e, (Throwable)e);
        }
        return url;
    }
}

