package io.fabric8.volcano.api.model.flow.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class JobFlowSpecFluent<A extends JobFlowSpecFluent<A>> extends BaseFluent<A>{
  public JobFlowSpecFluent() {
  }
  
  public JobFlowSpecFluent(JobFlowSpec instance) {
    this.copyInstance(instance);
  }
  private ArrayList<FlowBuilder> flows = new ArrayList<FlowBuilder>();
  private String jobRetainPolicy;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(JobFlowSpec instance) {
    instance = (instance != null ? instance : new JobFlowSpec());
    if (instance != null) {
          this.withFlows(instance.getFlows());
          this.withJobRetainPolicy(instance.getJobRetainPolicy());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToFlows(int index,Flow item) {
    if (this.flows == null) {this.flows = new ArrayList<FlowBuilder>();}
    FlowBuilder builder = new FlowBuilder(item);
    if (index < 0 || index >= flows.size()) {
        _visitables.get("flows").add(builder);
        flows.add(builder);
    } else {
        _visitables.get("flows").add(builder);
        flows.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToFlows(int index,Flow item) {
    if (this.flows == null) {this.flows = new ArrayList<FlowBuilder>();}
    FlowBuilder builder = new FlowBuilder(item);
    if (index < 0 || index >= flows.size()) {
        _visitables.get("flows").add(builder);
        flows.add(builder);
    } else {
        _visitables.get("flows").add(builder);
        flows.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToFlows(io.fabric8.volcano.api.model.flow.v1alpha1.Flow... items) {
    if (this.flows == null) {this.flows = new ArrayList<FlowBuilder>();}
    for (Flow item : items) {FlowBuilder builder = new FlowBuilder(item);_visitables.get("flows").add(builder);this.flows.add(builder);} return (A)this;
  }
  
  public A addAllToFlows(Collection<Flow> items) {
    if (this.flows == null) {this.flows = new ArrayList<FlowBuilder>();}
    for (Flow item : items) {FlowBuilder builder = new FlowBuilder(item);_visitables.get("flows").add(builder);this.flows.add(builder);} return (A)this;
  }
  
  public A removeFromFlows(io.fabric8.volcano.api.model.flow.v1alpha1.Flow... items) {
    if (this.flows == null) return (A)this;
    for (Flow item : items) {FlowBuilder builder = new FlowBuilder(item);_visitables.get("flows").remove(builder); this.flows.remove(builder);} return (A)this;
  }
  
  public A removeAllFromFlows(Collection<Flow> items) {
    if (this.flows == null) return (A)this;
    for (Flow item : items) {FlowBuilder builder = new FlowBuilder(item);_visitables.get("flows").remove(builder); this.flows.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromFlows(Predicate<FlowBuilder> predicate) {
    if (flows == null) return (A) this;
    final Iterator<FlowBuilder> each = flows.iterator();
    final List visitables = _visitables.get("flows");
    while (each.hasNext()) {
      FlowBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Flow> buildFlows() {
    return this.flows != null ? build(flows) : null;
  }
  
  public Flow buildFlow(int index) {
    return this.flows.get(index).build();
  }
  
  public Flow buildFirstFlow() {
    return this.flows.get(0).build();
  }
  
  public Flow buildLastFlow() {
    return this.flows.get(flows.size() - 1).build();
  }
  
  public Flow buildMatchingFlow(Predicate<FlowBuilder> predicate) {
      for (FlowBuilder item : flows) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingFlow(Predicate<FlowBuilder> predicate) {
      for (FlowBuilder item : flows) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withFlows(List<Flow> flows) {
    if (this.flows != null) {
      this._visitables.get("flows").clear();
    }
    if (flows != null) {
        this.flows = new ArrayList();
        for (Flow item : flows) {
          this.addToFlows(item);
        }
    } else {
      this.flows = null;
    }
    return (A) this;
  }
  
  public A withFlows(io.fabric8.volcano.api.model.flow.v1alpha1.Flow... flows) {
    if (this.flows != null) {
        this.flows.clear();
        _visitables.remove("flows");
    }
    if (flows != null) {
      for (Flow item : flows) {
        this.addToFlows(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasFlows() {
    return this.flows != null && !this.flows.isEmpty();
  }
  
  public FlowsNested<A> addNewFlow() {
    return new FlowsNested(-1, null);
  }
  
  public FlowsNested<A> addNewFlowLike(Flow item) {
    return new FlowsNested(-1, item);
  }
  
  public FlowsNested<A> setNewFlowLike(int index,Flow item) {
    return new FlowsNested(index, item);
  }
  
  public FlowsNested<A> editFlow(int index) {
    if (flows.size() <= index) throw new RuntimeException("Can't edit flows. Index exceeds size.");
    return setNewFlowLike(index, buildFlow(index));
  }
  
  public FlowsNested<A> editFirstFlow() {
    if (flows.size() == 0) throw new RuntimeException("Can't edit first flows. The list is empty.");
    return setNewFlowLike(0, buildFlow(0));
  }
  
  public FlowsNested<A> editLastFlow() {
    int index = flows.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last flows. The list is empty.");
    return setNewFlowLike(index, buildFlow(index));
  }
  
  public FlowsNested<A> editMatchingFlow(Predicate<FlowBuilder> predicate) {
    int index = -1;
    for (int i=0;i<flows.size();i++) { 
    if (predicate.test(flows.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching flows. No match found.");
    return setNewFlowLike(index, buildFlow(index));
  }
  
  public String getJobRetainPolicy() {
    return this.jobRetainPolicy;
  }
  
  public A withJobRetainPolicy(String jobRetainPolicy) {
    this.jobRetainPolicy = jobRetainPolicy;
    return (A) this;
  }
  
  public boolean hasJobRetainPolicy() {
    return this.jobRetainPolicy != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    JobFlowSpecFluent that = (JobFlowSpecFluent) o;
    if (!java.util.Objects.equals(flows, that.flows)) return false;
    if (!java.util.Objects.equals(jobRetainPolicy, that.jobRetainPolicy)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(flows,  jobRetainPolicy,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (flows != null && !flows.isEmpty()) { sb.append("flows:"); sb.append(flows + ","); }
    if (jobRetainPolicy != null) { sb.append("jobRetainPolicy:"); sb.append(jobRetainPolicy + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class FlowsNested<N> extends FlowFluent<FlowsNested<N>> implements Nested<N>{
    FlowsNested(int index,Flow item) {
      this.index = index;
      this.builder = new FlowBuilder(this, item);
    }
    FlowBuilder builder;
    int index;
    
    public N and() {
      return (N) JobFlowSpecFluent.this.setToFlows(index,builder.build());
    }
    
    public N endFlow() {
      return and();
    }
    
  
  }

}