package io.fabric8.volcano.api.model.batch.v1alpha1;

import io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpec;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class VolumeSpecFluent<A extends VolumeSpecFluent<A>> extends BaseFluent<A>{
  public VolumeSpecFluent() {
  }
  
  public VolumeSpecFluent(VolumeSpec instance) {
    this.copyInstance(instance);
  }
  private String mountPath;
  private PersistentVolumeClaimSpec volumeClaim;
  private String volumeClaimName;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(VolumeSpec instance) {
    instance = (instance != null ? instance : new VolumeSpec());
    if (instance != null) {
          this.withMountPath(instance.getMountPath());
          this.withVolumeClaim(instance.getVolumeClaim());
          this.withVolumeClaimName(instance.getVolumeClaimName());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getMountPath() {
    return this.mountPath;
  }
  
  public A withMountPath(String mountPath) {
    this.mountPath = mountPath;
    return (A) this;
  }
  
  public boolean hasMountPath() {
    return this.mountPath != null;
  }
  
  public PersistentVolumeClaimSpec getVolumeClaim() {
    return this.volumeClaim;
  }
  
  public A withVolumeClaim(PersistentVolumeClaimSpec volumeClaim) {
    this.volumeClaim = volumeClaim;
    return (A) this;
  }
  
  public boolean hasVolumeClaim() {
    return this.volumeClaim != null;
  }
  
  public String getVolumeClaimName() {
    return this.volumeClaimName;
  }
  
  public A withVolumeClaimName(String volumeClaimName) {
    this.volumeClaimName = volumeClaimName;
    return (A) this;
  }
  
  public boolean hasVolumeClaimName() {
    return this.volumeClaimName != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    VolumeSpecFluent that = (VolumeSpecFluent) o;
    if (!java.util.Objects.equals(mountPath, that.mountPath)) return false;
    if (!java.util.Objects.equals(volumeClaim, that.volumeClaim)) return false;
    if (!java.util.Objects.equals(volumeClaimName, that.volumeClaimName)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(mountPath,  volumeClaim,  volumeClaimName,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (mountPath != null) { sb.append("mountPath:"); sb.append(mountPath + ","); }
    if (volumeClaim != null) { sb.append("volumeClaim:"); sb.append(volumeClaim + ","); }
    if (volumeClaimName != null) { sb.append("volumeClaimName:"); sb.append(volumeClaimName + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}