package io.fabric8.volcano.api.model.batch.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;
import java.util.function.Predicate;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class DependsOnFluent<A extends DependsOnFluent<A>> extends BaseFluent<A>{
  public DependsOnFluent() {
  }
  
  public DependsOnFluent(DependsOn instance) {
    this.copyInstance(instance);
  }
  private String iteration;
  private List<String> name = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(DependsOn instance) {
    instance = (instance != null ? instance : new DependsOn());
    if (instance != null) {
          this.withIteration(instance.getIteration());
          this.withName(instance.getName());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getIteration() {
    return this.iteration;
  }
  
  public A withIteration(String iteration) {
    this.iteration = iteration;
    return (A) this;
  }
  
  public boolean hasIteration() {
    return this.iteration != null;
  }
  
  public A addToName(int index,String item) {
    if (this.name == null) {this.name = new ArrayList<String>();}
    this.name.add(index, item);
    return (A)this;
  }
  
  public A setToName(int index,String item) {
    if (this.name == null) {this.name = new ArrayList<String>();}
    this.name.set(index, item); return (A)this;
  }
  
  public A addToName(java.lang.String... items) {
    if (this.name == null) {this.name = new ArrayList<String>();}
    for (String item : items) {this.name.add(item);} return (A)this;
  }
  
  public A addAllToName(Collection<String> items) {
    if (this.name == null) {this.name = new ArrayList<String>();}
    for (String item : items) {this.name.add(item);} return (A)this;
  }
  
  public A removeFromName(java.lang.String... items) {
    if (this.name == null) return (A)this;
    for (String item : items) { this.name.remove(item);} return (A)this;
  }
  
  public A removeAllFromName(Collection<String> items) {
    if (this.name == null) return (A)this;
    for (String item : items) { this.name.remove(item);} return (A)this;
  }
  
  public List<String> getName() {
    return this.name;
  }
  
  public String getName(int index) {
    return this.name.get(index);
  }
  
  public String getFirstName() {
    return this.name.get(0);
  }
  
  public String getLastName() {
    return this.name.get(name.size() - 1);
  }
  
  public String getMatchingName(Predicate<String> predicate) {
      for (String item : name) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingName(Predicate<String> predicate) {
      for (String item : name) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withName(List<String> name) {
    if (name != null) {
        this.name = new ArrayList();
        for (String item : name) {
          this.addToName(item);
        }
    } else {
      this.name = null;
    }
    return (A) this;
  }
  
  public A withName(java.lang.String... name) {
    if (this.name != null) {
        this.name.clear();
        _visitables.remove("name");
    }
    if (name != null) {
      for (String item : name) {
        this.addToName(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null && !this.name.isEmpty();
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DependsOnFluent that = (DependsOnFluent) o;
    if (!java.util.Objects.equals(iteration, that.iteration)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(iteration,  name,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (iteration != null) { sb.append("iteration:"); sb.append(iteration + ","); }
    if (name != null && !name.isEmpty()) { sb.append("name:"); sb.append(name + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}