/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.volcano.api.model.scheduling.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.volcano.api.model.scheduling.v1beta1.Affinity;
import io.fabric8.volcano.api.model.scheduling.v1beta1.AffinityBuilder;
import io.fabric8.volcano.api.model.scheduling.v1beta1.AffinityFluent;
import io.fabric8.volcano.api.model.scheduling.v1beta1.Cluster;
import io.fabric8.volcano.api.model.scheduling.v1beta1.ClusterBuilder;
import io.fabric8.volcano.api.model.scheduling.v1beta1.ClusterFluent;
import io.fabric8.volcano.api.model.scheduling.v1beta1.Guarantee;
import io.fabric8.volcano.api.model.scheduling.v1beta1.GuaranteeBuilder;
import io.fabric8.volcano.api.model.scheduling.v1beta1.GuaranteeFluent;
import io.fabric8.volcano.api.model.scheduling.v1beta1.QueueSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class QueueSpecFluent<A extends QueueSpecFluent<A>>
extends BaseFluent<A> {
    private AffinityBuilder affinity;
    private Map<String, Quantity> capability;
    private Map<String, Quantity> deserved;
    private ArrayList<ClusterBuilder> extendClusters = new ArrayList();
    private GuaranteeBuilder guarantee;
    private String parent;
    private Integer priority;
    private Boolean reclaimable;
    private String type;
    private Integer weight;
    private Map<String, Object> additionalProperties;

    public QueueSpecFluent() {
    }

    public QueueSpecFluent(QueueSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(QueueSpec instance) {
        QueueSpec queueSpec = instance = instance != null ? instance : new QueueSpec();
        if (instance != null) {
            this.withAffinity(instance.getAffinity());
            this.withCapability(instance.getCapability());
            this.withDeserved(instance.getDeserved());
            this.withExtendClusters(instance.getExtendClusters());
            this.withGuarantee(instance.getGuarantee());
            this.withParent(instance.getParent());
            this.withPriority(instance.getPriority());
            this.withReclaimable(instance.getReclaimable());
            this.withType(instance.getType());
            this.withWeight(instance.getWeight());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Affinity buildAffinity() {
        return this.affinity != null ? this.affinity.build() : null;
    }

    public A withAffinity(Affinity affinity) {
        this._visitables.remove((Object)"affinity");
        if (affinity != null) {
            this.affinity = new AffinityBuilder(affinity);
            this._visitables.get((Object)"affinity").add(this.affinity);
        } else {
            this.affinity = null;
            this._visitables.get((Object)"affinity").remove((Object)this.affinity);
        }
        return (A)((Object)this);
    }

    public boolean hasAffinity() {
        return this.affinity != null;
    }

    public AffinityNested<A> withNewAffinity() {
        return new AffinityNested(null);
    }

    public AffinityNested<A> withNewAffinityLike(Affinity item) {
        return new AffinityNested(item);
    }

    public AffinityNested<A> editAffinity() {
        return this.withNewAffinityLike(Optional.ofNullable(this.buildAffinity()).orElse(null));
    }

    public AffinityNested<A> editOrNewAffinity() {
        return this.withNewAffinityLike(Optional.ofNullable(this.buildAffinity()).orElse(new AffinityBuilder().build()));
    }

    public AffinityNested<A> editOrNewAffinityLike(Affinity item) {
        return this.withNewAffinityLike(Optional.ofNullable(this.buildAffinity()).orElse(item));
    }

    public A addToCapability(String key, Quantity value) {
        if (this.capability == null && key != null && value != null) {
            this.capability = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.capability.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToCapability(Map<String, Quantity> map) {
        if (this.capability == null && map != null) {
            this.capability = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.capability.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromCapability(String key) {
        if (this.capability == null) {
            return (A)((Object)this);
        }
        if (key != null && this.capability != null) {
            this.capability.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromCapability(Map<String, Quantity> map) {
        if (this.capability == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.capability == null) continue;
                this.capability.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Quantity> getCapability() {
        return this.capability;
    }

    public <K, V> A withCapability(Map<String, Quantity> capability) {
        this.capability = capability == null ? null : new LinkedHashMap<String, Quantity>(capability);
        return (A)((Object)this);
    }

    public boolean hasCapability() {
        return this.capability != null;
    }

    public A addToDeserved(String key, Quantity value) {
        if (this.deserved == null && key != null && value != null) {
            this.deserved = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.deserved.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToDeserved(Map<String, Quantity> map) {
        if (this.deserved == null && map != null) {
            this.deserved = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.deserved.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromDeserved(String key) {
        if (this.deserved == null) {
            return (A)((Object)this);
        }
        if (key != null && this.deserved != null) {
            this.deserved.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromDeserved(Map<String, Quantity> map) {
        if (this.deserved == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.deserved == null) continue;
                this.deserved.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Quantity> getDeserved() {
        return this.deserved;
    }

    public <K, V> A withDeserved(Map<String, Quantity> deserved) {
        this.deserved = deserved == null ? null : new LinkedHashMap<String, Quantity>(deserved);
        return (A)((Object)this);
    }

    public boolean hasDeserved() {
        return this.deserved != null;
    }

    public A addToExtendClusters(int index, Cluster item) {
        if (this.extendClusters == null) {
            this.extendClusters = new ArrayList();
        }
        ClusterBuilder builder = new ClusterBuilder(item);
        if (index < 0 || index >= this.extendClusters.size()) {
            this._visitables.get((Object)"extendClusters").add(builder);
            this.extendClusters.add(builder);
        } else {
            this._visitables.get((Object)"extendClusters").add(index, builder);
            this.extendClusters.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToExtendClusters(int index, Cluster item) {
        if (this.extendClusters == null) {
            this.extendClusters = new ArrayList();
        }
        ClusterBuilder builder = new ClusterBuilder(item);
        if (index < 0 || index >= this.extendClusters.size()) {
            this._visitables.get((Object)"extendClusters").add(builder);
            this.extendClusters.add(builder);
        } else {
            this._visitables.get((Object)"extendClusters").set(index, builder);
            this.extendClusters.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToExtendClusters(Cluster ... items) {
        if (this.extendClusters == null) {
            this.extendClusters = new ArrayList();
        }
        for (Cluster item : items) {
            ClusterBuilder builder = new ClusterBuilder(item);
            this._visitables.get((Object)"extendClusters").add(builder);
            this.extendClusters.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToExtendClusters(Collection<Cluster> items) {
        if (this.extendClusters == null) {
            this.extendClusters = new ArrayList();
        }
        for (Cluster item : items) {
            ClusterBuilder builder = new ClusterBuilder(item);
            this._visitables.get((Object)"extendClusters").add(builder);
            this.extendClusters.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromExtendClusters(Cluster ... items) {
        if (this.extendClusters == null) {
            return (A)((Object)this);
        }
        for (Cluster item : items) {
            ClusterBuilder builder = new ClusterBuilder(item);
            this._visitables.get((Object)"extendClusters").remove((Object)builder);
            this.extendClusters.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromExtendClusters(Collection<Cluster> items) {
        if (this.extendClusters == null) {
            return (A)((Object)this);
        }
        for (Cluster item : items) {
            ClusterBuilder builder = new ClusterBuilder(item);
            this._visitables.get((Object)"extendClusters").remove((Object)builder);
            this.extendClusters.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromExtendClusters(Predicate<ClusterBuilder> predicate) {
        if (this.extendClusters == null) {
            return (A)((Object)this);
        }
        Iterator<ClusterBuilder> each = this.extendClusters.iterator();
        List visitables = this._visitables.get((Object)"extendClusters");
        while (each.hasNext()) {
            ClusterBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Cluster> buildExtendClusters() {
        return this.extendClusters != null ? QueueSpecFluent.build(this.extendClusters) : null;
    }

    public Cluster buildExtendCluster(int index) {
        return this.extendClusters.get(index).build();
    }

    public Cluster buildFirstExtendCluster() {
        return this.extendClusters.get(0).build();
    }

    public Cluster buildLastExtendCluster() {
        return this.extendClusters.get(this.extendClusters.size() - 1).build();
    }

    public Cluster buildMatchingExtendCluster(Predicate<ClusterBuilder> predicate) {
        for (ClusterBuilder item : this.extendClusters) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingExtendCluster(Predicate<ClusterBuilder> predicate) {
        for (ClusterBuilder item : this.extendClusters) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withExtendClusters(List<Cluster> extendClusters) {
        if (this.extendClusters != null) {
            this._visitables.get((Object)"extendClusters").clear();
        }
        if (extendClusters != null) {
            this.extendClusters = new ArrayList();
            for (Cluster item : extendClusters) {
                this.addToExtendClusters(item);
            }
        } else {
            this.extendClusters = null;
        }
        return (A)((Object)this);
    }

    public A withExtendClusters(Cluster ... extendClusters) {
        if (this.extendClusters != null) {
            this.extendClusters.clear();
            this._visitables.remove((Object)"extendClusters");
        }
        if (extendClusters != null) {
            for (Cluster item : extendClusters) {
                this.addToExtendClusters(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasExtendClusters() {
        return this.extendClusters != null && !this.extendClusters.isEmpty();
    }

    public ExtendClustersNested<A> addNewExtendCluster() {
        return new ExtendClustersNested(-1, null);
    }

    public ExtendClustersNested<A> addNewExtendClusterLike(Cluster item) {
        return new ExtendClustersNested(-1, item);
    }

    public ExtendClustersNested<A> setNewExtendClusterLike(int index, Cluster item) {
        return new ExtendClustersNested(index, item);
    }

    public ExtendClustersNested<A> editExtendCluster(int index) {
        if (this.extendClusters.size() <= index) {
            throw new RuntimeException("Can't edit extendClusters. Index exceeds size.");
        }
        return this.setNewExtendClusterLike(index, this.buildExtendCluster(index));
    }

    public ExtendClustersNested<A> editFirstExtendCluster() {
        if (this.extendClusters.size() == 0) {
            throw new RuntimeException("Can't edit first extendClusters. The list is empty.");
        }
        return this.setNewExtendClusterLike(0, this.buildExtendCluster(0));
    }

    public ExtendClustersNested<A> editLastExtendCluster() {
        int index = this.extendClusters.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last extendClusters. The list is empty.");
        }
        return this.setNewExtendClusterLike(index, this.buildExtendCluster(index));
    }

    public ExtendClustersNested<A> editMatchingExtendCluster(Predicate<ClusterBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.extendClusters.size(); ++i) {
            if (!predicate.test(this.extendClusters.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching extendClusters. No match found.");
        }
        return this.setNewExtendClusterLike(index, this.buildExtendCluster(index));
    }

    public Guarantee buildGuarantee() {
        return this.guarantee != null ? this.guarantee.build() : null;
    }

    public A withGuarantee(Guarantee guarantee) {
        this._visitables.remove((Object)"guarantee");
        if (guarantee != null) {
            this.guarantee = new GuaranteeBuilder(guarantee);
            this._visitables.get((Object)"guarantee").add(this.guarantee);
        } else {
            this.guarantee = null;
            this._visitables.get((Object)"guarantee").remove((Object)this.guarantee);
        }
        return (A)((Object)this);
    }

    public boolean hasGuarantee() {
        return this.guarantee != null;
    }

    public GuaranteeNested<A> withNewGuarantee() {
        return new GuaranteeNested(null);
    }

    public GuaranteeNested<A> withNewGuaranteeLike(Guarantee item) {
        return new GuaranteeNested(item);
    }

    public GuaranteeNested<A> editGuarantee() {
        return this.withNewGuaranteeLike(Optional.ofNullable(this.buildGuarantee()).orElse(null));
    }

    public GuaranteeNested<A> editOrNewGuarantee() {
        return this.withNewGuaranteeLike(Optional.ofNullable(this.buildGuarantee()).orElse(new GuaranteeBuilder().build()));
    }

    public GuaranteeNested<A> editOrNewGuaranteeLike(Guarantee item) {
        return this.withNewGuaranteeLike(Optional.ofNullable(this.buildGuarantee()).orElse(item));
    }

    public String getParent() {
        return this.parent;
    }

    public A withParent(String parent) {
        this.parent = parent;
        return (A)((Object)this);
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public A withPriority(Integer priority) {
        this.priority = priority;
        return (A)((Object)this);
    }

    public boolean hasPriority() {
        return this.priority != null;
    }

    public Boolean getReclaimable() {
        return this.reclaimable;
    }

    public A withReclaimable(Boolean reclaimable) {
        this.reclaimable = reclaimable;
        return (A)((Object)this);
    }

    public boolean hasReclaimable() {
        return this.reclaimable != null;
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type = type;
        return (A)((Object)this);
    }

    public boolean hasType() {
        return this.type != null;
    }

    public Integer getWeight() {
        return this.weight;
    }

    public A withWeight(Integer weight) {
        this.weight = weight;
        return (A)((Object)this);
    }

    public boolean hasWeight() {
        return this.weight != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        QueueSpecFluent that = (QueueSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.affinity, (Object)that.affinity)) {
            return false;
        }
        if (!Objects.equals(this.capability, that.capability)) {
            return false;
        }
        if (!Objects.equals(this.deserved, that.deserved)) {
            return false;
        }
        if (!Objects.equals(this.extendClusters, that.extendClusters)) {
            return false;
        }
        if (!Objects.equals((Object)this.guarantee, (Object)that.guarantee)) {
            return false;
        }
        if (!Objects.equals(this.parent, that.parent)) {
            return false;
        }
        if (!Objects.equals(this.priority, that.priority)) {
            return false;
        }
        if (!Objects.equals(this.reclaimable, that.reclaimable)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        if (!Objects.equals(this.weight, that.weight)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.affinity, this.capability, this.deserved, this.extendClusters, this.guarantee, this.parent, this.priority, this.reclaimable, this.type, this.weight, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.affinity != null) {
            sb.append("affinity:");
            sb.append(this.affinity + ",");
        }
        if (this.capability != null && !this.capability.isEmpty()) {
            sb.append("capability:");
            sb.append(this.capability + ",");
        }
        if (this.deserved != null && !this.deserved.isEmpty()) {
            sb.append("deserved:");
            sb.append(this.deserved + ",");
        }
        if (this.extendClusters != null && !this.extendClusters.isEmpty()) {
            sb.append("extendClusters:");
            sb.append(this.extendClusters + ",");
        }
        if (this.guarantee != null) {
            sb.append("guarantee:");
            sb.append(this.guarantee + ",");
        }
        if (this.parent != null) {
            sb.append("parent:");
            sb.append(this.parent + ",");
        }
        if (this.priority != null) {
            sb.append("priority:");
            sb.append(this.priority + ",");
        }
        if (this.reclaimable != null) {
            sb.append("reclaimable:");
            sb.append(this.reclaimable + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type + ",");
        }
        if (this.weight != null) {
            sb.append("weight:");
            sb.append(this.weight + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withReclaimable() {
        return this.withReclaimable(true);
    }

    public class GuaranteeNested<N>
    extends GuaranteeFluent<GuaranteeNested<N>>
    implements Nested<N> {
        GuaranteeBuilder builder;

        GuaranteeNested(Guarantee item) {
            this.builder = new GuaranteeBuilder(this, item);
        }

        public N and() {
            return (N)QueueSpecFluent.this.withGuarantee(this.builder.build());
        }

        public N endGuarantee() {
            return this.and();
        }
    }

    public class ExtendClustersNested<N>
    extends ClusterFluent<ExtendClustersNested<N>>
    implements Nested<N> {
        ClusterBuilder builder;
        int index;

        ExtendClustersNested(int index, Cluster item) {
            this.index = index;
            this.builder = new ClusterBuilder(this, item);
        }

        public N and() {
            return (N)QueueSpecFluent.this.setToExtendClusters(this.index, this.builder.build());
        }

        public N endExtendCluster() {
            return this.and();
        }
    }

    public class AffinityNested<N>
    extends AffinityFluent<AffinityNested<N>>
    implements Nested<N> {
        AffinityBuilder builder;

        AffinityNested(Affinity item) {
            this.builder = new AffinityBuilder(this, item);
        }

        public N and() {
            return (N)QueueSpecFluent.this.withAffinity(this.builder.build());
        }

        public N endAffinity() {
            return this.and();
        }
    }
}

