/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.volcano.api.model.batch.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.Duration;
import io.fabric8.volcano.api.model.batch.v1alpha1.LifecyclePolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class LifecyclePolicyFluent<A extends LifecyclePolicyFluent<A>>
extends BaseFluent<A> {
    private String action;
    private String event;
    private List<String> events = new ArrayList<String>();
    private Integer exitCode;
    private Duration timeout;
    private Map<String, Object> additionalProperties;

    public LifecyclePolicyFluent() {
    }

    public LifecyclePolicyFluent(LifecyclePolicy instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(LifecyclePolicy instance) {
        LifecyclePolicy lifecyclePolicy = instance = instance != null ? instance : new LifecyclePolicy();
        if (instance != null) {
            this.withAction(instance.getAction());
            this.withEvent(instance.getEvent());
            this.withEvents(instance.getEvents());
            this.withExitCode(instance.getExitCode());
            this.withTimeout(instance.getTimeout());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getAction() {
        return this.action;
    }

    public A withAction(String action) {
        this.action = action;
        return (A)((Object)this);
    }

    public boolean hasAction() {
        return this.action != null;
    }

    public String getEvent() {
        return this.event;
    }

    public A withEvent(String event) {
        this.event = event;
        return (A)((Object)this);
    }

    public boolean hasEvent() {
        return this.event != null;
    }

    public A addToEvents(int index, String item) {
        if (this.events == null) {
            this.events = new ArrayList<String>();
        }
        this.events.add(index, item);
        return (A)((Object)this);
    }

    public A setToEvents(int index, String item) {
        if (this.events == null) {
            this.events = new ArrayList<String>();
        }
        this.events.set(index, item);
        return (A)((Object)this);
    }

    public A addToEvents(String ... items) {
        if (this.events == null) {
            this.events = new ArrayList<String>();
        }
        for (String item : items) {
            this.events.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToEvents(Collection<String> items) {
        if (this.events == null) {
            this.events = new ArrayList<String>();
        }
        for (String item : items) {
            this.events.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromEvents(String ... items) {
        if (this.events == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.events.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromEvents(Collection<String> items) {
        if (this.events == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.events.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getEvents() {
        return this.events;
    }

    public String getEvent(int index) {
        return this.events.get(index);
    }

    public String getFirstEvent() {
        return this.events.get(0);
    }

    public String getLastEvent() {
        return this.events.get(this.events.size() - 1);
    }

    public String getMatchingEvent(Predicate<String> predicate) {
        for (String item : this.events) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingEvent(Predicate<String> predicate) {
        for (String item : this.events) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEvents(List<String> events) {
        if (events != null) {
            this.events = new ArrayList<String>();
            for (String item : events) {
                this.addToEvents(item);
            }
        } else {
            this.events = null;
        }
        return (A)((Object)this);
    }

    public A withEvents(String ... events) {
        if (this.events != null) {
            this.events.clear();
            this._visitables.remove((Object)"events");
        }
        if (events != null) {
            for (String item : events) {
                this.addToEvents(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasEvents() {
        return this.events != null && !this.events.isEmpty();
    }

    public Integer getExitCode() {
        return this.exitCode;
    }

    public A withExitCode(Integer exitCode) {
        this.exitCode = exitCode;
        return (A)((Object)this);
    }

    public boolean hasExitCode() {
        return this.exitCode != null;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public A withTimeout(Duration timeout) {
        this.timeout = timeout;
        return (A)((Object)this);
    }

    public boolean hasTimeout() {
        return this.timeout != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LifecyclePolicyFluent that = (LifecyclePolicyFluent)((Object)o);
        if (!Objects.equals(this.action, that.action)) {
            return false;
        }
        if (!Objects.equals(this.event, that.event)) {
            return false;
        }
        if (!Objects.equals(this.events, that.events)) {
            return false;
        }
        if (!Objects.equals(this.exitCode, that.exitCode)) {
            return false;
        }
        if (!Objects.equals(this.timeout, that.timeout)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.action, this.event, this.events, this.exitCode, this.timeout, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.action != null) {
            sb.append("action:");
            sb.append(this.action + ",");
        }
        if (this.event != null) {
            sb.append("event:");
            sb.append(this.event + ",");
        }
        if (this.events != null && !this.events.isEmpty()) {
            sb.append("events:");
            sb.append(this.events + ",");
        }
        if (this.exitCode != null) {
            sb.append("exitCode:");
            sb.append(this.exitCode + ",");
        }
        if (this.timeout != null) {
            sb.append("timeout:");
            sb.append(this.timeout + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

