/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.activemq.facade;

import io.fabric8.activemq.facade.RemoteBrokerFacade;
import java.io.IOException;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXConnectorBrokerFacade
extends RemoteBrokerFacade {
    private static final transient Logger LOG = LoggerFactory.getLogger(JMXConnectorBrokerFacade.class);
    private final JMXConnector connector;
    private MBeanServerConnection mbeanServerConnection;

    public JMXConnectorBrokerFacade(JMXConnector connector) {
        super((MBeanServerConnection)null);
        this.connector = connector;
    }

    public JMXConnector getConnector() {
        return this.connector;
    }

    @Override
    protected MBeanServerConnection getMBeanServerConnection() throws Exception {
        if (this.mbeanServerConnection == null) {
            this.mbeanServerConnection = this.connector.getMBeanServerConnection();
        }
        return this.mbeanServerConnection;
    }

    public synchronized void closeConnection() {
        if (this.connector != null) {
            try {
                LOG.debug("Closing a connection to a broker (" + this.connector.getConnectionId() + ")");
                this.connector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

