/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ContainerStateRunning;
import io.fabric8.kubernetes.api.model.ContainerStateTerminated;
import io.fabric8.kubernetes.api.model.ContainerStateWaiting;
import io.fabric8.tekton.v1beta1.Artifact;
import io.fabric8.tekton.v1beta1.ArtifactBuilder;
import io.fabric8.tekton.v1beta1.ArtifactFluent;
import io.fabric8.tekton.v1beta1.Provenance;
import io.fabric8.tekton.v1beta1.ProvenanceBuilder;
import io.fabric8.tekton.v1beta1.ProvenanceFluent;
import io.fabric8.tekton.v1beta1.StepState;
import io.fabric8.tekton.v1beta1.TaskRunResult;
import io.fabric8.tekton.v1beta1.TaskRunResultBuilder;
import io.fabric8.tekton.v1beta1.TaskRunResultFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class StepStateFluent<A extends StepStateFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String container;
    private String imageID;
    private ArrayList<ArtifactBuilder> inputs = new ArrayList();
    private String name;
    private ArrayList<ArtifactBuilder> outputs = new ArrayList();
    private ProvenanceBuilder provenance;
    private ArrayList<TaskRunResultBuilder> results = new ArrayList();
    private ContainerStateRunning running;
    private ContainerStateTerminated terminated;
    private ContainerStateWaiting waiting;

    public StepStateFluent() {
    }

    public StepStateFluent(StepState instance) {
        this.copyInstance(instance);
    }

    public A addAllToInputs(Collection<Artifact> items) {
        if (this.inputs == null) {
            this.inputs = new ArrayList();
        }
        for (Artifact item : items) {
            ArtifactBuilder builder = new ArtifactBuilder(item);
            this._visitables.get((Object)"inputs").add(builder);
            this.inputs.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToOutputs(Collection<Artifact> items) {
        if (this.outputs == null) {
            this.outputs = new ArrayList();
        }
        for (Artifact item : items) {
            ArtifactBuilder builder = new ArtifactBuilder(item);
            this._visitables.get((Object)"outputs").add(builder);
            this.outputs.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToResults(Collection<TaskRunResult> items) {
        if (this.results == null) {
            this.results = new ArrayList();
        }
        for (TaskRunResult item : items) {
            TaskRunResultBuilder builder = new TaskRunResultBuilder(item);
            this._visitables.get((Object)"results").add(builder);
            this.results.add(builder);
        }
        return (A)((Object)this);
    }

    public InputsNested<A> addNewInput() {
        return new InputsNested(-1, null);
    }

    public InputsNested<A> addNewInputLike(Artifact item) {
        return new InputsNested(-1, item);
    }

    public OutputsNested<A> addNewOutput() {
        return new OutputsNested(-1, null);
    }

    public OutputsNested<A> addNewOutputLike(Artifact item) {
        return new OutputsNested(-1, item);
    }

    public ResultsNested<A> addNewResult() {
        return new ResultsNested(-1, null);
    }

    public ResultsNested<A> addNewResultLike(TaskRunResult item) {
        return new ResultsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToInputs(Artifact ... items) {
        if (this.inputs == null) {
            this.inputs = new ArrayList();
        }
        for (Artifact item : items) {
            ArtifactBuilder builder = new ArtifactBuilder(item);
            this._visitables.get((Object)"inputs").add(builder);
            this.inputs.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToInputs(int index, Artifact item) {
        if (this.inputs == null) {
            this.inputs = new ArrayList();
        }
        ArtifactBuilder builder = new ArtifactBuilder(item);
        if (index < 0 || index >= this.inputs.size()) {
            this._visitables.get((Object)"inputs").add(builder);
            this.inputs.add(builder);
        } else {
            this._visitables.get((Object)"inputs").add(builder);
            this.inputs.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToOutputs(Artifact ... items) {
        if (this.outputs == null) {
            this.outputs = new ArrayList();
        }
        for (Artifact item : items) {
            ArtifactBuilder builder = new ArtifactBuilder(item);
            this._visitables.get((Object)"outputs").add(builder);
            this.outputs.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToOutputs(int index, Artifact item) {
        if (this.outputs == null) {
            this.outputs = new ArrayList();
        }
        ArtifactBuilder builder = new ArtifactBuilder(item);
        if (index < 0 || index >= this.outputs.size()) {
            this._visitables.get((Object)"outputs").add(builder);
            this.outputs.add(builder);
        } else {
            this._visitables.get((Object)"outputs").add(builder);
            this.outputs.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToResults(TaskRunResult ... items) {
        if (this.results == null) {
            this.results = new ArrayList();
        }
        for (TaskRunResult item : items) {
            TaskRunResultBuilder builder = new TaskRunResultBuilder(item);
            this._visitables.get((Object)"results").add(builder);
            this.results.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToResults(int index, TaskRunResult item) {
        if (this.results == null) {
            this.results = new ArrayList();
        }
        TaskRunResultBuilder builder = new TaskRunResultBuilder(item);
        if (index < 0 || index >= this.results.size()) {
            this._visitables.get((Object)"results").add(builder);
            this.results.add(builder);
        } else {
            this._visitables.get((Object)"results").add(builder);
            this.results.add(index, builder);
        }
        return (A)((Object)this);
    }

    public Artifact buildFirstInput() {
        return this.inputs.get(0).build();
    }

    public Artifact buildFirstOutput() {
        return this.outputs.get(0).build();
    }

    public TaskRunResult buildFirstResult() {
        return this.results.get(0).build();
    }

    public Artifact buildInput(int index) {
        return this.inputs.get(index).build();
    }

    public List<Artifact> buildInputs() {
        return this.inputs != null ? StepStateFluent.build(this.inputs) : null;
    }

    public Artifact buildLastInput() {
        return this.inputs.get(this.inputs.size() - 1).build();
    }

    public Artifact buildLastOutput() {
        return this.outputs.get(this.outputs.size() - 1).build();
    }

    public TaskRunResult buildLastResult() {
        return this.results.get(this.results.size() - 1).build();
    }

    public Artifact buildMatchingInput(Predicate<ArtifactBuilder> predicate) {
        for (ArtifactBuilder item : this.inputs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public Artifact buildMatchingOutput(Predicate<ArtifactBuilder> predicate) {
        for (ArtifactBuilder item : this.outputs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public TaskRunResult buildMatchingResult(Predicate<TaskRunResultBuilder> predicate) {
        for (TaskRunResultBuilder item : this.results) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public Artifact buildOutput(int index) {
        return this.outputs.get(index).build();
    }

    public List<Artifact> buildOutputs() {
        return this.outputs != null ? StepStateFluent.build(this.outputs) : null;
    }

    public Provenance buildProvenance() {
        return this.provenance != null ? this.provenance.build() : null;
    }

    public TaskRunResult buildResult(int index) {
        return this.results.get(index).build();
    }

    public List<TaskRunResult> buildResults() {
        return this.results != null ? StepStateFluent.build(this.results) : null;
    }

    protected void copyInstance(StepState instance) {
        StepState stepState = instance = instance != null ? instance : new StepState();
        if (instance != null) {
            this.withContainer(instance.getContainer());
            this.withImageID(instance.getImageID());
            this.withInputs(instance.getInputs());
            this.withName(instance.getName());
            this.withOutputs(instance.getOutputs());
            this.withProvenance(instance.getProvenance());
            this.withResults(instance.getResults());
            this.withRunning(instance.getRunning());
            this.withTerminated(instance.getTerminated());
            this.withWaiting(instance.getWaiting());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public InputsNested<A> editFirstInput() {
        if (this.inputs.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "inputs"));
        }
        return this.setNewInputLike(0, this.buildInput(0));
    }

    public OutputsNested<A> editFirstOutput() {
        if (this.outputs.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "outputs"));
        }
        return this.setNewOutputLike(0, this.buildOutput(0));
    }

    public ResultsNested<A> editFirstResult() {
        if (this.results.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "results"));
        }
        return this.setNewResultLike(0, this.buildResult(0));
    }

    public InputsNested<A> editInput(int index) {
        if (this.inputs.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "inputs"));
        }
        return this.setNewInputLike(index, this.buildInput(index));
    }

    public InputsNested<A> editLastInput() {
        int index = this.inputs.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "inputs"));
        }
        return this.setNewInputLike(index, this.buildInput(index));
    }

    public OutputsNested<A> editLastOutput() {
        int index = this.outputs.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "outputs"));
        }
        return this.setNewOutputLike(index, this.buildOutput(index));
    }

    public ResultsNested<A> editLastResult() {
        int index = this.results.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "results"));
        }
        return this.setNewResultLike(index, this.buildResult(index));
    }

    public InputsNested<A> editMatchingInput(Predicate<ArtifactBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.inputs.size(); ++i) {
            if (!predicate.test(this.inputs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "inputs"));
        }
        return this.setNewInputLike(index, this.buildInput(index));
    }

    public OutputsNested<A> editMatchingOutput(Predicate<ArtifactBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.outputs.size(); ++i) {
            if (!predicate.test(this.outputs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "outputs"));
        }
        return this.setNewOutputLike(index, this.buildOutput(index));
    }

    public ResultsNested<A> editMatchingResult(Predicate<TaskRunResultBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.results.size(); ++i) {
            if (!predicate.test(this.results.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "results"));
        }
        return this.setNewResultLike(index, this.buildResult(index));
    }

    public ProvenanceNested<A> editOrNewProvenance() {
        return this.withNewProvenanceLike(Optional.ofNullable(this.buildProvenance()).orElse(new ProvenanceBuilder().build()));
    }

    public ProvenanceNested<A> editOrNewProvenanceLike(Provenance item) {
        return this.withNewProvenanceLike(Optional.ofNullable(this.buildProvenance()).orElse(item));
    }

    public OutputsNested<A> editOutput(int index) {
        if (this.outputs.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "outputs"));
        }
        return this.setNewOutputLike(index, this.buildOutput(index));
    }

    public ProvenanceNested<A> editProvenance() {
        return this.withNewProvenanceLike(Optional.ofNullable(this.buildProvenance()).orElse(null));
    }

    public ResultsNested<A> editResult(int index) {
        if (this.results.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "results"));
        }
        return this.setNewResultLike(index, this.buildResult(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StepStateFluent that = (StepStateFluent)((Object)o);
        if (!Objects.equals(this.container, that.container)) {
            return false;
        }
        if (!Objects.equals(this.imageID, that.imageID)) {
            return false;
        }
        if (!Objects.equals(this.inputs, that.inputs)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.outputs, that.outputs)) {
            return false;
        }
        if (!Objects.equals((Object)this.provenance, (Object)that.provenance)) {
            return false;
        }
        if (!Objects.equals(this.results, that.results)) {
            return false;
        }
        if (!Objects.equals(this.running, that.running)) {
            return false;
        }
        if (!Objects.equals(this.terminated, that.terminated)) {
            return false;
        }
        if (!Objects.equals(this.waiting, that.waiting)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getContainer() {
        return this.container;
    }

    public String getImageID() {
        return this.imageID;
    }

    public String getName() {
        return this.name;
    }

    public ContainerStateRunning getRunning() {
        return this.running;
    }

    public ContainerStateTerminated getTerminated() {
        return this.terminated;
    }

    public ContainerStateWaiting getWaiting() {
        return this.waiting;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasContainer() {
        return this.container != null;
    }

    public boolean hasImageID() {
        return this.imageID != null;
    }

    public boolean hasInputs() {
        return this.inputs != null && !this.inputs.isEmpty();
    }

    public boolean hasMatchingInput(Predicate<ArtifactBuilder> predicate) {
        for (ArtifactBuilder item : this.inputs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingOutput(Predicate<ArtifactBuilder> predicate) {
        for (ArtifactBuilder item : this.outputs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingResult(Predicate<TaskRunResultBuilder> predicate) {
        for (TaskRunResultBuilder item : this.results) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean hasOutputs() {
        return this.outputs != null && !this.outputs.isEmpty();
    }

    public boolean hasProvenance() {
        return this.provenance != null;
    }

    public boolean hasResults() {
        return this.results != null && !this.results.isEmpty();
    }

    public boolean hasRunning() {
        return this.running != null;
    }

    public boolean hasTerminated() {
        return this.terminated != null;
    }

    public boolean hasWaiting() {
        return this.waiting != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.container, this.imageID, this.inputs, this.name, this.outputs, this.provenance, this.results, this.running, this.terminated, this.waiting, this.additionalProperties});
    }

    public A removeAllFromInputs(Collection<Artifact> items) {
        if (this.inputs == null) {
            return (A)((Object)this);
        }
        for (Artifact item : items) {
            ArtifactBuilder builder = new ArtifactBuilder(item);
            this._visitables.get((Object)"inputs").remove((Object)builder);
            this.inputs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromOutputs(Collection<Artifact> items) {
        if (this.outputs == null) {
            return (A)((Object)this);
        }
        for (Artifact item : items) {
            ArtifactBuilder builder = new ArtifactBuilder(item);
            this._visitables.get((Object)"outputs").remove((Object)builder);
            this.outputs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromResults(Collection<TaskRunResult> items) {
        if (this.results == null) {
            return (A)((Object)this);
        }
        for (TaskRunResult item : items) {
            TaskRunResultBuilder builder = new TaskRunResultBuilder(item);
            this._visitables.get((Object)"results").remove((Object)builder);
            this.results.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromInputs(Artifact ... items) {
        if (this.inputs == null) {
            return (A)((Object)this);
        }
        for (Artifact item : items) {
            ArtifactBuilder builder = new ArtifactBuilder(item);
            this._visitables.get((Object)"inputs").remove((Object)builder);
            this.inputs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromOutputs(Artifact ... items) {
        if (this.outputs == null) {
            return (A)((Object)this);
        }
        for (Artifact item : items) {
            ArtifactBuilder builder = new ArtifactBuilder(item);
            this._visitables.get((Object)"outputs").remove((Object)builder);
            this.outputs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromResults(TaskRunResult ... items) {
        if (this.results == null) {
            return (A)((Object)this);
        }
        for (TaskRunResult item : items) {
            TaskRunResultBuilder builder = new TaskRunResultBuilder(item);
            this._visitables.get((Object)"results").remove((Object)builder);
            this.results.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromInputs(Predicate<ArtifactBuilder> predicate) {
        if (this.inputs == null) {
            return (A)((Object)this);
        }
        Iterator<ArtifactBuilder> each = this.inputs.iterator();
        List visitables = this._visitables.get((Object)"inputs");
        while (each.hasNext()) {
            ArtifactBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromOutputs(Predicate<ArtifactBuilder> predicate) {
        if (this.outputs == null) {
            return (A)((Object)this);
        }
        Iterator<ArtifactBuilder> each = this.outputs.iterator();
        List visitables = this._visitables.get((Object)"outputs");
        while (each.hasNext()) {
            ArtifactBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromResults(Predicate<TaskRunResultBuilder> predicate) {
        if (this.results == null) {
            return (A)((Object)this);
        }
        Iterator<TaskRunResultBuilder> each = this.results.iterator();
        List visitables = this._visitables.get((Object)"results");
        while (each.hasNext()) {
            TaskRunResultBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public InputsNested<A> setNewInputLike(int index, Artifact item) {
        return new InputsNested(index, item);
    }

    public OutputsNested<A> setNewOutputLike(int index, Artifact item) {
        return new OutputsNested(index, item);
    }

    public ResultsNested<A> setNewResultLike(int index, TaskRunResult item) {
        return new ResultsNested(index, item);
    }

    public A setToInputs(int index, Artifact item) {
        if (this.inputs == null) {
            this.inputs = new ArrayList();
        }
        ArtifactBuilder builder = new ArtifactBuilder(item);
        if (index < 0 || index >= this.inputs.size()) {
            this._visitables.get((Object)"inputs").add(builder);
            this.inputs.add(builder);
        } else {
            this._visitables.get((Object)"inputs").add(builder);
            this.inputs.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToOutputs(int index, Artifact item) {
        if (this.outputs == null) {
            this.outputs = new ArrayList();
        }
        ArtifactBuilder builder = new ArtifactBuilder(item);
        if (index < 0 || index >= this.outputs.size()) {
            this._visitables.get((Object)"outputs").add(builder);
            this.outputs.add(builder);
        } else {
            this._visitables.get((Object)"outputs").add(builder);
            this.outputs.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToResults(int index, TaskRunResult item) {
        if (this.results == null) {
            this.results = new ArrayList();
        }
        TaskRunResultBuilder builder = new TaskRunResultBuilder(item);
        if (index < 0 || index >= this.results.size()) {
            this._visitables.get((Object)"results").add(builder);
            this.results.add(builder);
        } else {
            this._visitables.get((Object)"results").add(builder);
            this.results.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.container != null) {
            sb.append("container:");
            sb.append(this.container);
            sb.append(",");
        }
        if (this.imageID != null) {
            sb.append("imageID:");
            sb.append(this.imageID);
            sb.append(",");
        }
        if (this.inputs != null && !this.inputs.isEmpty()) {
            sb.append("inputs:");
            sb.append(this.inputs);
            sb.append(",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name);
            sb.append(",");
        }
        if (this.outputs != null && !this.outputs.isEmpty()) {
            sb.append("outputs:");
            sb.append(this.outputs);
            sb.append(",");
        }
        if (this.provenance != null) {
            sb.append("provenance:");
            sb.append((Object)this.provenance);
            sb.append(",");
        }
        if (this.results != null && !this.results.isEmpty()) {
            sb.append("results:");
            sb.append(this.results);
            sb.append(",");
        }
        if (this.running != null) {
            sb.append("running:");
            sb.append(this.running);
            sb.append(",");
        }
        if (this.terminated != null) {
            sb.append("terminated:");
            sb.append(this.terminated);
            sb.append(",");
        }
        if (this.waiting != null) {
            sb.append("waiting:");
            sb.append(this.waiting);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withContainer(String container) {
        this.container = container;
        return (A)((Object)this);
    }

    public A withImageID(String imageID) {
        this.imageID = imageID;
        return (A)((Object)this);
    }

    public A withInputs(List<Artifact> inputs) {
        if (this.inputs != null) {
            this._visitables.get((Object)"inputs").clear();
        }
        if (inputs != null) {
            this.inputs = new ArrayList();
            for (Artifact item : inputs) {
                this.addToInputs(item);
            }
        } else {
            this.inputs = null;
        }
        return (A)((Object)this);
    }

    public A withInputs(Artifact ... inputs) {
        if (this.inputs != null) {
            this.inputs.clear();
            this._visitables.remove((Object)"inputs");
        }
        if (inputs != null) {
            for (Artifact item : inputs) {
                this.addToInputs(item);
            }
        }
        return (A)((Object)this);
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public ProvenanceNested<A> withNewProvenance() {
        return new ProvenanceNested(null);
    }

    public ProvenanceNested<A> withNewProvenanceLike(Provenance item) {
        return new ProvenanceNested(item);
    }

    public A withNewRunning(String startedAt) {
        return this.withRunning(new ContainerStateRunning(startedAt));
    }

    public A withNewWaiting(String message, String reason) {
        return this.withWaiting(new ContainerStateWaiting(message, reason));
    }

    public A withOutputs(List<Artifact> outputs) {
        if (this.outputs != null) {
            this._visitables.get((Object)"outputs").clear();
        }
        if (outputs != null) {
            this.outputs = new ArrayList();
            for (Artifact item : outputs) {
                this.addToOutputs(item);
            }
        } else {
            this.outputs = null;
        }
        return (A)((Object)this);
    }

    public A withOutputs(Artifact ... outputs) {
        if (this.outputs != null) {
            this.outputs.clear();
            this._visitables.remove((Object)"outputs");
        }
        if (outputs != null) {
            for (Artifact item : outputs) {
                this.addToOutputs(item);
            }
        }
        return (A)((Object)this);
    }

    public A withProvenance(Provenance provenance) {
        this._visitables.remove((Object)"provenance");
        if (provenance != null) {
            this.provenance = new ProvenanceBuilder(provenance);
            this._visitables.get((Object)"provenance").add(this.provenance);
        } else {
            this.provenance = null;
            this._visitables.get((Object)"provenance").remove((Object)this.provenance);
        }
        return (A)((Object)this);
    }

    public A withResults(List<TaskRunResult> results) {
        if (this.results != null) {
            this._visitables.get((Object)"results").clear();
        }
        if (results != null) {
            this.results = new ArrayList();
            for (TaskRunResult item : results) {
                this.addToResults(item);
            }
        } else {
            this.results = null;
        }
        return (A)((Object)this);
    }

    public A withResults(TaskRunResult ... results) {
        if (this.results != null) {
            this.results.clear();
            this._visitables.remove((Object)"results");
        }
        if (results != null) {
            for (TaskRunResult item : results) {
                this.addToResults(item);
            }
        }
        return (A)((Object)this);
    }

    public A withRunning(ContainerStateRunning running) {
        this.running = running;
        return (A)((Object)this);
    }

    public A withTerminated(ContainerStateTerminated terminated) {
        this.terminated = terminated;
        return (A)((Object)this);
    }

    public A withWaiting(ContainerStateWaiting waiting) {
        this.waiting = waiting;
        return (A)((Object)this);
    }

    public class ResultsNested<N>
    extends TaskRunResultFluent<ResultsNested<N>>
    implements Nested<N> {
        TaskRunResultBuilder builder;
        int index;

        ResultsNested(int index, TaskRunResult item) {
            this.index = index;
            this.builder = new TaskRunResultBuilder(this, item);
        }

        public N and() {
            return (N)StepStateFluent.this.setToResults(this.index, this.builder.build());
        }

        public N endResult() {
            return this.and();
        }
    }

    public class ProvenanceNested<N>
    extends ProvenanceFluent<ProvenanceNested<N>>
    implements Nested<N> {
        ProvenanceBuilder builder;

        ProvenanceNested(Provenance item) {
            this.builder = new ProvenanceBuilder(this, item);
        }

        public N and() {
            return (N)StepStateFluent.this.withProvenance(this.builder.build());
        }

        public N endProvenance() {
            return this.and();
        }
    }

    public class OutputsNested<N>
    extends ArtifactFluent<OutputsNested<N>>
    implements Nested<N> {
        ArtifactBuilder builder;
        int index;

        OutputsNested(int index, Artifact item) {
            this.index = index;
            this.builder = new ArtifactBuilder(this, item);
        }

        public N and() {
            return (N)StepStateFluent.this.setToOutputs(this.index, this.builder.build());
        }

        public N endOutput() {
            return this.and();
        }
    }

    public class InputsNested<N>
    extends ArtifactFluent<InputsNested<N>>
    implements Nested<N> {
        ArtifactBuilder builder;
        int index;

        InputsNested(int index, Artifact item) {
            this.index = index;
            this.builder = new ArtifactBuilder(this, item);
        }

        public N and() {
            return (N)StepStateFluent.this.setToInputs(this.index, this.builder.build());
        }

        public N endInput() {
            return this.and();
        }
    }
}

