/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.tekton.pod.Template;
import io.fabric8.tekton.pod.TemplateBuilder;
import io.fabric8.tekton.pod.TemplateFluent;
import io.fabric8.tekton.v1beta1.PipelineTaskMetadata;
import io.fabric8.tekton.v1beta1.PipelineTaskMetadataBuilder;
import io.fabric8.tekton.v1beta1.PipelineTaskMetadataFluent;
import io.fabric8.tekton.v1beta1.PipelineTaskRunSpec;
import io.fabric8.tekton.v1beta1.TaskRunSidecarOverride;
import io.fabric8.tekton.v1beta1.TaskRunSidecarOverrideBuilder;
import io.fabric8.tekton.v1beta1.TaskRunSidecarOverrideFluent;
import io.fabric8.tekton.v1beta1.TaskRunStepOverride;
import io.fabric8.tekton.v1beta1.TaskRunStepOverrideBuilder;
import io.fabric8.tekton.v1beta1.TaskRunStepOverrideFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class PipelineTaskRunSpecFluent<A extends PipelineTaskRunSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ResourceRequirementsBuilder computeResources;
    private PipelineTaskMetadataBuilder metadata;
    private String pipelineTaskName;
    private ArrayList<TaskRunSidecarOverrideBuilder> sidecarOverrides = new ArrayList();
    private ArrayList<TaskRunStepOverrideBuilder> stepOverrides = new ArrayList();
    private TemplateBuilder taskPodTemplate;
    private String taskServiceAccountName;

    public PipelineTaskRunSpecFluent() {
    }

    public PipelineTaskRunSpecFluent(PipelineTaskRunSpec instance) {
        this.copyInstance(instance);
    }

    public A addAllToSidecarOverrides(Collection<TaskRunSidecarOverride> items) {
        if (this.sidecarOverrides == null) {
            this.sidecarOverrides = new ArrayList();
        }
        for (TaskRunSidecarOverride item : items) {
            TaskRunSidecarOverrideBuilder builder = new TaskRunSidecarOverrideBuilder(item);
            this._visitables.get((Object)"sidecarOverrides").add(builder);
            this.sidecarOverrides.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToStepOverrides(Collection<TaskRunStepOverride> items) {
        if (this.stepOverrides == null) {
            this.stepOverrides = new ArrayList();
        }
        for (TaskRunStepOverride item : items) {
            TaskRunStepOverrideBuilder builder = new TaskRunStepOverrideBuilder(item);
            this._visitables.get((Object)"stepOverrides").add(builder);
            this.stepOverrides.add(builder);
        }
        return (A)((Object)this);
    }

    public SidecarOverridesNested<A> addNewSidecarOverride() {
        return new SidecarOverridesNested(-1, null);
    }

    public SidecarOverridesNested<A> addNewSidecarOverrideLike(TaskRunSidecarOverride item) {
        return new SidecarOverridesNested(-1, item);
    }

    public StepOverridesNested<A> addNewStepOverride() {
        return new StepOverridesNested(-1, null);
    }

    public StepOverridesNested<A> addNewStepOverrideLike(TaskRunStepOverride item) {
        return new StepOverridesNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToSidecarOverrides(TaskRunSidecarOverride ... items) {
        if (this.sidecarOverrides == null) {
            this.sidecarOverrides = new ArrayList();
        }
        for (TaskRunSidecarOverride item : items) {
            TaskRunSidecarOverrideBuilder builder = new TaskRunSidecarOverrideBuilder(item);
            this._visitables.get((Object)"sidecarOverrides").add(builder);
            this.sidecarOverrides.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToSidecarOverrides(int index, TaskRunSidecarOverride item) {
        if (this.sidecarOverrides == null) {
            this.sidecarOverrides = new ArrayList();
        }
        TaskRunSidecarOverrideBuilder builder = new TaskRunSidecarOverrideBuilder(item);
        if (index < 0 || index >= this.sidecarOverrides.size()) {
            this._visitables.get((Object)"sidecarOverrides").add(builder);
            this.sidecarOverrides.add(builder);
        } else {
            this._visitables.get((Object)"sidecarOverrides").add(builder);
            this.sidecarOverrides.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToStepOverrides(TaskRunStepOverride ... items) {
        if (this.stepOverrides == null) {
            this.stepOverrides = new ArrayList();
        }
        for (TaskRunStepOverride item : items) {
            TaskRunStepOverrideBuilder builder = new TaskRunStepOverrideBuilder(item);
            this._visitables.get((Object)"stepOverrides").add(builder);
            this.stepOverrides.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToStepOverrides(int index, TaskRunStepOverride item) {
        if (this.stepOverrides == null) {
            this.stepOverrides = new ArrayList();
        }
        TaskRunStepOverrideBuilder builder = new TaskRunStepOverrideBuilder(item);
        if (index < 0 || index >= this.stepOverrides.size()) {
            this._visitables.get((Object)"stepOverrides").add(builder);
            this.stepOverrides.add(builder);
        } else {
            this._visitables.get((Object)"stepOverrides").add(builder);
            this.stepOverrides.add(index, builder);
        }
        return (A)((Object)this);
    }

    public ResourceRequirements buildComputeResources() {
        return this.computeResources != null ? this.computeResources.build() : null;
    }

    public TaskRunSidecarOverride buildFirstSidecarOverride() {
        return this.sidecarOverrides.get(0).build();
    }

    public TaskRunStepOverride buildFirstStepOverride() {
        return this.stepOverrides.get(0).build();
    }

    public TaskRunSidecarOverride buildLastSidecarOverride() {
        return this.sidecarOverrides.get(this.sidecarOverrides.size() - 1).build();
    }

    public TaskRunStepOverride buildLastStepOverride() {
        return this.stepOverrides.get(this.stepOverrides.size() - 1).build();
    }

    public TaskRunSidecarOverride buildMatchingSidecarOverride(Predicate<TaskRunSidecarOverrideBuilder> predicate) {
        for (TaskRunSidecarOverrideBuilder item : this.sidecarOverrides) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public TaskRunStepOverride buildMatchingStepOverride(Predicate<TaskRunStepOverrideBuilder> predicate) {
        for (TaskRunStepOverrideBuilder item : this.stepOverrides) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public PipelineTaskMetadata buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public TaskRunSidecarOverride buildSidecarOverride(int index) {
        return this.sidecarOverrides.get(index).build();
    }

    public List<TaskRunSidecarOverride> buildSidecarOverrides() {
        return this.sidecarOverrides != null ? PipelineTaskRunSpecFluent.build(this.sidecarOverrides) : null;
    }

    public TaskRunStepOverride buildStepOverride(int index) {
        return this.stepOverrides.get(index).build();
    }

    public List<TaskRunStepOverride> buildStepOverrides() {
        return this.stepOverrides != null ? PipelineTaskRunSpecFluent.build(this.stepOverrides) : null;
    }

    public Template buildTaskPodTemplate() {
        return this.taskPodTemplate != null ? this.taskPodTemplate.build() : null;
    }

    protected void copyInstance(PipelineTaskRunSpec instance) {
        PipelineTaskRunSpec pipelineTaskRunSpec = instance = instance != null ? instance : new PipelineTaskRunSpec();
        if (instance != null) {
            this.withComputeResources(instance.getComputeResources());
            this.withMetadata(instance.getMetadata());
            this.withPipelineTaskName(instance.getPipelineTaskName());
            this.withSidecarOverrides(instance.getSidecarOverrides());
            this.withStepOverrides(instance.getStepOverrides());
            this.withTaskPodTemplate(instance.getTaskPodTemplate());
            this.withTaskServiceAccountName(instance.getTaskServiceAccountName());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ComputeResourcesNested<A> editComputeResources() {
        return this.withNewComputeResourcesLike(Optional.ofNullable(this.buildComputeResources()).orElse(null));
    }

    public SidecarOverridesNested<A> editFirstSidecarOverride() {
        if (this.sidecarOverrides.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "sidecarOverrides"));
        }
        return this.setNewSidecarOverrideLike(0, this.buildSidecarOverride(0));
    }

    public StepOverridesNested<A> editFirstStepOverride() {
        if (this.stepOverrides.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "stepOverrides"));
        }
        return this.setNewStepOverrideLike(0, this.buildStepOverride(0));
    }

    public SidecarOverridesNested<A> editLastSidecarOverride() {
        int index = this.sidecarOverrides.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "sidecarOverrides"));
        }
        return this.setNewSidecarOverrideLike(index, this.buildSidecarOverride(index));
    }

    public StepOverridesNested<A> editLastStepOverride() {
        int index = this.stepOverrides.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "stepOverrides"));
        }
        return this.setNewStepOverrideLike(index, this.buildStepOverride(index));
    }

    public SidecarOverridesNested<A> editMatchingSidecarOverride(Predicate<TaskRunSidecarOverrideBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.sidecarOverrides.size(); ++i) {
            if (!predicate.test(this.sidecarOverrides.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "sidecarOverrides"));
        }
        return this.setNewSidecarOverrideLike(index, this.buildSidecarOverride(index));
    }

    public StepOverridesNested<A> editMatchingStepOverride(Predicate<TaskRunStepOverrideBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.stepOverrides.size(); ++i) {
            if (!predicate.test(this.stepOverrides.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "stepOverrides"));
        }
        return this.setNewStepOverrideLike(index, this.buildStepOverride(index));
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public ComputeResourcesNested<A> editOrNewComputeResources() {
        return this.withNewComputeResourcesLike(Optional.ofNullable(this.buildComputeResources()).orElse(new ResourceRequirementsBuilder().build()));
    }

    public ComputeResourcesNested<A> editOrNewComputeResourcesLike(ResourceRequirements item) {
        return this.withNewComputeResourcesLike(Optional.ofNullable(this.buildComputeResources()).orElse(item));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new PipelineTaskMetadataBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(PipelineTaskMetadata item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public TaskPodTemplateNested<A> editOrNewTaskPodTemplate() {
        return this.withNewTaskPodTemplateLike(Optional.ofNullable(this.buildTaskPodTemplate()).orElse(new TemplateBuilder().build()));
    }

    public TaskPodTemplateNested<A> editOrNewTaskPodTemplateLike(Template item) {
        return this.withNewTaskPodTemplateLike(Optional.ofNullable(this.buildTaskPodTemplate()).orElse(item));
    }

    public SidecarOverridesNested<A> editSidecarOverride(int index) {
        if (this.sidecarOverrides.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "sidecarOverrides"));
        }
        return this.setNewSidecarOverrideLike(index, this.buildSidecarOverride(index));
    }

    public StepOverridesNested<A> editStepOverride(int index) {
        if (this.stepOverrides.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "stepOverrides"));
        }
        return this.setNewStepOverrideLike(index, this.buildStepOverride(index));
    }

    public TaskPodTemplateNested<A> editTaskPodTemplate() {
        return this.withNewTaskPodTemplateLike(Optional.ofNullable(this.buildTaskPodTemplate()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PipelineTaskRunSpecFluent that = (PipelineTaskRunSpecFluent)((Object)o);
        if (!Objects.equals(this.computeResources, that.computeResources)) {
            return false;
        }
        if (!Objects.equals((Object)this.metadata, (Object)that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.pipelineTaskName, that.pipelineTaskName)) {
            return false;
        }
        if (!Objects.equals(this.sidecarOverrides, that.sidecarOverrides)) {
            return false;
        }
        if (!Objects.equals(this.stepOverrides, that.stepOverrides)) {
            return false;
        }
        if (!Objects.equals((Object)this.taskPodTemplate, (Object)that.taskPodTemplate)) {
            return false;
        }
        if (!Objects.equals(this.taskServiceAccountName, that.taskServiceAccountName)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getPipelineTaskName() {
        return this.pipelineTaskName;
    }

    public String getTaskServiceAccountName() {
        return this.taskServiceAccountName;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasComputeResources() {
        return this.computeResources != null;
    }

    public boolean hasMatchingSidecarOverride(Predicate<TaskRunSidecarOverrideBuilder> predicate) {
        for (TaskRunSidecarOverrideBuilder item : this.sidecarOverrides) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingStepOverride(Predicate<TaskRunStepOverrideBuilder> predicate) {
        for (TaskRunStepOverrideBuilder item : this.stepOverrides) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public boolean hasPipelineTaskName() {
        return this.pipelineTaskName != null;
    }

    public boolean hasSidecarOverrides() {
        return this.sidecarOverrides != null && !this.sidecarOverrides.isEmpty();
    }

    public boolean hasStepOverrides() {
        return this.stepOverrides != null && !this.stepOverrides.isEmpty();
    }

    public boolean hasTaskPodTemplate() {
        return this.taskPodTemplate != null;
    }

    public boolean hasTaskServiceAccountName() {
        return this.taskServiceAccountName != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.computeResources, this.metadata, this.pipelineTaskName, this.sidecarOverrides, this.stepOverrides, this.taskPodTemplate, this.taskServiceAccountName, this.additionalProperties});
    }

    public A removeAllFromSidecarOverrides(Collection<TaskRunSidecarOverride> items) {
        if (this.sidecarOverrides == null) {
            return (A)((Object)this);
        }
        for (TaskRunSidecarOverride item : items) {
            TaskRunSidecarOverrideBuilder builder = new TaskRunSidecarOverrideBuilder(item);
            this._visitables.get((Object)"sidecarOverrides").remove((Object)builder);
            this.sidecarOverrides.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromStepOverrides(Collection<TaskRunStepOverride> items) {
        if (this.stepOverrides == null) {
            return (A)((Object)this);
        }
        for (TaskRunStepOverride item : items) {
            TaskRunStepOverrideBuilder builder = new TaskRunStepOverrideBuilder(item);
            this._visitables.get((Object)"stepOverrides").remove((Object)builder);
            this.stepOverrides.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromSidecarOverrides(TaskRunSidecarOverride ... items) {
        if (this.sidecarOverrides == null) {
            return (A)((Object)this);
        }
        for (TaskRunSidecarOverride item : items) {
            TaskRunSidecarOverrideBuilder builder = new TaskRunSidecarOverrideBuilder(item);
            this._visitables.get((Object)"sidecarOverrides").remove((Object)builder);
            this.sidecarOverrides.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromStepOverrides(TaskRunStepOverride ... items) {
        if (this.stepOverrides == null) {
            return (A)((Object)this);
        }
        for (TaskRunStepOverride item : items) {
            TaskRunStepOverrideBuilder builder = new TaskRunStepOverrideBuilder(item);
            this._visitables.get((Object)"stepOverrides").remove((Object)builder);
            this.stepOverrides.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromSidecarOverrides(Predicate<TaskRunSidecarOverrideBuilder> predicate) {
        if (this.sidecarOverrides == null) {
            return (A)((Object)this);
        }
        Iterator<TaskRunSidecarOverrideBuilder> each = this.sidecarOverrides.iterator();
        List visitables = this._visitables.get((Object)"sidecarOverrides");
        while (each.hasNext()) {
            TaskRunSidecarOverrideBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromStepOverrides(Predicate<TaskRunStepOverrideBuilder> predicate) {
        if (this.stepOverrides == null) {
            return (A)((Object)this);
        }
        Iterator<TaskRunStepOverrideBuilder> each = this.stepOverrides.iterator();
        List visitables = this._visitables.get((Object)"stepOverrides");
        while (each.hasNext()) {
            TaskRunStepOverrideBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public SidecarOverridesNested<A> setNewSidecarOverrideLike(int index, TaskRunSidecarOverride item) {
        return new SidecarOverridesNested(index, item);
    }

    public StepOverridesNested<A> setNewStepOverrideLike(int index, TaskRunStepOverride item) {
        return new StepOverridesNested(index, item);
    }

    public A setToSidecarOverrides(int index, TaskRunSidecarOverride item) {
        if (this.sidecarOverrides == null) {
            this.sidecarOverrides = new ArrayList();
        }
        TaskRunSidecarOverrideBuilder builder = new TaskRunSidecarOverrideBuilder(item);
        if (index < 0 || index >= this.sidecarOverrides.size()) {
            this._visitables.get((Object)"sidecarOverrides").add(builder);
            this.sidecarOverrides.add(builder);
        } else {
            this._visitables.get((Object)"sidecarOverrides").add(builder);
            this.sidecarOverrides.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToStepOverrides(int index, TaskRunStepOverride item) {
        if (this.stepOverrides == null) {
            this.stepOverrides = new ArrayList();
        }
        TaskRunStepOverrideBuilder builder = new TaskRunStepOverrideBuilder(item);
        if (index < 0 || index >= this.stepOverrides.size()) {
            this._visitables.get((Object)"stepOverrides").add(builder);
            this.stepOverrides.add(builder);
        } else {
            this._visitables.get((Object)"stepOverrides").add(builder);
            this.stepOverrides.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.computeResources != null) {
            sb.append("computeResources:");
            sb.append(this.computeResources);
            sb.append(",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append((Object)this.metadata);
            sb.append(",");
        }
        if (this.pipelineTaskName != null) {
            sb.append("pipelineTaskName:");
            sb.append(this.pipelineTaskName);
            sb.append(",");
        }
        if (this.sidecarOverrides != null && !this.sidecarOverrides.isEmpty()) {
            sb.append("sidecarOverrides:");
            sb.append(this.sidecarOverrides);
            sb.append(",");
        }
        if (this.stepOverrides != null && !this.stepOverrides.isEmpty()) {
            sb.append("stepOverrides:");
            sb.append(this.stepOverrides);
            sb.append(",");
        }
        if (this.taskPodTemplate != null) {
            sb.append("taskPodTemplate:");
            sb.append((Object)this.taskPodTemplate);
            sb.append(",");
        }
        if (this.taskServiceAccountName != null) {
            sb.append("taskServiceAccountName:");
            sb.append(this.taskServiceAccountName);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withComputeResources(ResourceRequirements computeResources) {
        this._visitables.remove((Object)"computeResources");
        if (computeResources != null) {
            this.computeResources = new ResourceRequirementsBuilder(computeResources);
            this._visitables.get((Object)"computeResources").add(this.computeResources);
        } else {
            this.computeResources = null;
            this._visitables.get((Object)"computeResources").remove(this.computeResources);
        }
        return (A)((Object)this);
    }

    public A withMetadata(PipelineTaskMetadata metadata) {
        this._visitables.remove((Object)"metadata");
        if (metadata != null) {
            this.metadata = new PipelineTaskMetadataBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get((Object)"metadata").remove((Object)this.metadata);
        }
        return (A)((Object)this);
    }

    public ComputeResourcesNested<A> withNewComputeResources() {
        return new ComputeResourcesNested(null);
    }

    public ComputeResourcesNested<A> withNewComputeResourcesLike(ResourceRequirements item) {
        return new ComputeResourcesNested(item);
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(PipelineTaskMetadata item) {
        return new MetadataNested(item);
    }

    public TaskPodTemplateNested<A> withNewTaskPodTemplate() {
        return new TaskPodTemplateNested(null);
    }

    public TaskPodTemplateNested<A> withNewTaskPodTemplateLike(Template item) {
        return new TaskPodTemplateNested(item);
    }

    public A withPipelineTaskName(String pipelineTaskName) {
        this.pipelineTaskName = pipelineTaskName;
        return (A)((Object)this);
    }

    public A withSidecarOverrides(List<TaskRunSidecarOverride> sidecarOverrides) {
        if (this.sidecarOverrides != null) {
            this._visitables.get((Object)"sidecarOverrides").clear();
        }
        if (sidecarOverrides != null) {
            this.sidecarOverrides = new ArrayList();
            for (TaskRunSidecarOverride item : sidecarOverrides) {
                this.addToSidecarOverrides(item);
            }
        } else {
            this.sidecarOverrides = null;
        }
        return (A)((Object)this);
    }

    public A withSidecarOverrides(TaskRunSidecarOverride ... sidecarOverrides) {
        if (this.sidecarOverrides != null) {
            this.sidecarOverrides.clear();
            this._visitables.remove((Object)"sidecarOverrides");
        }
        if (sidecarOverrides != null) {
            for (TaskRunSidecarOverride item : sidecarOverrides) {
                this.addToSidecarOverrides(item);
            }
        }
        return (A)((Object)this);
    }

    public A withStepOverrides(List<TaskRunStepOverride> stepOverrides) {
        if (this.stepOverrides != null) {
            this._visitables.get((Object)"stepOverrides").clear();
        }
        if (stepOverrides != null) {
            this.stepOverrides = new ArrayList();
            for (TaskRunStepOverride item : stepOverrides) {
                this.addToStepOverrides(item);
            }
        } else {
            this.stepOverrides = null;
        }
        return (A)((Object)this);
    }

    public A withStepOverrides(TaskRunStepOverride ... stepOverrides) {
        if (this.stepOverrides != null) {
            this.stepOverrides.clear();
            this._visitables.remove((Object)"stepOverrides");
        }
        if (stepOverrides != null) {
            for (TaskRunStepOverride item : stepOverrides) {
                this.addToStepOverrides(item);
            }
        }
        return (A)((Object)this);
    }

    public A withTaskPodTemplate(Template taskPodTemplate) {
        this._visitables.remove((Object)"taskPodTemplate");
        if (taskPodTemplate != null) {
            this.taskPodTemplate = new TemplateBuilder(taskPodTemplate);
            this._visitables.get((Object)"taskPodTemplate").add(this.taskPodTemplate);
        } else {
            this.taskPodTemplate = null;
            this._visitables.get((Object)"taskPodTemplate").remove((Object)this.taskPodTemplate);
        }
        return (A)((Object)this);
    }

    public A withTaskServiceAccountName(String taskServiceAccountName) {
        this.taskServiceAccountName = taskServiceAccountName;
        return (A)((Object)this);
    }

    public class TaskPodTemplateNested<N>
    extends TemplateFluent<TaskPodTemplateNested<N>>
    implements Nested<N> {
        TemplateBuilder builder;

        TaskPodTemplateNested(Template item) {
            this.builder = new TemplateBuilder(this, item);
        }

        public N and() {
            return (N)PipelineTaskRunSpecFluent.this.withTaskPodTemplate(this.builder.build());
        }

        public N endTaskPodTemplate() {
            return this.and();
        }
    }

    public class StepOverridesNested<N>
    extends TaskRunStepOverrideFluent<StepOverridesNested<N>>
    implements Nested<N> {
        TaskRunStepOverrideBuilder builder;
        int index;

        StepOverridesNested(int index, TaskRunStepOverride item) {
            this.index = index;
            this.builder = new TaskRunStepOverrideBuilder(this, item);
        }

        public N and() {
            return (N)PipelineTaskRunSpecFluent.this.setToStepOverrides(this.index, this.builder.build());
        }

        public N endStepOverride() {
            return this.and();
        }
    }

    public class SidecarOverridesNested<N>
    extends TaskRunSidecarOverrideFluent<SidecarOverridesNested<N>>
    implements Nested<N> {
        TaskRunSidecarOverrideBuilder builder;
        int index;

        SidecarOverridesNested(int index, TaskRunSidecarOverride item) {
            this.index = index;
            this.builder = new TaskRunSidecarOverrideBuilder(this, item);
        }

        public N and() {
            return (N)PipelineTaskRunSpecFluent.this.setToSidecarOverrides(this.index, this.builder.build());
        }

        public N endSidecarOverride() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends PipelineTaskMetadataFluent<MetadataNested<N>>
    implements Nested<N> {
        PipelineTaskMetadataBuilder builder;

        MetadataNested(PipelineTaskMetadata item) {
            this.builder = new PipelineTaskMetadataBuilder(this, item);
        }

        public N and() {
            return (N)PipelineTaskRunSpecFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class ComputeResourcesNested<N>
    extends ResourceRequirementsFluent<ComputeResourcesNested<N>>
    implements Nested<N> {
        ResourceRequirementsBuilder builder;

        ComputeResourcesNested(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder((ResourceRequirementsFluent)this, item);
        }

        public N and() {
            return (N)PipelineTaskRunSpecFluent.this.withComputeResources(this.builder.build());
        }

        public N endComputeResources() {
            return this.and();
        }
    }
}

