/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.v1;

import io.fabric8.knative.pkg.apis.Condition;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.tekton.v1.Artifacts;
import io.fabric8.tekton.v1.ArtifactsBuilder;
import io.fabric8.tekton.v1.ArtifactsFluent;
import io.fabric8.tekton.v1.Provenance;
import io.fabric8.tekton.v1.ProvenanceBuilder;
import io.fabric8.tekton.v1.ProvenanceFluent;
import io.fabric8.tekton.v1.SidecarState;
import io.fabric8.tekton.v1.SidecarStateBuilder;
import io.fabric8.tekton.v1.SidecarStateFluent;
import io.fabric8.tekton.v1.StepState;
import io.fabric8.tekton.v1.StepStateBuilder;
import io.fabric8.tekton.v1.StepStateFluent;
import io.fabric8.tekton.v1.TaskRunResult;
import io.fabric8.tekton.v1.TaskRunResultBuilder;
import io.fabric8.tekton.v1.TaskRunResultFluent;
import io.fabric8.tekton.v1.TaskRunStatus;
import io.fabric8.tekton.v1.TaskRunStatusBuilder;
import io.fabric8.tekton.v1.TaskSpec;
import io.fabric8.tekton.v1.TaskSpecBuilder;
import io.fabric8.tekton.v1.TaskSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class TaskRunStatusFluent<A extends TaskRunStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private Map<String, String> annotations;
    private ArtifactsBuilder artifacts;
    private String completionTime;
    private List<Condition> conditions = new ArrayList<Condition>();
    private Long observedGeneration;
    private String podName;
    private ProvenanceBuilder provenance;
    private ArrayList<TaskRunResultBuilder> results = new ArrayList();
    private ArrayList<TaskRunStatusBuilder> retriesStatus = new ArrayList();
    private ArrayList<SidecarStateBuilder> sidecars = new ArrayList();
    private Map<String, String> spanContext;
    private String startTime;
    private ArrayList<StepStateBuilder> steps = new ArrayList();
    private TaskSpecBuilder taskSpec;

    public TaskRunStatusFluent() {
    }

    public TaskRunStatusFluent(TaskRunStatus instance) {
        this.copyInstance(instance);
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToResults(Collection<TaskRunResult> items) {
        if (this.results == null) {
            this.results = new ArrayList();
        }
        for (TaskRunResult item : items) {
            TaskRunResultBuilder builder = new TaskRunResultBuilder(item);
            this._visitables.get((Object)"results").add(builder);
            this.results.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToRetriesStatus(Collection<TaskRunStatus> items) {
        if (this.retriesStatus == null) {
            this.retriesStatus = new ArrayList();
        }
        for (TaskRunStatus item : items) {
            TaskRunStatusBuilder builder = new TaskRunStatusBuilder(item);
            this._visitables.get((Object)"retriesStatus").add(builder);
            this.retriesStatus.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToSidecars(Collection<SidecarState> items) {
        if (this.sidecars == null) {
            this.sidecars = new ArrayList();
        }
        for (SidecarState item : items) {
            SidecarStateBuilder builder = new SidecarStateBuilder(item);
            this._visitables.get((Object)"sidecars").add(builder);
            this.sidecars.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToSteps(Collection<StepState> items) {
        if (this.steps == null) {
            this.steps = new ArrayList();
        }
        for (StepState item : items) {
            StepStateBuilder builder = new StepStateBuilder(item);
            this._visitables.get((Object)"steps").add(builder);
            this.steps.add(builder);
        }
        return (A)((Object)this);
    }

    public ResultsNested<A> addNewResult() {
        return new ResultsNested(-1, null);
    }

    public ResultsNested<A> addNewResultLike(TaskRunResult item) {
        return new ResultsNested(-1, item);
    }

    public RetriesStatusNested<A> addNewRetriesStatus() {
        return new RetriesStatusNested(-1, null);
    }

    public RetriesStatusNested<A> addNewRetriesStatusLike(TaskRunStatus item) {
        return new RetriesStatusNested(-1, item);
    }

    public SidecarsNested<A> addNewSidecar() {
        return new SidecarsNested(-1, null);
    }

    public SidecarsNested<A> addNewSidecarLike(SidecarState item) {
        return new SidecarsNested(-1, item);
    }

    public StepsNested<A> addNewStep() {
        return new StepsNested(-1, null);
    }

    public StepsNested<A> addNewStepLike(StepState item) {
        return new StepsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)((Object)this);
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)((Object)this);
    }

    public A addToResults(TaskRunResult ... items) {
        if (this.results == null) {
            this.results = new ArrayList();
        }
        for (TaskRunResult item : items) {
            TaskRunResultBuilder builder = new TaskRunResultBuilder(item);
            this._visitables.get((Object)"results").add(builder);
            this.results.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToResults(int index, TaskRunResult item) {
        if (this.results == null) {
            this.results = new ArrayList();
        }
        TaskRunResultBuilder builder = new TaskRunResultBuilder(item);
        if (index < 0 || index >= this.results.size()) {
            this._visitables.get((Object)"results").add(builder);
            this.results.add(builder);
        } else {
            this._visitables.get((Object)"results").add(builder);
            this.results.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToRetriesStatus(TaskRunStatus ... items) {
        if (this.retriesStatus == null) {
            this.retriesStatus = new ArrayList();
        }
        for (TaskRunStatus item : items) {
            TaskRunStatusBuilder builder = new TaskRunStatusBuilder(item);
            this._visitables.get((Object)"retriesStatus").add(builder);
            this.retriesStatus.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToRetriesStatus(int index, TaskRunStatus item) {
        if (this.retriesStatus == null) {
            this.retriesStatus = new ArrayList();
        }
        TaskRunStatusBuilder builder = new TaskRunStatusBuilder(item);
        if (index < 0 || index >= this.retriesStatus.size()) {
            this._visitables.get((Object)"retriesStatus").add(builder);
            this.retriesStatus.add(builder);
        } else {
            this._visitables.get((Object)"retriesStatus").add(builder);
            this.retriesStatus.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToSidecars(SidecarState ... items) {
        if (this.sidecars == null) {
            this.sidecars = new ArrayList();
        }
        for (SidecarState item : items) {
            SidecarStateBuilder builder = new SidecarStateBuilder(item);
            this._visitables.get((Object)"sidecars").add(builder);
            this.sidecars.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToSidecars(int index, SidecarState item) {
        if (this.sidecars == null) {
            this.sidecars = new ArrayList();
        }
        SidecarStateBuilder builder = new SidecarStateBuilder(item);
        if (index < 0 || index >= this.sidecars.size()) {
            this._visitables.get((Object)"sidecars").add(builder);
            this.sidecars.add(builder);
        } else {
            this._visitables.get((Object)"sidecars").add(builder);
            this.sidecars.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToSpanContext(Map<String, String> map) {
        if (this.spanContext == null && map != null) {
            this.spanContext = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.spanContext.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToSpanContext(String key, String value) {
        if (this.spanContext == null && key != null && value != null) {
            this.spanContext = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.spanContext.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToSteps(StepState ... items) {
        if (this.steps == null) {
            this.steps = new ArrayList();
        }
        for (StepState item : items) {
            StepStateBuilder builder = new StepStateBuilder(item);
            this._visitables.get((Object)"steps").add(builder);
            this.steps.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToSteps(int index, StepState item) {
        if (this.steps == null) {
            this.steps = new ArrayList();
        }
        StepStateBuilder builder = new StepStateBuilder(item);
        if (index < 0 || index >= this.steps.size()) {
            this._visitables.get((Object)"steps").add(builder);
            this.steps.add(builder);
        } else {
            this._visitables.get((Object)"steps").add(builder);
            this.steps.add(index, builder);
        }
        return (A)((Object)this);
    }

    public Artifacts buildArtifacts() {
        return this.artifacts != null ? this.artifacts.build() : null;
    }

    public TaskRunResult buildFirstResult() {
        return this.results.get(0).build();
    }

    public TaskRunStatus buildFirstRetriesStatus() {
        return this.retriesStatus.get(0).build();
    }

    public SidecarState buildFirstSidecar() {
        return this.sidecars.get(0).build();
    }

    public StepState buildFirstStep() {
        return this.steps.get(0).build();
    }

    public TaskRunResult buildLastResult() {
        return this.results.get(this.results.size() - 1).build();
    }

    public TaskRunStatus buildLastRetriesStatus() {
        return this.retriesStatus.get(this.retriesStatus.size() - 1).build();
    }

    public SidecarState buildLastSidecar() {
        return this.sidecars.get(this.sidecars.size() - 1).build();
    }

    public StepState buildLastStep() {
        return this.steps.get(this.steps.size() - 1).build();
    }

    public TaskRunResult buildMatchingResult(Predicate<TaskRunResultBuilder> predicate) {
        for (TaskRunResultBuilder item : this.results) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public TaskRunStatus buildMatchingRetriesStatus(Predicate<TaskRunStatusBuilder> predicate) {
        for (TaskRunStatusBuilder item : this.retriesStatus) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public SidecarState buildMatchingSidecar(Predicate<SidecarStateBuilder> predicate) {
        for (SidecarStateBuilder item : this.sidecars) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public StepState buildMatchingStep(Predicate<StepStateBuilder> predicate) {
        for (StepStateBuilder item : this.steps) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public Provenance buildProvenance() {
        return this.provenance != null ? this.provenance.build() : null;
    }

    public TaskRunResult buildResult(int index) {
        return this.results.get(index).build();
    }

    public List<TaskRunResult> buildResults() {
        return this.results != null ? TaskRunStatusFluent.build(this.results) : null;
    }

    public List<TaskRunStatus> buildRetriesStatus() {
        return this.retriesStatus != null ? TaskRunStatusFluent.build(this.retriesStatus) : null;
    }

    public TaskRunStatus buildRetriesStatus(int index) {
        return this.retriesStatus.get(index).build();
    }

    public SidecarState buildSidecar(int index) {
        return this.sidecars.get(index).build();
    }

    public List<SidecarState> buildSidecars() {
        return this.sidecars != null ? TaskRunStatusFluent.build(this.sidecars) : null;
    }

    public StepState buildStep(int index) {
        return this.steps.get(index).build();
    }

    public List<StepState> buildSteps() {
        return this.steps != null ? TaskRunStatusFluent.build(this.steps) : null;
    }

    public TaskSpec buildTaskSpec() {
        return this.taskSpec != null ? this.taskSpec.build() : null;
    }

    protected void copyInstance(TaskRunStatus instance) {
        TaskRunStatus taskRunStatus = instance = instance != null ? instance : new TaskRunStatus();
        if (instance != null) {
            this.withAnnotations(instance.getAnnotations());
            this.withArtifacts(instance.getArtifacts());
            this.withCompletionTime(instance.getCompletionTime());
            this.withConditions(instance.getConditions());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withPodName(instance.getPodName());
            this.withProvenance(instance.getProvenance());
            this.withResults(instance.getResults());
            this.withRetriesStatus(instance.getRetriesStatus());
            this.withSidecars(instance.getSidecars());
            this.withSpanContext(instance.getSpanContext());
            this.withStartTime(instance.getStartTime());
            this.withSteps(instance.getSteps());
            this.withTaskSpec(instance.getTaskSpec());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ArtifactsNested<A> editArtifacts() {
        return this.withNewArtifactsLike(Optional.ofNullable(this.buildArtifacts()).orElse(null));
    }

    public ResultsNested<A> editFirstResult() {
        if (this.results.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "results"));
        }
        return this.setNewResultLike(0, this.buildResult(0));
    }

    public RetriesStatusNested<A> editFirstRetriesStatus() {
        if (this.retriesStatus.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "retriesStatus"));
        }
        return this.setNewRetriesStatusLike(0, this.buildRetriesStatus(0));
    }

    public SidecarsNested<A> editFirstSidecar() {
        if (this.sidecars.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "sidecars"));
        }
        return this.setNewSidecarLike(0, this.buildSidecar(0));
    }

    public StepsNested<A> editFirstStep() {
        if (this.steps.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "steps"));
        }
        return this.setNewStepLike(0, this.buildStep(0));
    }

    public ResultsNested<A> editLastResult() {
        int index = this.results.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "results"));
        }
        return this.setNewResultLike(index, this.buildResult(index));
    }

    public RetriesStatusNested<A> editLastRetriesStatus() {
        int index = this.retriesStatus.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "retriesStatus"));
        }
        return this.setNewRetriesStatusLike(index, this.buildRetriesStatus(index));
    }

    public SidecarsNested<A> editLastSidecar() {
        int index = this.sidecars.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "sidecars"));
        }
        return this.setNewSidecarLike(index, this.buildSidecar(index));
    }

    public StepsNested<A> editLastStep() {
        int index = this.steps.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "steps"));
        }
        return this.setNewStepLike(index, this.buildStep(index));
    }

    public ResultsNested<A> editMatchingResult(Predicate<TaskRunResultBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.results.size(); ++i) {
            if (!predicate.test(this.results.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "results"));
        }
        return this.setNewResultLike(index, this.buildResult(index));
    }

    public RetriesStatusNested<A> editMatchingRetriesStatus(Predicate<TaskRunStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.retriesStatus.size(); ++i) {
            if (!predicate.test(this.retriesStatus.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "retriesStatus"));
        }
        return this.setNewRetriesStatusLike(index, this.buildRetriesStatus(index));
    }

    public SidecarsNested<A> editMatchingSidecar(Predicate<SidecarStateBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.sidecars.size(); ++i) {
            if (!predicate.test(this.sidecars.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "sidecars"));
        }
        return this.setNewSidecarLike(index, this.buildSidecar(index));
    }

    public StepsNested<A> editMatchingStep(Predicate<StepStateBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.steps.size(); ++i) {
            if (!predicate.test(this.steps.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "steps"));
        }
        return this.setNewStepLike(index, this.buildStep(index));
    }

    public ArtifactsNested<A> editOrNewArtifacts() {
        return this.withNewArtifactsLike(Optional.ofNullable(this.buildArtifacts()).orElse(new ArtifactsBuilder().build()));
    }

    public ArtifactsNested<A> editOrNewArtifactsLike(Artifacts item) {
        return this.withNewArtifactsLike(Optional.ofNullable(this.buildArtifacts()).orElse(item));
    }

    public ProvenanceNested<A> editOrNewProvenance() {
        return this.withNewProvenanceLike(Optional.ofNullable(this.buildProvenance()).orElse(new ProvenanceBuilder().build()));
    }

    public ProvenanceNested<A> editOrNewProvenanceLike(Provenance item) {
        return this.withNewProvenanceLike(Optional.ofNullable(this.buildProvenance()).orElse(item));
    }

    public TaskSpecNested<A> editOrNewTaskSpec() {
        return this.withNewTaskSpecLike(Optional.ofNullable(this.buildTaskSpec()).orElse(new TaskSpecBuilder().build()));
    }

    public TaskSpecNested<A> editOrNewTaskSpecLike(TaskSpec item) {
        return this.withNewTaskSpecLike(Optional.ofNullable(this.buildTaskSpec()).orElse(item));
    }

    public ProvenanceNested<A> editProvenance() {
        return this.withNewProvenanceLike(Optional.ofNullable(this.buildProvenance()).orElse(null));
    }

    public ResultsNested<A> editResult(int index) {
        if (this.results.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "results"));
        }
        return this.setNewResultLike(index, this.buildResult(index));
    }

    public RetriesStatusNested<A> editRetriesStatus(int index) {
        if (this.retriesStatus.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "retriesStatus"));
        }
        return this.setNewRetriesStatusLike(index, this.buildRetriesStatus(index));
    }

    public SidecarsNested<A> editSidecar(int index) {
        if (this.sidecars.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "sidecars"));
        }
        return this.setNewSidecarLike(index, this.buildSidecar(index));
    }

    public StepsNested<A> editStep(int index) {
        if (this.steps.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "steps"));
        }
        return this.setNewStepLike(index, this.buildStep(index));
    }

    public TaskSpecNested<A> editTaskSpec() {
        return this.withNewTaskSpecLike(Optional.ofNullable(this.buildTaskSpec()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TaskRunStatusFluent that = (TaskRunStatusFluent)((Object)o);
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals((Object)this.artifacts, (Object)that.artifacts)) {
            return false;
        }
        if (!Objects.equals(this.completionTime, that.completionTime)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        if (!Objects.equals(this.podName, that.podName)) {
            return false;
        }
        if (!Objects.equals((Object)this.provenance, (Object)that.provenance)) {
            return false;
        }
        if (!Objects.equals(this.results, that.results)) {
            return false;
        }
        if (!Objects.equals(this.retriesStatus, that.retriesStatus)) {
            return false;
        }
        if (!Objects.equals(this.sidecars, that.sidecars)) {
            return false;
        }
        if (!Objects.equals(this.spanContext, that.spanContext)) {
            return false;
        }
        if (!Objects.equals(this.startTime, that.startTime)) {
            return false;
        }
        if (!Objects.equals(this.steps, that.steps)) {
            return false;
        }
        if (!Objects.equals((Object)this.taskSpec, (Object)that.taskSpec)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public String getCompletionTime() {
        return this.completionTime;
    }

    public Condition getCondition(int index) {
        return this.conditions.get(index);
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public String getPodName() {
        return this.podName;
    }

    public Map<String, String> getSpanContext() {
        return this.spanContext;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAnnotations() {
        return this.annotations != null;
    }

    public boolean hasArtifacts() {
        return this.artifacts != null;
    }

    public boolean hasCompletionTime() {
        return this.completionTime != null;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingResult(Predicate<TaskRunResultBuilder> predicate) {
        for (TaskRunResultBuilder item : this.results) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingRetriesStatus(Predicate<TaskRunStatusBuilder> predicate) {
        for (TaskRunStatusBuilder item : this.retriesStatus) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingSidecar(Predicate<SidecarStateBuilder> predicate) {
        for (SidecarStateBuilder item : this.sidecars) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingStep(Predicate<StepStateBuilder> predicate) {
        for (StepStateBuilder item : this.steps) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public boolean hasPodName() {
        return this.podName != null;
    }

    public boolean hasProvenance() {
        return this.provenance != null;
    }

    public boolean hasResults() {
        return this.results != null && !this.results.isEmpty();
    }

    public boolean hasRetriesStatus() {
        return this.retriesStatus != null && !this.retriesStatus.isEmpty();
    }

    public boolean hasSidecars() {
        return this.sidecars != null && !this.sidecars.isEmpty();
    }

    public boolean hasSpanContext() {
        return this.spanContext != null;
    }

    public boolean hasStartTime() {
        return this.startTime != null;
    }

    public boolean hasSteps() {
        return this.steps != null && !this.steps.isEmpty();
    }

    public boolean hasTaskSpec() {
        return this.taskSpec != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.annotations, this.artifacts, this.completionTime, this.conditions, this.observedGeneration, this.podName, this.provenance, this.results, this.retriesStatus, this.sidecars, this.spanContext, this.startTime, this.steps, this.taskSpec, this.additionalProperties});
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromResults(Collection<TaskRunResult> items) {
        if (this.results == null) {
            return (A)((Object)this);
        }
        for (TaskRunResult item : items) {
            TaskRunResultBuilder builder = new TaskRunResultBuilder(item);
            this._visitables.get((Object)"results").remove((Object)builder);
            this.results.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromRetriesStatus(Collection<TaskRunStatus> items) {
        if (this.retriesStatus == null) {
            return (A)((Object)this);
        }
        for (TaskRunStatus item : items) {
            TaskRunStatusBuilder builder = new TaskRunStatusBuilder(item);
            this._visitables.get((Object)"retriesStatus").remove((Object)builder);
            this.retriesStatus.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSidecars(Collection<SidecarState> items) {
        if (this.sidecars == null) {
            return (A)((Object)this);
        }
        for (SidecarState item : items) {
            SidecarStateBuilder builder = new SidecarStateBuilder(item);
            this._visitables.get((Object)"sidecars").remove((Object)builder);
            this.sidecars.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSteps(Collection<StepState> items) {
        if (this.steps == null) {
            return (A)((Object)this);
        }
        for (StepState item : items) {
            StepStateBuilder builder = new StepStateBuilder(item);
            this._visitables.get((Object)"steps").remove((Object)builder);
            this.steps.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromResults(TaskRunResult ... items) {
        if (this.results == null) {
            return (A)((Object)this);
        }
        for (TaskRunResult item : items) {
            TaskRunResultBuilder builder = new TaskRunResultBuilder(item);
            this._visitables.get((Object)"results").remove((Object)builder);
            this.results.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromRetriesStatus(TaskRunStatus ... items) {
        if (this.retriesStatus == null) {
            return (A)((Object)this);
        }
        for (TaskRunStatus item : items) {
            TaskRunStatusBuilder builder = new TaskRunStatusBuilder(item);
            this._visitables.get((Object)"retriesStatus").remove((Object)builder);
            this.retriesStatus.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromSidecars(SidecarState ... items) {
        if (this.sidecars == null) {
            return (A)((Object)this);
        }
        for (SidecarState item : items) {
            SidecarStateBuilder builder = new SidecarStateBuilder(item);
            this._visitables.get((Object)"sidecars").remove((Object)builder);
            this.sidecars.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromSpanContext(String key) {
        if (this.spanContext == null) {
            return (A)((Object)this);
        }
        if (key != null && this.spanContext != null) {
            this.spanContext.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromSpanContext(Map<String, String> map) {
        if (this.spanContext == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.spanContext == null) continue;
                this.spanContext.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromSteps(StepState ... items) {
        if (this.steps == null) {
            return (A)((Object)this);
        }
        for (StepState item : items) {
            StepStateBuilder builder = new StepStateBuilder(item);
            this._visitables.get((Object)"steps").remove((Object)builder);
            this.steps.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromResults(Predicate<TaskRunResultBuilder> predicate) {
        if (this.results == null) {
            return (A)((Object)this);
        }
        Iterator<TaskRunResultBuilder> each = this.results.iterator();
        List visitables = this._visitables.get((Object)"results");
        while (each.hasNext()) {
            TaskRunResultBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromRetriesStatus(Predicate<TaskRunStatusBuilder> predicate) {
        if (this.retriesStatus == null) {
            return (A)((Object)this);
        }
        Iterator<TaskRunStatusBuilder> each = this.retriesStatus.iterator();
        List visitables = this._visitables.get((Object)"retriesStatus");
        while (each.hasNext()) {
            TaskRunStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromSidecars(Predicate<SidecarStateBuilder> predicate) {
        if (this.sidecars == null) {
            return (A)((Object)this);
        }
        Iterator<SidecarStateBuilder> each = this.sidecars.iterator();
        List visitables = this._visitables.get((Object)"sidecars");
        while (each.hasNext()) {
            SidecarStateBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromSteps(Predicate<StepStateBuilder> predicate) {
        if (this.steps == null) {
            return (A)((Object)this);
        }
        Iterator<StepStateBuilder> each = this.steps.iterator();
        List visitables = this._visitables.get((Object)"steps");
        while (each.hasNext()) {
            StepStateBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public ResultsNested<A> setNewResultLike(int index, TaskRunResult item) {
        return new ResultsNested(index, item);
    }

    public RetriesStatusNested<A> setNewRetriesStatusLike(int index, TaskRunStatus item) {
        return new RetriesStatusNested(index, item);
    }

    public SidecarsNested<A> setNewSidecarLike(int index, SidecarState item) {
        return new SidecarsNested(index, item);
    }

    public StepsNested<A> setNewStepLike(int index, StepState item) {
        return new StepsNested(index, item);
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)((Object)this);
    }

    public A setToResults(int index, TaskRunResult item) {
        if (this.results == null) {
            this.results = new ArrayList();
        }
        TaskRunResultBuilder builder = new TaskRunResultBuilder(item);
        if (index < 0 || index >= this.results.size()) {
            this._visitables.get((Object)"results").add(builder);
            this.results.add(builder);
        } else {
            this._visitables.get((Object)"results").add(builder);
            this.results.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToRetriesStatus(int index, TaskRunStatus item) {
        if (this.retriesStatus == null) {
            this.retriesStatus = new ArrayList();
        }
        TaskRunStatusBuilder builder = new TaskRunStatusBuilder(item);
        if (index < 0 || index >= this.retriesStatus.size()) {
            this._visitables.get((Object)"retriesStatus").add(builder);
            this.retriesStatus.add(builder);
        } else {
            this._visitables.get((Object)"retriesStatus").add(builder);
            this.retriesStatus.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToSidecars(int index, SidecarState item) {
        if (this.sidecars == null) {
            this.sidecars = new ArrayList();
        }
        SidecarStateBuilder builder = new SidecarStateBuilder(item);
        if (index < 0 || index >= this.sidecars.size()) {
            this._visitables.get((Object)"sidecars").add(builder);
            this.sidecars.add(builder);
        } else {
            this._visitables.get((Object)"sidecars").add(builder);
            this.sidecars.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToSteps(int index, StepState item) {
        if (this.steps == null) {
            this.steps = new ArrayList();
        }
        StepStateBuilder builder = new StepStateBuilder(item);
        if (index < 0 || index >= this.steps.size()) {
            this._visitables.get((Object)"steps").add(builder);
            this.steps.add(builder);
        } else {
            this._visitables.get((Object)"steps").add(builder);
            this.steps.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(this.annotations);
            sb.append(",");
        }
        if (this.artifacts != null) {
            sb.append("artifacts:");
            sb.append((Object)this.artifacts);
            sb.append(",");
        }
        if (this.completionTime != null) {
            sb.append("completionTime:");
            sb.append(this.completionTime);
            sb.append(",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions);
            sb.append(",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration);
            sb.append(",");
        }
        if (this.podName != null) {
            sb.append("podName:");
            sb.append(this.podName);
            sb.append(",");
        }
        if (this.provenance != null) {
            sb.append("provenance:");
            sb.append((Object)this.provenance);
            sb.append(",");
        }
        if (this.results != null && !this.results.isEmpty()) {
            sb.append("results:");
            sb.append(this.results);
            sb.append(",");
        }
        if (this.retriesStatus != null && !this.retriesStatus.isEmpty()) {
            sb.append("retriesStatus:");
            sb.append(this.retriesStatus);
            sb.append(",");
        }
        if (this.sidecars != null && !this.sidecars.isEmpty()) {
            sb.append("sidecars:");
            sb.append(this.sidecars);
            sb.append(",");
        }
        if (this.spanContext != null && !this.spanContext.isEmpty()) {
            sb.append("spanContext:");
            sb.append(this.spanContext);
            sb.append(",");
        }
        if (this.startTime != null) {
            sb.append("startTime:");
            sb.append(this.startTime);
            sb.append(",");
        }
        if (this.steps != null && !this.steps.isEmpty()) {
            sb.append("steps:");
            sb.append(this.steps);
            sb.append(",");
        }
        if (this.taskSpec != null) {
            sb.append("taskSpec:");
            sb.append((Object)this.taskSpec);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public <K, V> A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)((Object)this);
    }

    public A withArtifacts(Artifacts artifacts) {
        this._visitables.remove((Object)"artifacts");
        if (artifacts != null) {
            this.artifacts = new ArtifactsBuilder(artifacts);
            this._visitables.get((Object)"artifacts").add(this.artifacts);
        } else {
            this.artifacts = null;
            this._visitables.get((Object)"artifacts").remove((Object)this.artifacts);
        }
        return (A)((Object)this);
    }

    public A withCompletionTime(String completionTime) {
        this.completionTime = completionTime;
        return (A)((Object)this);
    }

    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public ArtifactsNested<A> withNewArtifacts() {
        return new ArtifactsNested(null);
    }

    public ArtifactsNested<A> withNewArtifactsLike(Artifacts item) {
        return new ArtifactsNested(item);
    }

    public ProvenanceNested<A> withNewProvenance() {
        return new ProvenanceNested(null);
    }

    public ProvenanceNested<A> withNewProvenanceLike(Provenance item) {
        return new ProvenanceNested(item);
    }

    public TaskSpecNested<A> withNewTaskSpec() {
        return new TaskSpecNested(null);
    }

    public TaskSpecNested<A> withNewTaskSpecLike(TaskSpec item) {
        return new TaskSpecNested(item);
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)((Object)this);
    }

    public A withPodName(String podName) {
        this.podName = podName;
        return (A)((Object)this);
    }

    public A withProvenance(Provenance provenance) {
        this._visitables.remove((Object)"provenance");
        if (provenance != null) {
            this.provenance = new ProvenanceBuilder(provenance);
            this._visitables.get((Object)"provenance").add(this.provenance);
        } else {
            this.provenance = null;
            this._visitables.get((Object)"provenance").remove((Object)this.provenance);
        }
        return (A)((Object)this);
    }

    public A withResults(List<TaskRunResult> results) {
        if (this.results != null) {
            this._visitables.get((Object)"results").clear();
        }
        if (results != null) {
            this.results = new ArrayList();
            for (TaskRunResult item : results) {
                this.addToResults(item);
            }
        } else {
            this.results = null;
        }
        return (A)((Object)this);
    }

    public A withResults(TaskRunResult ... results) {
        if (this.results != null) {
            this.results.clear();
            this._visitables.remove((Object)"results");
        }
        if (results != null) {
            for (TaskRunResult item : results) {
                this.addToResults(item);
            }
        }
        return (A)((Object)this);
    }

    public A withRetriesStatus(List<TaskRunStatus> retriesStatus) {
        if (this.retriesStatus != null) {
            this._visitables.get((Object)"retriesStatus").clear();
        }
        if (retriesStatus != null) {
            this.retriesStatus = new ArrayList();
            for (TaskRunStatus item : retriesStatus) {
                this.addToRetriesStatus(item);
            }
        } else {
            this.retriesStatus = null;
        }
        return (A)((Object)this);
    }

    public A withRetriesStatus(TaskRunStatus ... retriesStatus) {
        if (this.retriesStatus != null) {
            this.retriesStatus.clear();
            this._visitables.remove((Object)"retriesStatus");
        }
        if (retriesStatus != null) {
            for (TaskRunStatus item : retriesStatus) {
                this.addToRetriesStatus(item);
            }
        }
        return (A)((Object)this);
    }

    public A withSidecars(List<SidecarState> sidecars) {
        if (this.sidecars != null) {
            this._visitables.get((Object)"sidecars").clear();
        }
        if (sidecars != null) {
            this.sidecars = new ArrayList();
            for (SidecarState item : sidecars) {
                this.addToSidecars(item);
            }
        } else {
            this.sidecars = null;
        }
        return (A)((Object)this);
    }

    public A withSidecars(SidecarState ... sidecars) {
        if (this.sidecars != null) {
            this.sidecars.clear();
            this._visitables.remove((Object)"sidecars");
        }
        if (sidecars != null) {
            for (SidecarState item : sidecars) {
                this.addToSidecars(item);
            }
        }
        return (A)((Object)this);
    }

    public <K, V> A withSpanContext(Map<String, String> spanContext) {
        this.spanContext = spanContext == null ? null : new LinkedHashMap<String, String>(spanContext);
        return (A)((Object)this);
    }

    public A withStartTime(String startTime) {
        this.startTime = startTime;
        return (A)((Object)this);
    }

    public A withSteps(List<StepState> steps) {
        if (this.steps != null) {
            this._visitables.get((Object)"steps").clear();
        }
        if (steps != null) {
            this.steps = new ArrayList();
            for (StepState item : steps) {
                this.addToSteps(item);
            }
        } else {
            this.steps = null;
        }
        return (A)((Object)this);
    }

    public A withSteps(StepState ... steps) {
        if (this.steps != null) {
            this.steps.clear();
            this._visitables.remove((Object)"steps");
        }
        if (steps != null) {
            for (StepState item : steps) {
                this.addToSteps(item);
            }
        }
        return (A)((Object)this);
    }

    public A withTaskSpec(TaskSpec taskSpec) {
        this._visitables.remove((Object)"taskSpec");
        if (taskSpec != null) {
            this.taskSpec = new TaskSpecBuilder(taskSpec);
            this._visitables.get((Object)"taskSpec").add(this.taskSpec);
        } else {
            this.taskSpec = null;
            this._visitables.get((Object)"taskSpec").remove((Object)this.taskSpec);
        }
        return (A)((Object)this);
    }

    public class TaskSpecNested<N>
    extends TaskSpecFluent<TaskSpecNested<N>>
    implements Nested<N> {
        TaskSpecBuilder builder;

        TaskSpecNested(TaskSpec item) {
            this.builder = new TaskSpecBuilder(this, item);
        }

        public N and() {
            return (N)TaskRunStatusFluent.this.withTaskSpec(this.builder.build());
        }

        public N endTaskSpec() {
            return this.and();
        }
    }

    public class StepsNested<N>
    extends StepStateFluent<StepsNested<N>>
    implements Nested<N> {
        StepStateBuilder builder;
        int index;

        StepsNested(int index, StepState item) {
            this.index = index;
            this.builder = new StepStateBuilder(this, item);
        }

        public N and() {
            return (N)TaskRunStatusFluent.this.setToSteps(this.index, this.builder.build());
        }

        public N endStep() {
            return this.and();
        }
    }

    public class SidecarsNested<N>
    extends SidecarStateFluent<SidecarsNested<N>>
    implements Nested<N> {
        SidecarStateBuilder builder;
        int index;

        SidecarsNested(int index, SidecarState item) {
            this.index = index;
            this.builder = new SidecarStateBuilder(this, item);
        }

        public N and() {
            return (N)TaskRunStatusFluent.this.setToSidecars(this.index, this.builder.build());
        }

        public N endSidecar() {
            return this.and();
        }
    }

    public class RetriesStatusNested<N>
    extends TaskRunStatusFluent<RetriesStatusNested<N>>
    implements Nested<N> {
        TaskRunStatusBuilder builder;
        int index;

        RetriesStatusNested(int index, TaskRunStatus item) {
            this.index = index;
            this.builder = new TaskRunStatusBuilder(this, item);
        }

        public N and() {
            return (N)TaskRunStatusFluent.this.setToRetriesStatus(this.index, this.builder.build());
        }

        public N endRetriesStatus() {
            return this.and();
        }
    }

    public class ResultsNested<N>
    extends TaskRunResultFluent<ResultsNested<N>>
    implements Nested<N> {
        TaskRunResultBuilder builder;
        int index;

        ResultsNested(int index, TaskRunResult item) {
            this.index = index;
            this.builder = new TaskRunResultBuilder(this, item);
        }

        public N and() {
            return (N)TaskRunStatusFluent.this.setToResults(this.index, this.builder.build());
        }

        public N endResult() {
            return this.and();
        }
    }

    public class ProvenanceNested<N>
    extends ProvenanceFluent<ProvenanceNested<N>>
    implements Nested<N> {
        ProvenanceBuilder builder;

        ProvenanceNested(Provenance item) {
            this.builder = new ProvenanceBuilder(this, item);
        }

        public N and() {
            return (N)TaskRunStatusFluent.this.withProvenance(this.builder.build());
        }

        public N endProvenance() {
            return this.and();
        }
    }

    public class ArtifactsNested<N>
    extends ArtifactsFluent<ArtifactsNested<N>>
    implements Nested<N> {
        ArtifactsBuilder builder;

        ArtifactsNested(Artifacts item) {
            this.builder = new ArtifactsBuilder(this, item);
        }

        public N and() {
            return (N)TaskRunStatusFluent.this.withArtifacts(this.builder.build());
        }

        public N endArtifacts() {
            return this.and();
        }
    }
}

