/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Duration;
import io.fabric8.kubernetes.api.model.EnvFromSource;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.model.SecurityContext;
import io.fabric8.kubernetes.api.model.VolumeDevice;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.VolumeMountFluent;
import io.fabric8.tekton.v1.Param;
import io.fabric8.tekton.v1.ParamBuilder;
import io.fabric8.tekton.v1.ParamFluent;
import io.fabric8.tekton.v1.Ref;
import io.fabric8.tekton.v1.RefBuilder;
import io.fabric8.tekton.v1.RefFluent;
import io.fabric8.tekton.v1.Step;
import io.fabric8.tekton.v1.StepOutputConfig;
import io.fabric8.tekton.v1.StepOutputConfigBuilder;
import io.fabric8.tekton.v1.StepOutputConfigFluent;
import io.fabric8.tekton.v1.StepResult;
import io.fabric8.tekton.v1.StepResultBuilder;
import io.fabric8.tekton.v1.StepResultFluent;
import io.fabric8.tekton.v1.WhenExpression;
import io.fabric8.tekton.v1.WhenExpressionBuilder;
import io.fabric8.tekton.v1.WhenExpressionFluent;
import io.fabric8.tekton.v1.WorkspaceUsage;
import io.fabric8.tekton.v1.WorkspaceUsageBuilder;
import io.fabric8.tekton.v1.WorkspaceUsageFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class StepFluent<A extends StepFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private List<String> args = new ArrayList<String>();
    private List<String> command = new ArrayList<String>();
    private ResourceRequirementsBuilder computeResources;
    private ArrayList<EnvVarBuilder> env = new ArrayList();
    private List<EnvFromSource> envFrom = new ArrayList<EnvFromSource>();
    private String image;
    private String imagePullPolicy;
    private String name;
    private String onError;
    private ArrayList<ParamBuilder> params = new ArrayList();
    private RefBuilder ref;
    private ArrayList<StepResultBuilder> results = new ArrayList();
    private String script;
    private SecurityContext securityContext;
    private StepOutputConfigBuilder stderrConfig;
    private StepOutputConfigBuilder stdoutConfig;
    private Duration timeout;
    private List<VolumeDevice> volumeDevices = new ArrayList<VolumeDevice>();
    private ArrayList<VolumeMountBuilder> volumeMounts = new ArrayList();
    private ArrayList<WhenExpressionBuilder> when = new ArrayList();
    private String workingDir;
    private ArrayList<WorkspaceUsageBuilder> workspaces = new ArrayList();

    public StepFluent() {
    }

    public StepFluent(Step instance) {
        this.copyInstance(instance);
    }

    public A addAllToArgs(Collection<String> items) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        for (String item : items) {
            this.args.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToCommand(Collection<String> items) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        for (String item : items) {
            this.command.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToEnv(Collection<EnvVar> items) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToEnvFrom(Collection<EnvFromSource> items) {
        if (this.envFrom == null) {
            this.envFrom = new ArrayList<EnvFromSource>();
        }
        for (EnvFromSource item : items) {
            this.envFrom.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToParams(Collection<Param> items) {
        if (this.params == null) {
            this.params = new ArrayList();
        }
        for (Param item : items) {
            ParamBuilder builder = new ParamBuilder(item);
            this._visitables.get((Object)"params").add(builder);
            this.params.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToResults(Collection<StepResult> items) {
        if (this.results == null) {
            this.results = new ArrayList();
        }
        for (StepResult item : items) {
            StepResultBuilder builder = new StepResultBuilder(item);
            this._visitables.get((Object)"results").add(builder);
            this.results.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToVolumeDevices(Collection<VolumeDevice> items) {
        if (this.volumeDevices == null) {
            this.volumeDevices = new ArrayList<VolumeDevice>();
        }
        for (VolumeDevice item : items) {
            this.volumeDevices.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToVolumeMounts(Collection<VolumeMount> items) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList();
        }
        for (VolumeMount item : items) {
            VolumeMountBuilder builder = new VolumeMountBuilder(item);
            this._visitables.get((Object)"volumeMounts").add(builder);
            this.volumeMounts.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToWhen(Collection<WhenExpression> items) {
        if (this.when == null) {
            this.when = new ArrayList();
        }
        for (WhenExpression item : items) {
            WhenExpressionBuilder builder = new WhenExpressionBuilder(item);
            this._visitables.get((Object)"when").add(builder);
            this.when.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToWorkspaces(Collection<WorkspaceUsage> items) {
        if (this.workspaces == null) {
            this.workspaces = new ArrayList();
        }
        for (WorkspaceUsage item : items) {
            WorkspaceUsageBuilder builder = new WorkspaceUsageBuilder(item);
            this._visitables.get((Object)"workspaces").add(builder);
            this.workspaces.add(builder);
        }
        return (A)((Object)this);
    }

    public EnvNested<A> addNewEnv() {
        return new EnvNested(-1, null);
    }

    public EnvNested<A> addNewEnvLike(EnvVar item) {
        return new EnvNested(-1, item);
    }

    public ParamsNested<A> addNewParam() {
        return new ParamsNested(-1, null);
    }

    public ParamsNested<A> addNewParamLike(Param item) {
        return new ParamsNested(-1, item);
    }

    public ResultsNested<A> addNewResult() {
        return new ResultsNested(-1, null);
    }

    public ResultsNested<A> addNewResultLike(StepResult item) {
        return new ResultsNested(-1, item);
    }

    public A addNewVolumeDevice(String devicePath, String name) {
        return this.addToVolumeDevices(new VolumeDevice(devicePath, name));
    }

    public VolumeMountsNested<A> addNewVolumeMount() {
        return new VolumeMountsNested(-1, null);
    }

    public VolumeMountsNested<A> addNewVolumeMountLike(VolumeMount item) {
        return new VolumeMountsNested(-1, item);
    }

    public WhenNested<A> addNewWhen() {
        return new WhenNested(-1, null);
    }

    public WhenNested<A> addNewWhenLike(WhenExpression item) {
        return new WhenNested(-1, item);
    }

    public WorkspacesNested<A> addNewWorkspace() {
        return new WorkspacesNested(-1, null);
    }

    public A addNewWorkspace(String mountPath, String name) {
        return this.addToWorkspaces(new WorkspaceUsage(mountPath, name));
    }

    public WorkspacesNested<A> addNewWorkspaceLike(WorkspaceUsage item) {
        return new WorkspacesNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToArgs(String ... items) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        for (String item : items) {
            this.args.add(item);
        }
        return (A)((Object)this);
    }

    public A addToArgs(int index, String item) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        this.args.add(index, item);
        return (A)((Object)this);
    }

    public A addToCommand(String ... items) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        for (String item : items) {
            this.command.add(item);
        }
        return (A)((Object)this);
    }

    public A addToCommand(int index, String item) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.add(index, item);
        return (A)((Object)this);
    }

    public A addToEnv(EnvVar ... items) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToEnv(int index, EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        EnvVarBuilder builder = new EnvVarBuilder(item);
        if (index < 0 || index >= this.env.size()) {
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        } else {
            this._visitables.get((Object)"env").add(builder);
            this.env.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToEnvFrom(EnvFromSource ... items) {
        if (this.envFrom == null) {
            this.envFrom = new ArrayList<EnvFromSource>();
        }
        for (EnvFromSource item : items) {
            this.envFrom.add(item);
        }
        return (A)((Object)this);
    }

    public A addToEnvFrom(int index, EnvFromSource item) {
        if (this.envFrom == null) {
            this.envFrom = new ArrayList<EnvFromSource>();
        }
        this.envFrom.add(index, item);
        return (A)((Object)this);
    }

    public A addToParams(Param ... items) {
        if (this.params == null) {
            this.params = new ArrayList();
        }
        for (Param item : items) {
            ParamBuilder builder = new ParamBuilder(item);
            this._visitables.get((Object)"params").add(builder);
            this.params.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToParams(int index, Param item) {
        if (this.params == null) {
            this.params = new ArrayList();
        }
        ParamBuilder builder = new ParamBuilder(item);
        if (index < 0 || index >= this.params.size()) {
            this._visitables.get((Object)"params").add(builder);
            this.params.add(builder);
        } else {
            this._visitables.get((Object)"params").add(builder);
            this.params.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToResults(StepResult ... items) {
        if (this.results == null) {
            this.results = new ArrayList();
        }
        for (StepResult item : items) {
            StepResultBuilder builder = new StepResultBuilder(item);
            this._visitables.get((Object)"results").add(builder);
            this.results.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToResults(int index, StepResult item) {
        if (this.results == null) {
            this.results = new ArrayList();
        }
        StepResultBuilder builder = new StepResultBuilder(item);
        if (index < 0 || index >= this.results.size()) {
            this._visitables.get((Object)"results").add(builder);
            this.results.add(builder);
        } else {
            this._visitables.get((Object)"results").add(builder);
            this.results.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToVolumeDevices(VolumeDevice ... items) {
        if (this.volumeDevices == null) {
            this.volumeDevices = new ArrayList<VolumeDevice>();
        }
        for (VolumeDevice item : items) {
            this.volumeDevices.add(item);
        }
        return (A)((Object)this);
    }

    public A addToVolumeDevices(int index, VolumeDevice item) {
        if (this.volumeDevices == null) {
            this.volumeDevices = new ArrayList<VolumeDevice>();
        }
        this.volumeDevices.add(index, item);
        return (A)((Object)this);
    }

    public A addToVolumeMounts(VolumeMount ... items) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList();
        }
        for (VolumeMount item : items) {
            VolumeMountBuilder builder = new VolumeMountBuilder(item);
            this._visitables.get((Object)"volumeMounts").add(builder);
            this.volumeMounts.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToVolumeMounts(int index, VolumeMount item) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList();
        }
        VolumeMountBuilder builder = new VolumeMountBuilder(item);
        if (index < 0 || index >= this.volumeMounts.size()) {
            this._visitables.get((Object)"volumeMounts").add(builder);
            this.volumeMounts.add(builder);
        } else {
            this._visitables.get((Object)"volumeMounts").add(builder);
            this.volumeMounts.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToWhen(WhenExpression ... items) {
        if (this.when == null) {
            this.when = new ArrayList();
        }
        for (WhenExpression item : items) {
            WhenExpressionBuilder builder = new WhenExpressionBuilder(item);
            this._visitables.get((Object)"when").add(builder);
            this.when.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToWhen(int index, WhenExpression item) {
        if (this.when == null) {
            this.when = new ArrayList();
        }
        WhenExpressionBuilder builder = new WhenExpressionBuilder(item);
        if (index < 0 || index >= this.when.size()) {
            this._visitables.get((Object)"when").add(builder);
            this.when.add(builder);
        } else {
            this._visitables.get((Object)"when").add(builder);
            this.when.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToWorkspaces(WorkspaceUsage ... items) {
        if (this.workspaces == null) {
            this.workspaces = new ArrayList();
        }
        for (WorkspaceUsage item : items) {
            WorkspaceUsageBuilder builder = new WorkspaceUsageBuilder(item);
            this._visitables.get((Object)"workspaces").add(builder);
            this.workspaces.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToWorkspaces(int index, WorkspaceUsage item) {
        if (this.workspaces == null) {
            this.workspaces = new ArrayList();
        }
        WorkspaceUsageBuilder builder = new WorkspaceUsageBuilder(item);
        if (index < 0 || index >= this.workspaces.size()) {
            this._visitables.get((Object)"workspaces").add(builder);
            this.workspaces.add(builder);
        } else {
            this._visitables.get((Object)"workspaces").add(builder);
            this.workspaces.add(index, builder);
        }
        return (A)((Object)this);
    }

    public ResourceRequirements buildComputeResources() {
        return this.computeResources != null ? this.computeResources.build() : null;
    }

    public List<EnvVar> buildEnv() {
        return this.env != null ? StepFluent.build(this.env) : null;
    }

    public EnvVar buildEnv(int index) {
        return this.env.get(index).build();
    }

    public EnvVar buildFirstEnv() {
        return this.env.get(0).build();
    }

    public Param buildFirstParam() {
        return this.params.get(0).build();
    }

    public StepResult buildFirstResult() {
        return this.results.get(0).build();
    }

    public VolumeMount buildFirstVolumeMount() {
        return this.volumeMounts.get(0).build();
    }

    public WhenExpression buildFirstWhen() {
        return this.when.get(0).build();
    }

    public WorkspaceUsage buildFirstWorkspace() {
        return this.workspaces.get(0).build();
    }

    public EnvVar buildLastEnv() {
        return this.env.get(this.env.size() - 1).build();
    }

    public Param buildLastParam() {
        return this.params.get(this.params.size() - 1).build();
    }

    public StepResult buildLastResult() {
        return this.results.get(this.results.size() - 1).build();
    }

    public VolumeMount buildLastVolumeMount() {
        return this.volumeMounts.get(this.volumeMounts.size() - 1).build();
    }

    public WhenExpression buildLastWhen() {
        return this.when.get(this.when.size() - 1).build();
    }

    public WorkspaceUsage buildLastWorkspace() {
        return this.workspaces.get(this.workspaces.size() - 1).build();
    }

    public EnvVar buildMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        for (EnvVarBuilder item : this.env) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public Param buildMatchingParam(Predicate<ParamBuilder> predicate) {
        for (ParamBuilder item : this.params) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public StepResult buildMatchingResult(Predicate<StepResultBuilder> predicate) {
        for (StepResultBuilder item : this.results) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public VolumeMount buildMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
        for (VolumeMountBuilder item : this.volumeMounts) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public WhenExpression buildMatchingWhen(Predicate<WhenExpressionBuilder> predicate) {
        for (WhenExpressionBuilder item : this.when) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public WorkspaceUsage buildMatchingWorkspace(Predicate<WorkspaceUsageBuilder> predicate) {
        for (WorkspaceUsageBuilder item : this.workspaces) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public Param buildParam(int index) {
        return this.params.get(index).build();
    }

    public List<Param> buildParams() {
        return this.params != null ? StepFluent.build(this.params) : null;
    }

    public Ref buildRef() {
        return this.ref != null ? this.ref.build() : null;
    }

    public StepResult buildResult(int index) {
        return this.results.get(index).build();
    }

    public List<StepResult> buildResults() {
        return this.results != null ? StepFluent.build(this.results) : null;
    }

    public StepOutputConfig buildStderrConfig() {
        return this.stderrConfig != null ? this.stderrConfig.build() : null;
    }

    public StepOutputConfig buildStdoutConfig() {
        return this.stdoutConfig != null ? this.stdoutConfig.build() : null;
    }

    public VolumeMount buildVolumeMount(int index) {
        return this.volumeMounts.get(index).build();
    }

    public List<VolumeMount> buildVolumeMounts() {
        return this.volumeMounts != null ? StepFluent.build(this.volumeMounts) : null;
    }

    public List<WhenExpression> buildWhen() {
        return this.when != null ? StepFluent.build(this.when) : null;
    }

    public WhenExpression buildWhen(int index) {
        return this.when.get(index).build();
    }

    public WorkspaceUsage buildWorkspace(int index) {
        return this.workspaces.get(index).build();
    }

    public List<WorkspaceUsage> buildWorkspaces() {
        return this.workspaces != null ? StepFluent.build(this.workspaces) : null;
    }

    protected void copyInstance(Step instance) {
        Step step = instance = instance != null ? instance : new Step();
        if (instance != null) {
            this.withArgs(instance.getArgs());
            this.withCommand(instance.getCommand());
            this.withComputeResources(instance.getComputeResources());
            this.withEnv(instance.getEnv());
            this.withEnvFrom(instance.getEnvFrom());
            this.withImage(instance.getImage());
            this.withImagePullPolicy(instance.getImagePullPolicy());
            this.withName(instance.getName());
            this.withOnError(instance.getOnError());
            this.withParams(instance.getParams());
            this.withRef(instance.getRef());
            this.withResults(instance.getResults());
            this.withScript(instance.getScript());
            this.withSecurityContext(instance.getSecurityContext());
            this.withStderrConfig(instance.getStderrConfig());
            this.withStdoutConfig(instance.getStdoutConfig());
            this.withTimeout(instance.getTimeout());
            this.withVolumeDevices(instance.getVolumeDevices());
            this.withVolumeMounts(instance.getVolumeMounts());
            this.withWhen(instance.getWhen());
            this.withWorkingDir(instance.getWorkingDir());
            this.withWorkspaces(instance.getWorkspaces());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ComputeResourcesNested<A> editComputeResources() {
        return this.withNewComputeResourcesLike(Optional.ofNullable(this.buildComputeResources()).orElse(null));
    }

    public EnvNested<A> editEnv(int index) {
        if (this.env.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "env"));
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public EnvNested<A> editFirstEnv() {
        if (this.env.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "env"));
        }
        return this.setNewEnvLike(0, this.buildEnv(0));
    }

    public ParamsNested<A> editFirstParam() {
        if (this.params.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "params"));
        }
        return this.setNewParamLike(0, this.buildParam(0));
    }

    public ResultsNested<A> editFirstResult() {
        if (this.results.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "results"));
        }
        return this.setNewResultLike(0, this.buildResult(0));
    }

    public VolumeMountsNested<A> editFirstVolumeMount() {
        if (this.volumeMounts.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "volumeMounts"));
        }
        return this.setNewVolumeMountLike(0, this.buildVolumeMount(0));
    }

    public WhenNested<A> editFirstWhen() {
        if (this.when.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "when"));
        }
        return this.setNewWhenLike(0, this.buildWhen(0));
    }

    public WorkspacesNested<A> editFirstWorkspace() {
        if (this.workspaces.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "workspaces"));
        }
        return this.setNewWorkspaceLike(0, this.buildWorkspace(0));
    }

    public EnvNested<A> editLastEnv() {
        int index = this.env.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "env"));
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public ParamsNested<A> editLastParam() {
        int index = this.params.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "params"));
        }
        return this.setNewParamLike(index, this.buildParam(index));
    }

    public ResultsNested<A> editLastResult() {
        int index = this.results.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "results"));
        }
        return this.setNewResultLike(index, this.buildResult(index));
    }

    public VolumeMountsNested<A> editLastVolumeMount() {
        int index = this.volumeMounts.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "volumeMounts"));
        }
        return this.setNewVolumeMountLike(index, this.buildVolumeMount(index));
    }

    public WhenNested<A> editLastWhen() {
        int index = this.when.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "when"));
        }
        return this.setNewWhenLike(index, this.buildWhen(index));
    }

    public WorkspacesNested<A> editLastWorkspace() {
        int index = this.workspaces.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "workspaces"));
        }
        return this.setNewWorkspaceLike(index, this.buildWorkspace(index));
    }

    public EnvNested<A> editMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.env.size(); ++i) {
            if (!predicate.test(this.env.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "env"));
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public ParamsNested<A> editMatchingParam(Predicate<ParamBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.params.size(); ++i) {
            if (!predicate.test(this.params.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "params"));
        }
        return this.setNewParamLike(index, this.buildParam(index));
    }

    public ResultsNested<A> editMatchingResult(Predicate<StepResultBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.results.size(); ++i) {
            if (!predicate.test(this.results.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "results"));
        }
        return this.setNewResultLike(index, this.buildResult(index));
    }

    public VolumeMountsNested<A> editMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumeMounts.size(); ++i) {
            if (!predicate.test(this.volumeMounts.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "volumeMounts"));
        }
        return this.setNewVolumeMountLike(index, this.buildVolumeMount(index));
    }

    public WhenNested<A> editMatchingWhen(Predicate<WhenExpressionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.when.size(); ++i) {
            if (!predicate.test(this.when.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "when"));
        }
        return this.setNewWhenLike(index, this.buildWhen(index));
    }

    public WorkspacesNested<A> editMatchingWorkspace(Predicate<WorkspaceUsageBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.workspaces.size(); ++i) {
            if (!predicate.test(this.workspaces.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "workspaces"));
        }
        return this.setNewWorkspaceLike(index, this.buildWorkspace(index));
    }

    public ComputeResourcesNested<A> editOrNewComputeResources() {
        return this.withNewComputeResourcesLike(Optional.ofNullable(this.buildComputeResources()).orElse(new ResourceRequirementsBuilder().build()));
    }

    public ComputeResourcesNested<A> editOrNewComputeResourcesLike(ResourceRequirements item) {
        return this.withNewComputeResourcesLike(Optional.ofNullable(this.buildComputeResources()).orElse(item));
    }

    public RefNested<A> editOrNewRef() {
        return this.withNewRefLike(Optional.ofNullable(this.buildRef()).orElse(new RefBuilder().build()));
    }

    public RefNested<A> editOrNewRefLike(Ref item) {
        return this.withNewRefLike(Optional.ofNullable(this.buildRef()).orElse(item));
    }

    public StderrConfigNested<A> editOrNewStderrConfig() {
        return this.withNewStderrConfigLike(Optional.ofNullable(this.buildStderrConfig()).orElse(new StepOutputConfigBuilder().build()));
    }

    public StderrConfigNested<A> editOrNewStderrConfigLike(StepOutputConfig item) {
        return this.withNewStderrConfigLike(Optional.ofNullable(this.buildStderrConfig()).orElse(item));
    }

    public StdoutConfigNested<A> editOrNewStdoutConfig() {
        return this.withNewStdoutConfigLike(Optional.ofNullable(this.buildStdoutConfig()).orElse(new StepOutputConfigBuilder().build()));
    }

    public StdoutConfigNested<A> editOrNewStdoutConfigLike(StepOutputConfig item) {
        return this.withNewStdoutConfigLike(Optional.ofNullable(this.buildStdoutConfig()).orElse(item));
    }

    public ParamsNested<A> editParam(int index) {
        if (this.params.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "params"));
        }
        return this.setNewParamLike(index, this.buildParam(index));
    }

    public RefNested<A> editRef() {
        return this.withNewRefLike(Optional.ofNullable(this.buildRef()).orElse(null));
    }

    public ResultsNested<A> editResult(int index) {
        if (this.results.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "results"));
        }
        return this.setNewResultLike(index, this.buildResult(index));
    }

    public StderrConfigNested<A> editStderrConfig() {
        return this.withNewStderrConfigLike(Optional.ofNullable(this.buildStderrConfig()).orElse(null));
    }

    public StdoutConfigNested<A> editStdoutConfig() {
        return this.withNewStdoutConfigLike(Optional.ofNullable(this.buildStdoutConfig()).orElse(null));
    }

    public VolumeMountsNested<A> editVolumeMount(int index) {
        if (this.volumeMounts.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "volumeMounts"));
        }
        return this.setNewVolumeMountLike(index, this.buildVolumeMount(index));
    }

    public WhenNested<A> editWhen(int index) {
        if (this.when.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "when"));
        }
        return this.setNewWhenLike(index, this.buildWhen(index));
    }

    public WorkspacesNested<A> editWorkspace(int index) {
        if (this.workspaces.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "workspaces"));
        }
        return this.setNewWorkspaceLike(index, this.buildWorkspace(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StepFluent that = (StepFluent)((Object)o);
        if (!Objects.equals(this.args, that.args)) {
            return false;
        }
        if (!Objects.equals(this.command, that.command)) {
            return false;
        }
        if (!Objects.equals(this.computeResources, that.computeResources)) {
            return false;
        }
        if (!Objects.equals(this.env, that.env)) {
            return false;
        }
        if (!Objects.equals(this.envFrom, that.envFrom)) {
            return false;
        }
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals(this.imagePullPolicy, that.imagePullPolicy)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.onError, that.onError)) {
            return false;
        }
        if (!Objects.equals(this.params, that.params)) {
            return false;
        }
        if (!Objects.equals((Object)this.ref, (Object)that.ref)) {
            return false;
        }
        if (!Objects.equals(this.results, that.results)) {
            return false;
        }
        if (!Objects.equals(this.script, that.script)) {
            return false;
        }
        if (!Objects.equals(this.securityContext, that.securityContext)) {
            return false;
        }
        if (!Objects.equals((Object)this.stderrConfig, (Object)that.stderrConfig)) {
            return false;
        }
        if (!Objects.equals((Object)this.stdoutConfig, (Object)that.stdoutConfig)) {
            return false;
        }
        if (!Objects.equals(this.timeout, that.timeout)) {
            return false;
        }
        if (!Objects.equals(this.volumeDevices, that.volumeDevices)) {
            return false;
        }
        if (!Objects.equals(this.volumeMounts, that.volumeMounts)) {
            return false;
        }
        if (!Objects.equals(this.when, that.when)) {
            return false;
        }
        if (!Objects.equals(this.workingDir, that.workingDir)) {
            return false;
        }
        if (!Objects.equals(this.workspaces, that.workspaces)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getArg(int index) {
        return this.args.get(index);
    }

    public List<String> getArgs() {
        return this.args;
    }

    public List<String> getCommand() {
        return this.command;
    }

    public String getCommand(int index) {
        return this.command.get(index);
    }

    public List<EnvFromSource> getEnvFrom() {
        return this.envFrom;
    }

    public EnvFromSource getEnvFrom(int index) {
        return this.envFrom.get(index);
    }

    public String getFirstArg() {
        return this.args.get(0);
    }

    public String getFirstCommand() {
        return this.command.get(0);
    }

    public EnvFromSource getFirstEnvFrom() {
        return this.envFrom.get(0);
    }

    public VolumeDevice getFirstVolumeDevice() {
        return this.volumeDevices.get(0);
    }

    public String getImage() {
        return this.image;
    }

    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public String getLastArg() {
        return this.args.get(this.args.size() - 1);
    }

    public String getLastCommand() {
        return this.command.get(this.command.size() - 1);
    }

    public EnvFromSource getLastEnvFrom() {
        return this.envFrom.get(this.envFrom.size() - 1);
    }

    public VolumeDevice getLastVolumeDevice() {
        return this.volumeDevices.get(this.volumeDevices.size() - 1);
    }

    public String getMatchingArg(Predicate<String> predicate) {
        for (String item : this.args) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getMatchingCommand(Predicate<String> predicate) {
        for (String item : this.command) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public EnvFromSource getMatchingEnvFrom(Predicate<EnvFromSource> predicate) {
        for (EnvFromSource item : this.envFrom) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public VolumeDevice getMatchingVolumeDevice(Predicate<VolumeDevice> predicate) {
        for (VolumeDevice item : this.volumeDevices) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getOnError() {
        return this.onError;
    }

    public String getScript() {
        return this.script;
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public VolumeDevice getVolumeDevice(int index) {
        return this.volumeDevices.get(index);
    }

    public List<VolumeDevice> getVolumeDevices() {
        return this.volumeDevices;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasArgs() {
        return this.args != null && !this.args.isEmpty();
    }

    public boolean hasCommand() {
        return this.command != null && !this.command.isEmpty();
    }

    public boolean hasComputeResources() {
        return this.computeResources != null;
    }

    public boolean hasEnv() {
        return this.env != null && !this.env.isEmpty();
    }

    public boolean hasEnvFrom() {
        return this.envFrom != null && !this.envFrom.isEmpty();
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public boolean hasImagePullPolicy() {
        return this.imagePullPolicy != null;
    }

    public boolean hasMatchingArg(Predicate<String> predicate) {
        for (String item : this.args) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingCommand(Predicate<String> predicate) {
        for (String item : this.command) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        for (EnvVarBuilder item : this.env) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingEnvFrom(Predicate<EnvFromSource> predicate) {
        for (EnvFromSource item : this.envFrom) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingParam(Predicate<ParamBuilder> predicate) {
        for (ParamBuilder item : this.params) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingResult(Predicate<StepResultBuilder> predicate) {
        for (StepResultBuilder item : this.results) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingVolumeDevice(Predicate<VolumeDevice> predicate) {
        for (VolumeDevice item : this.volumeDevices) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
        for (VolumeMountBuilder item : this.volumeMounts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingWhen(Predicate<WhenExpressionBuilder> predicate) {
        for (WhenExpressionBuilder item : this.when) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingWorkspace(Predicate<WorkspaceUsageBuilder> predicate) {
        for (WorkspaceUsageBuilder item : this.workspaces) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean hasOnError() {
        return this.onError != null;
    }

    public boolean hasParams() {
        return this.params != null && !this.params.isEmpty();
    }

    public boolean hasRef() {
        return this.ref != null;
    }

    public boolean hasResults() {
        return this.results != null && !this.results.isEmpty();
    }

    public boolean hasScript() {
        return this.script != null;
    }

    public boolean hasSecurityContext() {
        return this.securityContext != null;
    }

    public boolean hasStderrConfig() {
        return this.stderrConfig != null;
    }

    public boolean hasStdoutConfig() {
        return this.stdoutConfig != null;
    }

    public boolean hasTimeout() {
        return this.timeout != null;
    }

    public boolean hasVolumeDevices() {
        return this.volumeDevices != null && !this.volumeDevices.isEmpty();
    }

    public boolean hasVolumeMounts() {
        return this.volumeMounts != null && !this.volumeMounts.isEmpty();
    }

    public boolean hasWhen() {
        return this.when != null && !this.when.isEmpty();
    }

    public boolean hasWorkingDir() {
        return this.workingDir != null;
    }

    public boolean hasWorkspaces() {
        return this.workspaces != null && !this.workspaces.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.args, this.command, this.computeResources, this.env, this.envFrom, this.image, this.imagePullPolicy, this.name, this.onError, this.params, this.ref, this.results, this.script, this.securityContext, this.stderrConfig, this.stdoutConfig, this.timeout, this.volumeDevices, this.volumeMounts, this.when, this.workingDir, this.workspaces, this.additionalProperties});
    }

    public A removeAllFromArgs(Collection<String> items) {
        if (this.args == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.args.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromCommand(Collection<String> items) {
        if (this.command == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.command.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromEnv(Collection<EnvVar> items) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get((Object)"env").remove(builder);
            this.env.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromEnvFrom(Collection<EnvFromSource> items) {
        if (this.envFrom == null) {
            return (A)((Object)this);
        }
        for (EnvFromSource item : items) {
            this.envFrom.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromParams(Collection<Param> items) {
        if (this.params == null) {
            return (A)((Object)this);
        }
        for (Param item : items) {
            ParamBuilder builder = new ParamBuilder(item);
            this._visitables.get((Object)"params").remove((Object)builder);
            this.params.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromResults(Collection<StepResult> items) {
        if (this.results == null) {
            return (A)((Object)this);
        }
        for (StepResult item : items) {
            StepResultBuilder builder = new StepResultBuilder(item);
            this._visitables.get((Object)"results").remove((Object)builder);
            this.results.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromVolumeDevices(Collection<VolumeDevice> items) {
        if (this.volumeDevices == null) {
            return (A)((Object)this);
        }
        for (VolumeDevice item : items) {
            this.volumeDevices.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromVolumeMounts(Collection<VolumeMount> items) {
        if (this.volumeMounts == null) {
            return (A)((Object)this);
        }
        for (VolumeMount item : items) {
            VolumeMountBuilder builder = new VolumeMountBuilder(item);
            this._visitables.get((Object)"volumeMounts").remove(builder);
            this.volumeMounts.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromWhen(Collection<WhenExpression> items) {
        if (this.when == null) {
            return (A)((Object)this);
        }
        for (WhenExpression item : items) {
            WhenExpressionBuilder builder = new WhenExpressionBuilder(item);
            this._visitables.get((Object)"when").remove((Object)builder);
            this.when.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromWorkspaces(Collection<WorkspaceUsage> items) {
        if (this.workspaces == null) {
            return (A)((Object)this);
        }
        for (WorkspaceUsage item : items) {
            WorkspaceUsageBuilder builder = new WorkspaceUsageBuilder(item);
            this._visitables.get((Object)"workspaces").remove((Object)builder);
            this.workspaces.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromArgs(String ... items) {
        if (this.args == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.args.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromCommand(String ... items) {
        if (this.command == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.command.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromEnv(EnvVar ... items) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get((Object)"env").remove(builder);
            this.env.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromEnvFrom(EnvFromSource ... items) {
        if (this.envFrom == null) {
            return (A)((Object)this);
        }
        for (EnvFromSource item : items) {
            this.envFrom.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromParams(Param ... items) {
        if (this.params == null) {
            return (A)((Object)this);
        }
        for (Param item : items) {
            ParamBuilder builder = new ParamBuilder(item);
            this._visitables.get((Object)"params").remove((Object)builder);
            this.params.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromResults(StepResult ... items) {
        if (this.results == null) {
            return (A)((Object)this);
        }
        for (StepResult item : items) {
            StepResultBuilder builder = new StepResultBuilder(item);
            this._visitables.get((Object)"results").remove((Object)builder);
            this.results.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromVolumeDevices(VolumeDevice ... items) {
        if (this.volumeDevices == null) {
            return (A)((Object)this);
        }
        for (VolumeDevice item : items) {
            this.volumeDevices.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromVolumeMounts(VolumeMount ... items) {
        if (this.volumeMounts == null) {
            return (A)((Object)this);
        }
        for (VolumeMount item : items) {
            VolumeMountBuilder builder = new VolumeMountBuilder(item);
            this._visitables.get((Object)"volumeMounts").remove(builder);
            this.volumeMounts.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromWhen(WhenExpression ... items) {
        if (this.when == null) {
            return (A)((Object)this);
        }
        for (WhenExpression item : items) {
            WhenExpressionBuilder builder = new WhenExpressionBuilder(item);
            this._visitables.get((Object)"when").remove((Object)builder);
            this.when.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromWorkspaces(WorkspaceUsage ... items) {
        if (this.workspaces == null) {
            return (A)((Object)this);
        }
        for (WorkspaceUsage item : items) {
            WorkspaceUsageBuilder builder = new WorkspaceUsageBuilder(item);
            this._visitables.get((Object)"workspaces").remove((Object)builder);
            this.workspaces.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromEnv(Predicate<EnvVarBuilder> predicate) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        Iterator<EnvVarBuilder> each = this.env.iterator();
        List visitables = this._visitables.get((Object)"env");
        while (each.hasNext()) {
            EnvVarBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromParams(Predicate<ParamBuilder> predicate) {
        if (this.params == null) {
            return (A)((Object)this);
        }
        Iterator<ParamBuilder> each = this.params.iterator();
        List visitables = this._visitables.get((Object)"params");
        while (each.hasNext()) {
            ParamBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromResults(Predicate<StepResultBuilder> predicate) {
        if (this.results == null) {
            return (A)((Object)this);
        }
        Iterator<StepResultBuilder> each = this.results.iterator();
        List visitables = this._visitables.get((Object)"results");
        while (each.hasNext()) {
            StepResultBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromVolumeMounts(Predicate<VolumeMountBuilder> predicate) {
        if (this.volumeMounts == null) {
            return (A)((Object)this);
        }
        Iterator<VolumeMountBuilder> each = this.volumeMounts.iterator();
        List visitables = this._visitables.get((Object)"volumeMounts");
        while (each.hasNext()) {
            VolumeMountBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromWhen(Predicate<WhenExpressionBuilder> predicate) {
        if (this.when == null) {
            return (A)((Object)this);
        }
        Iterator<WhenExpressionBuilder> each = this.when.iterator();
        List visitables = this._visitables.get((Object)"when");
        while (each.hasNext()) {
            WhenExpressionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromWorkspaces(Predicate<WorkspaceUsageBuilder> predicate) {
        if (this.workspaces == null) {
            return (A)((Object)this);
        }
        Iterator<WorkspaceUsageBuilder> each = this.workspaces.iterator();
        List visitables = this._visitables.get((Object)"workspaces");
        while (each.hasNext()) {
            WorkspaceUsageBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public EnvNested<A> setNewEnvLike(int index, EnvVar item) {
        return new EnvNested(index, item);
    }

    public ParamsNested<A> setNewParamLike(int index, Param item) {
        return new ParamsNested(index, item);
    }

    public ResultsNested<A> setNewResultLike(int index, StepResult item) {
        return new ResultsNested(index, item);
    }

    public VolumeMountsNested<A> setNewVolumeMountLike(int index, VolumeMount item) {
        return new VolumeMountsNested(index, item);
    }

    public WhenNested<A> setNewWhenLike(int index, WhenExpression item) {
        return new WhenNested(index, item);
    }

    public WorkspacesNested<A> setNewWorkspaceLike(int index, WorkspaceUsage item) {
        return new WorkspacesNested(index, item);
    }

    public A setToArgs(int index, String item) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        this.args.set(index, item);
        return (A)((Object)this);
    }

    public A setToCommand(int index, String item) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.set(index, item);
        return (A)((Object)this);
    }

    public A setToEnv(int index, EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        EnvVarBuilder builder = new EnvVarBuilder(item);
        if (index < 0 || index >= this.env.size()) {
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        } else {
            this._visitables.get((Object)"env").add(builder);
            this.env.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToEnvFrom(int index, EnvFromSource item) {
        if (this.envFrom == null) {
            this.envFrom = new ArrayList<EnvFromSource>();
        }
        this.envFrom.set(index, item);
        return (A)((Object)this);
    }

    public A setToParams(int index, Param item) {
        if (this.params == null) {
            this.params = new ArrayList();
        }
        ParamBuilder builder = new ParamBuilder(item);
        if (index < 0 || index >= this.params.size()) {
            this._visitables.get((Object)"params").add(builder);
            this.params.add(builder);
        } else {
            this._visitables.get((Object)"params").add(builder);
            this.params.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToResults(int index, StepResult item) {
        if (this.results == null) {
            this.results = new ArrayList();
        }
        StepResultBuilder builder = new StepResultBuilder(item);
        if (index < 0 || index >= this.results.size()) {
            this._visitables.get((Object)"results").add(builder);
            this.results.add(builder);
        } else {
            this._visitables.get((Object)"results").add(builder);
            this.results.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToVolumeDevices(int index, VolumeDevice item) {
        if (this.volumeDevices == null) {
            this.volumeDevices = new ArrayList<VolumeDevice>();
        }
        this.volumeDevices.set(index, item);
        return (A)((Object)this);
    }

    public A setToVolumeMounts(int index, VolumeMount item) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList();
        }
        VolumeMountBuilder builder = new VolumeMountBuilder(item);
        if (index < 0 || index >= this.volumeMounts.size()) {
            this._visitables.get((Object)"volumeMounts").add(builder);
            this.volumeMounts.add(builder);
        } else {
            this._visitables.get((Object)"volumeMounts").add(builder);
            this.volumeMounts.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToWhen(int index, WhenExpression item) {
        if (this.when == null) {
            this.when = new ArrayList();
        }
        WhenExpressionBuilder builder = new WhenExpressionBuilder(item);
        if (index < 0 || index >= this.when.size()) {
            this._visitables.get((Object)"when").add(builder);
            this.when.add(builder);
        } else {
            this._visitables.get((Object)"when").add(builder);
            this.when.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToWorkspaces(int index, WorkspaceUsage item) {
        if (this.workspaces == null) {
            this.workspaces = new ArrayList();
        }
        WorkspaceUsageBuilder builder = new WorkspaceUsageBuilder(item);
        if (index < 0 || index >= this.workspaces.size()) {
            this._visitables.get((Object)"workspaces").add(builder);
            this.workspaces.add(builder);
        } else {
            this._visitables.get((Object)"workspaces").add(builder);
            this.workspaces.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.args != null && !this.args.isEmpty()) {
            sb.append("args:");
            sb.append(this.args);
            sb.append(",");
        }
        if (this.command != null && !this.command.isEmpty()) {
            sb.append("command:");
            sb.append(this.command);
            sb.append(",");
        }
        if (this.computeResources != null) {
            sb.append("computeResources:");
            sb.append(this.computeResources);
            sb.append(",");
        }
        if (this.env != null && !this.env.isEmpty()) {
            sb.append("env:");
            sb.append(this.env);
            sb.append(",");
        }
        if (this.envFrom != null && !this.envFrom.isEmpty()) {
            sb.append("envFrom:");
            sb.append(this.envFrom);
            sb.append(",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image);
            sb.append(",");
        }
        if (this.imagePullPolicy != null) {
            sb.append("imagePullPolicy:");
            sb.append(this.imagePullPolicy);
            sb.append(",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name);
            sb.append(",");
        }
        if (this.onError != null) {
            sb.append("onError:");
            sb.append(this.onError);
            sb.append(",");
        }
        if (this.params != null && !this.params.isEmpty()) {
            sb.append("params:");
            sb.append(this.params);
            sb.append(",");
        }
        if (this.ref != null) {
            sb.append("ref:");
            sb.append((Object)this.ref);
            sb.append(",");
        }
        if (this.results != null && !this.results.isEmpty()) {
            sb.append("results:");
            sb.append(this.results);
            sb.append(",");
        }
        if (this.script != null) {
            sb.append("script:");
            sb.append(this.script);
            sb.append(",");
        }
        if (this.securityContext != null) {
            sb.append("securityContext:");
            sb.append(this.securityContext);
            sb.append(",");
        }
        if (this.stderrConfig != null) {
            sb.append("stderrConfig:");
            sb.append((Object)this.stderrConfig);
            sb.append(",");
        }
        if (this.stdoutConfig != null) {
            sb.append("stdoutConfig:");
            sb.append((Object)this.stdoutConfig);
            sb.append(",");
        }
        if (this.timeout != null) {
            sb.append("timeout:");
            sb.append(this.timeout);
            sb.append(",");
        }
        if (this.volumeDevices != null && !this.volumeDevices.isEmpty()) {
            sb.append("volumeDevices:");
            sb.append(this.volumeDevices);
            sb.append(",");
        }
        if (this.volumeMounts != null && !this.volumeMounts.isEmpty()) {
            sb.append("volumeMounts:");
            sb.append(this.volumeMounts);
            sb.append(",");
        }
        if (this.when != null && !this.when.isEmpty()) {
            sb.append("when:");
            sb.append(this.when);
            sb.append(",");
        }
        if (this.workingDir != null) {
            sb.append("workingDir:");
            sb.append(this.workingDir);
            sb.append(",");
        }
        if (this.workspaces != null && !this.workspaces.isEmpty()) {
            sb.append("workspaces:");
            sb.append(this.workspaces);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withArgs(List<String> args) {
        if (args != null) {
            this.args = new ArrayList<String>();
            for (String item : args) {
                this.addToArgs(item);
            }
        } else {
            this.args = null;
        }
        return (A)((Object)this);
    }

    public A withArgs(String ... args) {
        if (this.args != null) {
            this.args.clear();
            this._visitables.remove((Object)"args");
        }
        if (args != null) {
            for (String item : args) {
                this.addToArgs(item);
            }
        }
        return (A)((Object)this);
    }

    public A withCommand(List<String> command) {
        if (command != null) {
            this.command = new ArrayList<String>();
            for (String item : command) {
                this.addToCommand(item);
            }
        } else {
            this.command = null;
        }
        return (A)((Object)this);
    }

    public A withCommand(String ... command) {
        if (this.command != null) {
            this.command.clear();
            this._visitables.remove((Object)"command");
        }
        if (command != null) {
            for (String item : command) {
                this.addToCommand(item);
            }
        }
        return (A)((Object)this);
    }

    public A withComputeResources(ResourceRequirements computeResources) {
        this._visitables.remove((Object)"computeResources");
        if (computeResources != null) {
            this.computeResources = new ResourceRequirementsBuilder(computeResources);
            this._visitables.get((Object)"computeResources").add(this.computeResources);
        } else {
            this.computeResources = null;
            this._visitables.get((Object)"computeResources").remove(this.computeResources);
        }
        return (A)((Object)this);
    }

    public A withEnv(List<EnvVar> env) {
        if (this.env != null) {
            this._visitables.get((Object)"env").clear();
        }
        if (env != null) {
            this.env = new ArrayList();
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        } else {
            this.env = null;
        }
        return (A)((Object)this);
    }

    public A withEnv(EnvVar ... env) {
        if (this.env != null) {
            this.env.clear();
            this._visitables.remove((Object)"env");
        }
        if (env != null) {
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (A)((Object)this);
    }

    public A withEnvFrom(List<EnvFromSource> envFrom) {
        if (envFrom != null) {
            this.envFrom = new ArrayList<EnvFromSource>();
            for (EnvFromSource item : envFrom) {
                this.addToEnvFrom(item);
            }
        } else {
            this.envFrom = null;
        }
        return (A)((Object)this);
    }

    public A withEnvFrom(EnvFromSource ... envFrom) {
        if (this.envFrom != null) {
            this.envFrom.clear();
            this._visitables.remove((Object)"envFrom");
        }
        if (envFrom != null) {
            for (EnvFromSource item : envFrom) {
                this.addToEnvFrom(item);
            }
        }
        return (A)((Object)this);
    }

    public A withImage(String image) {
        this.image = image;
        return (A)((Object)this);
    }

    public A withImagePullPolicy(String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
        return (A)((Object)this);
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public ComputeResourcesNested<A> withNewComputeResources() {
        return new ComputeResourcesNested(null);
    }

    public ComputeResourcesNested<A> withNewComputeResourcesLike(ResourceRequirements item) {
        return new ComputeResourcesNested(item);
    }

    public RefNested<A> withNewRef() {
        return new RefNested(null);
    }

    public A withNewRef(String name) {
        return this.withRef(new Ref(name));
    }

    public RefNested<A> withNewRefLike(Ref item) {
        return new RefNested(item);
    }

    public StderrConfigNested<A> withNewStderrConfig() {
        return new StderrConfigNested(null);
    }

    public A withNewStderrConfig(String path) {
        return this.withStderrConfig(new StepOutputConfig(path));
    }

    public StderrConfigNested<A> withNewStderrConfigLike(StepOutputConfig item) {
        return new StderrConfigNested(item);
    }

    public StdoutConfigNested<A> withNewStdoutConfig() {
        return new StdoutConfigNested(null);
    }

    public A withNewStdoutConfig(String path) {
        return this.withStdoutConfig(new StepOutputConfig(path));
    }

    public StdoutConfigNested<A> withNewStdoutConfigLike(StepOutputConfig item) {
        return new StdoutConfigNested(item);
    }

    public A withOnError(String onError) {
        this.onError = onError;
        return (A)((Object)this);
    }

    public A withParams(List<Param> params) {
        if (this.params != null) {
            this._visitables.get((Object)"params").clear();
        }
        if (params != null) {
            this.params = new ArrayList();
            for (Param item : params) {
                this.addToParams(item);
            }
        } else {
            this.params = null;
        }
        return (A)((Object)this);
    }

    public A withParams(Param ... params) {
        if (this.params != null) {
            this.params.clear();
            this._visitables.remove((Object)"params");
        }
        if (params != null) {
            for (Param item : params) {
                this.addToParams(item);
            }
        }
        return (A)((Object)this);
    }

    public A withRef(Ref ref) {
        this._visitables.remove((Object)"ref");
        if (ref != null) {
            this.ref = new RefBuilder(ref);
            this._visitables.get((Object)"ref").add(this.ref);
        } else {
            this.ref = null;
            this._visitables.get((Object)"ref").remove((Object)this.ref);
        }
        return (A)((Object)this);
    }

    public A withResults(List<StepResult> results) {
        if (this.results != null) {
            this._visitables.get((Object)"results").clear();
        }
        if (results != null) {
            this.results = new ArrayList();
            for (StepResult item : results) {
                this.addToResults(item);
            }
        } else {
            this.results = null;
        }
        return (A)((Object)this);
    }

    public A withResults(StepResult ... results) {
        if (this.results != null) {
            this.results.clear();
            this._visitables.remove((Object)"results");
        }
        if (results != null) {
            for (StepResult item : results) {
                this.addToResults(item);
            }
        }
        return (A)((Object)this);
    }

    public A withScript(String script) {
        this.script = script;
        return (A)((Object)this);
    }

    public A withSecurityContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
        return (A)((Object)this);
    }

    public A withStderrConfig(StepOutputConfig stderrConfig) {
        this._visitables.remove((Object)"stderrConfig");
        if (stderrConfig != null) {
            this.stderrConfig = new StepOutputConfigBuilder(stderrConfig);
            this._visitables.get((Object)"stderrConfig").add(this.stderrConfig);
        } else {
            this.stderrConfig = null;
            this._visitables.get((Object)"stderrConfig").remove((Object)this.stderrConfig);
        }
        return (A)((Object)this);
    }

    public A withStdoutConfig(StepOutputConfig stdoutConfig) {
        this._visitables.remove((Object)"stdoutConfig");
        if (stdoutConfig != null) {
            this.stdoutConfig = new StepOutputConfigBuilder(stdoutConfig);
            this._visitables.get((Object)"stdoutConfig").add(this.stdoutConfig);
        } else {
            this.stdoutConfig = null;
            this._visitables.get((Object)"stdoutConfig").remove((Object)this.stdoutConfig);
        }
        return (A)((Object)this);
    }

    public A withTimeout(Duration timeout) {
        this.timeout = timeout;
        return (A)((Object)this);
    }

    public A withVolumeDevices(List<VolumeDevice> volumeDevices) {
        if (volumeDevices != null) {
            this.volumeDevices = new ArrayList<VolumeDevice>();
            for (VolumeDevice item : volumeDevices) {
                this.addToVolumeDevices(item);
            }
        } else {
            this.volumeDevices = null;
        }
        return (A)((Object)this);
    }

    public A withVolumeDevices(VolumeDevice ... volumeDevices) {
        if (this.volumeDevices != null) {
            this.volumeDevices.clear();
            this._visitables.remove((Object)"volumeDevices");
        }
        if (volumeDevices != null) {
            for (VolumeDevice item : volumeDevices) {
                this.addToVolumeDevices(item);
            }
        }
        return (A)((Object)this);
    }

    public A withVolumeMounts(List<VolumeMount> volumeMounts) {
        if (this.volumeMounts != null) {
            this._visitables.get((Object)"volumeMounts").clear();
        }
        if (volumeMounts != null) {
            this.volumeMounts = new ArrayList();
            for (VolumeMount item : volumeMounts) {
                this.addToVolumeMounts(item);
            }
        } else {
            this.volumeMounts = null;
        }
        return (A)((Object)this);
    }

    public A withVolumeMounts(VolumeMount ... volumeMounts) {
        if (this.volumeMounts != null) {
            this.volumeMounts.clear();
            this._visitables.remove((Object)"volumeMounts");
        }
        if (volumeMounts != null) {
            for (VolumeMount item : volumeMounts) {
                this.addToVolumeMounts(item);
            }
        }
        return (A)((Object)this);
    }

    public A withWhen(List<WhenExpression> when) {
        if (this.when != null) {
            this._visitables.get((Object)"when").clear();
        }
        if (when != null) {
            this.when = new ArrayList();
            for (WhenExpression item : when) {
                this.addToWhen(item);
            }
        } else {
            this.when = null;
        }
        return (A)((Object)this);
    }

    public A withWhen(WhenExpression ... when) {
        if (this.when != null) {
            this.when.clear();
            this._visitables.remove((Object)"when");
        }
        if (when != null) {
            for (WhenExpression item : when) {
                this.addToWhen(item);
            }
        }
        return (A)((Object)this);
    }

    public A withWorkingDir(String workingDir) {
        this.workingDir = workingDir;
        return (A)((Object)this);
    }

    public A withWorkspaces(List<WorkspaceUsage> workspaces) {
        if (this.workspaces != null) {
            this._visitables.get((Object)"workspaces").clear();
        }
        if (workspaces != null) {
            this.workspaces = new ArrayList();
            for (WorkspaceUsage item : workspaces) {
                this.addToWorkspaces(item);
            }
        } else {
            this.workspaces = null;
        }
        return (A)((Object)this);
    }

    public A withWorkspaces(WorkspaceUsage ... workspaces) {
        if (this.workspaces != null) {
            this.workspaces.clear();
            this._visitables.remove((Object)"workspaces");
        }
        if (workspaces != null) {
            for (WorkspaceUsage item : workspaces) {
                this.addToWorkspaces(item);
            }
        }
        return (A)((Object)this);
    }

    public class WorkspacesNested<N>
    extends WorkspaceUsageFluent<WorkspacesNested<N>>
    implements Nested<N> {
        WorkspaceUsageBuilder builder;
        int index;

        WorkspacesNested(int index, WorkspaceUsage item) {
            this.index = index;
            this.builder = new WorkspaceUsageBuilder(this, item);
        }

        public N and() {
            return (N)StepFluent.this.setToWorkspaces(this.index, this.builder.build());
        }

        public N endWorkspace() {
            return this.and();
        }
    }

    public class WhenNested<N>
    extends WhenExpressionFluent<WhenNested<N>>
    implements Nested<N> {
        WhenExpressionBuilder builder;
        int index;

        WhenNested(int index, WhenExpression item) {
            this.index = index;
            this.builder = new WhenExpressionBuilder(this, item);
        }

        public N and() {
            return (N)StepFluent.this.setToWhen(this.index, this.builder.build());
        }

        public N endWhen() {
            return this.and();
        }
    }

    public class VolumeMountsNested<N>
    extends VolumeMountFluent<VolumeMountsNested<N>>
    implements Nested<N> {
        VolumeMountBuilder builder;
        int index;

        VolumeMountsNested(int index, VolumeMount item) {
            this.index = index;
            this.builder = new VolumeMountBuilder((VolumeMountFluent)this, item);
        }

        public N and() {
            return (N)StepFluent.this.setToVolumeMounts(this.index, this.builder.build());
        }

        public N endVolumeMount() {
            return this.and();
        }
    }

    public class StdoutConfigNested<N>
    extends StepOutputConfigFluent<StdoutConfigNested<N>>
    implements Nested<N> {
        StepOutputConfigBuilder builder;

        StdoutConfigNested(StepOutputConfig item) {
            this.builder = new StepOutputConfigBuilder(this, item);
        }

        public N and() {
            return (N)StepFluent.this.withStdoutConfig(this.builder.build());
        }

        public N endStdoutConfig() {
            return this.and();
        }
    }

    public class StderrConfigNested<N>
    extends StepOutputConfigFluent<StderrConfigNested<N>>
    implements Nested<N> {
        StepOutputConfigBuilder builder;

        StderrConfigNested(StepOutputConfig item) {
            this.builder = new StepOutputConfigBuilder(this, item);
        }

        public N and() {
            return (N)StepFluent.this.withStderrConfig(this.builder.build());
        }

        public N endStderrConfig() {
            return this.and();
        }
    }

    public class ResultsNested<N>
    extends StepResultFluent<ResultsNested<N>>
    implements Nested<N> {
        StepResultBuilder builder;
        int index;

        ResultsNested(int index, StepResult item) {
            this.index = index;
            this.builder = new StepResultBuilder(this, item);
        }

        public N and() {
            return (N)StepFluent.this.setToResults(this.index, this.builder.build());
        }

        public N endResult() {
            return this.and();
        }
    }

    public class RefNested<N>
    extends RefFluent<RefNested<N>>
    implements Nested<N> {
        RefBuilder builder;

        RefNested(Ref item) {
            this.builder = new RefBuilder(this, item);
        }

        public N and() {
            return (N)StepFluent.this.withRef(this.builder.build());
        }

        public N endRef() {
            return this.and();
        }
    }

    public class ParamsNested<N>
    extends ParamFluent<ParamsNested<N>>
    implements Nested<N> {
        ParamBuilder builder;
        int index;

        ParamsNested(int index, Param item) {
            this.index = index;
            this.builder = new ParamBuilder(this, item);
        }

        public N and() {
            return (N)StepFluent.this.setToParams(this.index, this.builder.build());
        }

        public N endParam() {
            return this.and();
        }
    }

    public class EnvNested<N>
    extends EnvVarFluent<EnvNested<N>>
    implements Nested<N> {
        EnvVarBuilder builder;
        int index;

        EnvNested(int index, EnvVar item) {
            this.index = index;
            this.builder = new EnvVarBuilder((EnvVarFluent)this, item);
        }

        public N and() {
            return (N)StepFluent.this.setToEnv(this.index, this.builder.build());
        }

        public N endEnv() {
            return this.and();
        }
    }

    public class ComputeResourcesNested<N>
    extends ResourceRequirementsFluent<ComputeResourcesNested<N>>
    implements Nested<N> {
        ResourceRequirementsBuilder builder;

        ComputeResourcesNested(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder((ResourceRequirementsFluent)this, item);
        }

        public N and() {
            return (N)StepFluent.this.withComputeResources(this.builder.build());
        }

        public N endComputeResources() {
            return this.and();
        }
    }
}

