/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.ContainerStateRunning;
import io.fabric8.kubernetes.api.model.ContainerStateTerminated;
import io.fabric8.kubernetes.api.model.ContainerStateWaiting;
import io.fabric8.tekton.v1.SidecarState;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class SidecarStateFluent<A extends SidecarStateFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String container;
    private String imageID;
    private String name;
    private ContainerStateRunning running;
    private ContainerStateTerminated terminated;
    private ContainerStateWaiting waiting;

    public SidecarStateFluent() {
    }

    public SidecarStateFluent(SidecarState instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    protected void copyInstance(SidecarState instance) {
        SidecarState sidecarState = instance = instance != null ? instance : new SidecarState();
        if (instance != null) {
            this.withContainer(instance.getContainer());
            this.withImageID(instance.getImageID());
            this.withName(instance.getName());
            this.withRunning(instance.getRunning());
            this.withTerminated(instance.getTerminated());
            this.withWaiting(instance.getWaiting());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SidecarStateFluent that = (SidecarStateFluent)((Object)o);
        if (!Objects.equals(this.container, that.container)) {
            return false;
        }
        if (!Objects.equals(this.imageID, that.imageID)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.running, that.running)) {
            return false;
        }
        if (!Objects.equals(this.terminated, that.terminated)) {
            return false;
        }
        if (!Objects.equals(this.waiting, that.waiting)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getContainer() {
        return this.container;
    }

    public String getImageID() {
        return this.imageID;
    }

    public String getName() {
        return this.name;
    }

    public ContainerStateRunning getRunning() {
        return this.running;
    }

    public ContainerStateTerminated getTerminated() {
        return this.terminated;
    }

    public ContainerStateWaiting getWaiting() {
        return this.waiting;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasContainer() {
        return this.container != null;
    }

    public boolean hasImageID() {
        return this.imageID != null;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean hasRunning() {
        return this.running != null;
    }

    public boolean hasTerminated() {
        return this.terminated != null;
    }

    public boolean hasWaiting() {
        return this.waiting != null;
    }

    public int hashCode() {
        return Objects.hash(this.container, this.imageID, this.name, this.running, this.terminated, this.waiting, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.container != null) {
            sb.append("container:");
            sb.append(this.container);
            sb.append(",");
        }
        if (this.imageID != null) {
            sb.append("imageID:");
            sb.append(this.imageID);
            sb.append(",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name);
            sb.append(",");
        }
        if (this.running != null) {
            sb.append("running:");
            sb.append(this.running);
            sb.append(",");
        }
        if (this.terminated != null) {
            sb.append("terminated:");
            sb.append(this.terminated);
            sb.append(",");
        }
        if (this.waiting != null) {
            sb.append("waiting:");
            sb.append(this.waiting);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withContainer(String container) {
        this.container = container;
        return (A)((Object)this);
    }

    public A withImageID(String imageID) {
        this.imageID = imageID;
        return (A)((Object)this);
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public A withNewRunning(String startedAt) {
        return this.withRunning(new ContainerStateRunning(startedAt));
    }

    public A withNewWaiting(String message, String reason) {
        return this.withWaiting(new ContainerStateWaiting(message, reason));
    }

    public A withRunning(ContainerStateRunning running) {
        this.running = running;
        return (A)((Object)this);
    }

    public A withTerminated(ContainerStateTerminated terminated) {
        this.terminated = terminated;
        return (A)((Object)this);
    }

    public A withWaiting(ContainerStateWaiting waiting) {
        this.waiting = waiting;
        return (A)((Object)this);
    }
}

