/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.tekton.v1.Artifact;
import io.fabric8.tekton.v1.ArtifactValue;
import io.fabric8.tekton.v1.ArtifactValueBuilder;
import io.fabric8.tekton.v1.ArtifactValueFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ArtifactFluent<A extends ArtifactFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private Boolean buildOutput;
    private String name;
    private ArrayList<ArtifactValueBuilder> values = new ArrayList();

    public ArtifactFluent() {
    }

    public ArtifactFluent(Artifact instance) {
        this.copyInstance(instance);
    }

    public A addAllToValues(Collection<ArtifactValue> items) {
        if (this.values == null) {
            this.values = new ArrayList();
        }
        for (ArtifactValue item : items) {
            ArtifactValueBuilder builder = new ArtifactValueBuilder(item);
            this._visitables.get((Object)"values").add(builder);
            this.values.add(builder);
        }
        return (A)((Object)this);
    }

    public ValuesNested<A> addNewValue() {
        return new ValuesNested(-1, null);
    }

    public ValuesNested<A> addNewValueLike(ArtifactValue item) {
        return new ValuesNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToValues(ArtifactValue ... items) {
        if (this.values == null) {
            this.values = new ArrayList();
        }
        for (ArtifactValue item : items) {
            ArtifactValueBuilder builder = new ArtifactValueBuilder(item);
            this._visitables.get((Object)"values").add(builder);
            this.values.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToValues(int index, ArtifactValue item) {
        if (this.values == null) {
            this.values = new ArrayList();
        }
        ArtifactValueBuilder builder = new ArtifactValueBuilder(item);
        if (index < 0 || index >= this.values.size()) {
            this._visitables.get((Object)"values").add(builder);
            this.values.add(builder);
        } else {
            this._visitables.get((Object)"values").add(builder);
            this.values.add(index, builder);
        }
        return (A)((Object)this);
    }

    public ArtifactValue buildFirstValue() {
        return this.values.get(0).build();
    }

    public ArtifactValue buildLastValue() {
        return this.values.get(this.values.size() - 1).build();
    }

    public ArtifactValue buildMatchingValue(Predicate<ArtifactValueBuilder> predicate) {
        for (ArtifactValueBuilder item : this.values) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public ArtifactValue buildValue(int index) {
        return this.values.get(index).build();
    }

    public List<ArtifactValue> buildValues() {
        return this.values != null ? ArtifactFluent.build(this.values) : null;
    }

    protected void copyInstance(Artifact instance) {
        Artifact artifact = instance = instance != null ? instance : new Artifact();
        if (instance != null) {
            this.withBuildOutput(instance.getBuildOutput());
            this.withName(instance.getName());
            this.withValues(instance.getValues());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ValuesNested<A> editFirstValue() {
        if (this.values.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "values"));
        }
        return this.setNewValueLike(0, this.buildValue(0));
    }

    public ValuesNested<A> editLastValue() {
        int index = this.values.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "values"));
        }
        return this.setNewValueLike(index, this.buildValue(index));
    }

    public ValuesNested<A> editMatchingValue(Predicate<ArtifactValueBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.values.size(); ++i) {
            if (!predicate.test(this.values.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "values"));
        }
        return this.setNewValueLike(index, this.buildValue(index));
    }

    public ValuesNested<A> editValue(int index) {
        if (this.values.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "values"));
        }
        return this.setNewValueLike(index, this.buildValue(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ArtifactFluent that = (ArtifactFluent)((Object)o);
        if (!Objects.equals(this.buildOutput, that.buildOutput)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.values, that.values)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Boolean getBuildOutput() {
        return this.buildOutput;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasBuildOutput() {
        return this.buildOutput != null;
    }

    public boolean hasMatchingValue(Predicate<ArtifactValueBuilder> predicate) {
        for (ArtifactValueBuilder item : this.values) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean hasValues() {
        return this.values != null && !this.values.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.buildOutput, this.name, this.values, this.additionalProperties);
    }

    public A removeAllFromValues(Collection<ArtifactValue> items) {
        if (this.values == null) {
            return (A)((Object)this);
        }
        for (ArtifactValue item : items) {
            ArtifactValueBuilder builder = new ArtifactValueBuilder(item);
            this._visitables.get((Object)"values").remove((Object)builder);
            this.values.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromValues(ArtifactValue ... items) {
        if (this.values == null) {
            return (A)((Object)this);
        }
        for (ArtifactValue item : items) {
            ArtifactValueBuilder builder = new ArtifactValueBuilder(item);
            this._visitables.get((Object)"values").remove((Object)builder);
            this.values.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromValues(Predicate<ArtifactValueBuilder> predicate) {
        if (this.values == null) {
            return (A)((Object)this);
        }
        Iterator<ArtifactValueBuilder> each = this.values.iterator();
        List visitables = this._visitables.get((Object)"values");
        while (each.hasNext()) {
            ArtifactValueBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public ValuesNested<A> setNewValueLike(int index, ArtifactValue item) {
        return new ValuesNested(index, item);
    }

    public A setToValues(int index, ArtifactValue item) {
        if (this.values == null) {
            this.values = new ArrayList();
        }
        ArtifactValueBuilder builder = new ArtifactValueBuilder(item);
        if (index < 0 || index >= this.values.size()) {
            this._visitables.get((Object)"values").add(builder);
            this.values.add(builder);
        } else {
            this._visitables.get((Object)"values").add(builder);
            this.values.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.buildOutput != null) {
            sb.append("buildOutput:");
            sb.append(this.buildOutput);
            sb.append(",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name);
            sb.append(",");
        }
        if (this.values != null && !this.values.isEmpty()) {
            sb.append("values:");
            sb.append(this.values);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withBuildOutput() {
        return this.withBuildOutput(true);
    }

    public A withBuildOutput(Boolean buildOutput) {
        this.buildOutput = buildOutput;
        return (A)((Object)this);
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public A withValues(List<ArtifactValue> values) {
        if (this.values != null) {
            this._visitables.get((Object)"values").clear();
        }
        if (values != null) {
            this.values = new ArrayList();
            for (ArtifactValue item : values) {
                this.addToValues(item);
            }
        } else {
            this.values = null;
        }
        return (A)((Object)this);
    }

    public A withValues(ArtifactValue ... values) {
        if (this.values != null) {
            this.values.clear();
            this._visitables.remove((Object)"values");
        }
        if (values != null) {
            for (ArtifactValue item : values) {
                this.addToValues(item);
            }
        }
        return (A)((Object)this);
    }

    public class ValuesNested<N>
    extends ArtifactValueFluent<ValuesNested<N>>
    implements Nested<N> {
        ArtifactValueBuilder builder;
        int index;

        ValuesNested(int index, ArtifactValue item) {
            this.index = index;
            this.builder = new ArtifactValueBuilder(this, item);
        }

        public N and() {
            return (N)ArtifactFluent.this.setToValues(this.index, this.builder.build());
        }

        public N endValue() {
            return this.and();
        }
    }
}

