/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.triggers.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.tekton.triggers.v1beta1.EventListenerTriggerGroup;
import io.fabric8.tekton.triggers.v1beta1.EventListenerTriggerSelector;
import io.fabric8.tekton.triggers.v1beta1.EventListenerTriggerSelectorBuilder;
import io.fabric8.tekton.triggers.v1beta1.EventListenerTriggerSelectorFluent;
import io.fabric8.tekton.triggers.v1beta1.TriggerInterceptor;
import io.fabric8.tekton.triggers.v1beta1.TriggerInterceptorBuilder;
import io.fabric8.tekton.triggers.v1beta1.TriggerInterceptorFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class EventListenerTriggerGroupFluent<A extends EventListenerTriggerGroupFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<TriggerInterceptorBuilder> interceptors = new ArrayList();
    private String name;
    private EventListenerTriggerSelectorBuilder triggerSelector;

    public EventListenerTriggerGroupFluent() {
    }

    public EventListenerTriggerGroupFluent(EventListenerTriggerGroup instance) {
        this.copyInstance(instance);
    }

    public A addAllToInterceptors(Collection<TriggerInterceptor> items) {
        if (this.interceptors == null) {
            this.interceptors = new ArrayList();
        }
        for (TriggerInterceptor item : items) {
            TriggerInterceptorBuilder builder = new TriggerInterceptorBuilder(item);
            this._visitables.get((Object)"interceptors").add(builder);
            this.interceptors.add(builder);
        }
        return (A)((Object)this);
    }

    public InterceptorsNested<A> addNewInterceptor() {
        return new InterceptorsNested(-1, null);
    }

    public InterceptorsNested<A> addNewInterceptorLike(TriggerInterceptor item) {
        return new InterceptorsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToInterceptors(TriggerInterceptor ... items) {
        if (this.interceptors == null) {
            this.interceptors = new ArrayList();
        }
        for (TriggerInterceptor item : items) {
            TriggerInterceptorBuilder builder = new TriggerInterceptorBuilder(item);
            this._visitables.get((Object)"interceptors").add(builder);
            this.interceptors.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToInterceptors(int index, TriggerInterceptor item) {
        if (this.interceptors == null) {
            this.interceptors = new ArrayList();
        }
        TriggerInterceptorBuilder builder = new TriggerInterceptorBuilder(item);
        if (index < 0 || index >= this.interceptors.size()) {
            this._visitables.get((Object)"interceptors").add(builder);
            this.interceptors.add(builder);
        } else {
            this._visitables.get((Object)"interceptors").add(builder);
            this.interceptors.add(index, builder);
        }
        return (A)((Object)this);
    }

    public TriggerInterceptor buildFirstInterceptor() {
        return this.interceptors.get(0).build();
    }

    public TriggerInterceptor buildInterceptor(int index) {
        return this.interceptors.get(index).build();
    }

    public List<TriggerInterceptor> buildInterceptors() {
        return this.interceptors != null ? EventListenerTriggerGroupFluent.build(this.interceptors) : null;
    }

    public TriggerInterceptor buildLastInterceptor() {
        return this.interceptors.get(this.interceptors.size() - 1).build();
    }

    public TriggerInterceptor buildMatchingInterceptor(Predicate<TriggerInterceptorBuilder> predicate) {
        for (TriggerInterceptorBuilder item : this.interceptors) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public EventListenerTriggerSelector buildTriggerSelector() {
        return this.triggerSelector != null ? this.triggerSelector.build() : null;
    }

    protected void copyInstance(EventListenerTriggerGroup instance) {
        EventListenerTriggerGroup eventListenerTriggerGroup = instance = instance != null ? instance : new EventListenerTriggerGroup();
        if (instance != null) {
            this.withInterceptors(instance.getInterceptors());
            this.withName(instance.getName());
            this.withTriggerSelector(instance.getTriggerSelector());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public InterceptorsNested<A> editFirstInterceptor() {
        if (this.interceptors.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "interceptors"));
        }
        return this.setNewInterceptorLike(0, this.buildInterceptor(0));
    }

    public InterceptorsNested<A> editInterceptor(int index) {
        if (this.interceptors.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "interceptors"));
        }
        return this.setNewInterceptorLike(index, this.buildInterceptor(index));
    }

    public InterceptorsNested<A> editLastInterceptor() {
        int index = this.interceptors.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "interceptors"));
        }
        return this.setNewInterceptorLike(index, this.buildInterceptor(index));
    }

    public InterceptorsNested<A> editMatchingInterceptor(Predicate<TriggerInterceptorBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.interceptors.size(); ++i) {
            if (!predicate.test(this.interceptors.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "interceptors"));
        }
        return this.setNewInterceptorLike(index, this.buildInterceptor(index));
    }

    public TriggerSelectorNested<A> editOrNewTriggerSelector() {
        return this.withNewTriggerSelectorLike(Optional.ofNullable(this.buildTriggerSelector()).orElse(new EventListenerTriggerSelectorBuilder().build()));
    }

    public TriggerSelectorNested<A> editOrNewTriggerSelectorLike(EventListenerTriggerSelector item) {
        return this.withNewTriggerSelectorLike(Optional.ofNullable(this.buildTriggerSelector()).orElse(item));
    }

    public TriggerSelectorNested<A> editTriggerSelector() {
        return this.withNewTriggerSelectorLike(Optional.ofNullable(this.buildTriggerSelector()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EventListenerTriggerGroupFluent that = (EventListenerTriggerGroupFluent)((Object)o);
        if (!Objects.equals(this.interceptors, that.interceptors)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals((Object)this.triggerSelector, (Object)that.triggerSelector)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasInterceptors() {
        return this.interceptors != null && !this.interceptors.isEmpty();
    }

    public boolean hasMatchingInterceptor(Predicate<TriggerInterceptorBuilder> predicate) {
        for (TriggerInterceptorBuilder item : this.interceptors) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean hasTriggerSelector() {
        return this.triggerSelector != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.interceptors, this.name, this.triggerSelector, this.additionalProperties});
    }

    public A removeAllFromInterceptors(Collection<TriggerInterceptor> items) {
        if (this.interceptors == null) {
            return (A)((Object)this);
        }
        for (TriggerInterceptor item : items) {
            TriggerInterceptorBuilder builder = new TriggerInterceptorBuilder(item);
            this._visitables.get((Object)"interceptors").remove((Object)builder);
            this.interceptors.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromInterceptors(TriggerInterceptor ... items) {
        if (this.interceptors == null) {
            return (A)((Object)this);
        }
        for (TriggerInterceptor item : items) {
            TriggerInterceptorBuilder builder = new TriggerInterceptorBuilder(item);
            this._visitables.get((Object)"interceptors").remove((Object)builder);
            this.interceptors.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromInterceptors(Predicate<TriggerInterceptorBuilder> predicate) {
        if (this.interceptors == null) {
            return (A)((Object)this);
        }
        Iterator<TriggerInterceptorBuilder> each = this.interceptors.iterator();
        List visitables = this._visitables.get((Object)"interceptors");
        while (each.hasNext()) {
            TriggerInterceptorBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public InterceptorsNested<A> setNewInterceptorLike(int index, TriggerInterceptor item) {
        return new InterceptorsNested(index, item);
    }

    public A setToInterceptors(int index, TriggerInterceptor item) {
        if (this.interceptors == null) {
            this.interceptors = new ArrayList();
        }
        TriggerInterceptorBuilder builder = new TriggerInterceptorBuilder(item);
        if (index < 0 || index >= this.interceptors.size()) {
            this._visitables.get((Object)"interceptors").add(builder);
            this.interceptors.add(builder);
        } else {
            this._visitables.get((Object)"interceptors").add(builder);
            this.interceptors.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.interceptors != null && !this.interceptors.isEmpty()) {
            sb.append("interceptors:");
            sb.append(this.interceptors);
            sb.append(",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name);
            sb.append(",");
        }
        if (this.triggerSelector != null) {
            sb.append("triggerSelector:");
            sb.append((Object)this.triggerSelector);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withInterceptors(List<TriggerInterceptor> interceptors) {
        if (this.interceptors != null) {
            this._visitables.get((Object)"interceptors").clear();
        }
        if (interceptors != null) {
            this.interceptors = new ArrayList();
            for (TriggerInterceptor item : interceptors) {
                this.addToInterceptors(item);
            }
        } else {
            this.interceptors = null;
        }
        return (A)((Object)this);
    }

    public A withInterceptors(TriggerInterceptor ... interceptors) {
        if (this.interceptors != null) {
            this.interceptors.clear();
            this._visitables.remove((Object)"interceptors");
        }
        if (interceptors != null) {
            for (TriggerInterceptor item : interceptors) {
                this.addToInterceptors(item);
            }
        }
        return (A)((Object)this);
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public TriggerSelectorNested<A> withNewTriggerSelector() {
        return new TriggerSelectorNested(null);
    }

    public TriggerSelectorNested<A> withNewTriggerSelectorLike(EventListenerTriggerSelector item) {
        return new TriggerSelectorNested(item);
    }

    public A withTriggerSelector(EventListenerTriggerSelector triggerSelector) {
        this._visitables.remove((Object)"triggerSelector");
        if (triggerSelector != null) {
            this.triggerSelector = new EventListenerTriggerSelectorBuilder(triggerSelector);
            this._visitables.get((Object)"triggerSelector").add(this.triggerSelector);
        } else {
            this.triggerSelector = null;
            this._visitables.get((Object)"triggerSelector").remove((Object)this.triggerSelector);
        }
        return (A)((Object)this);
    }

    public class TriggerSelectorNested<N>
    extends EventListenerTriggerSelectorFluent<TriggerSelectorNested<N>>
    implements Nested<N> {
        EventListenerTriggerSelectorBuilder builder;

        TriggerSelectorNested(EventListenerTriggerSelector item) {
            this.builder = new EventListenerTriggerSelectorBuilder(this, item);
        }

        public N and() {
            return (N)EventListenerTriggerGroupFluent.this.withTriggerSelector(this.builder.build());
        }

        public N endTriggerSelector() {
            return this.and();
        }
    }

    public class InterceptorsNested<N>
    extends TriggerInterceptorFluent<InterceptorsNested<N>>
    implements Nested<N> {
        TriggerInterceptorBuilder builder;
        int index;

        InterceptorsNested(int index, TriggerInterceptor item) {
            this.index = index;
            this.builder = new TriggerInterceptorBuilder(this, item);
        }

        public N and() {
            return (N)EventListenerTriggerGroupFluent.this.setToInterceptors(this.index, this.builder.build());
        }

        public N endInterceptor() {
            return this.and();
        }
    }
}

