/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.tekton.triggers.v1alpha1.EventListenerTrigger;
import io.fabric8.tekton.triggers.v1alpha1.TriggerInterceptor;
import io.fabric8.tekton.triggers.v1alpha1.TriggerInterceptorBuilder;
import io.fabric8.tekton.triggers.v1alpha1.TriggerInterceptorFluent;
import io.fabric8.tekton.triggers.v1alpha1.TriggerSpecBinding;
import io.fabric8.tekton.triggers.v1alpha1.TriggerSpecBindingBuilder;
import io.fabric8.tekton.triggers.v1alpha1.TriggerSpecBindingFluent;
import io.fabric8.tekton.triggers.v1alpha1.TriggerSpecTemplate;
import io.fabric8.tekton.triggers.v1alpha1.TriggerSpecTemplateBuilder;
import io.fabric8.tekton.triggers.v1alpha1.TriggerSpecTemplateFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class EventListenerTriggerFluent<A extends EventListenerTriggerFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<TriggerSpecBindingBuilder> bindings = new ArrayList();
    private ArrayList<TriggerInterceptorBuilder> interceptors = new ArrayList();
    private String name;
    private String serviceAccountName;
    private TriggerSpecTemplateBuilder template;
    private String triggerRef;

    public EventListenerTriggerFluent() {
    }

    public EventListenerTriggerFluent(EventListenerTrigger instance) {
        this.copyInstance(instance);
    }

    public A addAllToBindings(Collection<TriggerSpecBinding> items) {
        if (this.bindings == null) {
            this.bindings = new ArrayList();
        }
        for (TriggerSpecBinding item : items) {
            TriggerSpecBindingBuilder builder = new TriggerSpecBindingBuilder(item);
            this._visitables.get((Object)"bindings").add(builder);
            this.bindings.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToInterceptors(Collection<TriggerInterceptor> items) {
        if (this.interceptors == null) {
            this.interceptors = new ArrayList();
        }
        for (TriggerInterceptor item : items) {
            TriggerInterceptorBuilder builder = new TriggerInterceptorBuilder(item);
            this._visitables.get((Object)"interceptors").add(builder);
            this.interceptors.add(builder);
        }
        return (A)((Object)this);
    }

    public BindingsNested<A> addNewBinding() {
        return new BindingsNested(-1, null);
    }

    public A addNewBinding(String apiversion, String kind, String name, String ref, String value) {
        return this.addToBindings(new TriggerSpecBinding(apiversion, kind, name, ref, value));
    }

    public BindingsNested<A> addNewBindingLike(TriggerSpecBinding item) {
        return new BindingsNested(-1, item);
    }

    public InterceptorsNested<A> addNewInterceptor() {
        return new InterceptorsNested(-1, null);
    }

    public InterceptorsNested<A> addNewInterceptorLike(TriggerInterceptor item) {
        return new InterceptorsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToBindings(TriggerSpecBinding ... items) {
        if (this.bindings == null) {
            this.bindings = new ArrayList();
        }
        for (TriggerSpecBinding item : items) {
            TriggerSpecBindingBuilder builder = new TriggerSpecBindingBuilder(item);
            this._visitables.get((Object)"bindings").add(builder);
            this.bindings.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToBindings(int index, TriggerSpecBinding item) {
        if (this.bindings == null) {
            this.bindings = new ArrayList();
        }
        TriggerSpecBindingBuilder builder = new TriggerSpecBindingBuilder(item);
        if (index < 0 || index >= this.bindings.size()) {
            this._visitables.get((Object)"bindings").add(builder);
            this.bindings.add(builder);
        } else {
            this._visitables.get((Object)"bindings").add(builder);
            this.bindings.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToInterceptors(TriggerInterceptor ... items) {
        if (this.interceptors == null) {
            this.interceptors = new ArrayList();
        }
        for (TriggerInterceptor item : items) {
            TriggerInterceptorBuilder builder = new TriggerInterceptorBuilder(item);
            this._visitables.get((Object)"interceptors").add(builder);
            this.interceptors.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToInterceptors(int index, TriggerInterceptor item) {
        if (this.interceptors == null) {
            this.interceptors = new ArrayList();
        }
        TriggerInterceptorBuilder builder = new TriggerInterceptorBuilder(item);
        if (index < 0 || index >= this.interceptors.size()) {
            this._visitables.get((Object)"interceptors").add(builder);
            this.interceptors.add(builder);
        } else {
            this._visitables.get((Object)"interceptors").add(builder);
            this.interceptors.add(index, builder);
        }
        return (A)((Object)this);
    }

    public TriggerSpecBinding buildBinding(int index) {
        return this.bindings.get(index).build();
    }

    public List<TriggerSpecBinding> buildBindings() {
        return this.bindings != null ? EventListenerTriggerFluent.build(this.bindings) : null;
    }

    public TriggerSpecBinding buildFirstBinding() {
        return this.bindings.get(0).build();
    }

    public TriggerInterceptor buildFirstInterceptor() {
        return this.interceptors.get(0).build();
    }

    public TriggerInterceptor buildInterceptor(int index) {
        return this.interceptors.get(index).build();
    }

    public List<TriggerInterceptor> buildInterceptors() {
        return this.interceptors != null ? EventListenerTriggerFluent.build(this.interceptors) : null;
    }

    public TriggerSpecBinding buildLastBinding() {
        return this.bindings.get(this.bindings.size() - 1).build();
    }

    public TriggerInterceptor buildLastInterceptor() {
        return this.interceptors.get(this.interceptors.size() - 1).build();
    }

    public TriggerSpecBinding buildMatchingBinding(Predicate<TriggerSpecBindingBuilder> predicate) {
        for (TriggerSpecBindingBuilder item : this.bindings) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public TriggerInterceptor buildMatchingInterceptor(Predicate<TriggerInterceptorBuilder> predicate) {
        for (TriggerInterceptorBuilder item : this.interceptors) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public TriggerSpecTemplate buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    protected void copyInstance(EventListenerTrigger instance) {
        EventListenerTrigger eventListenerTrigger = instance = instance != null ? instance : new EventListenerTrigger();
        if (instance != null) {
            this.withBindings(instance.getBindings());
            this.withInterceptors(instance.getInterceptors());
            this.withName(instance.getName());
            this.withServiceAccountName(instance.getServiceAccountName());
            this.withTemplate(instance.getTemplate());
            this.withTriggerRef(instance.getTriggerRef());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public BindingsNested<A> editBinding(int index) {
        if (this.bindings.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "bindings"));
        }
        return this.setNewBindingLike(index, this.buildBinding(index));
    }

    public BindingsNested<A> editFirstBinding() {
        if (this.bindings.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "bindings"));
        }
        return this.setNewBindingLike(0, this.buildBinding(0));
    }

    public InterceptorsNested<A> editFirstInterceptor() {
        if (this.interceptors.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "interceptors"));
        }
        return this.setNewInterceptorLike(0, this.buildInterceptor(0));
    }

    public InterceptorsNested<A> editInterceptor(int index) {
        if (this.interceptors.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "interceptors"));
        }
        return this.setNewInterceptorLike(index, this.buildInterceptor(index));
    }

    public BindingsNested<A> editLastBinding() {
        int index = this.bindings.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "bindings"));
        }
        return this.setNewBindingLike(index, this.buildBinding(index));
    }

    public InterceptorsNested<A> editLastInterceptor() {
        int index = this.interceptors.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "interceptors"));
        }
        return this.setNewInterceptorLike(index, this.buildInterceptor(index));
    }

    public BindingsNested<A> editMatchingBinding(Predicate<TriggerSpecBindingBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.bindings.size(); ++i) {
            if (!predicate.test(this.bindings.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "bindings"));
        }
        return this.setNewBindingLike(index, this.buildBinding(index));
    }

    public InterceptorsNested<A> editMatchingInterceptor(Predicate<TriggerInterceptorBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.interceptors.size(); ++i) {
            if (!predicate.test(this.interceptors.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "interceptors"));
        }
        return this.setNewInterceptorLike(index, this.buildInterceptor(index));
    }

    public TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(new TriggerSpecTemplateBuilder().build()));
    }

    public TemplateNested<A> editOrNewTemplateLike(TriggerSpecTemplate item) {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(item));
    }

    public TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EventListenerTriggerFluent that = (EventListenerTriggerFluent)((Object)o);
        if (!Objects.equals(this.bindings, that.bindings)) {
            return false;
        }
        if (!Objects.equals(this.interceptors, that.interceptors)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.serviceAccountName, that.serviceAccountName)) {
            return false;
        }
        if (!Objects.equals((Object)this.template, (Object)that.template)) {
            return false;
        }
        if (!Objects.equals(this.triggerRef, that.triggerRef)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getName() {
        return this.name;
    }

    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    public String getTriggerRef() {
        return this.triggerRef;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasBindings() {
        return this.bindings != null && !this.bindings.isEmpty();
    }

    public boolean hasInterceptors() {
        return this.interceptors != null && !this.interceptors.isEmpty();
    }

    public boolean hasMatchingBinding(Predicate<TriggerSpecBindingBuilder> predicate) {
        for (TriggerSpecBindingBuilder item : this.bindings) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingInterceptor(Predicate<TriggerInterceptorBuilder> predicate) {
        for (TriggerInterceptorBuilder item : this.interceptors) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean hasServiceAccountName() {
        return this.serviceAccountName != null;
    }

    public boolean hasTemplate() {
        return this.template != null;
    }

    public boolean hasTriggerRef() {
        return this.triggerRef != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bindings, this.interceptors, this.name, this.serviceAccountName, this.template, this.triggerRef, this.additionalProperties});
    }

    public A removeAllFromBindings(Collection<TriggerSpecBinding> items) {
        if (this.bindings == null) {
            return (A)((Object)this);
        }
        for (TriggerSpecBinding item : items) {
            TriggerSpecBindingBuilder builder = new TriggerSpecBindingBuilder(item);
            this._visitables.get((Object)"bindings").remove((Object)builder);
            this.bindings.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromInterceptors(Collection<TriggerInterceptor> items) {
        if (this.interceptors == null) {
            return (A)((Object)this);
        }
        for (TriggerInterceptor item : items) {
            TriggerInterceptorBuilder builder = new TriggerInterceptorBuilder(item);
            this._visitables.get((Object)"interceptors").remove((Object)builder);
            this.interceptors.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromBindings(TriggerSpecBinding ... items) {
        if (this.bindings == null) {
            return (A)((Object)this);
        }
        for (TriggerSpecBinding item : items) {
            TriggerSpecBindingBuilder builder = new TriggerSpecBindingBuilder(item);
            this._visitables.get((Object)"bindings").remove((Object)builder);
            this.bindings.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromInterceptors(TriggerInterceptor ... items) {
        if (this.interceptors == null) {
            return (A)((Object)this);
        }
        for (TriggerInterceptor item : items) {
            TriggerInterceptorBuilder builder = new TriggerInterceptorBuilder(item);
            this._visitables.get((Object)"interceptors").remove((Object)builder);
            this.interceptors.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromBindings(Predicate<TriggerSpecBindingBuilder> predicate) {
        if (this.bindings == null) {
            return (A)((Object)this);
        }
        Iterator<TriggerSpecBindingBuilder> each = this.bindings.iterator();
        List visitables = this._visitables.get((Object)"bindings");
        while (each.hasNext()) {
            TriggerSpecBindingBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromInterceptors(Predicate<TriggerInterceptorBuilder> predicate) {
        if (this.interceptors == null) {
            return (A)((Object)this);
        }
        Iterator<TriggerInterceptorBuilder> each = this.interceptors.iterator();
        List visitables = this._visitables.get((Object)"interceptors");
        while (each.hasNext()) {
            TriggerInterceptorBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public BindingsNested<A> setNewBindingLike(int index, TriggerSpecBinding item) {
        return new BindingsNested(index, item);
    }

    public InterceptorsNested<A> setNewInterceptorLike(int index, TriggerInterceptor item) {
        return new InterceptorsNested(index, item);
    }

    public A setToBindings(int index, TriggerSpecBinding item) {
        if (this.bindings == null) {
            this.bindings = new ArrayList();
        }
        TriggerSpecBindingBuilder builder = new TriggerSpecBindingBuilder(item);
        if (index < 0 || index >= this.bindings.size()) {
            this._visitables.get((Object)"bindings").add(builder);
            this.bindings.add(builder);
        } else {
            this._visitables.get((Object)"bindings").add(builder);
            this.bindings.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToInterceptors(int index, TriggerInterceptor item) {
        if (this.interceptors == null) {
            this.interceptors = new ArrayList();
        }
        TriggerInterceptorBuilder builder = new TriggerInterceptorBuilder(item);
        if (index < 0 || index >= this.interceptors.size()) {
            this._visitables.get((Object)"interceptors").add(builder);
            this.interceptors.add(builder);
        } else {
            this._visitables.get((Object)"interceptors").add(builder);
            this.interceptors.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bindings != null && !this.bindings.isEmpty()) {
            sb.append("bindings:");
            sb.append(this.bindings);
            sb.append(",");
        }
        if (this.interceptors != null && !this.interceptors.isEmpty()) {
            sb.append("interceptors:");
            sb.append(this.interceptors);
            sb.append(",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name);
            sb.append(",");
        }
        if (this.serviceAccountName != null) {
            sb.append("serviceAccountName:");
            sb.append(this.serviceAccountName);
            sb.append(",");
        }
        if (this.template != null) {
            sb.append("template:");
            sb.append((Object)this.template);
            sb.append(",");
        }
        if (this.triggerRef != null) {
            sb.append("triggerRef:");
            sb.append(this.triggerRef);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withBindings(List<TriggerSpecBinding> bindings) {
        if (this.bindings != null) {
            this._visitables.get((Object)"bindings").clear();
        }
        if (bindings != null) {
            this.bindings = new ArrayList();
            for (TriggerSpecBinding item : bindings) {
                this.addToBindings(item);
            }
        } else {
            this.bindings = null;
        }
        return (A)((Object)this);
    }

    public A withBindings(TriggerSpecBinding ... bindings) {
        if (this.bindings != null) {
            this.bindings.clear();
            this._visitables.remove((Object)"bindings");
        }
        if (bindings != null) {
            for (TriggerSpecBinding item : bindings) {
                this.addToBindings(item);
            }
        }
        return (A)((Object)this);
    }

    public A withInterceptors(List<TriggerInterceptor> interceptors) {
        if (this.interceptors != null) {
            this._visitables.get((Object)"interceptors").clear();
        }
        if (interceptors != null) {
            this.interceptors = new ArrayList();
            for (TriggerInterceptor item : interceptors) {
                this.addToInterceptors(item);
            }
        } else {
            this.interceptors = null;
        }
        return (A)((Object)this);
    }

    public A withInterceptors(TriggerInterceptor ... interceptors) {
        if (this.interceptors != null) {
            this.interceptors.clear();
            this._visitables.remove((Object)"interceptors");
        }
        if (interceptors != null) {
            for (TriggerInterceptor item : interceptors) {
                this.addToInterceptors(item);
            }
        }
        return (A)((Object)this);
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public TemplateNested<A> withNewTemplate() {
        return new TemplateNested(null);
    }

    public TemplateNested<A> withNewTemplateLike(TriggerSpecTemplate item) {
        return new TemplateNested(item);
    }

    public A withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
        return (A)((Object)this);
    }

    public A withTemplate(TriggerSpecTemplate template) {
        this._visitables.remove((Object)"template");
        if (template != null) {
            this.template = new TriggerSpecTemplateBuilder(template);
            this._visitables.get((Object)"template").add(this.template);
        } else {
            this.template = null;
            this._visitables.get((Object)"template").remove((Object)this.template);
        }
        return (A)((Object)this);
    }

    public A withTriggerRef(String triggerRef) {
        this.triggerRef = triggerRef;
        return (A)((Object)this);
    }

    public class TemplateNested<N>
    extends TriggerSpecTemplateFluent<TemplateNested<N>>
    implements Nested<N> {
        TriggerSpecTemplateBuilder builder;

        TemplateNested(TriggerSpecTemplate item) {
            this.builder = new TriggerSpecTemplateBuilder(this, item);
        }

        public N and() {
            return (N)EventListenerTriggerFluent.this.withTemplate(this.builder.build());
        }

        public N endTemplate() {
            return this.and();
        }
    }

    public class InterceptorsNested<N>
    extends TriggerInterceptorFluent<InterceptorsNested<N>>
    implements Nested<N> {
        TriggerInterceptorBuilder builder;
        int index;

        InterceptorsNested(int index, TriggerInterceptor item) {
            this.index = index;
            this.builder = new TriggerInterceptorBuilder(this, item);
        }

        public N and() {
            return (N)EventListenerTriggerFluent.this.setToInterceptors(this.index, this.builder.build());
        }

        public N endInterceptor() {
            return this.and();
        }
    }

    public class BindingsNested<N>
    extends TriggerSpecBindingFluent<BindingsNested<N>>
    implements Nested<N> {
        TriggerSpecBindingBuilder builder;
        int index;

        BindingsNested(int index, TriggerSpecBinding item) {
            this.index = index;
            this.builder = new TriggerSpecBindingBuilder(this, item);
        }

        public N and() {
            return (N)EventListenerTriggerFluent.this.setToBindings(this.index, this.builder.build());
        }

        public N endBinding() {
            return this.and();
        }
    }
}

