/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.knative.duck.v1alpha1.Addressable;
import io.fabric8.knative.pkg.apis.Condition;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.tekton.triggers.v1alpha1.EventListenerConfig;
import io.fabric8.tekton.triggers.v1alpha1.EventListenerConfigBuilder;
import io.fabric8.tekton.triggers.v1alpha1.EventListenerConfigFluent;
import io.fabric8.tekton.triggers.v1alpha1.EventListenerStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class EventListenerStatusFluent<A extends EventListenerStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private Addressable address;
    private List<Addressable> addresses = new ArrayList<Addressable>();
    private Map<String, String> annotations;
    private List<Condition> conditions = new ArrayList<Condition>();
    private EventListenerConfigBuilder configuration;
    private Long observedGeneration;

    public EventListenerStatusFluent() {
    }

    public EventListenerStatusFluent(EventListenerStatus instance) {
        this.copyInstance(instance);
    }

    public A addAllToAddresses(Collection<Addressable> items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<Addressable>();
        }
        for (Addressable item : items) {
            this.addresses.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)((Object)this);
    }

    public A addNewAddress(String hostname) {
        return this.addToAddresses(new Addressable(hostname));
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAddresses(Addressable ... items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<Addressable>();
        }
        for (Addressable item : items) {
            this.addresses.add(item);
        }
        return (A)((Object)this);
    }

    public A addToAddresses(int index, Addressable item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<Addressable>();
        }
        this.addresses.add(index, item);
        return (A)((Object)this);
    }

    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)((Object)this);
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)((Object)this);
    }

    public EventListenerConfig buildConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    protected void copyInstance(EventListenerStatus instance) {
        EventListenerStatus eventListenerStatus = instance = instance != null ? instance : new EventListenerStatus();
        if (instance != null) {
            this.withAddress(instance.getAddress());
            this.withAddresses(instance.getAddresses());
            this.withAnnotations(instance.getAnnotations());
            this.withConditions(instance.getConditions());
            this.withConfiguration(instance.getConfiguration());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ConfigurationNested<A> editConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(null));
    }

    public ConfigurationNested<A> editOrNewConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(new EventListenerConfigBuilder().build()));
    }

    public ConfigurationNested<A> editOrNewConfigurationLike(EventListenerConfig item) {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EventListenerStatusFluent that = (EventListenerStatusFluent)((Object)o);
        if (!Objects.equals(this.address, that.address)) {
            return false;
        }
        if (!Objects.equals(this.addresses, that.addresses)) {
            return false;
        }
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals((Object)this.configuration, (Object)that.configuration)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Addressable getAddress() {
        return this.address;
    }

    public Addressable getAddress(int index) {
        return this.addresses.get(index);
    }

    public List<Addressable> getAddresses() {
        return this.addresses;
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public Condition getCondition(int index) {
        return this.conditions.get(index);
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public Addressable getFirstAddress() {
        return this.addresses.get(0);
    }

    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    public Addressable getLastAddress() {
        return this.addresses.get(this.addresses.size() - 1);
    }

    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    public Addressable getMatchingAddress(Predicate<Addressable> predicate) {
        for (Addressable item : this.addresses) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAddress() {
        return this.address != null;
    }

    public boolean hasAddresses() {
        return this.addresses != null && !this.addresses.isEmpty();
    }

    public boolean hasAnnotations() {
        return this.annotations != null;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public boolean hasMatchingAddress(Predicate<Addressable> predicate) {
        for (Addressable item : this.addresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.address, this.addresses, this.annotations, this.conditions, this.configuration, this.observedGeneration, this.additionalProperties});
    }

    public A removeAllFromAddresses(Collection<Addressable> items) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        for (Addressable item : items) {
            this.addresses.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromAddresses(Addressable ... items) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        for (Addressable item : items) {
            this.addresses.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)((Object)this);
    }

    public A setToAddresses(int index, Addressable item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<Addressable>();
        }
        this.addresses.set(index, item);
        return (A)((Object)this);
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.address != null) {
            sb.append("address:");
            sb.append(this.address);
            sb.append(",");
        }
        if (this.addresses != null && !this.addresses.isEmpty()) {
            sb.append("addresses:");
            sb.append(this.addresses);
            sb.append(",");
        }
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(this.annotations);
            sb.append(",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions);
            sb.append(",");
        }
        if (this.configuration != null) {
            sb.append("configuration:");
            sb.append((Object)this.configuration);
            sb.append(",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withAddress(Addressable address) {
        this.address = address;
        return (A)((Object)this);
    }

    public A withAddresses(List<Addressable> addresses) {
        if (addresses != null) {
            this.addresses = new ArrayList<Addressable>();
            for (Addressable item : addresses) {
                this.addToAddresses(item);
            }
        } else {
            this.addresses = null;
        }
        return (A)((Object)this);
    }

    public A withAddresses(Addressable ... addresses) {
        if (this.addresses != null) {
            this.addresses.clear();
            this._visitables.remove((Object)"addresses");
        }
        if (addresses != null) {
            for (Addressable item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)((Object)this);
    }

    public <K, V> A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)((Object)this);
    }

    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public A withConfiguration(EventListenerConfig configuration) {
        this._visitables.remove((Object)"configuration");
        if (configuration != null) {
            this.configuration = new EventListenerConfigBuilder(configuration);
            this._visitables.get((Object)"configuration").add(this.configuration);
        } else {
            this.configuration = null;
            this._visitables.get((Object)"configuration").remove((Object)this.configuration);
        }
        return (A)((Object)this);
    }

    public A withNewAddress(String hostname) {
        return this.withAddress(new Addressable(hostname));
    }

    public ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNested(null);
    }

    public A withNewConfiguration(String generatedName) {
        return this.withConfiguration(new EventListenerConfig(generatedName));
    }

    public ConfigurationNested<A> withNewConfigurationLike(EventListenerConfig item) {
        return new ConfigurationNested(item);
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)((Object)this);
    }

    public class ConfigurationNested<N>
    extends EventListenerConfigFluent<ConfigurationNested<N>>
    implements Nested<N> {
        EventListenerConfigBuilder builder;

        ConfigurationNested(EventListenerConfig item) {
            this.builder = new EventListenerConfigBuilder(this, item);
        }

        public N and() {
            return (N)EventListenerStatusFluent.this.withConfiguration(this.builder.build());
        }

        public N endConfiguration() {
            return this.and();
        }
    }
}

