/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.tekton.triggers.v1alpha1.EventListenerSpec;
import io.fabric8.tekton.triggers.v1alpha1.EventListenerTrigger;
import io.fabric8.tekton.triggers.v1alpha1.EventListenerTriggerBuilder;
import io.fabric8.tekton.triggers.v1alpha1.EventListenerTriggerFluent;
import io.fabric8.tekton.triggers.v1alpha1.NamespaceSelector;
import io.fabric8.tekton.triggers.v1alpha1.NamespaceSelectorBuilder;
import io.fabric8.tekton.triggers.v1alpha1.NamespaceSelectorFluent;
import io.fabric8.tekton.triggers.v1alpha1.Resources;
import io.fabric8.tekton.triggers.v1alpha1.ResourcesBuilder;
import io.fabric8.tekton.triggers.v1alpha1.ResourcesFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class EventListenerSpecFluent<A extends EventListenerSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private LabelSelectorBuilder labelSelector;
    private NamespaceSelectorBuilder namespaceSelector;
    private ResourcesBuilder resources;
    private String serviceAccountName;
    private ArrayList<EventListenerTriggerBuilder> triggers = new ArrayList();

    public EventListenerSpecFluent() {
    }

    public EventListenerSpecFluent(EventListenerSpec instance) {
        this.copyInstance(instance);
    }

    public A addAllToTriggers(Collection<EventListenerTrigger> items) {
        if (this.triggers == null) {
            this.triggers = new ArrayList();
        }
        for (EventListenerTrigger item : items) {
            EventListenerTriggerBuilder builder = new EventListenerTriggerBuilder(item);
            this._visitables.get((Object)"triggers").add(builder);
            this.triggers.add(builder);
        }
        return (A)((Object)this);
    }

    public TriggersNested<A> addNewTrigger() {
        return new TriggersNested(-1, null);
    }

    public TriggersNested<A> addNewTriggerLike(EventListenerTrigger item) {
        return new TriggersNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToTriggers(EventListenerTrigger ... items) {
        if (this.triggers == null) {
            this.triggers = new ArrayList();
        }
        for (EventListenerTrigger item : items) {
            EventListenerTriggerBuilder builder = new EventListenerTriggerBuilder(item);
            this._visitables.get((Object)"triggers").add(builder);
            this.triggers.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToTriggers(int index, EventListenerTrigger item) {
        if (this.triggers == null) {
            this.triggers = new ArrayList();
        }
        EventListenerTriggerBuilder builder = new EventListenerTriggerBuilder(item);
        if (index < 0 || index >= this.triggers.size()) {
            this._visitables.get((Object)"triggers").add(builder);
            this.triggers.add(builder);
        } else {
            this._visitables.get((Object)"triggers").add(builder);
            this.triggers.add(index, builder);
        }
        return (A)((Object)this);
    }

    public EventListenerTrigger buildFirstTrigger() {
        return this.triggers.get(0).build();
    }

    public LabelSelector buildLabelSelector() {
        return this.labelSelector != null ? this.labelSelector.build() : null;
    }

    public EventListenerTrigger buildLastTrigger() {
        return this.triggers.get(this.triggers.size() - 1).build();
    }

    public EventListenerTrigger buildMatchingTrigger(Predicate<EventListenerTriggerBuilder> predicate) {
        for (EventListenerTriggerBuilder item : this.triggers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public NamespaceSelector buildNamespaceSelector() {
        return this.namespaceSelector != null ? this.namespaceSelector.build() : null;
    }

    public Resources buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    public EventListenerTrigger buildTrigger(int index) {
        return this.triggers.get(index).build();
    }

    public List<EventListenerTrigger> buildTriggers() {
        return this.triggers != null ? EventListenerSpecFluent.build(this.triggers) : null;
    }

    protected void copyInstance(EventListenerSpec instance) {
        EventListenerSpec eventListenerSpec = instance = instance != null ? instance : new EventListenerSpec();
        if (instance != null) {
            this.withLabelSelector(instance.getLabelSelector());
            this.withNamespaceSelector(instance.getNamespaceSelector());
            this.withResources(instance.getResources());
            this.withServiceAccountName(instance.getServiceAccountName());
            this.withTriggers(instance.getTriggers());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public TriggersNested<A> editFirstTrigger() {
        if (this.triggers.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "triggers"));
        }
        return this.setNewTriggerLike(0, this.buildTrigger(0));
    }

    public LabelSelectorNested<A> editLabelSelector() {
        return this.withNewLabelSelectorLike(Optional.ofNullable(this.buildLabelSelector()).orElse(null));
    }

    public TriggersNested<A> editLastTrigger() {
        int index = this.triggers.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "triggers"));
        }
        return this.setNewTriggerLike(index, this.buildTrigger(index));
    }

    public TriggersNested<A> editMatchingTrigger(Predicate<EventListenerTriggerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.triggers.size(); ++i) {
            if (!predicate.test(this.triggers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "triggers"));
        }
        return this.setNewTriggerLike(index, this.buildTrigger(index));
    }

    public NamespaceSelectorNested<A> editNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(null));
    }

    public LabelSelectorNested<A> editOrNewLabelSelector() {
        return this.withNewLabelSelectorLike(Optional.ofNullable(this.buildLabelSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public LabelSelectorNested<A> editOrNewLabelSelectorLike(LabelSelector item) {
        return this.withNewLabelSelectorLike(Optional.ofNullable(this.buildLabelSelector()).orElse(item));
    }

    public NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(new NamespaceSelectorBuilder().build()));
    }

    public NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(NamespaceSelector item) {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(item));
    }

    public ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(new ResourcesBuilder().build()));
    }

    public ResourcesNested<A> editOrNewResourcesLike(Resources item) {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(item));
    }

    public ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(null));
    }

    public TriggersNested<A> editTrigger(int index) {
        if (this.triggers.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "triggers"));
        }
        return this.setNewTriggerLike(index, this.buildTrigger(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EventListenerSpecFluent that = (EventListenerSpecFluent)((Object)o);
        if (!Objects.equals(this.labelSelector, that.labelSelector)) {
            return false;
        }
        if (!Objects.equals((Object)this.namespaceSelector, (Object)that.namespaceSelector)) {
            return false;
        }
        if (!Objects.equals((Object)this.resources, (Object)that.resources)) {
            return false;
        }
        if (!Objects.equals(this.serviceAccountName, that.serviceAccountName)) {
            return false;
        }
        if (!Objects.equals(this.triggers, that.triggers)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasLabelSelector() {
        return this.labelSelector != null;
    }

    public boolean hasMatchingTrigger(Predicate<EventListenerTriggerBuilder> predicate) {
        for (EventListenerTriggerBuilder item : this.triggers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNamespaceSelector() {
        return this.namespaceSelector != null;
    }

    public boolean hasResources() {
        return this.resources != null;
    }

    public boolean hasServiceAccountName() {
        return this.serviceAccountName != null;
    }

    public boolean hasTriggers() {
        return this.triggers != null && !this.triggers.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.labelSelector, this.namespaceSelector, this.resources, this.serviceAccountName, this.triggers, this.additionalProperties});
    }

    public A removeAllFromTriggers(Collection<EventListenerTrigger> items) {
        if (this.triggers == null) {
            return (A)((Object)this);
        }
        for (EventListenerTrigger item : items) {
            EventListenerTriggerBuilder builder = new EventListenerTriggerBuilder(item);
            this._visitables.get((Object)"triggers").remove((Object)builder);
            this.triggers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromTriggers(EventListenerTrigger ... items) {
        if (this.triggers == null) {
            return (A)((Object)this);
        }
        for (EventListenerTrigger item : items) {
            EventListenerTriggerBuilder builder = new EventListenerTriggerBuilder(item);
            this._visitables.get((Object)"triggers").remove((Object)builder);
            this.triggers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromTriggers(Predicate<EventListenerTriggerBuilder> predicate) {
        if (this.triggers == null) {
            return (A)((Object)this);
        }
        Iterator<EventListenerTriggerBuilder> each = this.triggers.iterator();
        List visitables = this._visitables.get((Object)"triggers");
        while (each.hasNext()) {
            EventListenerTriggerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public TriggersNested<A> setNewTriggerLike(int index, EventListenerTrigger item) {
        return new TriggersNested(index, item);
    }

    public A setToTriggers(int index, EventListenerTrigger item) {
        if (this.triggers == null) {
            this.triggers = new ArrayList();
        }
        EventListenerTriggerBuilder builder = new EventListenerTriggerBuilder(item);
        if (index < 0 || index >= this.triggers.size()) {
            this._visitables.get((Object)"triggers").add(builder);
            this.triggers.add(builder);
        } else {
            this._visitables.get((Object)"triggers").add(builder);
            this.triggers.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.labelSelector != null) {
            sb.append("labelSelector:");
            sb.append(this.labelSelector);
            sb.append(",");
        }
        if (this.namespaceSelector != null) {
            sb.append("namespaceSelector:");
            sb.append((Object)this.namespaceSelector);
            sb.append(",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append((Object)this.resources);
            sb.append(",");
        }
        if (this.serviceAccountName != null) {
            sb.append("serviceAccountName:");
            sb.append(this.serviceAccountName);
            sb.append(",");
        }
        if (this.triggers != null && !this.triggers.isEmpty()) {
            sb.append("triggers:");
            sb.append(this.triggers);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withLabelSelector(LabelSelector labelSelector) {
        this._visitables.remove((Object)"labelSelector");
        if (labelSelector != null) {
            this.labelSelector = new LabelSelectorBuilder(labelSelector);
            this._visitables.get((Object)"labelSelector").add(this.labelSelector);
        } else {
            this.labelSelector = null;
            this._visitables.get((Object)"labelSelector").remove(this.labelSelector);
        }
        return (A)((Object)this);
    }

    public A withNamespaceSelector(NamespaceSelector namespaceSelector) {
        this._visitables.remove((Object)"namespaceSelector");
        if (namespaceSelector != null) {
            this.namespaceSelector = new NamespaceSelectorBuilder(namespaceSelector);
            this._visitables.get((Object)"namespaceSelector").add(this.namespaceSelector);
        } else {
            this.namespaceSelector = null;
            this._visitables.get((Object)"namespaceSelector").remove((Object)this.namespaceSelector);
        }
        return (A)((Object)this);
    }

    public LabelSelectorNested<A> withNewLabelSelector() {
        return new LabelSelectorNested(null);
    }

    public LabelSelectorNested<A> withNewLabelSelectorLike(LabelSelector item) {
        return new LabelSelectorNested(item);
    }

    public NamespaceSelectorNested<A> withNewNamespaceSelector() {
        return new NamespaceSelectorNested(null);
    }

    public NamespaceSelectorNested<A> withNewNamespaceSelectorLike(NamespaceSelector item) {
        return new NamespaceSelectorNested(item);
    }

    public ResourcesNested<A> withNewResources() {
        return new ResourcesNested(null);
    }

    public ResourcesNested<A> withNewResourcesLike(Resources item) {
        return new ResourcesNested(item);
    }

    public A withResources(Resources resources) {
        this._visitables.remove((Object)"resources");
        if (resources != null) {
            this.resources = new ResourcesBuilder(resources);
            this._visitables.get((Object)"resources").add(this.resources);
        } else {
            this.resources = null;
            this._visitables.get((Object)"resources").remove((Object)this.resources);
        }
        return (A)((Object)this);
    }

    public A withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
        return (A)((Object)this);
    }

    public A withTriggers(List<EventListenerTrigger> triggers) {
        if (this.triggers != null) {
            this._visitables.get((Object)"triggers").clear();
        }
        if (triggers != null) {
            this.triggers = new ArrayList();
            for (EventListenerTrigger item : triggers) {
                this.addToTriggers(item);
            }
        } else {
            this.triggers = null;
        }
        return (A)((Object)this);
    }

    public A withTriggers(EventListenerTrigger ... triggers) {
        if (this.triggers != null) {
            this.triggers.clear();
            this._visitables.remove((Object)"triggers");
        }
        if (triggers != null) {
            for (EventListenerTrigger item : triggers) {
                this.addToTriggers(item);
            }
        }
        return (A)((Object)this);
    }

    public class TriggersNested<N>
    extends EventListenerTriggerFluent<TriggersNested<N>>
    implements Nested<N> {
        EventListenerTriggerBuilder builder;
        int index;

        TriggersNested(int index, EventListenerTrigger item) {
            this.index = index;
            this.builder = new EventListenerTriggerBuilder(this, item);
        }

        public N and() {
            return (N)EventListenerSpecFluent.this.setToTriggers(this.index, this.builder.build());
        }

        public N endTrigger() {
            return this.and();
        }
    }

    public class ResourcesNested<N>
    extends ResourcesFluent<ResourcesNested<N>>
    implements Nested<N> {
        ResourcesBuilder builder;

        ResourcesNested(Resources item) {
            this.builder = new ResourcesBuilder(this, item);
        }

        public N and() {
            return (N)EventListenerSpecFluent.this.withResources(this.builder.build());
        }

        public N endResources() {
            return this.and();
        }
    }

    public class NamespaceSelectorNested<N>
    extends NamespaceSelectorFluent<NamespaceSelectorNested<N>>
    implements Nested<N> {
        NamespaceSelectorBuilder builder;

        NamespaceSelectorNested(NamespaceSelector item) {
            this.builder = new NamespaceSelectorBuilder(this, item);
        }

        public N and() {
            return (N)EventListenerSpecFluent.this.withNamespaceSelector(this.builder.build());
        }

        public N endNamespaceSelector() {
            return this.and();
        }
    }

    public class LabelSelectorNested<N>
    extends LabelSelectorFluent<LabelSelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        LabelSelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        public N and() {
            return (N)EventListenerSpecFluent.this.withLabelSelector(this.builder.build());
        }

        public N endLabelSelector() {
            return this.and();
        }
    }
}

