/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.tekton.v1alpha1.Authority;
import io.fabric8.tekton.v1alpha1.AuthorityBuilder;
import io.fabric8.tekton.v1alpha1.AuthorityFluent;
import io.fabric8.tekton.v1alpha1.ResourcePattern;
import io.fabric8.tekton.v1alpha1.ResourcePatternBuilder;
import io.fabric8.tekton.v1alpha1.ResourcePatternFluent;
import io.fabric8.tekton.v1alpha1.VerificationPolicySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class VerificationPolicySpecFluent<A extends VerificationPolicySpecFluent<A>>
extends BaseFluent<A> {
    private ArrayList<AuthorityBuilder> authorities = new ArrayList();
    private String mode;
    private ArrayList<ResourcePatternBuilder> resources = new ArrayList();
    private Map<String, Object> additionalProperties;

    public VerificationPolicySpecFluent() {
    }

    public VerificationPolicySpecFluent(VerificationPolicySpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(VerificationPolicySpec instance) {
        VerificationPolicySpec verificationPolicySpec = instance = instance != null ? instance : new VerificationPolicySpec();
        if (instance != null) {
            this.withAuthorities(instance.getAuthorities());
            this.withMode(instance.getMode());
            this.withResources(instance.getResources());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAuthorities(int index, Authority item) {
        if (this.authorities == null) {
            this.authorities = new ArrayList();
        }
        AuthorityBuilder builder = new AuthorityBuilder(item);
        if (index < 0 || index >= this.authorities.size()) {
            this._visitables.get((Object)"authorities").add(builder);
            this.authorities.add(builder);
        } else {
            this._visitables.get((Object)"authorities").add(builder);
            this.authorities.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToAuthorities(int index, Authority item) {
        if (this.authorities == null) {
            this.authorities = new ArrayList();
        }
        AuthorityBuilder builder = new AuthorityBuilder(item);
        if (index < 0 || index >= this.authorities.size()) {
            this._visitables.get((Object)"authorities").add(builder);
            this.authorities.add(builder);
        } else {
            this._visitables.get((Object)"authorities").add(builder);
            this.authorities.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToAuthorities(Authority ... items) {
        if (this.authorities == null) {
            this.authorities = new ArrayList();
        }
        for (Authority item : items) {
            AuthorityBuilder builder = new AuthorityBuilder(item);
            this._visitables.get((Object)"authorities").add(builder);
            this.authorities.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToAuthorities(Collection<Authority> items) {
        if (this.authorities == null) {
            this.authorities = new ArrayList();
        }
        for (Authority item : items) {
            AuthorityBuilder builder = new AuthorityBuilder(item);
            this._visitables.get((Object)"authorities").add(builder);
            this.authorities.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAuthorities(Authority ... items) {
        if (this.authorities == null) {
            return (A)((Object)this);
        }
        for (Authority item : items) {
            AuthorityBuilder builder = new AuthorityBuilder(item);
            this._visitables.get((Object)"authorities").remove((Object)builder);
            this.authorities.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAuthorities(Collection<Authority> items) {
        if (this.authorities == null) {
            return (A)((Object)this);
        }
        for (Authority item : items) {
            AuthorityBuilder builder = new AuthorityBuilder(item);
            this._visitables.get((Object)"authorities").remove((Object)builder);
            this.authorities.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromAuthorities(Predicate<AuthorityBuilder> predicate) {
        if (this.authorities == null) {
            return (A)((Object)this);
        }
        Iterator<AuthorityBuilder> each = this.authorities.iterator();
        List visitables = this._visitables.get((Object)"authorities");
        while (each.hasNext()) {
            AuthorityBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Authority> buildAuthorities() {
        return this.authorities != null ? VerificationPolicySpecFluent.build(this.authorities) : null;
    }

    public Authority buildAuthority(int index) {
        return this.authorities.get(index).build();
    }

    public Authority buildFirstAuthority() {
        return this.authorities.get(0).build();
    }

    public Authority buildLastAuthority() {
        return this.authorities.get(this.authorities.size() - 1).build();
    }

    public Authority buildMatchingAuthority(Predicate<AuthorityBuilder> predicate) {
        for (AuthorityBuilder item : this.authorities) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAuthority(Predicate<AuthorityBuilder> predicate) {
        for (AuthorityBuilder item : this.authorities) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAuthorities(List<Authority> authorities) {
        if (this.authorities != null) {
            this._visitables.get((Object)"authorities").clear();
        }
        if (authorities != null) {
            this.authorities = new ArrayList();
            for (Authority item : authorities) {
                this.addToAuthorities(item);
            }
        } else {
            this.authorities = null;
        }
        return (A)((Object)this);
    }

    public A withAuthorities(Authority ... authorities) {
        if (this.authorities != null) {
            this.authorities.clear();
            this._visitables.remove((Object)"authorities");
        }
        if (authorities != null) {
            for (Authority item : authorities) {
                this.addToAuthorities(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAuthorities() {
        return this.authorities != null && !this.authorities.isEmpty();
    }

    public AuthoritiesNested<A> addNewAuthority() {
        return new AuthoritiesNested(-1, null);
    }

    public AuthoritiesNested<A> addNewAuthorityLike(Authority item) {
        return new AuthoritiesNested(-1, item);
    }

    public AuthoritiesNested<A> setNewAuthorityLike(int index, Authority item) {
        return new AuthoritiesNested(index, item);
    }

    public AuthoritiesNested<A> editAuthority(int index) {
        if (this.authorities.size() <= index) {
            throw new RuntimeException("Can't edit authorities. Index exceeds size.");
        }
        return this.setNewAuthorityLike(index, this.buildAuthority(index));
    }

    public AuthoritiesNested<A> editFirstAuthority() {
        if (this.authorities.size() == 0) {
            throw new RuntimeException("Can't edit first authorities. The list is empty.");
        }
        return this.setNewAuthorityLike(0, this.buildAuthority(0));
    }

    public AuthoritiesNested<A> editLastAuthority() {
        int index = this.authorities.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last authorities. The list is empty.");
        }
        return this.setNewAuthorityLike(index, this.buildAuthority(index));
    }

    public AuthoritiesNested<A> editMatchingAuthority(Predicate<AuthorityBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.authorities.size(); ++i) {
            if (!predicate.test(this.authorities.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching authorities. No match found.");
        }
        return this.setNewAuthorityLike(index, this.buildAuthority(index));
    }

    public String getMode() {
        return this.mode;
    }

    public A withMode(String mode) {
        this.mode = mode;
        return (A)((Object)this);
    }

    public boolean hasMode() {
        return this.mode != null;
    }

    public A addToResources(int index, ResourcePattern item) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        ResourcePatternBuilder builder = new ResourcePatternBuilder(item);
        if (index < 0 || index >= this.resources.size()) {
            this._visitables.get((Object)"resources").add(builder);
            this.resources.add(builder);
        } else {
            this._visitables.get((Object)"resources").add(builder);
            this.resources.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToResources(int index, ResourcePattern item) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        ResourcePatternBuilder builder = new ResourcePatternBuilder(item);
        if (index < 0 || index >= this.resources.size()) {
            this._visitables.get((Object)"resources").add(builder);
            this.resources.add(builder);
        } else {
            this._visitables.get((Object)"resources").add(builder);
            this.resources.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToResources(ResourcePattern ... items) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        for (ResourcePattern item : items) {
            ResourcePatternBuilder builder = new ResourcePatternBuilder(item);
            this._visitables.get((Object)"resources").add(builder);
            this.resources.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToResources(Collection<ResourcePattern> items) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        for (ResourcePattern item : items) {
            ResourcePatternBuilder builder = new ResourcePatternBuilder(item);
            this._visitables.get((Object)"resources").add(builder);
            this.resources.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromResources(ResourcePattern ... items) {
        if (this.resources == null) {
            return (A)((Object)this);
        }
        for (ResourcePattern item : items) {
            ResourcePatternBuilder builder = new ResourcePatternBuilder(item);
            this._visitables.get((Object)"resources").remove((Object)builder);
            this.resources.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromResources(Collection<ResourcePattern> items) {
        if (this.resources == null) {
            return (A)((Object)this);
        }
        for (ResourcePattern item : items) {
            ResourcePatternBuilder builder = new ResourcePatternBuilder(item);
            this._visitables.get((Object)"resources").remove((Object)builder);
            this.resources.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromResources(Predicate<ResourcePatternBuilder> predicate) {
        if (this.resources == null) {
            return (A)((Object)this);
        }
        Iterator<ResourcePatternBuilder> each = this.resources.iterator();
        List visitables = this._visitables.get((Object)"resources");
        while (each.hasNext()) {
            ResourcePatternBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ResourcePattern> buildResources() {
        return this.resources != null ? VerificationPolicySpecFluent.build(this.resources) : null;
    }

    public ResourcePattern buildResource(int index) {
        return this.resources.get(index).build();
    }

    public ResourcePattern buildFirstResource() {
        return this.resources.get(0).build();
    }

    public ResourcePattern buildLastResource() {
        return this.resources.get(this.resources.size() - 1).build();
    }

    public ResourcePattern buildMatchingResource(Predicate<ResourcePatternBuilder> predicate) {
        for (ResourcePatternBuilder item : this.resources) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingResource(Predicate<ResourcePatternBuilder> predicate) {
        for (ResourcePatternBuilder item : this.resources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withResources(List<ResourcePattern> resources) {
        if (this.resources != null) {
            this._visitables.get((Object)"resources").clear();
        }
        if (resources != null) {
            this.resources = new ArrayList();
            for (ResourcePattern item : resources) {
                this.addToResources(item);
            }
        } else {
            this.resources = null;
        }
        return (A)((Object)this);
    }

    public A withResources(ResourcePattern ... resources) {
        if (this.resources != null) {
            this.resources.clear();
            this._visitables.remove((Object)"resources");
        }
        if (resources != null) {
            for (ResourcePattern item : resources) {
                this.addToResources(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasResources() {
        return this.resources != null && !this.resources.isEmpty();
    }

    public A addNewResource(String pattern) {
        return this.addToResources(new ResourcePattern(pattern));
    }

    public ResourcesNested<A> addNewResource() {
        return new ResourcesNested(-1, null);
    }

    public ResourcesNested<A> addNewResourceLike(ResourcePattern item) {
        return new ResourcesNested(-1, item);
    }

    public ResourcesNested<A> setNewResourceLike(int index, ResourcePattern item) {
        return new ResourcesNested(index, item);
    }

    public ResourcesNested<A> editResource(int index) {
        if (this.resources.size() <= index) {
            throw new RuntimeException("Can't edit resources. Index exceeds size.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    public ResourcesNested<A> editFirstResource() {
        if (this.resources.size() == 0) {
            throw new RuntimeException("Can't edit first resources. The list is empty.");
        }
        return this.setNewResourceLike(0, this.buildResource(0));
    }

    public ResourcesNested<A> editLastResource() {
        int index = this.resources.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last resources. The list is empty.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    public ResourcesNested<A> editMatchingResource(Predicate<ResourcePatternBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resources.size(); ++i) {
            if (!predicate.test(this.resources.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching resources. No match found.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VerificationPolicySpecFluent that = (VerificationPolicySpecFluent)((Object)o);
        if (!Objects.equals(this.authorities, that.authorities)) {
            return false;
        }
        if (!Objects.equals(this.mode, that.mode)) {
            return false;
        }
        if (!Objects.equals(this.resources, that.resources)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.authorities, this.mode, this.resources, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.authorities != null && !this.authorities.isEmpty()) {
            sb.append("authorities:");
            sb.append(String.valueOf(this.authorities) + ",");
        }
        if (this.mode != null) {
            sb.append("mode:");
            sb.append(this.mode + ",");
        }
        if (this.resources != null && !this.resources.isEmpty()) {
            sb.append("resources:");
            sb.append(String.valueOf(this.resources) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ResourcesNested<N>
    extends ResourcePatternFluent<ResourcesNested<N>>
    implements Nested<N> {
        ResourcePatternBuilder builder;
        int index;

        ResourcesNested(int index, ResourcePattern item) {
            this.index = index;
            this.builder = new ResourcePatternBuilder(this, item);
        }

        public N and() {
            return (N)VerificationPolicySpecFluent.this.setToResources(this.index, this.builder.build());
        }

        public N endResource() {
            return this.and();
        }
    }

    public class AuthoritiesNested<N>
    extends AuthorityFluent<AuthoritiesNested<N>>
    implements Nested<N> {
        AuthorityBuilder builder;
        int index;

        AuthoritiesNested(int index, Authority item) {
            this.index = index;
            this.builder = new AuthorityBuilder(this, item);
        }

        public N and() {
            return (N)VerificationPolicySpecFluent.this.setToAuthorities(this.index, this.builder.build());
        }

        public N endAuthority() {
            return this.and();
        }
    }
}

