/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.v1alpha1;

import io.fabric8.knative.pkg.apis.Condition;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.tekton.v1alpha1.RunResult;
import io.fabric8.tekton.v1alpha1.RunResultBuilder;
import io.fabric8.tekton.v1alpha1.RunResultFluent;
import io.fabric8.tekton.v1alpha1.RunStatus;
import io.fabric8.tekton.v1alpha1.RunStatusBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RunStatusFluent<A extends RunStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, String> annotations;
    private String completionTime;
    private List<Condition> conditions = new ArrayList<Condition>();
    private Object extraFields;
    private Long observedGeneration;
    private ArrayList<RunResultBuilder> results = new ArrayList();
    private ArrayList<RunStatusBuilder> retriesStatus = new ArrayList();
    private String startTime;
    private Map<String, Object> additionalProperties;

    public RunStatusFluent() {
    }

    public RunStatusFluent(RunStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(RunStatus instance) {
        RunStatus runStatus = instance = instance != null ? instance : new RunStatus();
        if (instance != null) {
            this.withAnnotations(instance.getAnnotations());
            this.withCompletionTime(instance.getCompletionTime());
            this.withConditions(instance.getConditions());
            this.withExtraFields(instance.getExtraFields());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withResults(instance.getResults());
            this.withRetriesStatus(instance.getRetriesStatus());
            this.withStartTime(instance.getStartTime());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public <K, V> A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)((Object)this);
    }

    public boolean hasAnnotations() {
        return this.annotations != null;
    }

    public String getCompletionTime() {
        return this.completionTime;
    }

    public A withCompletionTime(String completionTime) {
        this.completionTime = completionTime;
        return (A)((Object)this);
    }

    public boolean hasCompletionTime() {
        return this.completionTime != null;
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)((Object)this);
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)((Object)this);
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)((Object)this);
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public Condition getCondition(int index) {
        return this.conditions.get(index);
    }

    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public Object getExtraFields() {
        return this.extraFields;
    }

    public A withExtraFields(Object extraFields) {
        this.extraFields = extraFields;
        return (A)((Object)this);
    }

    public boolean hasExtraFields() {
        return this.extraFields != null;
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)((Object)this);
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public A addToResults(int index, RunResult item) {
        if (this.results == null) {
            this.results = new ArrayList();
        }
        RunResultBuilder builder = new RunResultBuilder(item);
        if (index < 0 || index >= this.results.size()) {
            this._visitables.get((Object)"results").add(builder);
            this.results.add(builder);
        } else {
            this._visitables.get((Object)"results").add(builder);
            this.results.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToResults(int index, RunResult item) {
        if (this.results == null) {
            this.results = new ArrayList();
        }
        RunResultBuilder builder = new RunResultBuilder(item);
        if (index < 0 || index >= this.results.size()) {
            this._visitables.get((Object)"results").add(builder);
            this.results.add(builder);
        } else {
            this._visitables.get((Object)"results").add(builder);
            this.results.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToResults(RunResult ... items) {
        if (this.results == null) {
            this.results = new ArrayList();
        }
        for (RunResult item : items) {
            RunResultBuilder builder = new RunResultBuilder(item);
            this._visitables.get((Object)"results").add(builder);
            this.results.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToResults(Collection<RunResult> items) {
        if (this.results == null) {
            this.results = new ArrayList();
        }
        for (RunResult item : items) {
            RunResultBuilder builder = new RunResultBuilder(item);
            this._visitables.get((Object)"results").add(builder);
            this.results.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromResults(RunResult ... items) {
        if (this.results == null) {
            return (A)((Object)this);
        }
        for (RunResult item : items) {
            RunResultBuilder builder = new RunResultBuilder(item);
            this._visitables.get((Object)"results").remove((Object)builder);
            this.results.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromResults(Collection<RunResult> items) {
        if (this.results == null) {
            return (A)((Object)this);
        }
        for (RunResult item : items) {
            RunResultBuilder builder = new RunResultBuilder(item);
            this._visitables.get((Object)"results").remove((Object)builder);
            this.results.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromResults(Predicate<RunResultBuilder> predicate) {
        if (this.results == null) {
            return (A)((Object)this);
        }
        Iterator<RunResultBuilder> each = this.results.iterator();
        List visitables = this._visitables.get((Object)"results");
        while (each.hasNext()) {
            RunResultBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<RunResult> buildResults() {
        return this.results != null ? RunStatusFluent.build(this.results) : null;
    }

    public RunResult buildResult(int index) {
        return this.results.get(index).build();
    }

    public RunResult buildFirstResult() {
        return this.results.get(0).build();
    }

    public RunResult buildLastResult() {
        return this.results.get(this.results.size() - 1).build();
    }

    public RunResult buildMatchingResult(Predicate<RunResultBuilder> predicate) {
        for (RunResultBuilder item : this.results) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingResult(Predicate<RunResultBuilder> predicate) {
        for (RunResultBuilder item : this.results) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withResults(List<RunResult> results) {
        if (this.results != null) {
            this._visitables.get((Object)"results").clear();
        }
        if (results != null) {
            this.results = new ArrayList();
            for (RunResult item : results) {
                this.addToResults(item);
            }
        } else {
            this.results = null;
        }
        return (A)((Object)this);
    }

    public A withResults(RunResult ... results) {
        if (this.results != null) {
            this.results.clear();
            this._visitables.remove((Object)"results");
        }
        if (results != null) {
            for (RunResult item : results) {
                this.addToResults(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasResults() {
        return this.results != null && !this.results.isEmpty();
    }

    public A addNewResult(String name, String value) {
        return this.addToResults(new RunResult(name, value));
    }

    public ResultsNested<A> addNewResult() {
        return new ResultsNested(-1, null);
    }

    public ResultsNested<A> addNewResultLike(RunResult item) {
        return new ResultsNested(-1, item);
    }

    public ResultsNested<A> setNewResultLike(int index, RunResult item) {
        return new ResultsNested(index, item);
    }

    public ResultsNested<A> editResult(int index) {
        if (this.results.size() <= index) {
            throw new RuntimeException("Can't edit results. Index exceeds size.");
        }
        return this.setNewResultLike(index, this.buildResult(index));
    }

    public ResultsNested<A> editFirstResult() {
        if (this.results.size() == 0) {
            throw new RuntimeException("Can't edit first results. The list is empty.");
        }
        return this.setNewResultLike(0, this.buildResult(0));
    }

    public ResultsNested<A> editLastResult() {
        int index = this.results.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last results. The list is empty.");
        }
        return this.setNewResultLike(index, this.buildResult(index));
    }

    public ResultsNested<A> editMatchingResult(Predicate<RunResultBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.results.size(); ++i) {
            if (!predicate.test(this.results.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching results. No match found.");
        }
        return this.setNewResultLike(index, this.buildResult(index));
    }

    public A addToRetriesStatus(int index, RunStatus item) {
        if (this.retriesStatus == null) {
            this.retriesStatus = new ArrayList();
        }
        RunStatusBuilder builder = new RunStatusBuilder(item);
        if (index < 0 || index >= this.retriesStatus.size()) {
            this._visitables.get((Object)"retriesStatus").add(builder);
            this.retriesStatus.add(builder);
        } else {
            this._visitables.get((Object)"retriesStatus").add(builder);
            this.retriesStatus.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToRetriesStatus(int index, RunStatus item) {
        if (this.retriesStatus == null) {
            this.retriesStatus = new ArrayList();
        }
        RunStatusBuilder builder = new RunStatusBuilder(item);
        if (index < 0 || index >= this.retriesStatus.size()) {
            this._visitables.get((Object)"retriesStatus").add(builder);
            this.retriesStatus.add(builder);
        } else {
            this._visitables.get((Object)"retriesStatus").add(builder);
            this.retriesStatus.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToRetriesStatus(RunStatus ... items) {
        if (this.retriesStatus == null) {
            this.retriesStatus = new ArrayList();
        }
        for (RunStatus item : items) {
            RunStatusBuilder builder = new RunStatusBuilder(item);
            this._visitables.get((Object)"retriesStatus").add(builder);
            this.retriesStatus.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToRetriesStatus(Collection<RunStatus> items) {
        if (this.retriesStatus == null) {
            this.retriesStatus = new ArrayList();
        }
        for (RunStatus item : items) {
            RunStatusBuilder builder = new RunStatusBuilder(item);
            this._visitables.get((Object)"retriesStatus").add(builder);
            this.retriesStatus.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromRetriesStatus(RunStatus ... items) {
        if (this.retriesStatus == null) {
            return (A)((Object)this);
        }
        for (RunStatus item : items) {
            RunStatusBuilder builder = new RunStatusBuilder(item);
            this._visitables.get((Object)"retriesStatus").remove((Object)builder);
            this.retriesStatus.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromRetriesStatus(Collection<RunStatus> items) {
        if (this.retriesStatus == null) {
            return (A)((Object)this);
        }
        for (RunStatus item : items) {
            RunStatusBuilder builder = new RunStatusBuilder(item);
            this._visitables.get((Object)"retriesStatus").remove((Object)builder);
            this.retriesStatus.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromRetriesStatus(Predicate<RunStatusBuilder> predicate) {
        if (this.retriesStatus == null) {
            return (A)((Object)this);
        }
        Iterator<RunStatusBuilder> each = this.retriesStatus.iterator();
        List visitables = this._visitables.get((Object)"retriesStatus");
        while (each.hasNext()) {
            RunStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<RunStatus> buildRetriesStatus() {
        return this.retriesStatus != null ? RunStatusFluent.build(this.retriesStatus) : null;
    }

    public RunStatus buildRetriesStatus(int index) {
        return this.retriesStatus.get(index).build();
    }

    public RunStatus buildFirstRetriesStatus() {
        return this.retriesStatus.get(0).build();
    }

    public RunStatus buildLastRetriesStatus() {
        return this.retriesStatus.get(this.retriesStatus.size() - 1).build();
    }

    public RunStatus buildMatchingRetriesStatus(Predicate<RunStatusBuilder> predicate) {
        for (RunStatusBuilder item : this.retriesStatus) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingRetriesStatus(Predicate<RunStatusBuilder> predicate) {
        for (RunStatusBuilder item : this.retriesStatus) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRetriesStatus(List<RunStatus> retriesStatus) {
        if (this.retriesStatus != null) {
            this._visitables.get((Object)"retriesStatus").clear();
        }
        if (retriesStatus != null) {
            this.retriesStatus = new ArrayList();
            for (RunStatus item : retriesStatus) {
                this.addToRetriesStatus(item);
            }
        } else {
            this.retriesStatus = null;
        }
        return (A)((Object)this);
    }

    public A withRetriesStatus(RunStatus ... retriesStatus) {
        if (this.retriesStatus != null) {
            this.retriesStatus.clear();
            this._visitables.remove((Object)"retriesStatus");
        }
        if (retriesStatus != null) {
            for (RunStatus item : retriesStatus) {
                this.addToRetriesStatus(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasRetriesStatus() {
        return this.retriesStatus != null && !this.retriesStatus.isEmpty();
    }

    public RetriesStatusNested<A> addNewRetriesStatus() {
        return new RetriesStatusNested(-1, null);
    }

    public RetriesStatusNested<A> addNewRetriesStatusLike(RunStatus item) {
        return new RetriesStatusNested(-1, item);
    }

    public RetriesStatusNested<A> setNewRetriesStatusLike(int index, RunStatus item) {
        return new RetriesStatusNested(index, item);
    }

    public RetriesStatusNested<A> editRetriesStatus(int index) {
        if (this.retriesStatus.size() <= index) {
            throw new RuntimeException("Can't edit retriesStatus. Index exceeds size.");
        }
        return this.setNewRetriesStatusLike(index, this.buildRetriesStatus(index));
    }

    public RetriesStatusNested<A> editFirstRetriesStatus() {
        if (this.retriesStatus.size() == 0) {
            throw new RuntimeException("Can't edit first retriesStatus. The list is empty.");
        }
        return this.setNewRetriesStatusLike(0, this.buildRetriesStatus(0));
    }

    public RetriesStatusNested<A> editLastRetriesStatus() {
        int index = this.retriesStatus.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last retriesStatus. The list is empty.");
        }
        return this.setNewRetriesStatusLike(index, this.buildRetriesStatus(index));
    }

    public RetriesStatusNested<A> editMatchingRetriesStatus(Predicate<RunStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.retriesStatus.size(); ++i) {
            if (!predicate.test(this.retriesStatus.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching retriesStatus. No match found.");
        }
        return this.setNewRetriesStatusLike(index, this.buildRetriesStatus(index));
    }

    public String getStartTime() {
        return this.startTime;
    }

    public A withStartTime(String startTime) {
        this.startTime = startTime;
        return (A)((Object)this);
    }

    public boolean hasStartTime() {
        return this.startTime != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RunStatusFluent that = (RunStatusFluent)((Object)o);
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals(this.completionTime, that.completionTime)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.extraFields, that.extraFields)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        if (!Objects.equals(this.results, that.results)) {
            return false;
        }
        if (!Objects.equals(this.retriesStatus, that.retriesStatus)) {
            return false;
        }
        if (!Objects.equals(this.startTime, that.startTime)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.annotations, this.completionTime, this.conditions, this.extraFields, this.observedGeneration, this.results, this.retriesStatus, this.startTime, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(String.valueOf(this.annotations) + ",");
        }
        if (this.completionTime != null) {
            sb.append("completionTime:");
            sb.append(this.completionTime + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(String.valueOf(this.conditions) + ",");
        }
        if (this.extraFields != null) {
            sb.append("extraFields:");
            sb.append(String.valueOf(this.extraFields) + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.results != null && !this.results.isEmpty()) {
            sb.append("results:");
            sb.append(String.valueOf(this.results) + ",");
        }
        if (this.retriesStatus != null && !this.retriesStatus.isEmpty()) {
            sb.append("retriesStatus:");
            sb.append(String.valueOf(this.retriesStatus) + ",");
        }
        if (this.startTime != null) {
            sb.append("startTime:");
            sb.append(this.startTime + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RetriesStatusNested<N>
    extends RunStatusFluent<RetriesStatusNested<N>>
    implements Nested<N> {
        RunStatusBuilder builder;
        int index;

        RetriesStatusNested(int index, RunStatus item) {
            this.index = index;
            this.builder = new RunStatusBuilder(this, item);
        }

        public N and() {
            return (N)RunStatusFluent.this.setToRetriesStatus(this.index, this.builder.build());
        }

        public N endRetriesStatus() {
            return this.and();
        }
    }

    public class ResultsNested<N>
    extends RunResultFluent<ResultsNested<N>>
    implements Nested<N> {
        RunResultBuilder builder;
        int index;

        ResultsNested(int index, RunResult item) {
            this.index = index;
            this.builder = new RunResultBuilder(this, item);
        }

        public N and() {
            return (N)RunStatusFluent.this.setToResults(this.index, this.builder.build());
        }

        public N endResult() {
            return this.and();
        }
    }
}

