package io.fabric8.tekton.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import io.fabric8.tekton.pipeline.pkg.result.RunResult;
import io.fabric8.tekton.pipeline.pkg.result.RunResultBuilder;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Iterator;
import io.fabric8.tekton.pipeline.pkg.result.RunResultFluent;
import java.lang.Integer;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class TaskRunStatusFieldsFluent<A extends TaskRunStatusFieldsFluent<A>> extends BaseFluent<A>{
  public TaskRunStatusFieldsFluent() {
  }
  
  public TaskRunStatusFieldsFluent(TaskRunStatusFields instance) {
    this.copyInstance(instance);
  }
  private ArrayList<CloudEventDeliveryBuilder> cloudEvents = new ArrayList<CloudEventDeliveryBuilder>();
  private String completionTime;
  private String podName;
  private ProvenanceBuilder provenance;
  private ArrayList<RunResultBuilder> resourcesResult = new ArrayList<RunResultBuilder>();
  private ArrayList<TaskRunStatusBuilder> retriesStatus = new ArrayList<TaskRunStatusBuilder>();
  private ArrayList<SidecarStateBuilder> sidecars = new ArrayList<SidecarStateBuilder>();
  private Map<String,String> spanContext;
  private String startTime;
  private ArrayList<StepStateBuilder> steps = new ArrayList<StepStateBuilder>();
  private ArrayList<TaskRunResultBuilder> taskResults = new ArrayList<TaskRunResultBuilder>();
  private TaskSpecBuilder taskSpec;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(TaskRunStatusFields instance) {
    instance = (instance != null ? instance : new TaskRunStatusFields());
    if (instance != null) {
          this.withCloudEvents(instance.getCloudEvents());
          this.withCompletionTime(instance.getCompletionTime());
          this.withPodName(instance.getPodName());
          this.withProvenance(instance.getProvenance());
          this.withResourcesResult(instance.getResourcesResult());
          this.withRetriesStatus(instance.getRetriesStatus());
          this.withSidecars(instance.getSidecars());
          this.withSpanContext(instance.getSpanContext());
          this.withStartTime(instance.getStartTime());
          this.withSteps(instance.getSteps());
          this.withTaskResults(instance.getTaskResults());
          this.withTaskSpec(instance.getTaskSpec());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToCloudEvents(int index,CloudEventDelivery item) {
    if (this.cloudEvents == null) {this.cloudEvents = new ArrayList<CloudEventDeliveryBuilder>();}
    CloudEventDeliveryBuilder builder = new CloudEventDeliveryBuilder(item);
    if (index < 0 || index >= cloudEvents.size()) {
        _visitables.get("cloudEvents").add(builder);
        cloudEvents.add(builder);
    } else {
        _visitables.get("cloudEvents").add(builder);
        cloudEvents.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToCloudEvents(int index,CloudEventDelivery item) {
    if (this.cloudEvents == null) {this.cloudEvents = new ArrayList<CloudEventDeliveryBuilder>();}
    CloudEventDeliveryBuilder builder = new CloudEventDeliveryBuilder(item);
    if (index < 0 || index >= cloudEvents.size()) {
        _visitables.get("cloudEvents").add(builder);
        cloudEvents.add(builder);
    } else {
        _visitables.get("cloudEvents").add(builder);
        cloudEvents.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToCloudEvents(io.fabric8.tekton.v1beta1.CloudEventDelivery... items) {
    if (this.cloudEvents == null) {this.cloudEvents = new ArrayList<CloudEventDeliveryBuilder>();}
    for (CloudEventDelivery item : items) {CloudEventDeliveryBuilder builder = new CloudEventDeliveryBuilder(item);_visitables.get("cloudEvents").add(builder);this.cloudEvents.add(builder);} return (A)this;
  }
  
  public A addAllToCloudEvents(Collection<CloudEventDelivery> items) {
    if (this.cloudEvents == null) {this.cloudEvents = new ArrayList<CloudEventDeliveryBuilder>();}
    for (CloudEventDelivery item : items) {CloudEventDeliveryBuilder builder = new CloudEventDeliveryBuilder(item);_visitables.get("cloudEvents").add(builder);this.cloudEvents.add(builder);} return (A)this;
  }
  
  public A removeFromCloudEvents(io.fabric8.tekton.v1beta1.CloudEventDelivery... items) {
    if (this.cloudEvents == null) return (A)this;
    for (CloudEventDelivery item : items) {CloudEventDeliveryBuilder builder = new CloudEventDeliveryBuilder(item);_visitables.get("cloudEvents").remove(builder); this.cloudEvents.remove(builder);} return (A)this;
  }
  
  public A removeAllFromCloudEvents(Collection<CloudEventDelivery> items) {
    if (this.cloudEvents == null) return (A)this;
    for (CloudEventDelivery item : items) {CloudEventDeliveryBuilder builder = new CloudEventDeliveryBuilder(item);_visitables.get("cloudEvents").remove(builder); this.cloudEvents.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromCloudEvents(Predicate<CloudEventDeliveryBuilder> predicate) {
    if (cloudEvents == null) return (A) this;
    final Iterator<CloudEventDeliveryBuilder> each = cloudEvents.iterator();
    final List visitables = _visitables.get("cloudEvents");
    while (each.hasNext()) {
      CloudEventDeliveryBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<CloudEventDelivery> buildCloudEvents() {
    return this.cloudEvents != null ? build(cloudEvents) : null;
  }
  
  public CloudEventDelivery buildCloudEvent(int index) {
    return this.cloudEvents.get(index).build();
  }
  
  public CloudEventDelivery buildFirstCloudEvent() {
    return this.cloudEvents.get(0).build();
  }
  
  public CloudEventDelivery buildLastCloudEvent() {
    return this.cloudEvents.get(cloudEvents.size() - 1).build();
  }
  
  public CloudEventDelivery buildMatchingCloudEvent(Predicate<CloudEventDeliveryBuilder> predicate) {
      for (CloudEventDeliveryBuilder item : cloudEvents) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingCloudEvent(Predicate<CloudEventDeliveryBuilder> predicate) {
      for (CloudEventDeliveryBuilder item : cloudEvents) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withCloudEvents(List<CloudEventDelivery> cloudEvents) {
    if (this.cloudEvents != null) {
      this._visitables.get("cloudEvents").clear();
    }
    if (cloudEvents != null) {
        this.cloudEvents = new ArrayList();
        for (CloudEventDelivery item : cloudEvents) {
          this.addToCloudEvents(item);
        }
    } else {
      this.cloudEvents = null;
    }
    return (A) this;
  }
  
  public A withCloudEvents(io.fabric8.tekton.v1beta1.CloudEventDelivery... cloudEvents) {
    if (this.cloudEvents != null) {
        this.cloudEvents.clear();
        _visitables.remove("cloudEvents");
    }
    if (cloudEvents != null) {
      for (CloudEventDelivery item : cloudEvents) {
        this.addToCloudEvents(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasCloudEvents() {
    return this.cloudEvents != null && !this.cloudEvents.isEmpty();
  }
  
  public CloudEventsNested<A> addNewCloudEvent() {
    return new CloudEventsNested(-1, null);
  }
  
  public CloudEventsNested<A> addNewCloudEventLike(CloudEventDelivery item) {
    return new CloudEventsNested(-1, item);
  }
  
  public CloudEventsNested<A> setNewCloudEventLike(int index,CloudEventDelivery item) {
    return new CloudEventsNested(index, item);
  }
  
  public CloudEventsNested<A> editCloudEvent(int index) {
    if (cloudEvents.size() <= index) throw new RuntimeException("Can't edit cloudEvents. Index exceeds size.");
    return setNewCloudEventLike(index, buildCloudEvent(index));
  }
  
  public CloudEventsNested<A> editFirstCloudEvent() {
    if (cloudEvents.size() == 0) throw new RuntimeException("Can't edit first cloudEvents. The list is empty.");
    return setNewCloudEventLike(0, buildCloudEvent(0));
  }
  
  public CloudEventsNested<A> editLastCloudEvent() {
    int index = cloudEvents.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last cloudEvents. The list is empty.");
    return setNewCloudEventLike(index, buildCloudEvent(index));
  }
  
  public CloudEventsNested<A> editMatchingCloudEvent(Predicate<CloudEventDeliveryBuilder> predicate) {
    int index = -1;
    for (int i=0;i<cloudEvents.size();i++) { 
    if (predicate.test(cloudEvents.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching cloudEvents. No match found.");
    return setNewCloudEventLike(index, buildCloudEvent(index));
  }
  
  public String getCompletionTime() {
    return this.completionTime;
  }
  
  public A withCompletionTime(String completionTime) {
    this.completionTime = completionTime;
    return (A) this;
  }
  
  public boolean hasCompletionTime() {
    return this.completionTime != null;
  }
  
  public String getPodName() {
    return this.podName;
  }
  
  public A withPodName(String podName) {
    this.podName = podName;
    return (A) this;
  }
  
  public boolean hasPodName() {
    return this.podName != null;
  }
  
  public Provenance buildProvenance() {
    return this.provenance != null ? this.provenance.build() : null;
  }
  
  public A withProvenance(Provenance provenance) {
    this._visitables.remove("provenance");
    if (provenance != null) {
        this.provenance = new ProvenanceBuilder(provenance);
        this._visitables.get("provenance").add(this.provenance);
    } else {
        this.provenance = null;
        this._visitables.get("provenance").remove(this.provenance);
    }
    return (A) this;
  }
  
  public boolean hasProvenance() {
    return this.provenance != null;
  }
  
  public ProvenanceNested<A> withNewProvenance() {
    return new ProvenanceNested(null);
  }
  
  public ProvenanceNested<A> withNewProvenanceLike(Provenance item) {
    return new ProvenanceNested(item);
  }
  
  public ProvenanceNested<A> editProvenance() {
    return withNewProvenanceLike(java.util.Optional.ofNullable(buildProvenance()).orElse(null));
  }
  
  public ProvenanceNested<A> editOrNewProvenance() {
    return withNewProvenanceLike(java.util.Optional.ofNullable(buildProvenance()).orElse(new ProvenanceBuilder().build()));
  }
  
  public ProvenanceNested<A> editOrNewProvenanceLike(Provenance item) {
    return withNewProvenanceLike(java.util.Optional.ofNullable(buildProvenance()).orElse(item));
  }
  
  public A addToResourcesResult(int index,RunResult item) {
    if (this.resourcesResult == null) {this.resourcesResult = new ArrayList<RunResultBuilder>();}
    RunResultBuilder builder = new RunResultBuilder(item);
    if (index < 0 || index >= resourcesResult.size()) {
        _visitables.get("resourcesResult").add(builder);
        resourcesResult.add(builder);
    } else {
        _visitables.get("resourcesResult").add(builder);
        resourcesResult.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToResourcesResult(int index,RunResult item) {
    if (this.resourcesResult == null) {this.resourcesResult = new ArrayList<RunResultBuilder>();}
    RunResultBuilder builder = new RunResultBuilder(item);
    if (index < 0 || index >= resourcesResult.size()) {
        _visitables.get("resourcesResult").add(builder);
        resourcesResult.add(builder);
    } else {
        _visitables.get("resourcesResult").add(builder);
        resourcesResult.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToResourcesResult(io.fabric8.tekton.pipeline.pkg.result.RunResult... items) {
    if (this.resourcesResult == null) {this.resourcesResult = new ArrayList<RunResultBuilder>();}
    for (RunResult item : items) {RunResultBuilder builder = new RunResultBuilder(item);_visitables.get("resourcesResult").add(builder);this.resourcesResult.add(builder);} return (A)this;
  }
  
  public A addAllToResourcesResult(Collection<RunResult> items) {
    if (this.resourcesResult == null) {this.resourcesResult = new ArrayList<RunResultBuilder>();}
    for (RunResult item : items) {RunResultBuilder builder = new RunResultBuilder(item);_visitables.get("resourcesResult").add(builder);this.resourcesResult.add(builder);} return (A)this;
  }
  
  public A removeFromResourcesResult(io.fabric8.tekton.pipeline.pkg.result.RunResult... items) {
    if (this.resourcesResult == null) return (A)this;
    for (RunResult item : items) {RunResultBuilder builder = new RunResultBuilder(item);_visitables.get("resourcesResult").remove(builder); this.resourcesResult.remove(builder);} return (A)this;
  }
  
  public A removeAllFromResourcesResult(Collection<RunResult> items) {
    if (this.resourcesResult == null) return (A)this;
    for (RunResult item : items) {RunResultBuilder builder = new RunResultBuilder(item);_visitables.get("resourcesResult").remove(builder); this.resourcesResult.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromResourcesResult(Predicate<RunResultBuilder> predicate) {
    if (resourcesResult == null) return (A) this;
    final Iterator<RunResultBuilder> each = resourcesResult.iterator();
    final List visitables = _visitables.get("resourcesResult");
    while (each.hasNext()) {
      RunResultBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<RunResult> buildResourcesResult() {
    return this.resourcesResult != null ? build(resourcesResult) : null;
  }
  
  public RunResult buildResourcesResult(int index) {
    return this.resourcesResult.get(index).build();
  }
  
  public RunResult buildFirstResourcesResult() {
    return this.resourcesResult.get(0).build();
  }
  
  public RunResult buildLastResourcesResult() {
    return this.resourcesResult.get(resourcesResult.size() - 1).build();
  }
  
  public RunResult buildMatchingResourcesResult(Predicate<RunResultBuilder> predicate) {
      for (RunResultBuilder item : resourcesResult) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingResourcesResult(Predicate<RunResultBuilder> predicate) {
      for (RunResultBuilder item : resourcesResult) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withResourcesResult(List<RunResult> resourcesResult) {
    if (this.resourcesResult != null) {
      this._visitables.get("resourcesResult").clear();
    }
    if (resourcesResult != null) {
        this.resourcesResult = new ArrayList();
        for (RunResult item : resourcesResult) {
          this.addToResourcesResult(item);
        }
    } else {
      this.resourcesResult = null;
    }
    return (A) this;
  }
  
  public A withResourcesResult(io.fabric8.tekton.pipeline.pkg.result.RunResult... resourcesResult) {
    if (this.resourcesResult != null) {
        this.resourcesResult.clear();
        _visitables.remove("resourcesResult");
    }
    if (resourcesResult != null) {
      for (RunResult item : resourcesResult) {
        this.addToResourcesResult(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasResourcesResult() {
    return this.resourcesResult != null && !this.resourcesResult.isEmpty();
  }
  
  public A addNewResourcesResult(String key,String resourceName,Integer type,String value) {
    return (A)addToResourcesResult(new RunResult(key, resourceName, type, value));
  }
  
  public ResourcesResultNested<A> addNewResourcesResult() {
    return new ResourcesResultNested(-1, null);
  }
  
  public ResourcesResultNested<A> addNewResourcesResultLike(RunResult item) {
    return new ResourcesResultNested(-1, item);
  }
  
  public ResourcesResultNested<A> setNewResourcesResultLike(int index,RunResult item) {
    return new ResourcesResultNested(index, item);
  }
  
  public ResourcesResultNested<A> editResourcesResult(int index) {
    if (resourcesResult.size() <= index) throw new RuntimeException("Can't edit resourcesResult. Index exceeds size.");
    return setNewResourcesResultLike(index, buildResourcesResult(index));
  }
  
  public ResourcesResultNested<A> editFirstResourcesResult() {
    if (resourcesResult.size() == 0) throw new RuntimeException("Can't edit first resourcesResult. The list is empty.");
    return setNewResourcesResultLike(0, buildResourcesResult(0));
  }
  
  public ResourcesResultNested<A> editLastResourcesResult() {
    int index = resourcesResult.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last resourcesResult. The list is empty.");
    return setNewResourcesResultLike(index, buildResourcesResult(index));
  }
  
  public ResourcesResultNested<A> editMatchingResourcesResult(Predicate<RunResultBuilder> predicate) {
    int index = -1;
    for (int i=0;i<resourcesResult.size();i++) { 
    if (predicate.test(resourcesResult.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching resourcesResult. No match found.");
    return setNewResourcesResultLike(index, buildResourcesResult(index));
  }
  
  public A addToRetriesStatus(int index,TaskRunStatus item) {
    if (this.retriesStatus == null) {this.retriesStatus = new ArrayList<TaskRunStatusBuilder>();}
    TaskRunStatusBuilder builder = new TaskRunStatusBuilder(item);
    if (index < 0 || index >= retriesStatus.size()) {
        _visitables.get("retriesStatus").add(builder);
        retriesStatus.add(builder);
    } else {
        _visitables.get("retriesStatus").add(builder);
        retriesStatus.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToRetriesStatus(int index,TaskRunStatus item) {
    if (this.retriesStatus == null) {this.retriesStatus = new ArrayList<TaskRunStatusBuilder>();}
    TaskRunStatusBuilder builder = new TaskRunStatusBuilder(item);
    if (index < 0 || index >= retriesStatus.size()) {
        _visitables.get("retriesStatus").add(builder);
        retriesStatus.add(builder);
    } else {
        _visitables.get("retriesStatus").add(builder);
        retriesStatus.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToRetriesStatus(io.fabric8.tekton.v1beta1.TaskRunStatus... items) {
    if (this.retriesStatus == null) {this.retriesStatus = new ArrayList<TaskRunStatusBuilder>();}
    for (TaskRunStatus item : items) {TaskRunStatusBuilder builder = new TaskRunStatusBuilder(item);_visitables.get("retriesStatus").add(builder);this.retriesStatus.add(builder);} return (A)this;
  }
  
  public A addAllToRetriesStatus(Collection<TaskRunStatus> items) {
    if (this.retriesStatus == null) {this.retriesStatus = new ArrayList<TaskRunStatusBuilder>();}
    for (TaskRunStatus item : items) {TaskRunStatusBuilder builder = new TaskRunStatusBuilder(item);_visitables.get("retriesStatus").add(builder);this.retriesStatus.add(builder);} return (A)this;
  }
  
  public A removeFromRetriesStatus(io.fabric8.tekton.v1beta1.TaskRunStatus... items) {
    if (this.retriesStatus == null) return (A)this;
    for (TaskRunStatus item : items) {TaskRunStatusBuilder builder = new TaskRunStatusBuilder(item);_visitables.get("retriesStatus").remove(builder); this.retriesStatus.remove(builder);} return (A)this;
  }
  
  public A removeAllFromRetriesStatus(Collection<TaskRunStatus> items) {
    if (this.retriesStatus == null) return (A)this;
    for (TaskRunStatus item : items) {TaskRunStatusBuilder builder = new TaskRunStatusBuilder(item);_visitables.get("retriesStatus").remove(builder); this.retriesStatus.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromRetriesStatus(Predicate<TaskRunStatusBuilder> predicate) {
    if (retriesStatus == null) return (A) this;
    final Iterator<TaskRunStatusBuilder> each = retriesStatus.iterator();
    final List visitables = _visitables.get("retriesStatus");
    while (each.hasNext()) {
      TaskRunStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<TaskRunStatus> buildRetriesStatus() {
    return this.retriesStatus != null ? build(retriesStatus) : null;
  }
  
  public TaskRunStatus buildRetriesStatus(int index) {
    return this.retriesStatus.get(index).build();
  }
  
  public TaskRunStatus buildFirstRetriesStatus() {
    return this.retriesStatus.get(0).build();
  }
  
  public TaskRunStatus buildLastRetriesStatus() {
    return this.retriesStatus.get(retriesStatus.size() - 1).build();
  }
  
  public TaskRunStatus buildMatchingRetriesStatus(Predicate<TaskRunStatusBuilder> predicate) {
      for (TaskRunStatusBuilder item : retriesStatus) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingRetriesStatus(Predicate<TaskRunStatusBuilder> predicate) {
      for (TaskRunStatusBuilder item : retriesStatus) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withRetriesStatus(List<TaskRunStatus> retriesStatus) {
    if (this.retriesStatus != null) {
      this._visitables.get("retriesStatus").clear();
    }
    if (retriesStatus != null) {
        this.retriesStatus = new ArrayList();
        for (TaskRunStatus item : retriesStatus) {
          this.addToRetriesStatus(item);
        }
    } else {
      this.retriesStatus = null;
    }
    return (A) this;
  }
  
  public A withRetriesStatus(io.fabric8.tekton.v1beta1.TaskRunStatus... retriesStatus) {
    if (this.retriesStatus != null) {
        this.retriesStatus.clear();
        _visitables.remove("retriesStatus");
    }
    if (retriesStatus != null) {
      for (TaskRunStatus item : retriesStatus) {
        this.addToRetriesStatus(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasRetriesStatus() {
    return this.retriesStatus != null && !this.retriesStatus.isEmpty();
  }
  
  public RetriesStatusNested<A> addNewRetriesStatus() {
    return new RetriesStatusNested(-1, null);
  }
  
  public RetriesStatusNested<A> addNewRetriesStatusLike(TaskRunStatus item) {
    return new RetriesStatusNested(-1, item);
  }
  
  public RetriesStatusNested<A> setNewRetriesStatusLike(int index,TaskRunStatus item) {
    return new RetriesStatusNested(index, item);
  }
  
  public RetriesStatusNested<A> editRetriesStatus(int index) {
    if (retriesStatus.size() <= index) throw new RuntimeException("Can't edit retriesStatus. Index exceeds size.");
    return setNewRetriesStatusLike(index, buildRetriesStatus(index));
  }
  
  public RetriesStatusNested<A> editFirstRetriesStatus() {
    if (retriesStatus.size() == 0) throw new RuntimeException("Can't edit first retriesStatus. The list is empty.");
    return setNewRetriesStatusLike(0, buildRetriesStatus(0));
  }
  
  public RetriesStatusNested<A> editLastRetriesStatus() {
    int index = retriesStatus.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last retriesStatus. The list is empty.");
    return setNewRetriesStatusLike(index, buildRetriesStatus(index));
  }
  
  public RetriesStatusNested<A> editMatchingRetriesStatus(Predicate<TaskRunStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<retriesStatus.size();i++) { 
    if (predicate.test(retriesStatus.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching retriesStatus. No match found.");
    return setNewRetriesStatusLike(index, buildRetriesStatus(index));
  }
  
  public A addToSidecars(int index,SidecarState item) {
    if (this.sidecars == null) {this.sidecars = new ArrayList<SidecarStateBuilder>();}
    SidecarStateBuilder builder = new SidecarStateBuilder(item);
    if (index < 0 || index >= sidecars.size()) {
        _visitables.get("sidecars").add(builder);
        sidecars.add(builder);
    } else {
        _visitables.get("sidecars").add(builder);
        sidecars.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToSidecars(int index,SidecarState item) {
    if (this.sidecars == null) {this.sidecars = new ArrayList<SidecarStateBuilder>();}
    SidecarStateBuilder builder = new SidecarStateBuilder(item);
    if (index < 0 || index >= sidecars.size()) {
        _visitables.get("sidecars").add(builder);
        sidecars.add(builder);
    } else {
        _visitables.get("sidecars").add(builder);
        sidecars.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToSidecars(io.fabric8.tekton.v1beta1.SidecarState... items) {
    if (this.sidecars == null) {this.sidecars = new ArrayList<SidecarStateBuilder>();}
    for (SidecarState item : items) {SidecarStateBuilder builder = new SidecarStateBuilder(item);_visitables.get("sidecars").add(builder);this.sidecars.add(builder);} return (A)this;
  }
  
  public A addAllToSidecars(Collection<SidecarState> items) {
    if (this.sidecars == null) {this.sidecars = new ArrayList<SidecarStateBuilder>();}
    for (SidecarState item : items) {SidecarStateBuilder builder = new SidecarStateBuilder(item);_visitables.get("sidecars").add(builder);this.sidecars.add(builder);} return (A)this;
  }
  
  public A removeFromSidecars(io.fabric8.tekton.v1beta1.SidecarState... items) {
    if (this.sidecars == null) return (A)this;
    for (SidecarState item : items) {SidecarStateBuilder builder = new SidecarStateBuilder(item);_visitables.get("sidecars").remove(builder); this.sidecars.remove(builder);} return (A)this;
  }
  
  public A removeAllFromSidecars(Collection<SidecarState> items) {
    if (this.sidecars == null) return (A)this;
    for (SidecarState item : items) {SidecarStateBuilder builder = new SidecarStateBuilder(item);_visitables.get("sidecars").remove(builder); this.sidecars.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromSidecars(Predicate<SidecarStateBuilder> predicate) {
    if (sidecars == null) return (A) this;
    final Iterator<SidecarStateBuilder> each = sidecars.iterator();
    final List visitables = _visitables.get("sidecars");
    while (each.hasNext()) {
      SidecarStateBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<SidecarState> buildSidecars() {
    return this.sidecars != null ? build(sidecars) : null;
  }
  
  public SidecarState buildSidecar(int index) {
    return this.sidecars.get(index).build();
  }
  
  public SidecarState buildFirstSidecar() {
    return this.sidecars.get(0).build();
  }
  
  public SidecarState buildLastSidecar() {
    return this.sidecars.get(sidecars.size() - 1).build();
  }
  
  public SidecarState buildMatchingSidecar(Predicate<SidecarStateBuilder> predicate) {
      for (SidecarStateBuilder item : sidecars) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingSidecar(Predicate<SidecarStateBuilder> predicate) {
      for (SidecarStateBuilder item : sidecars) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withSidecars(List<SidecarState> sidecars) {
    if (this.sidecars != null) {
      this._visitables.get("sidecars").clear();
    }
    if (sidecars != null) {
        this.sidecars = new ArrayList();
        for (SidecarState item : sidecars) {
          this.addToSidecars(item);
        }
    } else {
      this.sidecars = null;
    }
    return (A) this;
  }
  
  public A withSidecars(io.fabric8.tekton.v1beta1.SidecarState... sidecars) {
    if (this.sidecars != null) {
        this.sidecars.clear();
        _visitables.remove("sidecars");
    }
    if (sidecars != null) {
      for (SidecarState item : sidecars) {
        this.addToSidecars(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasSidecars() {
    return this.sidecars != null && !this.sidecars.isEmpty();
  }
  
  public SidecarsNested<A> addNewSidecar() {
    return new SidecarsNested(-1, null);
  }
  
  public SidecarsNested<A> addNewSidecarLike(SidecarState item) {
    return new SidecarsNested(-1, item);
  }
  
  public SidecarsNested<A> setNewSidecarLike(int index,SidecarState item) {
    return new SidecarsNested(index, item);
  }
  
  public SidecarsNested<A> editSidecar(int index) {
    if (sidecars.size() <= index) throw new RuntimeException("Can't edit sidecars. Index exceeds size.");
    return setNewSidecarLike(index, buildSidecar(index));
  }
  
  public SidecarsNested<A> editFirstSidecar() {
    if (sidecars.size() == 0) throw new RuntimeException("Can't edit first sidecars. The list is empty.");
    return setNewSidecarLike(0, buildSidecar(0));
  }
  
  public SidecarsNested<A> editLastSidecar() {
    int index = sidecars.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last sidecars. The list is empty.");
    return setNewSidecarLike(index, buildSidecar(index));
  }
  
  public SidecarsNested<A> editMatchingSidecar(Predicate<SidecarStateBuilder> predicate) {
    int index = -1;
    for (int i=0;i<sidecars.size();i++) { 
    if (predicate.test(sidecars.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching sidecars. No match found.");
    return setNewSidecarLike(index, buildSidecar(index));
  }
  
  public A addToSpanContext(String key,String value) {
    if(this.spanContext == null && key != null && value != null) { this.spanContext = new LinkedHashMap(); }
    if(key != null && value != null) {this.spanContext.put(key, value);} return (A)this;
  }
  
  public A addToSpanContext(Map<String,String> map) {
    if(this.spanContext == null && map != null) { this.spanContext = new LinkedHashMap(); }
    if(map != null) { this.spanContext.putAll(map);} return (A)this;
  }
  
  public A removeFromSpanContext(String key) {
    if(this.spanContext == null) { return (A) this; }
    if(key != null && this.spanContext != null) {this.spanContext.remove(key);} return (A)this;
  }
  
  public A removeFromSpanContext(Map<String,String> map) {
    if(this.spanContext == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.spanContext != null){this.spanContext.remove(key);}}} return (A)this;
  }
  
  public Map<String,String> getSpanContext() {
    return this.spanContext;
  }
  
  public <K,V>A withSpanContext(Map<String,String> spanContext) {
    if (spanContext == null) {
      this.spanContext = null;
    } else {
      this.spanContext = new LinkedHashMap(spanContext);
    }
    return (A) this;
  }
  
  public boolean hasSpanContext() {
    return this.spanContext != null;
  }
  
  public String getStartTime() {
    return this.startTime;
  }
  
  public A withStartTime(String startTime) {
    this.startTime = startTime;
    return (A) this;
  }
  
  public boolean hasStartTime() {
    return this.startTime != null;
  }
  
  public A addToSteps(int index,StepState item) {
    if (this.steps == null) {this.steps = new ArrayList<StepStateBuilder>();}
    StepStateBuilder builder = new StepStateBuilder(item);
    if (index < 0 || index >= steps.size()) {
        _visitables.get("steps").add(builder);
        steps.add(builder);
    } else {
        _visitables.get("steps").add(builder);
        steps.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToSteps(int index,StepState item) {
    if (this.steps == null) {this.steps = new ArrayList<StepStateBuilder>();}
    StepStateBuilder builder = new StepStateBuilder(item);
    if (index < 0 || index >= steps.size()) {
        _visitables.get("steps").add(builder);
        steps.add(builder);
    } else {
        _visitables.get("steps").add(builder);
        steps.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToSteps(io.fabric8.tekton.v1beta1.StepState... items) {
    if (this.steps == null) {this.steps = new ArrayList<StepStateBuilder>();}
    for (StepState item : items) {StepStateBuilder builder = new StepStateBuilder(item);_visitables.get("steps").add(builder);this.steps.add(builder);} return (A)this;
  }
  
  public A addAllToSteps(Collection<StepState> items) {
    if (this.steps == null) {this.steps = new ArrayList<StepStateBuilder>();}
    for (StepState item : items) {StepStateBuilder builder = new StepStateBuilder(item);_visitables.get("steps").add(builder);this.steps.add(builder);} return (A)this;
  }
  
  public A removeFromSteps(io.fabric8.tekton.v1beta1.StepState... items) {
    if (this.steps == null) return (A)this;
    for (StepState item : items) {StepStateBuilder builder = new StepStateBuilder(item);_visitables.get("steps").remove(builder); this.steps.remove(builder);} return (A)this;
  }
  
  public A removeAllFromSteps(Collection<StepState> items) {
    if (this.steps == null) return (A)this;
    for (StepState item : items) {StepStateBuilder builder = new StepStateBuilder(item);_visitables.get("steps").remove(builder); this.steps.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromSteps(Predicate<StepStateBuilder> predicate) {
    if (steps == null) return (A) this;
    final Iterator<StepStateBuilder> each = steps.iterator();
    final List visitables = _visitables.get("steps");
    while (each.hasNext()) {
      StepStateBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<StepState> buildSteps() {
    return this.steps != null ? build(steps) : null;
  }
  
  public StepState buildStep(int index) {
    return this.steps.get(index).build();
  }
  
  public StepState buildFirstStep() {
    return this.steps.get(0).build();
  }
  
  public StepState buildLastStep() {
    return this.steps.get(steps.size() - 1).build();
  }
  
  public StepState buildMatchingStep(Predicate<StepStateBuilder> predicate) {
      for (StepStateBuilder item : steps) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingStep(Predicate<StepStateBuilder> predicate) {
      for (StepStateBuilder item : steps) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withSteps(List<StepState> steps) {
    if (this.steps != null) {
      this._visitables.get("steps").clear();
    }
    if (steps != null) {
        this.steps = new ArrayList();
        for (StepState item : steps) {
          this.addToSteps(item);
        }
    } else {
      this.steps = null;
    }
    return (A) this;
  }
  
  public A withSteps(io.fabric8.tekton.v1beta1.StepState... steps) {
    if (this.steps != null) {
        this.steps.clear();
        _visitables.remove("steps");
    }
    if (steps != null) {
      for (StepState item : steps) {
        this.addToSteps(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasSteps() {
    return this.steps != null && !this.steps.isEmpty();
  }
  
  public StepsNested<A> addNewStep() {
    return new StepsNested(-1, null);
  }
  
  public StepsNested<A> addNewStepLike(StepState item) {
    return new StepsNested(-1, item);
  }
  
  public StepsNested<A> setNewStepLike(int index,StepState item) {
    return new StepsNested(index, item);
  }
  
  public StepsNested<A> editStep(int index) {
    if (steps.size() <= index) throw new RuntimeException("Can't edit steps. Index exceeds size.");
    return setNewStepLike(index, buildStep(index));
  }
  
  public StepsNested<A> editFirstStep() {
    if (steps.size() == 0) throw new RuntimeException("Can't edit first steps. The list is empty.");
    return setNewStepLike(0, buildStep(0));
  }
  
  public StepsNested<A> editLastStep() {
    int index = steps.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last steps. The list is empty.");
    return setNewStepLike(index, buildStep(index));
  }
  
  public StepsNested<A> editMatchingStep(Predicate<StepStateBuilder> predicate) {
    int index = -1;
    for (int i=0;i<steps.size();i++) { 
    if (predicate.test(steps.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching steps. No match found.");
    return setNewStepLike(index, buildStep(index));
  }
  
  public A addToTaskResults(int index,TaskRunResult item) {
    if (this.taskResults == null) {this.taskResults = new ArrayList<TaskRunResultBuilder>();}
    TaskRunResultBuilder builder = new TaskRunResultBuilder(item);
    if (index < 0 || index >= taskResults.size()) {
        _visitables.get("taskResults").add(builder);
        taskResults.add(builder);
    } else {
        _visitables.get("taskResults").add(builder);
        taskResults.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToTaskResults(int index,TaskRunResult item) {
    if (this.taskResults == null) {this.taskResults = new ArrayList<TaskRunResultBuilder>();}
    TaskRunResultBuilder builder = new TaskRunResultBuilder(item);
    if (index < 0 || index >= taskResults.size()) {
        _visitables.get("taskResults").add(builder);
        taskResults.add(builder);
    } else {
        _visitables.get("taskResults").add(builder);
        taskResults.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToTaskResults(io.fabric8.tekton.v1beta1.TaskRunResult... items) {
    if (this.taskResults == null) {this.taskResults = new ArrayList<TaskRunResultBuilder>();}
    for (TaskRunResult item : items) {TaskRunResultBuilder builder = new TaskRunResultBuilder(item);_visitables.get("taskResults").add(builder);this.taskResults.add(builder);} return (A)this;
  }
  
  public A addAllToTaskResults(Collection<TaskRunResult> items) {
    if (this.taskResults == null) {this.taskResults = new ArrayList<TaskRunResultBuilder>();}
    for (TaskRunResult item : items) {TaskRunResultBuilder builder = new TaskRunResultBuilder(item);_visitables.get("taskResults").add(builder);this.taskResults.add(builder);} return (A)this;
  }
  
  public A removeFromTaskResults(io.fabric8.tekton.v1beta1.TaskRunResult... items) {
    if (this.taskResults == null) return (A)this;
    for (TaskRunResult item : items) {TaskRunResultBuilder builder = new TaskRunResultBuilder(item);_visitables.get("taskResults").remove(builder); this.taskResults.remove(builder);} return (A)this;
  }
  
  public A removeAllFromTaskResults(Collection<TaskRunResult> items) {
    if (this.taskResults == null) return (A)this;
    for (TaskRunResult item : items) {TaskRunResultBuilder builder = new TaskRunResultBuilder(item);_visitables.get("taskResults").remove(builder); this.taskResults.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromTaskResults(Predicate<TaskRunResultBuilder> predicate) {
    if (taskResults == null) return (A) this;
    final Iterator<TaskRunResultBuilder> each = taskResults.iterator();
    final List visitables = _visitables.get("taskResults");
    while (each.hasNext()) {
      TaskRunResultBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<TaskRunResult> buildTaskResults() {
    return this.taskResults != null ? build(taskResults) : null;
  }
  
  public TaskRunResult buildTaskResult(int index) {
    return this.taskResults.get(index).build();
  }
  
  public TaskRunResult buildFirstTaskResult() {
    return this.taskResults.get(0).build();
  }
  
  public TaskRunResult buildLastTaskResult() {
    return this.taskResults.get(taskResults.size() - 1).build();
  }
  
  public TaskRunResult buildMatchingTaskResult(Predicate<TaskRunResultBuilder> predicate) {
      for (TaskRunResultBuilder item : taskResults) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingTaskResult(Predicate<TaskRunResultBuilder> predicate) {
      for (TaskRunResultBuilder item : taskResults) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withTaskResults(List<TaskRunResult> taskResults) {
    if (this.taskResults != null) {
      this._visitables.get("taskResults").clear();
    }
    if (taskResults != null) {
        this.taskResults = new ArrayList();
        for (TaskRunResult item : taskResults) {
          this.addToTaskResults(item);
        }
    } else {
      this.taskResults = null;
    }
    return (A) this;
  }
  
  public A withTaskResults(io.fabric8.tekton.v1beta1.TaskRunResult... taskResults) {
    if (this.taskResults != null) {
        this.taskResults.clear();
        _visitables.remove("taskResults");
    }
    if (taskResults != null) {
      for (TaskRunResult item : taskResults) {
        this.addToTaskResults(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasTaskResults() {
    return this.taskResults != null && !this.taskResults.isEmpty();
  }
  
  public TaskResultsNested<A> addNewTaskResult() {
    return new TaskResultsNested(-1, null);
  }
  
  public TaskResultsNested<A> addNewTaskResultLike(TaskRunResult item) {
    return new TaskResultsNested(-1, item);
  }
  
  public TaskResultsNested<A> setNewTaskResultLike(int index,TaskRunResult item) {
    return new TaskResultsNested(index, item);
  }
  
  public TaskResultsNested<A> editTaskResult(int index) {
    if (taskResults.size() <= index) throw new RuntimeException("Can't edit taskResults. Index exceeds size.");
    return setNewTaskResultLike(index, buildTaskResult(index));
  }
  
  public TaskResultsNested<A> editFirstTaskResult() {
    if (taskResults.size() == 0) throw new RuntimeException("Can't edit first taskResults. The list is empty.");
    return setNewTaskResultLike(0, buildTaskResult(0));
  }
  
  public TaskResultsNested<A> editLastTaskResult() {
    int index = taskResults.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last taskResults. The list is empty.");
    return setNewTaskResultLike(index, buildTaskResult(index));
  }
  
  public TaskResultsNested<A> editMatchingTaskResult(Predicate<TaskRunResultBuilder> predicate) {
    int index = -1;
    for (int i=0;i<taskResults.size();i++) { 
    if (predicate.test(taskResults.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching taskResults. No match found.");
    return setNewTaskResultLike(index, buildTaskResult(index));
  }
  
  public TaskSpec buildTaskSpec() {
    return this.taskSpec != null ? this.taskSpec.build() : null;
  }
  
  public A withTaskSpec(TaskSpec taskSpec) {
    this._visitables.remove("taskSpec");
    if (taskSpec != null) {
        this.taskSpec = new TaskSpecBuilder(taskSpec);
        this._visitables.get("taskSpec").add(this.taskSpec);
    } else {
        this.taskSpec = null;
        this._visitables.get("taskSpec").remove(this.taskSpec);
    }
    return (A) this;
  }
  
  public boolean hasTaskSpec() {
    return this.taskSpec != null;
  }
  
  public TaskSpecNested<A> withNewTaskSpec() {
    return new TaskSpecNested(null);
  }
  
  public TaskSpecNested<A> withNewTaskSpecLike(TaskSpec item) {
    return new TaskSpecNested(item);
  }
  
  public TaskSpecNested<A> editTaskSpec() {
    return withNewTaskSpecLike(java.util.Optional.ofNullable(buildTaskSpec()).orElse(null));
  }
  
  public TaskSpecNested<A> editOrNewTaskSpec() {
    return withNewTaskSpecLike(java.util.Optional.ofNullable(buildTaskSpec()).orElse(new TaskSpecBuilder().build()));
  }
  
  public TaskSpecNested<A> editOrNewTaskSpecLike(TaskSpec item) {
    return withNewTaskSpecLike(java.util.Optional.ofNullable(buildTaskSpec()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TaskRunStatusFieldsFluent that = (TaskRunStatusFieldsFluent) o;
    if (!java.util.Objects.equals(cloudEvents, that.cloudEvents)) return false;
    if (!java.util.Objects.equals(completionTime, that.completionTime)) return false;
    if (!java.util.Objects.equals(podName, that.podName)) return false;
    if (!java.util.Objects.equals(provenance, that.provenance)) return false;
    if (!java.util.Objects.equals(resourcesResult, that.resourcesResult)) return false;
    if (!java.util.Objects.equals(retriesStatus, that.retriesStatus)) return false;
    if (!java.util.Objects.equals(sidecars, that.sidecars)) return false;
    if (!java.util.Objects.equals(spanContext, that.spanContext)) return false;
    if (!java.util.Objects.equals(startTime, that.startTime)) return false;
    if (!java.util.Objects.equals(steps, that.steps)) return false;
    if (!java.util.Objects.equals(taskResults, that.taskResults)) return false;
    if (!java.util.Objects.equals(taskSpec, that.taskSpec)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(cloudEvents,  completionTime,  podName,  provenance,  resourcesResult,  retriesStatus,  sidecars,  spanContext,  startTime,  steps,  taskResults,  taskSpec,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (cloudEvents != null && !cloudEvents.isEmpty()) { sb.append("cloudEvents:"); sb.append(cloudEvents + ","); }
    if (completionTime != null) { sb.append("completionTime:"); sb.append(completionTime + ","); }
    if (podName != null) { sb.append("podName:"); sb.append(podName + ","); }
    if (provenance != null) { sb.append("provenance:"); sb.append(provenance + ","); }
    if (resourcesResult != null && !resourcesResult.isEmpty()) { sb.append("resourcesResult:"); sb.append(resourcesResult + ","); }
    if (retriesStatus != null && !retriesStatus.isEmpty()) { sb.append("retriesStatus:"); sb.append(retriesStatus + ","); }
    if (sidecars != null && !sidecars.isEmpty()) { sb.append("sidecars:"); sb.append(sidecars + ","); }
    if (spanContext != null && !spanContext.isEmpty()) { sb.append("spanContext:"); sb.append(spanContext + ","); }
    if (startTime != null) { sb.append("startTime:"); sb.append(startTime + ","); }
    if (steps != null && !steps.isEmpty()) { sb.append("steps:"); sb.append(steps + ","); }
    if (taskResults != null && !taskResults.isEmpty()) { sb.append("taskResults:"); sb.append(taskResults + ","); }
    if (taskSpec != null) { sb.append("taskSpec:"); sb.append(taskSpec + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class CloudEventsNested<N> extends CloudEventDeliveryFluent<CloudEventsNested<N>> implements Nested<N>{
    CloudEventsNested(int index,CloudEventDelivery item) {
      this.index = index;
      this.builder = new CloudEventDeliveryBuilder(this, item);
    }
    CloudEventDeliveryBuilder builder;
    int index;
    
    public N and() {
      return (N) TaskRunStatusFieldsFluent.this.setToCloudEvents(index,builder.build());
    }
    
    public N endCloudEvent() {
      return and();
    }
    
  
  }
  public class ProvenanceNested<N> extends ProvenanceFluent<ProvenanceNested<N>> implements Nested<N>{
    ProvenanceNested(Provenance item) {
      this.builder = new ProvenanceBuilder(this, item);
    }
    ProvenanceBuilder builder;
    
    public N and() {
      return (N) TaskRunStatusFieldsFluent.this.withProvenance(builder.build());
    }
    
    public N endProvenance() {
      return and();
    }
    
  
  }
  public class ResourcesResultNested<N> extends RunResultFluent<ResourcesResultNested<N>> implements Nested<N>{
    ResourcesResultNested(int index,RunResult item) {
      this.index = index;
      this.builder = new RunResultBuilder(this, item);
    }
    RunResultBuilder builder;
    int index;
    
    public N and() {
      return (N) TaskRunStatusFieldsFluent.this.setToResourcesResult(index,builder.build());
    }
    
    public N endResourcesResult() {
      return and();
    }
    
  
  }
  public class RetriesStatusNested<N> extends TaskRunStatusFluent<RetriesStatusNested<N>> implements Nested<N>{
    RetriesStatusNested(int index,TaskRunStatus item) {
      this.index = index;
      this.builder = new TaskRunStatusBuilder(this, item);
    }
    TaskRunStatusBuilder builder;
    int index;
    
    public N and() {
      return (N) TaskRunStatusFieldsFluent.this.setToRetriesStatus(index,builder.build());
    }
    
    public N endRetriesStatus() {
      return and();
    }
    
  
  }
  public class SidecarsNested<N> extends SidecarStateFluent<SidecarsNested<N>> implements Nested<N>{
    SidecarsNested(int index,SidecarState item) {
      this.index = index;
      this.builder = new SidecarStateBuilder(this, item);
    }
    SidecarStateBuilder builder;
    int index;
    
    public N and() {
      return (N) TaskRunStatusFieldsFluent.this.setToSidecars(index,builder.build());
    }
    
    public N endSidecar() {
      return and();
    }
    
  
  }
  public class StepsNested<N> extends StepStateFluent<StepsNested<N>> implements Nested<N>{
    StepsNested(int index,StepState item) {
      this.index = index;
      this.builder = new StepStateBuilder(this, item);
    }
    StepStateBuilder builder;
    int index;
    
    public N and() {
      return (N) TaskRunStatusFieldsFluent.this.setToSteps(index,builder.build());
    }
    
    public N endStep() {
      return and();
    }
    
  
  }
  public class TaskResultsNested<N> extends TaskRunResultFluent<TaskResultsNested<N>> implements Nested<N>{
    TaskResultsNested(int index,TaskRunResult item) {
      this.index = index;
      this.builder = new TaskRunResultBuilder(this, item);
    }
    TaskRunResultBuilder builder;
    int index;
    
    public N and() {
      return (N) TaskRunStatusFieldsFluent.this.setToTaskResults(index,builder.build());
    }
    
    public N endTaskResult() {
      return and();
    }
    
  
  }
  public class TaskSpecNested<N> extends TaskSpecFluent<TaskSpecNested<N>> implements Nested<N>{
    TaskSpecNested(TaskSpec item) {
      this.builder = new TaskSpecBuilder(this, item);
    }
    TaskSpecBuilder builder;
    
    public N and() {
      return (N) TaskRunStatusFieldsFluent.this.withTaskSpec(builder.build());
    }
    
    public N endTaskSpec() {
      return and();
    }
    
  
  }

}