package io.fabric8.tekton.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class TaskResultBuilder extends TaskResultFluent<TaskResultBuilder> implements VisitableBuilder<TaskResult,TaskResultBuilder>{
  public TaskResultBuilder() {
    this(new TaskResult());
  }
  
  public TaskResultBuilder(TaskResultFluent<?> fluent) {
    this(fluent, new TaskResult());
  }
  
  public TaskResultBuilder(TaskResultFluent<?> fluent,TaskResult instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public TaskResultBuilder(TaskResult instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  TaskResultFluent<?> fluent;
  
  public TaskResult build() {
    TaskResult buildable = new TaskResult(fluent.getDescription(),fluent.getName(),fluent.getProperties(),fluent.getType(),fluent.buildValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}