package io.fabric8.tekton.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.tekton.v1alpha1.PipelineResourceSpecFluent;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.tekton.v1alpha1.PipelineResourceSpecBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;
import io.fabric8.tekton.v1alpha1.PipelineResourceSpec;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class TaskResourceBindingFluent<A extends TaskResourceBindingFluent<A>> extends BaseFluent<A>{
  public TaskResourceBindingFluent() {
  }
  
  public TaskResourceBindingFluent(TaskResourceBinding instance) {
    this.copyInstance(instance);
  }
  private String name;
  private List<String> paths = new ArrayList<String>();
  private PipelineResourceRefBuilder resourceRef;
  private PipelineResourceSpecBuilder resourceSpec;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(TaskResourceBinding instance) {
    instance = (instance != null ? instance : new TaskResourceBinding());
    if (instance != null) {
          this.withName(instance.getName());
          this.withPaths(instance.getPaths());
          this.withResourceRef(instance.getResourceRef());
          this.withResourceSpec(instance.getResourceSpec());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public A addToPaths(int index,String item) {
    if (this.paths == null) {this.paths = new ArrayList<String>();}
    this.paths.add(index, item);
    return (A)this;
  }
  
  public A setToPaths(int index,String item) {
    if (this.paths == null) {this.paths = new ArrayList<String>();}
    this.paths.set(index, item); return (A)this;
  }
  
  public A addToPaths(java.lang.String... items) {
    if (this.paths == null) {this.paths = new ArrayList<String>();}
    for (String item : items) {this.paths.add(item);} return (A)this;
  }
  
  public A addAllToPaths(Collection<String> items) {
    if (this.paths == null) {this.paths = new ArrayList<String>();}
    for (String item : items) {this.paths.add(item);} return (A)this;
  }
  
  public A removeFromPaths(java.lang.String... items) {
    if (this.paths == null) return (A)this;
    for (String item : items) { this.paths.remove(item);} return (A)this;
  }
  
  public A removeAllFromPaths(Collection<String> items) {
    if (this.paths == null) return (A)this;
    for (String item : items) { this.paths.remove(item);} return (A)this;
  }
  
  public List<String> getPaths() {
    return this.paths;
  }
  
  public String getPath(int index) {
    return this.paths.get(index);
  }
  
  public String getFirstPath() {
    return this.paths.get(0);
  }
  
  public String getLastPath() {
    return this.paths.get(paths.size() - 1);
  }
  
  public String getMatchingPath(Predicate<String> predicate) {
      for (String item : paths) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingPath(Predicate<String> predicate) {
      for (String item : paths) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withPaths(List<String> paths) {
    if (paths != null) {
        this.paths = new ArrayList();
        for (String item : paths) {
          this.addToPaths(item);
        }
    } else {
      this.paths = null;
    }
    return (A) this;
  }
  
  public A withPaths(java.lang.String... paths) {
    if (this.paths != null) {
        this.paths.clear();
        _visitables.remove("paths");
    }
    if (paths != null) {
      for (String item : paths) {
        this.addToPaths(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasPaths() {
    return this.paths != null && !this.paths.isEmpty();
  }
  
  public PipelineResourceRef buildResourceRef() {
    return this.resourceRef != null ? this.resourceRef.build() : null;
  }
  
  public A withResourceRef(PipelineResourceRef resourceRef) {
    this._visitables.remove("resourceRef");
    if (resourceRef != null) {
        this.resourceRef = new PipelineResourceRefBuilder(resourceRef);
        this._visitables.get("resourceRef").add(this.resourceRef);
    } else {
        this.resourceRef = null;
        this._visitables.get("resourceRef").remove(this.resourceRef);
    }
    return (A) this;
  }
  
  public boolean hasResourceRef() {
    return this.resourceRef != null;
  }
  
  public A withNewResourceRef(String apiVersion,String name) {
    return (A)withResourceRef(new PipelineResourceRef(apiVersion, name));
  }
  
  public ResourceRefNested<A> withNewResourceRef() {
    return new ResourceRefNested(null);
  }
  
  public ResourceRefNested<A> withNewResourceRefLike(PipelineResourceRef item) {
    return new ResourceRefNested(item);
  }
  
  public ResourceRefNested<A> editResourceRef() {
    return withNewResourceRefLike(java.util.Optional.ofNullable(buildResourceRef()).orElse(null));
  }
  
  public ResourceRefNested<A> editOrNewResourceRef() {
    return withNewResourceRefLike(java.util.Optional.ofNullable(buildResourceRef()).orElse(new PipelineResourceRefBuilder().build()));
  }
  
  public ResourceRefNested<A> editOrNewResourceRefLike(PipelineResourceRef item) {
    return withNewResourceRefLike(java.util.Optional.ofNullable(buildResourceRef()).orElse(item));
  }
  
  public PipelineResourceSpec buildResourceSpec() {
    return this.resourceSpec != null ? this.resourceSpec.build() : null;
  }
  
  public A withResourceSpec(PipelineResourceSpec resourceSpec) {
    this._visitables.remove("resourceSpec");
    if (resourceSpec != null) {
        this.resourceSpec = new PipelineResourceSpecBuilder(resourceSpec);
        this._visitables.get("resourceSpec").add(this.resourceSpec);
    } else {
        this.resourceSpec = null;
        this._visitables.get("resourceSpec").remove(this.resourceSpec);
    }
    return (A) this;
  }
  
  public boolean hasResourceSpec() {
    return this.resourceSpec != null;
  }
  
  public ResourceSpecNested<A> withNewResourceSpec() {
    return new ResourceSpecNested(null);
  }
  
  public ResourceSpecNested<A> withNewResourceSpecLike(PipelineResourceSpec item) {
    return new ResourceSpecNested(item);
  }
  
  public ResourceSpecNested<A> editResourceSpec() {
    return withNewResourceSpecLike(java.util.Optional.ofNullable(buildResourceSpec()).orElse(null));
  }
  
  public ResourceSpecNested<A> editOrNewResourceSpec() {
    return withNewResourceSpecLike(java.util.Optional.ofNullable(buildResourceSpec()).orElse(new PipelineResourceSpecBuilder().build()));
  }
  
  public ResourceSpecNested<A> editOrNewResourceSpecLike(PipelineResourceSpec item) {
    return withNewResourceSpecLike(java.util.Optional.ofNullable(buildResourceSpec()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TaskResourceBindingFluent that = (TaskResourceBindingFluent) o;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(paths, that.paths)) return false;
    if (!java.util.Objects.equals(resourceRef, that.resourceRef)) return false;
    if (!java.util.Objects.equals(resourceSpec, that.resourceSpec)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(name,  paths,  resourceRef,  resourceSpec,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (paths != null && !paths.isEmpty()) { sb.append("paths:"); sb.append(paths + ","); }
    if (resourceRef != null) { sb.append("resourceRef:"); sb.append(resourceRef + ","); }
    if (resourceSpec != null) { sb.append("resourceSpec:"); sb.append(resourceSpec + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ResourceRefNested<N> extends PipelineResourceRefFluent<ResourceRefNested<N>> implements Nested<N>{
    ResourceRefNested(PipelineResourceRef item) {
      this.builder = new PipelineResourceRefBuilder(this, item);
    }
    PipelineResourceRefBuilder builder;
    
    public N and() {
      return (N) TaskResourceBindingFluent.this.withResourceRef(builder.build());
    }
    
    public N endResourceRef() {
      return and();
    }
    
  
  }
  public class ResourceSpecNested<N> extends PipelineResourceSpecFluent<ResourceSpecNested<N>> implements Nested<N>{
    ResourceSpecNested(PipelineResourceSpec item) {
      this.builder = new PipelineResourceSpecBuilder(this, item);
    }
    PipelineResourceSpecBuilder builder;
    
    public N and() {
      return (N) TaskResourceBindingFluent.this.withResourceSpec(builder.build());
    }
    
    public N endResourceSpec() {
      return and();
    }
    
  
  }

}