package io.fabric8.tekton.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class RefBuilder extends RefFluent<RefBuilder> implements VisitableBuilder<Ref,RefBuilder>{
  public RefBuilder() {
    this(new Ref());
  }
  
  public RefBuilder(RefFluent<?> fluent) {
    this(fluent, new Ref());
  }
  
  public RefBuilder(RefFluent<?> fluent,Ref instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public RefBuilder(Ref instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  RefFluent<?> fluent;
  
  public Ref build() {
    Ref buildable = new Ref(fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}