package io.fabric8.tekton.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PipelineRunTaskRunStatusFluent<A extends PipelineRunTaskRunStatusFluent<A>> extends BaseFluent<A>{
  public PipelineRunTaskRunStatusFluent() {
  }
  
  public PipelineRunTaskRunStatusFluent(PipelineRunTaskRunStatus instance) {
    this.copyInstance(instance);
  }
  private String pipelineTaskName;
  private TaskRunStatusBuilder status;
  private ArrayList<WhenExpressionBuilder> whenExpressions = new ArrayList<WhenExpressionBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(PipelineRunTaskRunStatus instance) {
    instance = (instance != null ? instance : new PipelineRunTaskRunStatus());
    if (instance != null) {
          this.withPipelineTaskName(instance.getPipelineTaskName());
          this.withStatus(instance.getStatus());
          this.withWhenExpressions(instance.getWhenExpressions());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getPipelineTaskName() {
    return this.pipelineTaskName;
  }
  
  public A withPipelineTaskName(String pipelineTaskName) {
    this.pipelineTaskName = pipelineTaskName;
    return (A) this;
  }
  
  public boolean hasPipelineTaskName() {
    return this.pipelineTaskName != null;
  }
  
  public TaskRunStatus buildStatus() {
    return this.status != null ? this.status.build() : null;
  }
  
  public A withStatus(TaskRunStatus status) {
    this._visitables.remove("status");
    if (status != null) {
        this.status = new TaskRunStatusBuilder(status);
        this._visitables.get("status").add(this.status);
    } else {
        this.status = null;
        this._visitables.get("status").remove(this.status);
    }
    return (A) this;
  }
  
  public boolean hasStatus() {
    return this.status != null;
  }
  
  public StatusNested<A> withNewStatus() {
    return new StatusNested(null);
  }
  
  public StatusNested<A> withNewStatusLike(TaskRunStatus item) {
    return new StatusNested(item);
  }
  
  public StatusNested<A> editStatus() {
    return withNewStatusLike(java.util.Optional.ofNullable(buildStatus()).orElse(null));
  }
  
  public StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(java.util.Optional.ofNullable(buildStatus()).orElse(new TaskRunStatusBuilder().build()));
  }
  
  public StatusNested<A> editOrNewStatusLike(TaskRunStatus item) {
    return withNewStatusLike(java.util.Optional.ofNullable(buildStatus()).orElse(item));
  }
  
  public A addToWhenExpressions(int index,WhenExpression item) {
    if (this.whenExpressions == null) {this.whenExpressions = new ArrayList<WhenExpressionBuilder>();}
    WhenExpressionBuilder builder = new WhenExpressionBuilder(item);
    if (index < 0 || index >= whenExpressions.size()) {
        _visitables.get("whenExpressions").add(builder);
        whenExpressions.add(builder);
    } else {
        _visitables.get("whenExpressions").add(builder);
        whenExpressions.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToWhenExpressions(int index,WhenExpression item) {
    if (this.whenExpressions == null) {this.whenExpressions = new ArrayList<WhenExpressionBuilder>();}
    WhenExpressionBuilder builder = new WhenExpressionBuilder(item);
    if (index < 0 || index >= whenExpressions.size()) {
        _visitables.get("whenExpressions").add(builder);
        whenExpressions.add(builder);
    } else {
        _visitables.get("whenExpressions").add(builder);
        whenExpressions.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToWhenExpressions(io.fabric8.tekton.v1beta1.WhenExpression... items) {
    if (this.whenExpressions == null) {this.whenExpressions = new ArrayList<WhenExpressionBuilder>();}
    for (WhenExpression item : items) {WhenExpressionBuilder builder = new WhenExpressionBuilder(item);_visitables.get("whenExpressions").add(builder);this.whenExpressions.add(builder);} return (A)this;
  }
  
  public A addAllToWhenExpressions(Collection<WhenExpression> items) {
    if (this.whenExpressions == null) {this.whenExpressions = new ArrayList<WhenExpressionBuilder>();}
    for (WhenExpression item : items) {WhenExpressionBuilder builder = new WhenExpressionBuilder(item);_visitables.get("whenExpressions").add(builder);this.whenExpressions.add(builder);} return (A)this;
  }
  
  public A removeFromWhenExpressions(io.fabric8.tekton.v1beta1.WhenExpression... items) {
    if (this.whenExpressions == null) return (A)this;
    for (WhenExpression item : items) {WhenExpressionBuilder builder = new WhenExpressionBuilder(item);_visitables.get("whenExpressions").remove(builder); this.whenExpressions.remove(builder);} return (A)this;
  }
  
  public A removeAllFromWhenExpressions(Collection<WhenExpression> items) {
    if (this.whenExpressions == null) return (A)this;
    for (WhenExpression item : items) {WhenExpressionBuilder builder = new WhenExpressionBuilder(item);_visitables.get("whenExpressions").remove(builder); this.whenExpressions.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromWhenExpressions(Predicate<WhenExpressionBuilder> predicate) {
    if (whenExpressions == null) return (A) this;
    final Iterator<WhenExpressionBuilder> each = whenExpressions.iterator();
    final List visitables = _visitables.get("whenExpressions");
    while (each.hasNext()) {
      WhenExpressionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<WhenExpression> buildWhenExpressions() {
    return this.whenExpressions != null ? build(whenExpressions) : null;
  }
  
  public WhenExpression buildWhenExpression(int index) {
    return this.whenExpressions.get(index).build();
  }
  
  public WhenExpression buildFirstWhenExpression() {
    return this.whenExpressions.get(0).build();
  }
  
  public WhenExpression buildLastWhenExpression() {
    return this.whenExpressions.get(whenExpressions.size() - 1).build();
  }
  
  public WhenExpression buildMatchingWhenExpression(Predicate<WhenExpressionBuilder> predicate) {
      for (WhenExpressionBuilder item : whenExpressions) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingWhenExpression(Predicate<WhenExpressionBuilder> predicate) {
      for (WhenExpressionBuilder item : whenExpressions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withWhenExpressions(List<WhenExpression> whenExpressions) {
    if (this.whenExpressions != null) {
      this._visitables.get("whenExpressions").clear();
    }
    if (whenExpressions != null) {
        this.whenExpressions = new ArrayList();
        for (WhenExpression item : whenExpressions) {
          this.addToWhenExpressions(item);
        }
    } else {
      this.whenExpressions = null;
    }
    return (A) this;
  }
  
  public A withWhenExpressions(io.fabric8.tekton.v1beta1.WhenExpression... whenExpressions) {
    if (this.whenExpressions != null) {
        this.whenExpressions.clear();
        _visitables.remove("whenExpressions");
    }
    if (whenExpressions != null) {
      for (WhenExpression item : whenExpressions) {
        this.addToWhenExpressions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasWhenExpressions() {
    return this.whenExpressions != null && !this.whenExpressions.isEmpty();
  }
  
  public WhenExpressionsNested<A> addNewWhenExpression() {
    return new WhenExpressionsNested(-1, null);
  }
  
  public WhenExpressionsNested<A> addNewWhenExpressionLike(WhenExpression item) {
    return new WhenExpressionsNested(-1, item);
  }
  
  public WhenExpressionsNested<A> setNewWhenExpressionLike(int index,WhenExpression item) {
    return new WhenExpressionsNested(index, item);
  }
  
  public WhenExpressionsNested<A> editWhenExpression(int index) {
    if (whenExpressions.size() <= index) throw new RuntimeException("Can't edit whenExpressions. Index exceeds size.");
    return setNewWhenExpressionLike(index, buildWhenExpression(index));
  }
  
  public WhenExpressionsNested<A> editFirstWhenExpression() {
    if (whenExpressions.size() == 0) throw new RuntimeException("Can't edit first whenExpressions. The list is empty.");
    return setNewWhenExpressionLike(0, buildWhenExpression(0));
  }
  
  public WhenExpressionsNested<A> editLastWhenExpression() {
    int index = whenExpressions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last whenExpressions. The list is empty.");
    return setNewWhenExpressionLike(index, buildWhenExpression(index));
  }
  
  public WhenExpressionsNested<A> editMatchingWhenExpression(Predicate<WhenExpressionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<whenExpressions.size();i++) { 
    if (predicate.test(whenExpressions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching whenExpressions. No match found.");
    return setNewWhenExpressionLike(index, buildWhenExpression(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PipelineRunTaskRunStatusFluent that = (PipelineRunTaskRunStatusFluent) o;
    if (!java.util.Objects.equals(pipelineTaskName, that.pipelineTaskName)) return false;
    if (!java.util.Objects.equals(status, that.status)) return false;
    if (!java.util.Objects.equals(whenExpressions, that.whenExpressions)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(pipelineTaskName,  status,  whenExpressions,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (pipelineTaskName != null) { sb.append("pipelineTaskName:"); sb.append(pipelineTaskName + ","); }
    if (status != null) { sb.append("status:"); sb.append(status + ","); }
    if (whenExpressions != null && !whenExpressions.isEmpty()) { sb.append("whenExpressions:"); sb.append(whenExpressions + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class StatusNested<N> extends TaskRunStatusFluent<StatusNested<N>> implements Nested<N>{
    StatusNested(TaskRunStatus item) {
      this.builder = new TaskRunStatusBuilder(this, item);
    }
    TaskRunStatusBuilder builder;
    
    public N and() {
      return (N) PipelineRunTaskRunStatusFluent.this.withStatus(builder.build());
    }
    
    public N endStatus() {
      return and();
    }
    
  
  }
  public class WhenExpressionsNested<N> extends WhenExpressionFluent<WhenExpressionsNested<N>> implements Nested<N>{
    WhenExpressionsNested(int index,WhenExpression item) {
      this.index = index;
      this.builder = new WhenExpressionBuilder(this, item);
    }
    WhenExpressionBuilder builder;
    int index;
    
    public N and() {
      return (N) PipelineRunTaskRunStatusFluent.this.setToWhenExpressions(index,builder.build());
    }
    
    public N endWhenExpression() {
      return and();
    }
    
  
  }

}