package io.fabric8.tekton.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PipelineRunStatusFieldsFluent<A extends PipelineRunStatusFieldsFluent<A>> extends BaseFluent<A>{
  public PipelineRunStatusFieldsFluent() {
  }
  
  public PipelineRunStatusFieldsFluent(PipelineRunStatusFields instance) {
    this.copyInstance(instance);
  }
  private ArrayList<ChildStatusReferenceBuilder> childReferences = new ArrayList<ChildStatusReferenceBuilder>();
  private String completionTime;
  private String finallyStartTime;
  private ArrayList<PipelineRunResultBuilder> pipelineResults = new ArrayList<PipelineRunResultBuilder>();
  private PipelineSpecBuilder pipelineSpec;
  private ProvenanceBuilder provenance;
  private Map<String,PipelineRunRunStatus> runs;
  private ArrayList<SkippedTaskBuilder> skippedTasks = new ArrayList<SkippedTaskBuilder>();
  private Map<String,String> spanContext;
  private String startTime;
  private Map<String,PipelineRunTaskRunStatus> taskRuns;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(PipelineRunStatusFields instance) {
    instance = (instance != null ? instance : new PipelineRunStatusFields());
    if (instance != null) {
          this.withChildReferences(instance.getChildReferences());
          this.withCompletionTime(instance.getCompletionTime());
          this.withFinallyStartTime(instance.getFinallyStartTime());
          this.withPipelineResults(instance.getPipelineResults());
          this.withPipelineSpec(instance.getPipelineSpec());
          this.withProvenance(instance.getProvenance());
          this.withRuns(instance.getRuns());
          this.withSkippedTasks(instance.getSkippedTasks());
          this.withSpanContext(instance.getSpanContext());
          this.withStartTime(instance.getStartTime());
          this.withTaskRuns(instance.getTaskRuns());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToChildReferences(int index,ChildStatusReference item) {
    if (this.childReferences == null) {this.childReferences = new ArrayList<ChildStatusReferenceBuilder>();}
    ChildStatusReferenceBuilder builder = new ChildStatusReferenceBuilder(item);
    if (index < 0 || index >= childReferences.size()) {
        _visitables.get("childReferences").add(builder);
        childReferences.add(builder);
    } else {
        _visitables.get("childReferences").add(builder);
        childReferences.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToChildReferences(int index,ChildStatusReference item) {
    if (this.childReferences == null) {this.childReferences = new ArrayList<ChildStatusReferenceBuilder>();}
    ChildStatusReferenceBuilder builder = new ChildStatusReferenceBuilder(item);
    if (index < 0 || index >= childReferences.size()) {
        _visitables.get("childReferences").add(builder);
        childReferences.add(builder);
    } else {
        _visitables.get("childReferences").add(builder);
        childReferences.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToChildReferences(io.fabric8.tekton.v1beta1.ChildStatusReference... items) {
    if (this.childReferences == null) {this.childReferences = new ArrayList<ChildStatusReferenceBuilder>();}
    for (ChildStatusReference item : items) {ChildStatusReferenceBuilder builder = new ChildStatusReferenceBuilder(item);_visitables.get("childReferences").add(builder);this.childReferences.add(builder);} return (A)this;
  }
  
  public A addAllToChildReferences(Collection<ChildStatusReference> items) {
    if (this.childReferences == null) {this.childReferences = new ArrayList<ChildStatusReferenceBuilder>();}
    for (ChildStatusReference item : items) {ChildStatusReferenceBuilder builder = new ChildStatusReferenceBuilder(item);_visitables.get("childReferences").add(builder);this.childReferences.add(builder);} return (A)this;
  }
  
  public A removeFromChildReferences(io.fabric8.tekton.v1beta1.ChildStatusReference... items) {
    if (this.childReferences == null) return (A)this;
    for (ChildStatusReference item : items) {ChildStatusReferenceBuilder builder = new ChildStatusReferenceBuilder(item);_visitables.get("childReferences").remove(builder); this.childReferences.remove(builder);} return (A)this;
  }
  
  public A removeAllFromChildReferences(Collection<ChildStatusReference> items) {
    if (this.childReferences == null) return (A)this;
    for (ChildStatusReference item : items) {ChildStatusReferenceBuilder builder = new ChildStatusReferenceBuilder(item);_visitables.get("childReferences").remove(builder); this.childReferences.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromChildReferences(Predicate<ChildStatusReferenceBuilder> predicate) {
    if (childReferences == null) return (A) this;
    final Iterator<ChildStatusReferenceBuilder> each = childReferences.iterator();
    final List visitables = _visitables.get("childReferences");
    while (each.hasNext()) {
      ChildStatusReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ChildStatusReference> buildChildReferences() {
    return this.childReferences != null ? build(childReferences) : null;
  }
  
  public ChildStatusReference buildChildReference(int index) {
    return this.childReferences.get(index).build();
  }
  
  public ChildStatusReference buildFirstChildReference() {
    return this.childReferences.get(0).build();
  }
  
  public ChildStatusReference buildLastChildReference() {
    return this.childReferences.get(childReferences.size() - 1).build();
  }
  
  public ChildStatusReference buildMatchingChildReference(Predicate<ChildStatusReferenceBuilder> predicate) {
      for (ChildStatusReferenceBuilder item : childReferences) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingChildReference(Predicate<ChildStatusReferenceBuilder> predicate) {
      for (ChildStatusReferenceBuilder item : childReferences) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withChildReferences(List<ChildStatusReference> childReferences) {
    if (this.childReferences != null) {
      this._visitables.get("childReferences").clear();
    }
    if (childReferences != null) {
        this.childReferences = new ArrayList();
        for (ChildStatusReference item : childReferences) {
          this.addToChildReferences(item);
        }
    } else {
      this.childReferences = null;
    }
    return (A) this;
  }
  
  public A withChildReferences(io.fabric8.tekton.v1beta1.ChildStatusReference... childReferences) {
    if (this.childReferences != null) {
        this.childReferences.clear();
        _visitables.remove("childReferences");
    }
    if (childReferences != null) {
      for (ChildStatusReference item : childReferences) {
        this.addToChildReferences(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasChildReferences() {
    return this.childReferences != null && !this.childReferences.isEmpty();
  }
  
  public ChildReferencesNested<A> addNewChildReference() {
    return new ChildReferencesNested(-1, null);
  }
  
  public ChildReferencesNested<A> addNewChildReferenceLike(ChildStatusReference item) {
    return new ChildReferencesNested(-1, item);
  }
  
  public ChildReferencesNested<A> setNewChildReferenceLike(int index,ChildStatusReference item) {
    return new ChildReferencesNested(index, item);
  }
  
  public ChildReferencesNested<A> editChildReference(int index) {
    if (childReferences.size() <= index) throw new RuntimeException("Can't edit childReferences. Index exceeds size.");
    return setNewChildReferenceLike(index, buildChildReference(index));
  }
  
  public ChildReferencesNested<A> editFirstChildReference() {
    if (childReferences.size() == 0) throw new RuntimeException("Can't edit first childReferences. The list is empty.");
    return setNewChildReferenceLike(0, buildChildReference(0));
  }
  
  public ChildReferencesNested<A> editLastChildReference() {
    int index = childReferences.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last childReferences. The list is empty.");
    return setNewChildReferenceLike(index, buildChildReference(index));
  }
  
  public ChildReferencesNested<A> editMatchingChildReference(Predicate<ChildStatusReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<childReferences.size();i++) { 
    if (predicate.test(childReferences.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching childReferences. No match found.");
    return setNewChildReferenceLike(index, buildChildReference(index));
  }
  
  public String getCompletionTime() {
    return this.completionTime;
  }
  
  public A withCompletionTime(String completionTime) {
    this.completionTime = completionTime;
    return (A) this;
  }
  
  public boolean hasCompletionTime() {
    return this.completionTime != null;
  }
  
  public String getFinallyStartTime() {
    return this.finallyStartTime;
  }
  
  public A withFinallyStartTime(String finallyStartTime) {
    this.finallyStartTime = finallyStartTime;
    return (A) this;
  }
  
  public boolean hasFinallyStartTime() {
    return this.finallyStartTime != null;
  }
  
  public A addToPipelineResults(int index,PipelineRunResult item) {
    if (this.pipelineResults == null) {this.pipelineResults = new ArrayList<PipelineRunResultBuilder>();}
    PipelineRunResultBuilder builder = new PipelineRunResultBuilder(item);
    if (index < 0 || index >= pipelineResults.size()) {
        _visitables.get("pipelineResults").add(builder);
        pipelineResults.add(builder);
    } else {
        _visitables.get("pipelineResults").add(builder);
        pipelineResults.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToPipelineResults(int index,PipelineRunResult item) {
    if (this.pipelineResults == null) {this.pipelineResults = new ArrayList<PipelineRunResultBuilder>();}
    PipelineRunResultBuilder builder = new PipelineRunResultBuilder(item);
    if (index < 0 || index >= pipelineResults.size()) {
        _visitables.get("pipelineResults").add(builder);
        pipelineResults.add(builder);
    } else {
        _visitables.get("pipelineResults").add(builder);
        pipelineResults.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToPipelineResults(io.fabric8.tekton.v1beta1.PipelineRunResult... items) {
    if (this.pipelineResults == null) {this.pipelineResults = new ArrayList<PipelineRunResultBuilder>();}
    for (PipelineRunResult item : items) {PipelineRunResultBuilder builder = new PipelineRunResultBuilder(item);_visitables.get("pipelineResults").add(builder);this.pipelineResults.add(builder);} return (A)this;
  }
  
  public A addAllToPipelineResults(Collection<PipelineRunResult> items) {
    if (this.pipelineResults == null) {this.pipelineResults = new ArrayList<PipelineRunResultBuilder>();}
    for (PipelineRunResult item : items) {PipelineRunResultBuilder builder = new PipelineRunResultBuilder(item);_visitables.get("pipelineResults").add(builder);this.pipelineResults.add(builder);} return (A)this;
  }
  
  public A removeFromPipelineResults(io.fabric8.tekton.v1beta1.PipelineRunResult... items) {
    if (this.pipelineResults == null) return (A)this;
    for (PipelineRunResult item : items) {PipelineRunResultBuilder builder = new PipelineRunResultBuilder(item);_visitables.get("pipelineResults").remove(builder); this.pipelineResults.remove(builder);} return (A)this;
  }
  
  public A removeAllFromPipelineResults(Collection<PipelineRunResult> items) {
    if (this.pipelineResults == null) return (A)this;
    for (PipelineRunResult item : items) {PipelineRunResultBuilder builder = new PipelineRunResultBuilder(item);_visitables.get("pipelineResults").remove(builder); this.pipelineResults.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromPipelineResults(Predicate<PipelineRunResultBuilder> predicate) {
    if (pipelineResults == null) return (A) this;
    final Iterator<PipelineRunResultBuilder> each = pipelineResults.iterator();
    final List visitables = _visitables.get("pipelineResults");
    while (each.hasNext()) {
      PipelineRunResultBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<PipelineRunResult> buildPipelineResults() {
    return this.pipelineResults != null ? build(pipelineResults) : null;
  }
  
  public PipelineRunResult buildPipelineResult(int index) {
    return this.pipelineResults.get(index).build();
  }
  
  public PipelineRunResult buildFirstPipelineResult() {
    return this.pipelineResults.get(0).build();
  }
  
  public PipelineRunResult buildLastPipelineResult() {
    return this.pipelineResults.get(pipelineResults.size() - 1).build();
  }
  
  public PipelineRunResult buildMatchingPipelineResult(Predicate<PipelineRunResultBuilder> predicate) {
      for (PipelineRunResultBuilder item : pipelineResults) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingPipelineResult(Predicate<PipelineRunResultBuilder> predicate) {
      for (PipelineRunResultBuilder item : pipelineResults) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withPipelineResults(List<PipelineRunResult> pipelineResults) {
    if (this.pipelineResults != null) {
      this._visitables.get("pipelineResults").clear();
    }
    if (pipelineResults != null) {
        this.pipelineResults = new ArrayList();
        for (PipelineRunResult item : pipelineResults) {
          this.addToPipelineResults(item);
        }
    } else {
      this.pipelineResults = null;
    }
    return (A) this;
  }
  
  public A withPipelineResults(io.fabric8.tekton.v1beta1.PipelineRunResult... pipelineResults) {
    if (this.pipelineResults != null) {
        this.pipelineResults.clear();
        _visitables.remove("pipelineResults");
    }
    if (pipelineResults != null) {
      for (PipelineRunResult item : pipelineResults) {
        this.addToPipelineResults(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasPipelineResults() {
    return this.pipelineResults != null && !this.pipelineResults.isEmpty();
  }
  
  public PipelineResultsNested<A> addNewPipelineResult() {
    return new PipelineResultsNested(-1, null);
  }
  
  public PipelineResultsNested<A> addNewPipelineResultLike(PipelineRunResult item) {
    return new PipelineResultsNested(-1, item);
  }
  
  public PipelineResultsNested<A> setNewPipelineResultLike(int index,PipelineRunResult item) {
    return new PipelineResultsNested(index, item);
  }
  
  public PipelineResultsNested<A> editPipelineResult(int index) {
    if (pipelineResults.size() <= index) throw new RuntimeException("Can't edit pipelineResults. Index exceeds size.");
    return setNewPipelineResultLike(index, buildPipelineResult(index));
  }
  
  public PipelineResultsNested<A> editFirstPipelineResult() {
    if (pipelineResults.size() == 0) throw new RuntimeException("Can't edit first pipelineResults. The list is empty.");
    return setNewPipelineResultLike(0, buildPipelineResult(0));
  }
  
  public PipelineResultsNested<A> editLastPipelineResult() {
    int index = pipelineResults.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last pipelineResults. The list is empty.");
    return setNewPipelineResultLike(index, buildPipelineResult(index));
  }
  
  public PipelineResultsNested<A> editMatchingPipelineResult(Predicate<PipelineRunResultBuilder> predicate) {
    int index = -1;
    for (int i=0;i<pipelineResults.size();i++) { 
    if (predicate.test(pipelineResults.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching pipelineResults. No match found.");
    return setNewPipelineResultLike(index, buildPipelineResult(index));
  }
  
  public PipelineSpec buildPipelineSpec() {
    return this.pipelineSpec != null ? this.pipelineSpec.build() : null;
  }
  
  public A withPipelineSpec(PipelineSpec pipelineSpec) {
    this._visitables.remove("pipelineSpec");
    if (pipelineSpec != null) {
        this.pipelineSpec = new PipelineSpecBuilder(pipelineSpec);
        this._visitables.get("pipelineSpec").add(this.pipelineSpec);
    } else {
        this.pipelineSpec = null;
        this._visitables.get("pipelineSpec").remove(this.pipelineSpec);
    }
    return (A) this;
  }
  
  public boolean hasPipelineSpec() {
    return this.pipelineSpec != null;
  }
  
  public PipelineSpecNested<A> withNewPipelineSpec() {
    return new PipelineSpecNested(null);
  }
  
  public PipelineSpecNested<A> withNewPipelineSpecLike(PipelineSpec item) {
    return new PipelineSpecNested(item);
  }
  
  public PipelineSpecNested<A> editPipelineSpec() {
    return withNewPipelineSpecLike(java.util.Optional.ofNullable(buildPipelineSpec()).orElse(null));
  }
  
  public PipelineSpecNested<A> editOrNewPipelineSpec() {
    return withNewPipelineSpecLike(java.util.Optional.ofNullable(buildPipelineSpec()).orElse(new PipelineSpecBuilder().build()));
  }
  
  public PipelineSpecNested<A> editOrNewPipelineSpecLike(PipelineSpec item) {
    return withNewPipelineSpecLike(java.util.Optional.ofNullable(buildPipelineSpec()).orElse(item));
  }
  
  public Provenance buildProvenance() {
    return this.provenance != null ? this.provenance.build() : null;
  }
  
  public A withProvenance(Provenance provenance) {
    this._visitables.remove("provenance");
    if (provenance != null) {
        this.provenance = new ProvenanceBuilder(provenance);
        this._visitables.get("provenance").add(this.provenance);
    } else {
        this.provenance = null;
        this._visitables.get("provenance").remove(this.provenance);
    }
    return (A) this;
  }
  
  public boolean hasProvenance() {
    return this.provenance != null;
  }
  
  public ProvenanceNested<A> withNewProvenance() {
    return new ProvenanceNested(null);
  }
  
  public ProvenanceNested<A> withNewProvenanceLike(Provenance item) {
    return new ProvenanceNested(item);
  }
  
  public ProvenanceNested<A> editProvenance() {
    return withNewProvenanceLike(java.util.Optional.ofNullable(buildProvenance()).orElse(null));
  }
  
  public ProvenanceNested<A> editOrNewProvenance() {
    return withNewProvenanceLike(java.util.Optional.ofNullable(buildProvenance()).orElse(new ProvenanceBuilder().build()));
  }
  
  public ProvenanceNested<A> editOrNewProvenanceLike(Provenance item) {
    return withNewProvenanceLike(java.util.Optional.ofNullable(buildProvenance()).orElse(item));
  }
  
  public A addToRuns(String key,PipelineRunRunStatus value) {
    if(this.runs == null && key != null && value != null) { this.runs = new LinkedHashMap(); }
    if(key != null && value != null) {this.runs.put(key, value);} return (A)this;
  }
  
  public A addToRuns(Map<String,PipelineRunRunStatus> map) {
    if(this.runs == null && map != null) { this.runs = new LinkedHashMap(); }
    if(map != null) { this.runs.putAll(map);} return (A)this;
  }
  
  public A removeFromRuns(String key) {
    if(this.runs == null) { return (A) this; }
    if(key != null && this.runs != null) {this.runs.remove(key);} return (A)this;
  }
  
  public A removeFromRuns(Map<String,PipelineRunRunStatus> map) {
    if(this.runs == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.runs != null){this.runs.remove(key);}}} return (A)this;
  }
  
  public Map<String,PipelineRunRunStatus> getRuns() {
    return this.runs;
  }
  
  public <K,V>A withRuns(Map<String,PipelineRunRunStatus> runs) {
    if (runs == null) {
      this.runs = null;
    } else {
      this.runs = new LinkedHashMap(runs);
    }
    return (A) this;
  }
  
  public boolean hasRuns() {
    return this.runs != null;
  }
  
  public A addToSkippedTasks(int index,SkippedTask item) {
    if (this.skippedTasks == null) {this.skippedTasks = new ArrayList<SkippedTaskBuilder>();}
    SkippedTaskBuilder builder = new SkippedTaskBuilder(item);
    if (index < 0 || index >= skippedTasks.size()) {
        _visitables.get("skippedTasks").add(builder);
        skippedTasks.add(builder);
    } else {
        _visitables.get("skippedTasks").add(builder);
        skippedTasks.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToSkippedTasks(int index,SkippedTask item) {
    if (this.skippedTasks == null) {this.skippedTasks = new ArrayList<SkippedTaskBuilder>();}
    SkippedTaskBuilder builder = new SkippedTaskBuilder(item);
    if (index < 0 || index >= skippedTasks.size()) {
        _visitables.get("skippedTasks").add(builder);
        skippedTasks.add(builder);
    } else {
        _visitables.get("skippedTasks").add(builder);
        skippedTasks.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToSkippedTasks(io.fabric8.tekton.v1beta1.SkippedTask... items) {
    if (this.skippedTasks == null) {this.skippedTasks = new ArrayList<SkippedTaskBuilder>();}
    for (SkippedTask item : items) {SkippedTaskBuilder builder = new SkippedTaskBuilder(item);_visitables.get("skippedTasks").add(builder);this.skippedTasks.add(builder);} return (A)this;
  }
  
  public A addAllToSkippedTasks(Collection<SkippedTask> items) {
    if (this.skippedTasks == null) {this.skippedTasks = new ArrayList<SkippedTaskBuilder>();}
    for (SkippedTask item : items) {SkippedTaskBuilder builder = new SkippedTaskBuilder(item);_visitables.get("skippedTasks").add(builder);this.skippedTasks.add(builder);} return (A)this;
  }
  
  public A removeFromSkippedTasks(io.fabric8.tekton.v1beta1.SkippedTask... items) {
    if (this.skippedTasks == null) return (A)this;
    for (SkippedTask item : items) {SkippedTaskBuilder builder = new SkippedTaskBuilder(item);_visitables.get("skippedTasks").remove(builder); this.skippedTasks.remove(builder);} return (A)this;
  }
  
  public A removeAllFromSkippedTasks(Collection<SkippedTask> items) {
    if (this.skippedTasks == null) return (A)this;
    for (SkippedTask item : items) {SkippedTaskBuilder builder = new SkippedTaskBuilder(item);_visitables.get("skippedTasks").remove(builder); this.skippedTasks.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromSkippedTasks(Predicate<SkippedTaskBuilder> predicate) {
    if (skippedTasks == null) return (A) this;
    final Iterator<SkippedTaskBuilder> each = skippedTasks.iterator();
    final List visitables = _visitables.get("skippedTasks");
    while (each.hasNext()) {
      SkippedTaskBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<SkippedTask> buildSkippedTasks() {
    return this.skippedTasks != null ? build(skippedTasks) : null;
  }
  
  public SkippedTask buildSkippedTask(int index) {
    return this.skippedTasks.get(index).build();
  }
  
  public SkippedTask buildFirstSkippedTask() {
    return this.skippedTasks.get(0).build();
  }
  
  public SkippedTask buildLastSkippedTask() {
    return this.skippedTasks.get(skippedTasks.size() - 1).build();
  }
  
  public SkippedTask buildMatchingSkippedTask(Predicate<SkippedTaskBuilder> predicate) {
      for (SkippedTaskBuilder item : skippedTasks) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingSkippedTask(Predicate<SkippedTaskBuilder> predicate) {
      for (SkippedTaskBuilder item : skippedTasks) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withSkippedTasks(List<SkippedTask> skippedTasks) {
    if (this.skippedTasks != null) {
      this._visitables.get("skippedTasks").clear();
    }
    if (skippedTasks != null) {
        this.skippedTasks = new ArrayList();
        for (SkippedTask item : skippedTasks) {
          this.addToSkippedTasks(item);
        }
    } else {
      this.skippedTasks = null;
    }
    return (A) this;
  }
  
  public A withSkippedTasks(io.fabric8.tekton.v1beta1.SkippedTask... skippedTasks) {
    if (this.skippedTasks != null) {
        this.skippedTasks.clear();
        _visitables.remove("skippedTasks");
    }
    if (skippedTasks != null) {
      for (SkippedTask item : skippedTasks) {
        this.addToSkippedTasks(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasSkippedTasks() {
    return this.skippedTasks != null && !this.skippedTasks.isEmpty();
  }
  
  public SkippedTasksNested<A> addNewSkippedTask() {
    return new SkippedTasksNested(-1, null);
  }
  
  public SkippedTasksNested<A> addNewSkippedTaskLike(SkippedTask item) {
    return new SkippedTasksNested(-1, item);
  }
  
  public SkippedTasksNested<A> setNewSkippedTaskLike(int index,SkippedTask item) {
    return new SkippedTasksNested(index, item);
  }
  
  public SkippedTasksNested<A> editSkippedTask(int index) {
    if (skippedTasks.size() <= index) throw new RuntimeException("Can't edit skippedTasks. Index exceeds size.");
    return setNewSkippedTaskLike(index, buildSkippedTask(index));
  }
  
  public SkippedTasksNested<A> editFirstSkippedTask() {
    if (skippedTasks.size() == 0) throw new RuntimeException("Can't edit first skippedTasks. The list is empty.");
    return setNewSkippedTaskLike(0, buildSkippedTask(0));
  }
  
  public SkippedTasksNested<A> editLastSkippedTask() {
    int index = skippedTasks.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last skippedTasks. The list is empty.");
    return setNewSkippedTaskLike(index, buildSkippedTask(index));
  }
  
  public SkippedTasksNested<A> editMatchingSkippedTask(Predicate<SkippedTaskBuilder> predicate) {
    int index = -1;
    for (int i=0;i<skippedTasks.size();i++) { 
    if (predicate.test(skippedTasks.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching skippedTasks. No match found.");
    return setNewSkippedTaskLike(index, buildSkippedTask(index));
  }
  
  public A addToSpanContext(String key,String value) {
    if(this.spanContext == null && key != null && value != null) { this.spanContext = new LinkedHashMap(); }
    if(key != null && value != null) {this.spanContext.put(key, value);} return (A)this;
  }
  
  public A addToSpanContext(Map<String,String> map) {
    if(this.spanContext == null && map != null) { this.spanContext = new LinkedHashMap(); }
    if(map != null) { this.spanContext.putAll(map);} return (A)this;
  }
  
  public A removeFromSpanContext(String key) {
    if(this.spanContext == null) { return (A) this; }
    if(key != null && this.spanContext != null) {this.spanContext.remove(key);} return (A)this;
  }
  
  public A removeFromSpanContext(Map<String,String> map) {
    if(this.spanContext == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.spanContext != null){this.spanContext.remove(key);}}} return (A)this;
  }
  
  public Map<String,String> getSpanContext() {
    return this.spanContext;
  }
  
  public <K,V>A withSpanContext(Map<String,String> spanContext) {
    if (spanContext == null) {
      this.spanContext = null;
    } else {
      this.spanContext = new LinkedHashMap(spanContext);
    }
    return (A) this;
  }
  
  public boolean hasSpanContext() {
    return this.spanContext != null;
  }
  
  public String getStartTime() {
    return this.startTime;
  }
  
  public A withStartTime(String startTime) {
    this.startTime = startTime;
    return (A) this;
  }
  
  public boolean hasStartTime() {
    return this.startTime != null;
  }
  
  public A addToTaskRuns(String key,PipelineRunTaskRunStatus value) {
    if(this.taskRuns == null && key != null && value != null) { this.taskRuns = new LinkedHashMap(); }
    if(key != null && value != null) {this.taskRuns.put(key, value);} return (A)this;
  }
  
  public A addToTaskRuns(Map<String,PipelineRunTaskRunStatus> map) {
    if(this.taskRuns == null && map != null) { this.taskRuns = new LinkedHashMap(); }
    if(map != null) { this.taskRuns.putAll(map);} return (A)this;
  }
  
  public A removeFromTaskRuns(String key) {
    if(this.taskRuns == null) { return (A) this; }
    if(key != null && this.taskRuns != null) {this.taskRuns.remove(key);} return (A)this;
  }
  
  public A removeFromTaskRuns(Map<String,PipelineRunTaskRunStatus> map) {
    if(this.taskRuns == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.taskRuns != null){this.taskRuns.remove(key);}}} return (A)this;
  }
  
  public Map<String,PipelineRunTaskRunStatus> getTaskRuns() {
    return this.taskRuns;
  }
  
  public <K,V>A withTaskRuns(Map<String,PipelineRunTaskRunStatus> taskRuns) {
    if (taskRuns == null) {
      this.taskRuns = null;
    } else {
      this.taskRuns = new LinkedHashMap(taskRuns);
    }
    return (A) this;
  }
  
  public boolean hasTaskRuns() {
    return this.taskRuns != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PipelineRunStatusFieldsFluent that = (PipelineRunStatusFieldsFluent) o;
    if (!java.util.Objects.equals(childReferences, that.childReferences)) return false;
    if (!java.util.Objects.equals(completionTime, that.completionTime)) return false;
    if (!java.util.Objects.equals(finallyStartTime, that.finallyStartTime)) return false;
    if (!java.util.Objects.equals(pipelineResults, that.pipelineResults)) return false;
    if (!java.util.Objects.equals(pipelineSpec, that.pipelineSpec)) return false;
    if (!java.util.Objects.equals(provenance, that.provenance)) return false;
    if (!java.util.Objects.equals(runs, that.runs)) return false;
    if (!java.util.Objects.equals(skippedTasks, that.skippedTasks)) return false;
    if (!java.util.Objects.equals(spanContext, that.spanContext)) return false;
    if (!java.util.Objects.equals(startTime, that.startTime)) return false;
    if (!java.util.Objects.equals(taskRuns, that.taskRuns)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(childReferences,  completionTime,  finallyStartTime,  pipelineResults,  pipelineSpec,  provenance,  runs,  skippedTasks,  spanContext,  startTime,  taskRuns,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (childReferences != null && !childReferences.isEmpty()) { sb.append("childReferences:"); sb.append(childReferences + ","); }
    if (completionTime != null) { sb.append("completionTime:"); sb.append(completionTime + ","); }
    if (finallyStartTime != null) { sb.append("finallyStartTime:"); sb.append(finallyStartTime + ","); }
    if (pipelineResults != null && !pipelineResults.isEmpty()) { sb.append("pipelineResults:"); sb.append(pipelineResults + ","); }
    if (pipelineSpec != null) { sb.append("pipelineSpec:"); sb.append(pipelineSpec + ","); }
    if (provenance != null) { sb.append("provenance:"); sb.append(provenance + ","); }
    if (runs != null && !runs.isEmpty()) { sb.append("runs:"); sb.append(runs + ","); }
    if (skippedTasks != null && !skippedTasks.isEmpty()) { sb.append("skippedTasks:"); sb.append(skippedTasks + ","); }
    if (spanContext != null && !spanContext.isEmpty()) { sb.append("spanContext:"); sb.append(spanContext + ","); }
    if (startTime != null) { sb.append("startTime:"); sb.append(startTime + ","); }
    if (taskRuns != null && !taskRuns.isEmpty()) { sb.append("taskRuns:"); sb.append(taskRuns + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ChildReferencesNested<N> extends ChildStatusReferenceFluent<ChildReferencesNested<N>> implements Nested<N>{
    ChildReferencesNested(int index,ChildStatusReference item) {
      this.index = index;
      this.builder = new ChildStatusReferenceBuilder(this, item);
    }
    ChildStatusReferenceBuilder builder;
    int index;
    
    public N and() {
      return (N) PipelineRunStatusFieldsFluent.this.setToChildReferences(index,builder.build());
    }
    
    public N endChildReference() {
      return and();
    }
    
  
  }
  public class PipelineResultsNested<N> extends PipelineRunResultFluent<PipelineResultsNested<N>> implements Nested<N>{
    PipelineResultsNested(int index,PipelineRunResult item) {
      this.index = index;
      this.builder = new PipelineRunResultBuilder(this, item);
    }
    PipelineRunResultBuilder builder;
    int index;
    
    public N and() {
      return (N) PipelineRunStatusFieldsFluent.this.setToPipelineResults(index,builder.build());
    }
    
    public N endPipelineResult() {
      return and();
    }
    
  
  }
  public class PipelineSpecNested<N> extends PipelineSpecFluent<PipelineSpecNested<N>> implements Nested<N>{
    PipelineSpecNested(PipelineSpec item) {
      this.builder = new PipelineSpecBuilder(this, item);
    }
    PipelineSpecBuilder builder;
    
    public N and() {
      return (N) PipelineRunStatusFieldsFluent.this.withPipelineSpec(builder.build());
    }
    
    public N endPipelineSpec() {
      return and();
    }
    
  
  }
  public class ProvenanceNested<N> extends ProvenanceFluent<ProvenanceNested<N>> implements Nested<N>{
    ProvenanceNested(Provenance item) {
      this.builder = new ProvenanceBuilder(this, item);
    }
    ProvenanceBuilder builder;
    
    public N and() {
      return (N) PipelineRunStatusFieldsFluent.this.withProvenance(builder.build());
    }
    
    public N endProvenance() {
      return and();
    }
    
  
  }
  public class SkippedTasksNested<N> extends SkippedTaskFluent<SkippedTasksNested<N>> implements Nested<N>{
    SkippedTasksNested(int index,SkippedTask item) {
      this.index = index;
      this.builder = new SkippedTaskBuilder(this, item);
    }
    SkippedTaskBuilder builder;
    int index;
    
    public N and() {
      return (N) PipelineRunStatusFieldsFluent.this.setToSkippedTasks(index,builder.build());
    }
    
    public N endSkippedTask() {
      return and();
    }
    
  
  }

}