package io.fabric8.tekton.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class MatrixBuilder extends MatrixFluent<MatrixBuilder> implements VisitableBuilder<Matrix,MatrixBuilder>{
  public MatrixBuilder() {
    this(new Matrix());
  }
  
  public MatrixBuilder(MatrixFluent<?> fluent) {
    this(fluent, new Matrix());
  }
  
  public MatrixBuilder(MatrixFluent<?> fluent,Matrix instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public MatrixBuilder(Matrix instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  MatrixFluent<?> fluent;
  
  public Matrix build() {
    Matrix buildable = new Matrix(fluent.buildInclude(),fluent.buildParams());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}