package io.fabric8.tekton.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class CustomRunBuilder extends CustomRunFluent<CustomRunBuilder> implements VisitableBuilder<CustomRun,CustomRunBuilder>{
  public CustomRunBuilder() {
    this(new CustomRun());
  }
  
  public CustomRunBuilder(CustomRunFluent<?> fluent) {
    this(fluent, new CustomRun());
  }
  
  public CustomRunBuilder(CustomRunFluent<?> fluent,CustomRun instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public CustomRunBuilder(CustomRun instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  CustomRunFluent<?> fluent;
  
  public CustomRun build() {
    CustomRun buildable = new CustomRun(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}